/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.LegacyTransaction;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class Transaction2930
extends LegacyTransaction {
    private long chainId;
    private List<AccessListObject> accessList;

    public Transaction2930(long chainId, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, List<AccessListObject> accessList) {
        super(TransactionType.EIP2930, nonce, gasPrice, gasLimit, to, value, data);
        this.chainId = chainId;
        this.accessList = accessList;
    }

    @Override
    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((long)this.getChainId()));
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        List<AccessListObject> accessList = this.getAccessList();
        ArrayList rlpAccessList = new ArrayList();
        accessList.forEach(entry -> {
            ArrayList<Object> rlpAccessListObject = new ArrayList<Object>();
            rlpAccessListObject.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)entry.getAddress())));
            ArrayList keyList = new ArrayList();
            entry.getStorageKeys().forEach(key -> keyList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)key))));
            rlpAccessListObject.add(new RlpList(keyList));
            rlpAccessList.add(new RlpList(rlpAccessListObject));
        });
        result.add((RlpType)new RlpList(rlpAccessList));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((long)Sign.getRecId(signatureData, this.getChainId())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return result;
    }

    public static Transaction2930 createEtherTransaction(long chainId, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new Transaction2930(chainId, nonce, gasPrice, gasLimit, to, value, "", Collections.emptyList());
    }

    public static Transaction2930 createTransaction(long chainId, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, List<AccessListObject> accessList) {
        return new Transaction2930(chainId, nonce, gasPrice, gasLimit, to, value, data, accessList);
    }

    public long getChainId() {
        return this.chainId;
    }

    public List<AccessListObject> getAccessList() {
        return this.accessList;
    }
}

