/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class TransactionDecoder {
    private static final int UNSIGNED_EIP1559TX_RLP_LIST_SIZE = 9;
    private static final int UNSIGNED_EIP2930TX_RLP_LIST_SIZE = 8;

    public static RawTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray((String)hexTransaction);
        if (TransactionDecoder.getTransactionType(transaction) == TransactionType.EIP1559) {
            return TransactionDecoder.decodeEIP1559Transaction(transaction);
        }
        if (TransactionDecoder.getTransactionType(transaction) == TransactionType.EIP2930) {
            return TransactionDecoder.decodeEIP2930Transaction(transaction);
        }
        return TransactionDecoder.decodeLegacyTransaction(transaction);
    }

    private static TransactionType getTransactionType(byte[] transaction) {
        byte firstByte = transaction[0];
        if (firstByte == TransactionType.EIP1559.getRlpType()) {
            return TransactionType.EIP1559;
        }
        if (firstByte == TransactionType.EIP2930.getRlpType()) {
            return TransactionType.EIP2930;
        }
        return TransactionType.LEGACY;
    }

    private static RawTransaction decodeEIP1559Transaction(byte[] transaction) {
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        long chainId = ((RlpString)values.getValues().get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger maxPriorityFeePerGas = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        BigInteger maxFeePerGas = ((RlpString)values.getValues().get(3)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(4)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(5)).asString();
        BigInteger value = ((RlpString)values.getValues().get(6)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(7)).asString();
        RawTransaction rawTransaction = RawTransaction.createTransaction(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
        if (values.getValues().size() == 9) {
            return rawTransaction;
        }
        byte[] v = Sign.getVFromRecId(Numeric.toBigInt((byte[])((RlpString)values.getValues().get(9)).getBytes()).intValue());
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(10)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(11)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(rawTransaction.getTransaction(), signatureData);
    }

    private static RawTransaction decodeLegacyTransaction(byte[] transaction) {
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        BigInteger nonce = ((RlpString)values.getValues().get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(3)).asString();
        BigInteger value = ((RlpString)values.getValues().get(4)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(5)).asString();
        if (values.getValues().size() == 6 || values.getValues().size() == 8 && ((RlpString)values.getValues().get(7)).getBytes().length == 10 || values.getValues().size() == 9 && ((RlpString)values.getValues().get(8)).getBytes().length == 10) {
            return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data);
        }
        byte[] v = ((RlpString)values.getValues().get(6)).getBytes();
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(7)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(8)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(nonce, gasPrice, gasLimit, to, value, data, signatureData);
    }

    private static RawTransaction decodeEIP2930Transaction(byte[] transaction) {
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        long chainId = ((RlpString)values.getValues().get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(3)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(4)).asString();
        BigInteger value = ((RlpString)values.getValues().get(5)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(6)).asString();
        List<AccessListObject> accessList = TransactionDecoder.decodeAccessList(((RlpList)values.getValues().get(7)).getValues());
        RawTransaction rawTransaction = RawTransaction.createTransaction(chainId, nonce, gasPrice, gasLimit, to, value, data, accessList);
        if (values.getValues().size() == 8) {
            return rawTransaction;
        }
        byte[] v = Sign.getVFromRecId(Numeric.toBigInt((byte[])((RlpString)values.getValues().get(8)).getBytes()).intValue());
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(9)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(10)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(rawTransaction.getTransaction(), signatureData);
    }

    private static List<AccessListObject> decodeAccessList(List<RlpType> rlp) {
        return rlp.stream().map(rawEntry -> ((RlpList)rawEntry).getValues()).map(values -> new AccessListObject(((RlpString)values.get(0)).asString(), ((RlpList)values.get(1)).getValues().stream().map(rawKey -> ((RlpString)rawKey).asString()).collect(Collectors.toList()))).collect(Collectors.toList());
    }
}

