/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenStream;
import org.ssssssss.script.parsing.TokenType;
import org.ssssssss.script.parsing.Tokenizer;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.VarScope;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.LanguageExpression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.TernaryOperation;
import org.ssssssss.script.parsing.ast.UnaryOperation;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.binary.AssigmentOperation;
import org.ssssssss.script.parsing.ast.linq.LinqExpression;
import org.ssssssss.script.parsing.ast.linq.LinqField;
import org.ssssssss.script.parsing.ast.linq.LinqJoin;
import org.ssssssss.script.parsing.ast.linq.LinqOrder;
import org.ssssssss.script.parsing.ast.linq.LinqSelect;
import org.ssssssss.script.parsing.ast.linq.WholeLiteral;
import org.ssssssss.script.parsing.ast.literal.BigDecimalLiteral;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.parsing.ast.literal.ByteLiteral;
import org.ssssssss.script.parsing.ast.literal.DoubleLiteral;
import org.ssssssss.script.parsing.ast.literal.FloatLiteral;
import org.ssssssss.script.parsing.ast.literal.IntegerLiteral;
import org.ssssssss.script.parsing.ast.literal.ListLiteral;
import org.ssssssss.script.parsing.ast.literal.LongLiteral;
import org.ssssssss.script.parsing.ast.literal.MapLiteral;
import org.ssssssss.script.parsing.ast.literal.NullLiteral;
import org.ssssssss.script.parsing.ast.literal.NumberLiteral;
import org.ssssssss.script.parsing.ast.literal.RegexpLiteral;
import org.ssssssss.script.parsing.ast.literal.ShortLiteral;
import org.ssssssss.script.parsing.ast.literal.StringLiteral;
import org.ssssssss.script.parsing.ast.statement.Assert;
import org.ssssssss.script.parsing.ast.statement.AsyncCall;
import org.ssssssss.script.parsing.ast.statement.Break;
import org.ssssssss.script.parsing.ast.statement.ClassConverter;
import org.ssssssss.script.parsing.ast.statement.Continue;
import org.ssssssss.script.parsing.ast.statement.Exit;
import org.ssssssss.script.parsing.ast.statement.ForStatement;
import org.ssssssss.script.parsing.ast.statement.FunctionCall;
import org.ssssssss.script.parsing.ast.statement.IfStatement;
import org.ssssssss.script.parsing.ast.statement.Import;
import org.ssssssss.script.parsing.ast.statement.LambdaFunction;
import org.ssssssss.script.parsing.ast.statement.MapOrArrayAccess;
import org.ssssssss.script.parsing.ast.statement.MemberAccess;
import org.ssssssss.script.parsing.ast.statement.MethodCall;
import org.ssssssss.script.parsing.ast.statement.NewStatement;
import org.ssssssss.script.parsing.ast.statement.Return;
import org.ssssssss.script.parsing.ast.statement.Spread;
import org.ssssssss.script.parsing.ast.statement.Throw;
import org.ssssssss.script.parsing.ast.statement.TryStatement;
import org.ssssssss.script.parsing.ast.statement.VariableAccess;
import org.ssssssss.script.parsing.ast.statement.VariableDefine;
import org.ssssssss.script.parsing.ast.statement.VariableDestructuringDefine;
import org.ssssssss.script.parsing.ast.statement.WhileStatement;

public class Parser {
    public static final String ANONYMOUS_VARIABLE = "-anonymous";
    private static final TokenType[][] BINARY_OPERATOR_PRECEDENCE = new TokenType[][]{{TokenType.Assignment}, {TokenType.RShift2Equal, TokenType.RShiftEqual, TokenType.LShiftEqual, TokenType.XorEqual, TokenType.BitOrEqual, TokenType.BitAndEqual, TokenType.PercentEqual, TokenType.ForwardSlashEqual, TokenType.AsteriskEqual, TokenType.MinusEqual, TokenType.PlusEqual}, {TokenType.Or, TokenType.SqlOr}, {TokenType.And, TokenType.SqlAnd}, {TokenType.BitOr}, {TokenType.Xor}, {TokenType.BitAnd}, {TokenType.EqualEqualEqual, TokenType.Equal, TokenType.NotEqualEqual, TokenType.NotEqual, TokenType.SqlNotEqual}, {TokenType.Less, TokenType.LessEqual, TokenType.Greater, TokenType.GreaterEqual, TokenType.InstanceOf}, {TokenType.Plus, TokenType.Minus}, {TokenType.LShift, TokenType.RShift, TokenType.Rshift2}, {TokenType.Asterisk, TokenType.ForwardSlash, TokenType.Percentage}};
    private static final TokenType[][] LINQ_BINARY_OPERATOR_PRECEDENCE = new TokenType[][]{{TokenType.RShift2Equal, TokenType.RShiftEqual, TokenType.LShiftEqual, TokenType.XorEqual, TokenType.BitOrEqual, TokenType.BitAndEqual, TokenType.PercentEqual, TokenType.ForwardSlashEqual, TokenType.AsteriskEqual, TokenType.MinusEqual, TokenType.PlusEqual}, {TokenType.Or, TokenType.SqlOr}, {TokenType.And, TokenType.SqlAnd}, {TokenType.BitOr}, {TokenType.Xor}, {TokenType.BitAnd}, {TokenType.Assignment, TokenType.EqualEqualEqual, TokenType.Equal, TokenType.NotEqualEqual, TokenType.NotEqual, TokenType.SqlNotEqual}, {TokenType.Less, TokenType.LessEqual, TokenType.Greater, TokenType.GreaterEqual, TokenType.InstanceOf}, {TokenType.Plus, TokenType.Minus}, {TokenType.LShift, TokenType.RShift, TokenType.Rshift2}, {TokenType.ForwardSlash, TokenType.Asterisk, TokenType.Percentage}};
    private static final TokenType[] UNARY_OPERATORS = new TokenType[]{TokenType.MinusMinus, TokenType.PlusPlus, TokenType.BitNot, TokenType.Minus, TokenType.Plus, TokenType.Not};
    private static final List<String> KEYWORDS = Arrays.asList("import", "as", "var", "let", "const", "return", "break", "continue", "if", "for", "in", "new", "true", "false", "null", "else", "try", "catch", "finally", "async", "while", "exit", "and", "or", "throw");
    private static final List<String> LINQ_KEYWORDS = Arrays.asList("from", "join", "left", "group", "by", "as", "having", "and", "or", "in", "where", "on", "limit", "offset");
    private VarScope varNames;
    private VarScope rootvarNames;
    private final List<Span> spans;
    private final Set<VarIndex> varIndices;
    private int varCount;
    private int linqLevel;
    private boolean requiredNew;
    private TokenStream stream;
    private final List<String> defines;

    public Parser() {
        this.rootvarNames = this.varNames = new VarScope();
        this.spans = new ArrayList<Span>();
        this.varIndices = new LinkedHashSet<VarIndex>();
        this.varCount = 0;
        this.linqLevel = 0;
        this.requiredNew = true;
        this.defines = new ArrayList<String>();
    }

    public Set<VarIndex> getVarIndices() {
        return this.varIndices;
    }

    public List<Node> parse(String source) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.push();
        this.stream = Tokenizer.tokenize(source);
        while (this.stream.hasMore()) {
            Node node = this.parseStatement();
            if (node == null) continue;
            this.validateNode(node);
            nodes.add(node);
        }
        this.pop();
        return nodes;
    }

    private void validateNode(Node node) {
        if (node instanceof Literal) {
            MagicScriptError.error("literal cannot be used alone", node.getSpan());
        }
    }

    private Node parseStatement() {
        return this.parseStatement(false);
    }

    private Node parseStatement(boolean expectRightCurly) {
        Node result = null;
        if (this.stream.match("import", false)) {
            result = this.parseImport();
        } else if (this.matchVarDefine()) {
            result = this.parseVarDefine();
        } else if (this.stream.match("if", false)) {
            result = this.parseIfStatement();
        } else if (this.stream.match("return", false)) {
            result = this.parseReturn();
        } else if (this.stream.match("for", false)) {
            result = this.parseForStatement();
        } else if (this.stream.match("while", false)) {
            result = this.parseWhileStatement();
        } else if (this.stream.match("continue", false)) {
            result = new Continue(this.stream.consume().getSpan());
        } else if (this.stream.match("async", false)) {
            result = this.parseAsync();
        } else if (this.stream.match("try", false)) {
            result = this.parseTryStatement();
        } else if (this.stream.match("break", false)) {
            result = new Break(this.stream.consume().getSpan());
        } else if (this.stream.match("exit", false)) {
            result = this.parseExit();
        } else if (this.stream.match("assert", false)) {
            result = this.parseAssert();
        } else if (this.stream.match("throw", false)) {
            result = this.parseThrow();
        } else {
            int index = this.stream.makeIndex();
            if (this.matchTypeDefine()) {
                this.stream.resetIndex(index);
                result = this.parseVarDefine();
            }
            if (result == null) {
                this.stream.resetIndex(index);
                result = this.parseExpression(expectRightCurly);
            }
        }
        while (this.stream.match(";", true)) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchTypeDefine() {
        boolean typeDefine = this.stream.match(TokenType.Identifier, true);
        if (!typeDefine) {
            return false;
        }
        int index = this.stream.makeIndex();
        try {
            if ("new".equals(this.stream.getPrev().getText())) {
                boolean bl = false;
                return bl;
            }
            if (this.stream.match(TokenType.Identifier, false)) {
                boolean bl = true;
                return bl;
            }
            int end = this.stream.getPrev().getSpan().getEnd();
            if (this.stream.hasMore() && this.stream.consume().getSpan().getStart() == end) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.stream.resetIndex(index);
        }
        boolean isMapAccess = this.stream.match(true, TokenType.LeftCurly);
        if (isMapAccess || this.stream.match(true, TokenType.LeftBracket)) {
            do {
                if (this.stream.match(true, TokenType.Identifier)) continue;
                return false;
            } while (this.stream.match(true, TokenType.Comma));
            if (isMapAccess) {
                return this.stream.match(true, TokenType.RightCurly);
            }
            return this.stream.match(true, TokenType.RightBracket);
        }
        return false;
    }

    private boolean matchVarDefine() {
        return this.stream.match(false, "var", "let", "const");
    }

    private VarIndex add(String name) {
        VarScope varIndices = this.varNames;
        do {
            for (int j = varIndices.size() - 1; j >= 0; --j) {
                VarIndex varIndex = (VarIndex)varIndices.get(j);
                if (!varIndex.getName().equals(name)) continue;
                return this.defines.contains(name) ? varIndex.scoped() : varIndex;
            }
        } while ((varIndices = varIndices.getParent()) != null);
        return this.add(new VarIndex(name, this.varCount++, true), true);
    }

    private VarIndex add(VarIndex varIndex) {
        return this.add(varIndex, false);
    }

    private VarIndex add(VarIndex varIndex, boolean isRoot) {
        if (this.defines.contains(varIndex.getName())) {
            varIndex = varIndex.scoped();
        }
        if (isRoot) {
            this.rootvarNames.add(varIndex);
        } else {
            this.varNames.add(varIndex);
        }
        this.varIndices.add(varIndex);
        return varIndex;
    }

    private VarIndex forceAdd(String name) {
        return this.forceAdd(name, false);
    }

    private VarIndex forceAdd(String name, boolean isConst) {
        return this.add(new VarIndex(name, this.varCount++, false, isConst));
    }

    private void push() {
        this.varNames = this.varNames.push();
    }

    private void pop() {
        this.varNames = this.varNames.pop();
    }

    private Span addSpan(Span opening, Span ending) {
        this.addSpan(opening);
        this.addSpan(ending);
        return this.addSpan(new Span(opening, ending));
    }

    private Span addSpan(String source, int start, int end) {
        return this.addSpan(new Span(source, start, end));
    }

    private Span addSpan(Span span) {
        this.spans.add(span);
        return span;
    }

    private Node parseExit() {
        Span opening = this.stream.expect("exit").getSpan();
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        do {
            expressionList.add(this.parseExpression());
        } while (this.stream.match(TokenType.Comma, true));
        return new Exit(this.addSpan(opening, this.stream.getPrev().getSpan()), expressionList);
    }

    private Node parseThrow() {
        Span opening = this.stream.consume().getSpan();
        Expression expression = this.parseExpression();
        return new Throw(this.addSpan(opening, this.stream.getPrev().getSpan()), expression);
    }

    private Node parseAssert() {
        int index = this.stream.makeIndex();
        try {
            Span opening = this.stream.expect("assert").getSpan();
            Expression condition = this.parseExpression();
            this.stream.expect(TokenType.Colon);
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            do {
                expressionList.add(this.parseExpression());
            } while (this.stream.match(TokenType.Comma, true));
            return new Assert(this.addSpan(opening, this.stream.getPrev().getSpan()), condition, expressionList);
        }
        catch (Exception e) {
            this.stream.resetIndex(index);
            return this.parseExpression();
        }
    }

    private Expression parseAsync() {
        Span opening = this.stream.expect("async").getSpan();
        this.requiredNew = false;
        Expression expression = this.parseExpression();
        this.requiredNew = true;
        if (expression instanceof MethodCall || expression instanceof FunctionCall || expression instanceof LambdaFunction) {
            return new AsyncCall(this.addSpan(opening, this.stream.getPrev().getSpan()), expression);
        }
        MagicScriptError.error("Expected MethodCall or FunctionCall or LambdaFunction", this.stream.getPrev().getSpan());
        return null;
    }

    private Import parseImport() {
        Span opening = this.stream.expect("import").getSpan();
        if (this.stream.hasMore()) {
            boolean isStringLiteral;
            Token expected = this.stream.consume();
            String packageName = null;
            boolean bl = isStringLiteral = expected.getType() == TokenType.StringLiteral;
            if (isStringLiteral) {
                packageName = this.createStringLiteral(expected).getValue();
            } else if (expected.getType() == TokenType.Identifier) {
                Span startSpan = expected.getSpan();
                packageName = startSpan.getText();
                while (this.stream.match(true, TokenType.Period)) {
                    isStringLiteral = true;
                    if (this.stream.match(false, TokenType.Asterisk)) {
                        expected = this.stream.consume();
                        break;
                    }
                    expected = this.stream.expect(TokenType.Identifier);
                }
                if (isStringLiteral) {
                    packageName = new Span(startSpan, expected.getSpan()).getText();
                }
            } else {
                MagicScriptError.error("Expected identifier or string, but got stream is " + expected.getType().getError(), this.stream.getPrev().getSpan());
            }
            String varName = packageName;
            if (isStringLiteral) {
                if (this.stream.match("as", true)) {
                    expected = this.stream.expect(TokenType.Identifier);
                    this.checkKeyword(expected.getSpan());
                    varName = expected.getSpan().getText();
                } else {
                    String temp = packageName;
                    if (!temp.startsWith("@")) {
                        int index = temp.lastIndexOf(".");
                        if (index != -1) {
                            temp = temp.substring(index + 1);
                        }
                    } else {
                        MagicScriptError.error("Expected as", this.stream);
                    }
                    varName = temp;
                }
            }
            return new Import(this.addSpan(opening, expected.getSpan()), packageName, this.forceAdd(varName), !isStringLiteral);
        }
        MagicScriptError.error("Expected identifier or string, but got stream is EOF", this.stream.getPrev().getSpan());
        return null;
    }

    private TryStatement parseTryStatement() {
        Token opening = this.stream.expect("try");
        this.push();
        ArrayList<VariableDefine> tryResources = new ArrayList<VariableDefine>();
        if (this.stream.match("(", true)) {
            if (!this.stream.match(")", false)) {
                while (!this.stream.match(")", false)) {
                    if (this.stream.match(";", true)) continue;
                    VariableDefine result = null;
                    if (this.matchVarDefine()) {
                        result = this.parseVarDefine();
                    } else {
                        if (this.stream.match(false, KEYWORDS.toArray(new String[0]))) {
                            MagicScriptError.error("try \u62ec\u53f7\u4e2d\u53ea\u5141\u8bb8\u5199\u8d4b\u503c\u8bed\u53e5", this.stream.consume().getSpan());
                        }
                        int index = this.stream.makeIndex();
                        if (this.matchTypeDefine()) {
                            this.stream.resetIndex(index);
                            result = this.parseVarDefine();
                        }
                        if (result == null) {
                            this.stream.resetIndex(index);
                            MagicScriptError.error("try \u62ec\u53f7\u4e2d\u53ea\u5141\u8bb8\u5199\u8d4b\u503c\u8bed\u53e5", this.stream.consume().getSpan());
                        }
                    }
                    tryResources.add(result);
                }
            }
            this.stream.expect(")");
        }
        List<Node> tryBlocks = this.parseFunctionBody();
        this.pop();
        ArrayList<Node> catchBlocks = new ArrayList<Node>();
        ArrayList<Node> finallyBlocks = new ArrayList<Node>();
        VarIndex exceptionVarNode = null;
        if (this.stream.match("catch", true)) {
            this.push();
            if (this.stream.match("(", true)) {
                exceptionVarNode = this.add(this.stream.expect(TokenType.Identifier).getText());
                this.defines.add(exceptionVarNode.getName());
                this.stream.expect(")");
            }
            catchBlocks.addAll(this.parseFunctionBody());
            this.pop();
        }
        if (this.stream.match("finally", true)) {
            this.push();
            finallyBlocks.addAll(this.parseFunctionBody());
            this.pop();
        }
        return new TryStatement(this.addSpan(opening.getSpan(), this.stream.getPrev().getSpan()), exceptionVarNode, tryBlocks, tryResources, catchBlocks, finallyBlocks);
    }

    private List<Node> parseFunctionBody() {
        this.stream.expect("{");
        ArrayList<Node> blocks = new ArrayList<Node>();
        while (this.stream.hasMore() && !this.stream.match("}", false)) {
            Node node = this.parseStatement(true);
            if (node == null) continue;
            this.validateNode(node);
            blocks.add(node);
        }
        this.expectCloseing();
        return blocks;
    }

    private Expression parseNewExpression(Span opening) {
        Expression expression = this.parseAccessOrCall(TokenType.Identifier, true);
        if (expression instanceof MethodCall) {
            MethodCall call = (MethodCall)expression;
            Span span = this.addSpan(opening.getSource(), opening.getStart(), this.stream.getPrev().getSpan().getEnd());
            return this.parseAccessOrCall(new NewStatement(span, call.getMethod(), call.getArguments()));
        }
        if (expression instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)expression;
            Span span = this.addSpan(opening.getSource(), opening.getStart(), this.stream.getPrev().getSpan().getEnd());
            return this.parseAccessOrCall(new NewStatement(span, call.getFunction(), call.getArguments()));
        }
        MagicScriptError.error("Expected MethodCall or FunctionCall or LambdaFunction", this.stream.getPrev().getSpan());
        return null;
    }

    private VariableDefine parseVarDefine() {
        Span opening = this.stream.consume().getSpan();
        boolean isMapAccess = this.stream.match(false, TokenType.LeftCurly);
        if (isMapAccess || this.stream.match(false, TokenType.LeftBracket)) {
            this.stream.expect(TokenType.LeftCurly, TokenType.LeftBracket);
            ArrayList<Token> tokens = new ArrayList<Token>();
            do {
                Token token = this.stream.expect(TokenType.Identifier);
                tokens.add(token);
            } while (this.stream.match(true, TokenType.Comma));
            if (isMapAccess) {
                this.stream.expect(TokenType.RightCurly);
            } else {
                this.stream.expect(TokenType.RightBracket);
            }
            this.stream.match(TokenType.Assignment, true);
            boolean isConst = "const".equals(opening.getText());
            VariableDestructuringDefine destructuring = new VariableDestructuringDefine(this.addSpan(opening, this.stream.getPrev().getSpan()), tokens.size(), this.parseExpression(), isMapAccess);
            for (Token token : tokens) {
                String variableName = token.getSpan().getText();
                VarIndex varIndex = this.forceAdd(variableName, isConst);
                this.defines.add(variableName);
                VariableDefine variableDefine = new VariableDefine(this.addSpan(token.getSpan(), this.stream.getPrev().getSpan()), varIndex, null);
                destructuring.add(variableDefine);
            }
            return destructuring;
        }
        Token token = this.stream.expect(TokenType.Identifier);
        boolean isConst = "const".equals(opening.getText());
        this.checkKeyword(token.getSpan());
        String variableName = token.getSpan().getText();
        if (this.stream.match(TokenType.Assignment, true)) {
            VarIndex varIndex = this.forceAdd(variableName, isConst);
            this.defines.add(variableName);
            return new VariableDefine(this.addSpan(opening, this.stream.getPrev().getSpan()), varIndex, this.parseExpression());
        }
        if (isConst) {
            MagicScriptError.error("const\u4fee\u9970\u7684\u53d8\u91cf\u9700\u8981\u7ed9\u521d\u59cb\u503c", this.stream.getPrev().getSpan());
        }
        return new VariableDefine(this.addSpan(opening, this.stream.getPrev().getSpan()), this.forceAdd(variableName), null);
    }

    private void checkKeyword(Span span) {
        if (KEYWORDS.contains(span.getText())) {
            MagicScriptError.error("\u53d8\u91cf\u540d\u4e0d\u80fd\u5b9a\u4e49\u4e3a\u5173\u952e\u5b57", span);
        }
    }

    private WhileStatement parseWhileStatement() {
        Span openingWhile = this.stream.expect("while").getSpan();
        this.requiredNew = false;
        Expression condition = this.parseExpression();
        this.requiredNew = true;
        this.push();
        List<Node> trueBlock = this.parseFunctionBody();
        Span closingEnd = this.stream.getPrev().getSpan();
        this.pop();
        return new WhileStatement(this.addSpan(openingWhile, closingEnd), condition, trueBlock);
    }

    private ForStatement parseForStatement() {
        Span openingFor = this.stream.expect("for").getSpan();
        this.stream.expect("(");
        this.push();
        Span index = null;
        Span value = this.stream.expect(TokenType.Identifier).getSpan();
        this.checkKeyword(value);
        this.defines.add(value.getText());
        if (this.stream.match(TokenType.Comma, true)) {
            index = value;
            value = this.stream.expect(TokenType.Identifier).getSpan();
            this.defines.add(value.getText());
            this.checkKeyword(value);
        }
        VarIndex indexOrKeyNode = null;
        if (index != null) {
            indexOrKeyNode = this.forceAdd(index.getText());
        }
        VarIndex valueNode = this.forceAdd(value.getText());
        this.stream.expect("in");
        Expression mapOrArray = this.parseExpression();
        this.stream.expect(")");
        List<Node> body = this.parseFunctionBody();
        VarIndex anonymous = this.forceAdd(ANONYMOUS_VARIABLE);
        this.pop();
        return new ForStatement(this.addSpan(openingFor, this.stream.getPrev().getSpan()), indexOrKeyNode, valueNode, anonymous, mapOrArray, body);
    }

    private Span expectCloseing() {
        if (!this.stream.hasMore()) {
            MagicScriptError.error("Did not find closing }.", this.stream.prev().getSpan());
        }
        return this.stream.expect("}").getSpan();
    }

    private Node parseIfStatement() {
        Span openingIf = this.stream.expect("if").getSpan();
        this.requiredNew = false;
        Expression condition = this.parseExpression();
        this.requiredNew = true;
        this.push();
        List<Node> trueBlock = this.parseFunctionBody();
        this.pop();
        ArrayList<IfStatement> elseIfs = new ArrayList<IfStatement>();
        ArrayList<Node> falseBlock = new ArrayList<Node>();
        while (this.stream.hasMore() && this.stream.match("else", true)) {
            if (this.stream.hasMore() && this.stream.match("if", false)) {
                Span elseIfOpening = this.stream.expect("if").getSpan();
                Expression elseIfCondition = this.parseExpression();
                this.push();
                List<Node> elseIfBlock = this.parseFunctionBody();
                Span elseIfSpan = this.addSpan(elseIfOpening, elseIfBlock.size() > 0 ? elseIfBlock.get(elseIfBlock.size() - 1).getSpan() : elseIfOpening);
                this.pop();
                elseIfs.add(new IfStatement(elseIfSpan, elseIfCondition, elseIfBlock, new ArrayList<IfStatement>(), new ArrayList<Node>()));
                continue;
            }
            this.push();
            falseBlock.addAll(this.parseFunctionBody());
            this.pop();
            break;
        }
        Span closingEnd = this.stream.getPrev().getSpan();
        return new IfStatement(this.addSpan(openingIf, closingEnd), condition, trueBlock, elseIfs, falseBlock);
    }

    private Node parseReturn() {
        Span returnSpan = this.stream.expect("return").getSpan();
        if (this.stream.match(false, ";", "}")) {
            return new Return(returnSpan, null);
        }
        Expression returnValue = this.parseExpression();
        return new Return(this.addSpan(returnSpan, returnValue.getSpan()), returnValue);
    }

    public Expression parseExpression() {
        return this.parseTernaryOperator();
    }

    public Expression parseExpression(boolean expectRightCurly) {
        return this.parseTernaryOperator(expectRightCurly);
    }

    private Expression parseTernaryOperator(boolean expectRightCurly) {
        Expression condition = this.parseBinaryOperator(0, expectRightCurly);
        if (this.stream.match(TokenType.QuestionMark, true)) {
            Expression trueExpression = this.parseTernaryOperator(expectRightCurly);
            this.stream.expect(TokenType.Colon);
            Expression falseExpression = this.parseTernaryOperator(expectRightCurly);
            if (condition instanceof AssigmentOperation) {
                AssigmentOperation operation = (AssigmentOperation)condition;
                operation.setRightOperand(new TernaryOperation(operation.getRightOperand(), trueExpression, falseExpression));
                return operation;
            }
            return new TernaryOperation(condition, trueExpression, falseExpression);
        }
        return condition;
    }

    private Expression parseTernaryOperator() {
        return this.parseTernaryOperator(false);
    }

    private Expression parseBinaryOperator(TokenType[][] precedence, int level, boolean expectRightCurly) {
        int nextLevel = level + 1;
        Expression left = nextLevel == precedence.length ? this.parseUnaryOperator(expectRightCurly) : this.parseBinaryOperator(nextLevel, expectRightCurly);
        TokenType[] operators = precedence[level];
        while (this.stream.hasMore() && this.stream.match(false, operators)) {
            Token operator = this.stream.consume();
            if (operator.getType().isInLinq() && this.linqLevel == 0) {
                MagicScriptError.error(operator.getText() + " \u53ea\u80fd\u5728Linq\u4e2d\u4f7f\u7528", this.stream);
            }
            Expression right = nextLevel == precedence.length ? this.parseUnaryOperator(expectRightCurly) : this.parseBinaryOperator(nextLevel, expectRightCurly);
            left = BinaryOperation.create(left, operator, right, this.linqLevel);
        }
        this.addSpan(left.getSpan());
        return left;
    }

    private Expression parseBinaryOperator(int level, boolean expectRightCurly) {
        if (this.linqLevel > 0) {
            return this.parseBinaryOperator(LINQ_BINARY_OPERATOR_PRECEDENCE, level, expectRightCurly);
        }
        return this.parseBinaryOperator(BINARY_OPERATOR_PRECEDENCE, level, expectRightCurly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression parseUnaryOperator(boolean expectRightCurly) {
        if (this.stream.match(false, UNARY_OPERATORS)) {
            Token operator = this.stream.consume();
            Expression operand = this.parseUnaryOperator(expectRightCurly);
            if (operator.getType() == TokenType.Minus && operand instanceof NumberLiteral) {
                ((NumberLiteral)operand).setNeg(true);
                return operand;
            }
            return new UnaryOperation(operator, operand);
        }
        if (this.stream.match(TokenType.LeftParantheses, false)) {
            Span openSpan = this.stream.expect(TokenType.LeftParantheses).getSpan();
            int index = this.stream.makeIndex();
            ArrayList<VarIndex> parameters = new ArrayList<VarIndex>();
            this.push();
            try {
                Object identifier;
                while (this.stream.match(TokenType.Identifier, false)) {
                    identifier = this.stream.expect(TokenType.Identifier);
                    this.checkKeyword(((Token)identifier).getSpan());
                    if (this.requiredNew) {
                        parameters.add(this.forceAdd(((Token)identifier).getSpan().getText()));
                    } else {
                        parameters.add(this.add(((Token)identifier).getSpan().getText()));
                    }
                    if (this.stream.match(TokenType.Comma, true)) continue;
                    if (!this.stream.match(TokenType.RightParantheses, true)) continue;
                    if (!this.stream.match(TokenType.Lambda, true)) break;
                    Expression expression = this.parseLambdaBody(openSpan, parameters);
                    return expression;
                }
                if (this.stream.match(TokenType.RightParantheses, true) && this.stream.match(TokenType.Lambda, true)) {
                    identifier = this.parseLambdaBody(openSpan, parameters);
                    return identifier;
                }
            }
            finally {
                this.pop();
            }
            this.stream.resetIndex(index);
            Expression expression = this.parseExpression();
            this.stream.expect(TokenType.RightParantheses);
            return this.parseAccessOrCall(expression);
        }
        Expression expression = this.parseAccessOrCallOrLiteral(expectRightCurly);
        if (expression instanceof VariableSetter && this.stream.match(false, TokenType.PlusPlus, TokenType.MinusMinus)) {
            return new UnaryOperation(this.stream.consume(), expression, true);
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression parseLambdaBody(Span openSpan, List<VarIndex> parameters) {
        this.defines.clear();
        int index = this.stream.makeIndex();
        ArrayList<Node> childNodes = new ArrayList<Node>();
        try {
            Expression expression = this.parseExpression();
            childNodes.add(new Return(new Span("return", 0, 6), expression));
            LambdaFunction lambdaFunction = new LambdaFunction(this.addSpan(openSpan, expression.getSpan()), parameters, childNodes);
            return lambdaFunction;
        }
        catch (Exception e) {
            this.stream.resetIndex(index);
            if (this.stream.match(TokenType.LeftCurly, true)) {
                while (this.stream.hasMore() && !this.stream.match(false, "}")) {
                    Node node = this.parseStatement(true);
                    this.validateNode(node);
                    childNodes.add(node);
                }
                Span closeSpan = this.expectCloseing();
                LambdaFunction lambdaFunction = new LambdaFunction(this.addSpan(openSpan, closeSpan), parameters, childNodes);
                return lambdaFunction;
            }
            Node node = this.parseStatement();
            childNodes.add(new Return(this.addSpan("return", 0, 6), node));
            LambdaFunction lambdaFunction = new LambdaFunction(this.addSpan(openSpan, node.getSpan()), parameters, childNodes);
            return lambdaFunction;
        }
        finally {
            this.defines.clear();
        }
    }

    private Expression parseSpreadAccess(Token spread) {
        Expression target = this.parseExpression();
        return new Spread(this.addSpan(spread.getSpan(), target.getSpan()), target);
    }

    private Expression parseSpreadAccess() {
        Token spread = this.stream.expect(TokenType.Spread);
        return this.parseSpreadAccess(spread);
    }

    private Expression parseSelect() {
        Span opeing = this.stream.expect("select", true).getSpan();
        ++this.linqLevel;
        List<LinqField> fields = this.parseLinqFields();
        this.stream.expect("from", true);
        LinqField from = this.parseLinqField();
        List<LinqJoin> joins = this.parseLinqJoins();
        LinqExpression where = null;
        if (this.stream.match("where", true, true)) {
            where = new LinqExpression(this.parseExpression());
        }
        List<LinqField> groups = this.parseGroup();
        LinqExpression having = null;
        if (this.stream.match("having", true, true)) {
            having = new LinqExpression(this.parseExpression());
        }
        List<LinqOrder> orders = this.parseLinqOrders();
        --this.linqLevel;
        Expression limit = null;
        Expression offset = null;
        if (this.stream.match("limit", true, true)) {
            limit = this.parseExpression();
            if (this.stream.match("offset", true, true)) {
                offset = this.parseExpression();
            }
        }
        Span close = this.stream.getPrev().getSpan();
        return new LinqSelect(this.addSpan(opeing, close), fields, from, joins, where, groups, having, orders, limit, offset);
    }

    private List<LinqField> parseGroup() {
        ArrayList<LinqField> groups = new ArrayList<LinqField>();
        if (this.stream.match("group", true, true)) {
            this.stream.expect("by", true);
            do {
                Expression expression = this.parseExpression();
                groups.add(new LinqField(expression.getSpan(), expression, null));
            } while (this.stream.match(TokenType.Comma, true));
        }
        return groups;
    }

    private List<LinqOrder> parseLinqOrders() {
        ArrayList<LinqOrder> orders = new ArrayList<LinqOrder>();
        if (this.stream.match("order", true, true)) {
            this.stream.expect("by", true);
            do {
                Expression expression = this.parseExpression();
                int order = 1;
                if (this.stream.match(false, true, "desc", "asc") && "desc".equalsIgnoreCase(this.stream.consume().getText())) {
                    order = -1;
                }
                orders.add(new LinqOrder(this.addSpan(expression.getSpan(), this.stream.getPrev().getSpan()), expression, null, order));
            } while (this.stream.match(TokenType.Comma, true));
        }
        return orders;
    }

    private List<LinqField> parseLinqFields() {
        ArrayList<LinqField> fields = new ArrayList<LinqField>();
        do {
            Expression expression = this.parseExpression();
            if (this.stream.match(TokenType.Identifier, false) && !this.stream.match(LINQ_KEYWORDS, false, true)) {
                if (expression instanceof WholeLiteral) {
                    MagicScriptError.error("* \u540e\u8fb9\u4e0d\u80fd\u8ddf\u522b\u540d", this.stream);
                } else if (expression instanceof MemberAccess && ((MemberAccess)expression).isWhole()) {
                    MagicScriptError.error(expression.getSpan().getText() + " \u540e\u8fb9\u4e0d\u80fd\u8ddf\u522b\u540d", this.stream);
                }
                Span alias = this.stream.consume().getSpan();
                fields.add(new LinqField(this.addSpan(expression.getSpan(), alias), expression, this.add(alias.getText())));
                continue;
            }
            fields.add(new LinqField(expression.getSpan(), expression, null));
        } while (this.stream.match(TokenType.Comma, true));
        if (fields.isEmpty()) {
            MagicScriptError.error("\u81f3\u5c11\u8981\u67e5\u8be2\u4e00\u4e2a\u5b57\u6bb5", this.stream);
        }
        return fields;
    }

    private List<LinqJoin> parseLinqJoins() {
        ArrayList<LinqJoin> joins = new ArrayList<LinqJoin>();
        do {
            boolean isLeft;
            Span opeing;
            Span span = opeing = (isLeft = this.stream.match("left", false, true)) ? this.stream.consume().getSpan() : null;
            if (!this.stream.match("join", true, true)) continue;
            opeing = isLeft ? opeing : this.stream.getPrev().getSpan();
            LinqField target = this.parseLinqField();
            this.stream.expect("on", true);
            Expression condition = this.parseExpression();
            joins.add(new LinqJoin(this.addSpan(opeing, this.stream.getPrev().getSpan()), isLeft, target, condition));
        } while (this.stream.match(false, true, "left", "join"));
        return joins;
    }

    private LinqField parseLinqField() {
        Expression expression = this.parseExpression();
        if (this.stream.match(TokenType.Identifier, false) && !this.stream.match(LINQ_KEYWORDS, false, true)) {
            Span alias = this.stream.expect(TokenType.Identifier).getSpan();
            return new LinqField(this.addSpan(expression.getSpan(), alias), expression, this.add(alias.getText()));
        }
        return new LinqField(expression.getSpan(), expression, null);
    }

    private Expression parseAccessOrCallOrLiteral(boolean expectRightCurly) {
        Expression expression = null;
        if (expectRightCurly && this.stream.match("}", false)) {
            return null;
        }
        if (this.stream.match(TokenType.Spread, false)) {
            expression = this.parseSpreadAccess();
        } else if (this.stream.match(TokenType.Identifier, false)) {
            expression = this.stream.match("async", false) ? this.parseAsync() : (this.stream.match("select", false, true) ? this.parseSelect() : this.parseAccessOrCall(TokenType.Identifier, false));
        } else if (this.stream.match(TokenType.LeftCurly, false)) {
            expression = this.parseMapLiteral();
        } else if (this.stream.match(TokenType.LeftBracket, false)) {
            expression = this.parseListLiteral();
        } else if (this.stream.match(TokenType.StringLiteral, false)) {
            expression = this.createStringLiteral(this.stream.expect(TokenType.StringLiteral));
        } else if (this.stream.match(TokenType.BooleanLiteral, false)) {
            expression = new BooleanLiteral(this.stream.expect(TokenType.BooleanLiteral).getSpan());
        } else if (this.stream.match(TokenType.DoubleLiteral, false)) {
            expression = new DoubleLiteral(this.stream.expect(TokenType.DoubleLiteral).getSpan());
        } else if (this.stream.match(TokenType.FloatLiteral, false)) {
            expression = new FloatLiteral(this.stream.expect(TokenType.FloatLiteral).getSpan());
        } else if (this.stream.match(TokenType.ByteLiteral, false)) {
            Token token = this.stream.expect(TokenType.ByteLiteral);
            expression = token.getValue() != null ? new ByteLiteral(token.getSpan(), token.getValue()) : new ByteLiteral(token.getSpan());
        } else if (this.stream.match(TokenType.ShortLiteral, false)) {
            expression = new ShortLiteral(this.stream.expect(TokenType.ShortLiteral).getSpan());
        } else if (this.stream.match(TokenType.IntegerLiteral, false)) {
            Token token = this.stream.expect(TokenType.IntegerLiteral);
            expression = token.getValue() != null ? new IntegerLiteral(token.getSpan(), token.getValue()) : new IntegerLiteral(token.getSpan());
        } else if (this.stream.match(TokenType.LongLiteral, false)) {
            Token token = this.stream.expect(TokenType.LongLiteral);
            expression = token.getValue() != null ? new LongLiteral(token.getSpan(), token.getValue()) : new LongLiteral(token.getSpan());
        } else if (this.stream.match(TokenType.DecimalLiteral, false)) {
            expression = new BigDecimalLiteral(this.stream.expect(TokenType.DecimalLiteral).getSpan());
        } else if (this.stream.match(TokenType.RegexpLiteral, false)) {
            Token token = this.stream.expect(TokenType.RegexpLiteral);
            expression = new RegexpLiteral(token.getSpan(), token);
        } else if (this.stream.match(TokenType.NullLiteral, false)) {
            expression = new NullLiteral(this.stream.expect(TokenType.NullLiteral).getSpan());
        } else if (this.linqLevel > 0 && this.stream.match(TokenType.Asterisk, false)) {
            expression = new WholeLiteral(this.stream.expect(TokenType.Asterisk).getSpan());
        } else if (this.stream.match(TokenType.Language, false)) {
            expression = new LanguageExpression(this.stream.consume().getSpan(), this.stream.consume().getSpan());
        }
        if (expression == null) {
            MagicScriptError.error("Expected a variable, field, map, array, function or method call, or literal.", this.stream);
        }
        return this.parseAccessOrCall(expression);
    }

    private StringLiteral createStringLiteral(Token token) {
        if (token.getTokenStream() == null) {
            return new StringLiteral(token);
        }
        TokenStream tempStream = this.stream;
        this.stream = token.getTokenStream();
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        while (this.stream.hasMore()) {
            expressionList.add(this.parseExpression());
        }
        this.stream = tempStream;
        return new StringLiteral(token, expressionList);
    }

    private Expression parseMapLiteral() {
        Span openCurly = this.stream.expect(TokenType.LeftCurly).getSpan();
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        while (this.stream.hasMore() && !this.stream.match("}", false)) {
            Expression key;
            boolean isStringKey;
            if (this.stream.hasPrev()) {
                Token prev = this.stream.getPrev();
                if (this.stream.match(TokenType.Spread, false) && (prev.getType() == TokenType.LeftCurly || prev.getType() == TokenType.Comma)) {
                    Token spread = this.stream.expect(TokenType.Spread);
                    keys.add(null);
                    values.add(this.parseSpreadAccess(spread));
                    if (!this.stream.match(false, TokenType.Comma, TokenType.RightCurly)) continue;
                    this.stream.match(TokenType.Comma, true);
                    continue;
                }
            }
            if (isStringKey = this.stream.match(TokenType.StringLiteral, false)) {
                key = this.createStringLiteral(this.stream.expect(TokenType.StringLiteral));
            } else if (this.stream.match(TokenType.LeftBracket, true)) {
                key = this.parseExpression();
                this.stream.expect(TokenType.RightBracket);
            } else {
                key = this.createStringLiteral(this.stream.expect(TokenType.Identifier));
            }
            keys.add(key);
            if (this.stream.match(false, TokenType.Comma, TokenType.RightCurly)) {
                this.stream.match(TokenType.Comma, true);
                if (!isStringKey && !(key instanceof VariableAccess)) {
                    values.add(new VariableAccess(key.getSpan(), this.add(key.getSpan().getText())));
                    continue;
                }
                values.add(key);
                continue;
            }
            this.stream.expect(":");
            values.add(this.parseExpression());
            if (this.stream.match("}", false)) continue;
            this.stream.expect(TokenType.Comma);
        }
        Span closeCurly = this.stream.expect("}").getSpan();
        return new MapLiteral(this.addSpan(openCurly, closeCurly), keys, values);
    }

    private Expression parseListLiteral() {
        Span openBracket = this.stream.expect(TokenType.LeftBracket).getSpan();
        ArrayList<Expression> values = new ArrayList<Expression>();
        while (this.stream.hasMore() && !this.stream.match(TokenType.RightBracket, false)) {
            values.add(this.parseExpression());
            if (this.stream.match(TokenType.RightBracket, false)) continue;
            this.stream.expect(TokenType.Comma);
        }
        Span closeBracket = this.stream.expect(TokenType.RightBracket).getSpan();
        return new ListLiteral(this.addSpan(openBracket, closeBracket), values);
    }

    private Expression parseAccessOrCall(TokenType tokenType, boolean isNew) {
        Token token = this.stream.expect(tokenType);
        Span identifier = token.getSpan();
        if (tokenType == TokenType.Identifier && "new".equals(identifier.getText())) {
            return this.parseNewExpression(identifier);
        }
        if (tokenType == TokenType.Identifier && this.stream.match(TokenType.Lambda, true)) {
            this.push();
            String name = identifier.getText();
            Expression expression = this.parseLambdaBody(identifier, Collections.singletonList(this.requiredNew ? this.forceAdd(name) : this.add(name)));
            this.pop();
            return expression;
        }
        Expression result = tokenType == TokenType.StringLiteral ? this.createStringLiteral(token) : new VariableAccess(identifier, this.add(identifier.getText()));
        return this.parseAccessOrCall(result, isNew);
    }

    private Expression parseAccessOrCall(Expression target) {
        return this.parseAccessOrCall(target, false);
    }

    private Expression parseAccessOrCall(Expression target, boolean isNew) {
        while (this.stream.hasMore() && this.stream.match(false, TokenType.LeftParantheses, TokenType.LeftBracket, TokenType.Period, TokenType.QuestionPeriod, TokenType.ColonColon)) {
            boolean optional;
            Span closingSpan;
            if (this.stream.match(TokenType.ColonColon, false)) {
                Span open = this.stream.consume().getSpan();
                List<Expression> arguments = Collections.emptyList();
                Token identifier = this.stream.expect(TokenType.Identifier);
                Span closing = identifier.getSpan();
                if (this.stream.match(TokenType.LeftParantheses, false)) {
                    arguments = this.parseArguments();
                    closing = this.stream.expect(TokenType.RightParantheses).getSpan();
                }
                target = new ClassConverter(this.addSpan(open, closing), identifier.getText(), target, arguments);
                continue;
            }
            if (this.stream.match(TokenType.LeftParantheses, false)) {
                List<Expression> arguments = this.parseArguments();
                closingSpan = this.stream.expect(TokenType.RightParantheses).getSpan();
                if (target instanceof VariableAccess || target instanceof MapOrArrayAccess) {
                    target = new FunctionCall(this.addSpan(target.getSpan(), closingSpan), target, arguments, this.linqLevel > 0);
                } else if (target instanceof MemberAccess) {
                    target = new MethodCall(this.addSpan(target.getSpan(), closingSpan), (MemberAccess)target, arguments, this.linqLevel > 0);
                } else {
                    MagicScriptError.error("Expected a variable, field or method.", this.stream);
                }
                if (!isNew) continue;
                break;
            }
            if (this.stream.match(TokenType.LeftBracket, true)) {
                Expression keyOrIndex = this.parseExpression();
                closingSpan = this.stream.expect(TokenType.RightBracket).getSpan();
                target = new MapOrArrayAccess(this.addSpan(target.getSpan(), closingSpan), target, keyOrIndex);
                continue;
            }
            if (!this.stream.match(false, TokenType.Period, TokenType.QuestionPeriod)) continue;
            boolean bl = optional = this.stream.consume().getType() == TokenType.QuestionPeriod;
            if (this.linqLevel > 0 && this.stream.match(TokenType.Asterisk, false)) {
                target = new MemberAccess(target, optional, this.stream.expect(TokenType.Asterisk).getSpan(), true);
                continue;
            }
            target = new MemberAccess(target, optional, this.stream.expect(TokenType.Identifier, TokenType.SqlAnd, TokenType.SqlOr).getSpan(), false);
        }
        return target;
    }

    private List<Expression> parseArguments() {
        this.stream.expect(TokenType.LeftParantheses);
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        while (this.stream.hasMore() && !this.stream.match(TokenType.RightParantheses, false)) {
            arguments.add(this.parseExpression());
            if (this.stream.match(TokenType.RightParantheses, false)) continue;
            this.stream.expect(TokenType.Comma);
        }
        return arguments;
    }
}

