/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.environment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.config.environment.PropertySource;

public class Environment {
    private String name;
    private String label;
    private List<PropertySource> propertySources = new ArrayList<PropertySource>();

    @JsonCreator
    public Environment(@JsonProperty(value="name") String name, @JsonProperty(value="label") String label) {
        this.name = name;
        this.label = label;
    }

    public void add(PropertySource propertySource) {
        this.propertySources.add(propertySource);
    }

    public void addFirst(PropertySource propertySource) {
        this.propertySources.add(0, propertySource);
    }

    public List<PropertySource> getPropertySources() {
        return this.propertySources;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "Environment [name=" + this.name + ", label=" + this.label + ", propertySources=" + this.propertySources + "]";
    }
}

