/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

@ConfigurationProperties(value="spring.cloud.config")
public class ConfigClientProperties {
    public static final String PREFIX = "spring.cloud.config";
    private boolean enabled = true;
    private String profile = "default";
    @Value(value="${spring.application.name:application}")
    private String name;
    private String label = "master";
    private String username;
    private String password;
    private String uri = "http://localhost:8888";
    private Discovery discovery = new Discovery();
    private boolean failFast = false;

    private ConfigClientProperties() {
    }

    public ConfigClientProperties(Environment environment) {
        Object[] profiles = environment.getActiveProfiles();
        if (profiles.length == 0) {
            profiles = environment.getDefaultProfiles();
        }
        this.setProfile(StringUtils.arrayToCommaDelimitedString((Object[])profiles));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRawUri() {
        return this.extractCredentials()[2];
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String url) {
        this.uri = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String env) {
        this.profile = env;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUsername() {
        return this.extractCredentials()[0];
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.extractCredentials()[1];
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    private String[] extractCredentials() {
        String uri;
        String[] result = new String[3];
        result[2] = uri = this.uri;
        String[] creds = this.getUsernamePassword();
        result[0] = creds[0];
        result[1] = creds[1];
        try {
            String bare;
            URL url = new URL(uri);
            String userInfo = url.getUserInfo();
            if (StringUtils.isEmpty((Object)userInfo) || ":".equals(userInfo)) {
                return result;
            }
            result[2] = bare = UriComponentsBuilder.fromHttpUrl((String)uri).userInfo(null).build().toUriString();
            if (!userInfo.contains(":")) {
                userInfo = String.valueOf(userInfo) + ":";
            }
            String[] split = userInfo.split(":");
            result[0] = split[0];
            result[1] = split[1];
            if (creds[1] != null) {
                result[1] = creds[1];
                if ("user".equals(creds[0])) {
                    result[0] = split[0];
                }
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + uri);
        }
    }

    private String[] getUsernamePassword() {
        if (StringUtils.hasText((String)this.password)) {
            return new String[]{StringUtils.hasText((String)this.username) ? this.username.trim() : "user", this.password.trim()};
        }
        return new String[2];
    }

    public ConfigClientProperties override(Environment environment) {
        ConfigClientProperties override = new ConfigClientProperties();
        BeanUtils.copyProperties((Object)this, (Object)override);
        override.setName(environment.resolvePlaceholders("${spring.cloud.config.name:${spring.application.name:application}}"));
        if (environment.containsProperty("spring.cloud.config.profile")) {
            override.setProfile(environment.getProperty("spring.cloud.config.profile"));
        }
        if (environment.containsProperty("spring.cloud.config.label")) {
            override.setLabel(environment.getProperty("spring.cloud.config.label"));
        }
        return override;
    }

    public String toString() {
        return "ConfigClientProperties [name=" + this.name + ", env=" + this.profile + ", label=" + this.label + ", uri=" + this.uri + ", discovery.enabled=" + this.discovery.enabled + ", failFast=" + this.failFast + "]";
    }

    public static class Discovery {
        public static final String DEFAULT_CONFIG_SERVER = "CONFIGSERVER";
        private boolean enabled;
        private String serviceId = "CONFIGSERVER";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }
}

