/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.util.CollectionUtils;

public class ActuatorOpenApiCustomizer
implements GlobalOpenApiCustomizer {
    private final Pattern pathPathern = Pattern.compile("\\{(.*?)}");
    private final WebEndpointProperties webEndpointProperties;

    public ActuatorOpenApiCustomizer(WebEndpointProperties webEndpointProperties) {
        this.webEndpointProperties = webEndpointProperties;
    }

    private Stream<Map.Entry<String, PathItem>> actuatorPathEntryStream(OpenAPI openApi, String relativeSubPath) {
        String pathPrefix = this.webEndpointProperties.getBasePath() + Optional.ofNullable(relativeSubPath).orElse("");
        return Optional.ofNullable(openApi.getPaths()).map(LinkedHashMap::entrySet).map(Collection::stream).map(s -> s.filter(entry -> ((String)entry.getKey()).startsWith(pathPrefix))).orElse(Stream.empty());
    }

    private void handleActuatorPathParam(OpenAPI openApi) {
        this.actuatorPathEntryStream(openApi, "/").forEach(stringPathItemEntry -> {
            String path = (String)stringPathItemEntry.getKey();
            Matcher matcher = this.pathPathern.matcher(path);
            while (matcher.find()) {
                String pathParam = matcher.group(1);
                PathItem pathItem = (PathItem)stringPathItemEntry.getValue();
                pathItem.readOperations().forEach(operation -> {
                    List existingParameters = operation.getParameters();
                    Optional<Object> existingParam = Optional.empty();
                    if (!CollectionUtils.isEmpty((Collection)existingParameters)) {
                        existingParam = existingParameters.stream().filter(p -> pathParam.equals(p.getName())).findAny();
                    }
                    if (!existingParam.isPresent()) {
                        operation.addParametersItem(new PathParameter().name(pathParam).schema((Schema)new StringSchema()));
                    }
                });
            }
        });
    }

    private void handleActuatorOperationIdUniqueness(OpenAPI openApi) {
        HashSet usedOperationIds = new HashSet();
        this.actuatorPathEntryStream(openApi, null).sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(stringPathItemEntry -> ((PathItem)stringPathItemEntry.getValue()).readOperations().forEach(operation -> {
            String initialOperationId = operation.getOperationId();
            Object uniqueOperationId = operation.getOperationId();
            int counter = 1;
            while (!usedOperationIds.add(uniqueOperationId)) {
                uniqueOperationId = initialOperationId + "_" + ++counter;
            }
            operation.setOperationId((String)uniqueOperationId);
        }));
    }

    @Override
    public void customise(OpenAPI openApi) {
        this.handleActuatorPathParam(openApi);
        this.handleActuatorOperationIdUniqueness(openApi);
    }
}

