/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.tools;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class QrCodeCreateUtil {
    private static final Logger log = LoggerFactory.getLogger(QrCodeCreateUtil.class);
    private static int onColor = -16777215;
    private static int offColor = -1;

    private QrCodeCreateUtil() {
    }

    public static BufferedImage crateQR(BarcodeFormat type, String content, int width, int height) {
        if (!StringUtils.isEmpty((Object)content)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            hints.put(EncodeHintType.MARGIN, 1);
            try {
                MatrixToImageConfig config = new MatrixToImageConfig(onColor, offColor);
                MultiFormatWriter writer = new MultiFormatWriter();
                BitMatrix bitMatrix = writer.encode(content, type, width, height, hints);
                BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)config);
                ImageIO.write((RenderedImage)bufferedImage, "png", os);
                return bufferedImage;
            }
            catch (Exception e) {
                log.info("\u5f02\u5e38{}", (Throwable)e);
            }
        }
        return null;
    }

    public static BufferedImage addLogo(String logoPath, BufferedImage qrCode) throws IOException {
        URL url = new URL(logoPath);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        BufferedImage logoImage = ImageIO.read(inputStream);
        int logoWidth = qrCode.getWidth() / 5;
        int logoHeight = qrCode.getHeight() / 5;
        int logoX = (qrCode.getWidth() - logoWidth) / 2;
        int logoY = (qrCode.getHeight() - logoHeight) / 2;
        Graphics2D graphics = qrCode.createGraphics();
        graphics.drawImage(logoImage, logoX, logoY, logoWidth, logoHeight, null);
        graphics.dispose();
        return qrCode;
    }
}

