/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.tools;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelUtil {
    public static SXSSFWorkbook createExecl(String[] titles, String[] alias, List list) {
        JSONArray ja = JSONArray.parseArray((String)JSON.toJSONString((Object)list));
        return ExcelUtil.createExecl(titles, alias, ja);
    }

    public static SXSSFWorkbook createExecl(String[] titles, String[] alias, JSONArray data) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet("Sheet1");
        Row rowTitle = sheet.createRow(0);
        for (int i = 0; i < titles.length; ++i) {
            Cell cell = rowTitle.createCell(i);
            cell.setCellValue(titles[i]);
        }
        Iterator it = data.iterator();
        int j = 1;
        CellStyle cellStyle = workbook.createCellStyle();
        while (it.hasNext()) {
            JSONObject jsonObject = (JSONObject)it.next();
            Row tmpRow = sheet.createRow(j);
            for (int i = 0; i < alias.length; ++i) {
                Cell cell = tmpRow.createCell(i);
                Object param = jsonObject.get((Object)alias[i]);
                if (param instanceof Integer) {
                    cell.setCellValue((double)((Integer)param).intValue());
                    continue;
                }
                if (param instanceof String) {
                    cell.setCellValue((String)param);
                    continue;
                }
                if (param instanceof Double) {
                    double d = (Double)param;
                    cell.setCellValue(d);
                    continue;
                }
                if (param instanceof Float) {
                    float f = ((Float)param).floatValue();
                    cell.setCellValue((double)f);
                    continue;
                }
                if (param instanceof Long) {
                    long l = (Long)param;
                    cell.setCellValue(new Date(l));
                    DataFormat dateFormat = workbook.createDataFormat();
                    cellStyle.setDataFormat(dateFormat.getFormat("yyyy/MM/dd HH:mm:ss"));
                    cell.setCellStyle(cellStyle);
                    continue;
                }
                if (param instanceof Boolean) {
                    cell.setCellValue(((Boolean)param).booleanValue());
                    continue;
                }
                if (param instanceof Date) {
                    cell.setCellValue((Date)param);
                    continue;
                }
                if (!(param instanceof BigDecimal)) continue;
                BigDecimal d = (BigDecimal)param;
                cell.setCellValue(d.setScale(2, RoundingMode.HALF_UP).doubleValue());
                cell.setCellStyle(cellStyle);
            }
            ++j;
        }
        return workbook;
    }
}

