/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.tools;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class QrCodeCreateUtil {
    private static final Logger log = LoggerFactory.getLogger(QrCodeCreateUtil.class);

    private QrCodeCreateUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage drawImage(String backgroundPath, BufferedImage zxingImage, int x, int y) {
        BufferedImage backgroundImage = null;
        try (FileInputStream imagein = new FileInputStream(backgroundPath);){
            backgroundImage = ImageIO.read(imagein);
            BufferedImage bufferedImage = QrCodeCreateUtil.drawImage(backgroundImage, zxingImage, x, y);
            return bufferedImage;
        }
        catch (IOException e) {
            log.info("\u5f02\u5e38{}", (Throwable)e);
            return backgroundImage;
        }
    }

    public static BufferedImage drawImage(BufferedImage backgroundImage, BufferedImage zxingImage, int x, int y) throws IOException {
        Objects.requireNonNull(backgroundImage, ">>>>>\u80cc\u666f\u56fe\u4e0d\u53ef\u4e3a\u7a7a");
        Objects.requireNonNull(zxingImage, ">>>>>\u4e8c\u7ef4\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        if (zxingImage.getWidth() + x > backgroundImage.getWidth() || zxingImage.getHeight() + y > backgroundImage.getHeight()) {
            throw new IOException(">>>>>\u4e8c\u7ef4\u7801\u5bbd\u5ea6+x\u4e0d\u53ef\u4ee5\u8d85\u8fc7\u80cc\u666f\u56fe\u7684\u5bbd\u5ea6,\u957f\u5ea6\u540c\u7406");
        }
        Graphics2D g = backgroundImage.createGraphics();
        g.drawImage(zxingImage, x, y, zxingImage.getWidth(), zxingImage.getHeight(), null);
        return backgroundImage;
    }

    public static BufferedImage crateQR(BarcodeFormat type, String content, int width, int height) throws IOException {
        if (!StringUtils.isEmpty((Object)content)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            hints.put(EncodeHintType.MARGIN, 1);
            try {
                MultiFormatWriter writer = new MultiFormatWriter();
                BitMatrix bitMatrix = writer.encode(content, type, width, height, hints);
                BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                ImageIO.write((RenderedImage)bufferedImage, "png", os);
                return bufferedImage;
            }
            catch (Exception e) {
                log.info("\u5f02\u5e38{}", (Throwable)e);
            }
        }
        return null;
    }

    public static BufferedImage overlapImage(String imagePath, BufferedImage qrCode) throws IOException {
        URL url = new URL(imagePath);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        BufferedImage image = ImageIO.read(inputStream);
        int logoX = image.getWidth() / 4 * 3;
        int logoY = image.getHeight() / 5 * 4;
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(qrCode, logoX, logoY, qrCode.getWidth(), qrCode.getHeight(), null);
        return image;
    }
}

