/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.tools;

import java.util.Arrays;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.signal.framework.annotation.OpMsg;
import org.signal.framework.tools.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Aspect
public class MsgAspect {
    private static final Logger log = LoggerFactory.getLogger(MsgAspect.class);
    RestTemplate restTemplate;

    @Pointcut(value="@annotation(org.signal.framework.annotation.OpMsg)")
    public void methodPointcut() {
    }

    @Around(value="methodPointcut() && @annotation(opMsg)", argNames="opMsg")
    public Object doAround(ProceedingJoinPoint pjp, OpMsg opMsg) throws Throwable {
        log.info("\u6ce8\u89e3\u53c2\u6570:{}", (Object)opMsg.content());
        Map<String, Object> map = MapBuilder.builder().map("msg", opMsg.content()).build().getMaps();
        ResponseEntity msg = this.restTemplate.postForEntity("http://SYSTEM/wordlib/test", map, String.class, new Object[0]);
        log.info("\u8fd4\u56de\u503c\uff1a{}", (Object)msg);
        log.info("[aop]\u6267\u884c\u65b9\u6cd5:{}.{}(..)", (Object)pjp.getTarget().getClass().getName(), (Object)pjp.getSignature().getName());
        log.info("[aop]\u65b9\u6cd5\u53c2\u6570:{} ", (Object)Arrays.toString(pjp.getArgs()));
        long time = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        time = System.currentTimeMillis() - time;
        log.info("[aop]\u65b9\u6cd5\u8017\u65f6:{}ms  \u65b9\u6cd5\u8fd4\u56de\u503c:{}\n", (Object)time, retVal);
        return retVal;
    }
}

