/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.tools;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtil {
    private static final Logger log = LoggerFactory.getLogger(RSAUtil.class);

    public static String encryptStringForBase64(String publicKeyStr, String plaintext) throws Exception {
        if (plaintext == null) {
            return null;
        }
        byte[] data = plaintext.getBytes();
        RSAPublicKey rsaPublicKey = RSAUtil.loadPublicKey(publicKeyStr);
        try {
            Cipher ci = Cipher.getInstance("RSA");
            ci.init(1, rsaPublicKey);
            byte[] endata = ci.doFinal(data);
            return new String(Base64.encodeBase64((byte[])endata));
        }
        catch (NullPointerException ex) {
            log.error("keyPair cannot be null.");
            log.error("\u5f02\u5e38{}", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error(ex.getCause().getMessage());
            log.error("\u5f02\u5e38{}", (Throwable)ex);
        }
        return null;
    }

    private static RSAPublicKey loadPublicKey(String publicKeyStr) throws Exception {
        try {
            byte[] buffer = DatatypeConverter.parseBase64Binary((String)publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5", e);
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a", e);
        }
    }
}

