/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.config;

import java.util.Collections;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@Configuration
public class TransactionAdviceConfig {
    private static final String AOP_POINTCUT_EXPRESSION = "execution(* com.hy.sb.*.service..*.*(..))";

    @Bean
    public TransactionInterceptor txAdvice(PlatformTransactionManager transactionManager) {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        source.addTransactionalMethod("add*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("save*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("insert*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("update*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("modify*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("del*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("remove*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("exec*", (TransactionAttribute)this.requiredTransactionRule());
        source.addTransactionalMethod("get*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("query*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("find*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("list*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("count*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("is*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("has*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("page*", (TransactionAttribute)this.readOnlyTransactionRule());
        source.addTransactionalMethod("search*", (TransactionAttribute)this.readOnlyTransactionRule());
        return new TransactionInterceptor(transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor(PlatformTransactionManager transactionManager) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice(transactionManager));
    }

    private RuleBasedTransactionAttribute requiredTransactionRule() {
        RuleBasedTransactionAttribute required = new RuleBasedTransactionAttribute();
        required.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Exception.class)));
        required.setPropagationBehavior(0);
        required.setTimeout(-1);
        return required;
    }

    private RuleBasedTransactionAttribute readOnlyTransactionRule() {
        RuleBasedTransactionAttribute readOnly = new RuleBasedTransactionAttribute();
        readOnly.setReadOnly(true);
        readOnly.setPropagationBehavior(1);
        return readOnly;
    }
}

