/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder {
    private Map<String, Object> maps;

    MapBuilder(Map<String, Object> maps) {
        this.maps = maps;
    }

    public static MapBuilderBuilder builder() {
        return new MapBuilderBuilder();
    }

    public Map<String, Object> getMaps() {
        return this.maps;
    }

    public static class MapBuilderBuilder {
        private ArrayList<String> maps$key;
        private ArrayList<Object> maps$value;

        MapBuilderBuilder() {
        }

        public MapBuilderBuilder map(String mapKey, Object mapValue) {
            if (this.maps$key == null) {
                this.maps$key = new ArrayList();
                this.maps$value = new ArrayList();
            }
            this.maps$key.add(mapKey);
            this.maps$value.add(mapValue);
            return this;
        }

        public MapBuilderBuilder maps(Map<? extends String, ? extends Object> maps) {
            if (this.maps$key == null) {
                this.maps$key = new ArrayList();
                this.maps$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : maps.entrySet()) {
                this.maps$key.add($lombokEntry.getKey());
                this.maps$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public MapBuilderBuilder clearMaps() {
            if (this.maps$key != null) {
                this.maps$key.clear();
                this.maps$value.clear();
            }
            return this;
        }

        public MapBuilder build() {
            Map<String, Object> maps;
            switch (this.maps$key == null ? 0 : this.maps$key.size()) {
                case 0: {
                    maps = Collections.emptyMap();
                    break;
                }
                case 1: {
                    maps = Collections.singletonMap(this.maps$key.get(0), this.maps$value.get(0));
                    break;
                }
                default: {
                    maps = new LinkedHashMap<String, Object>(this.maps$key.size() < 0x40000000 ? 1 + this.maps$key.size() + (this.maps$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.maps$key.size(); ++$i) {
                        maps.put(this.maps$key.get($i), this.maps$value.get($i));
                    }
                    maps = Collections.unmodifiableMap(maps);
                }
            }
            return new MapBuilder(maps);
        }

        public String toString() {
            return "MapBuilder.MapBuilderBuilder(maps$key=" + this.maps$key + ", maps$value=" + this.maps$value + ")";
        }
    }
}

