/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pinyin4jUtil {
    private static final Logger log = LoggerFactory.getLogger(Pinyin4jUtil.class);

    public static String converterToFirstSpell(String chines) {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (strs == null) continue;
                    pinyinName = Pinyin4jUtil.getFirstSpell(strs, pinyinName);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    log.error("\u9519\u8bef", (Throwable)e);
                }
            } else {
                pinyinName.append(nameChar[i]);
            }
            pinyinName.append(" ");
        }
        return Pinyin4jUtil.parseTheChineseByObject(Pinyin4jUtil.discountTheChinese(pinyinName.toString()));
    }

    private static StringBuilder getFirstSpell(String[] strs, StringBuilder pinyinName) {
        for (int j = 0; j < strs.length; ++j) {
            pinyinName.append(strs[j].charAt(0));
            if (j == strs.length - 1) continue;
            pinyinName.append(",");
        }
        return pinyinName;
    }

    public static String converterToSpell(String chines) {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (strs == null) continue;
                    pinyinName = Pinyin4jUtil.setPinyinName(strs, pinyinName);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    log.error("\u9519\u8bef", (Throwable)e);
                }
            } else {
                pinyinName.append(nameChar[i]);
            }
            pinyinName.append(" ");
        }
        return Pinyin4jUtil.parseTheChineseByObject(Pinyin4jUtil.discountTheChinese(pinyinName.toString()));
    }

    private static StringBuilder setPinyinName(String[] strs, StringBuilder pinyinName) {
        for (int j = 0; j < strs.length; ++j) {
            pinyinName.append(strs[j]);
            if (j == strs.length - 1) continue;
            pinyinName.append(",");
        }
        return pinyinName;
    }

    private static List<Map<String, Integer>> discountTheChinese(String theStr) {
        String[] firsts;
        ArrayList<Map<String, Integer>> mapList = new ArrayList<Map<String, Integer>>();
        Hashtable<String, Integer> onlyOne = null;
        for (String str : firsts = theStr.split(" ")) {
            String[] china;
            onlyOne = new Hashtable<String, Integer>();
            for (String s : china = str.split(",")) {
                Integer count = (Integer)onlyOne.get(s);
                if (count == null) {
                    onlyOne.put(s, 1);
                    continue;
                }
                onlyOne.remove(s);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                onlyOne.put(s, count);
            }
            mapList.add(onlyOne);
        }
        return mapList;
    }

    private static String parseTheChineseByObject(List<Map<String, Integer>> list) {
        Map<String, Integer> first = null;
        for (int i = 0; i < list.size(); ++i) {
            first = Pinyin4jUtil.getFirst(list, first, i);
        }
        StringBuilder returnStr = new StringBuilder();
        String returnString = null;
        if (first != null) {
            for (String str : first.keySet()) {
                returnStr.append(str + ",");
            }
        }
        if (returnStr.length() > 0) {
            returnString = returnStr.substring(0, returnStr.length() - 1);
        }
        if (returnString != null) {
            return returnString.split(",")[0];
        }
        return returnString;
    }

    private static Map<String, Integer> getFirst(List<Map<String, Integer>> list, Map<String, Integer> first, int i) {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        if (first != null) {
            for (String s : first.keySet()) {
                for (String s1 : list.get(i).keySet()) {
                    String str = s + s1;
                    temp.put(str, 1);
                }
            }
            if (!temp.isEmpty()) {
                first.clear();
            }
        } else {
            Iterator<String> iterator = list.get(i).keySet().iterator();
            while (iterator.hasNext()) {
                String s;
                String str = s = iterator.next();
                temp.put(str, 1);
            }
        }
        if (!temp.isEmpty()) {
            first = temp;
        }
        return first;
    }
}

