/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.exception;

import com.alibaba.fastjson.JSON;
import org.signal.framework.exception.GlobalException;
import org.signal.framework.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice(annotations={RestController.class, Controller.class})
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public String handlerRuntimeException(RuntimeException ex) {
        log.error("RuntimeException", (Throwable)ex);
        Message msg = new Message("RuntimeException: " + ex.toString(), 500);
        msg.setContent(ex.getStackTrace());
        return JSON.toJSONString((Object)msg);
    }

    @ExceptionHandler(value={GlobalException.class})
    @ResponseBody
    public String handlerGlobalRuntimeException(GlobalException ex) {
        log.error("\u81ea\u5b9a\u4e49\u5168\u5c40\u5f02\u5e38", (Throwable)ex);
        return JSON.toJSONString((Object)ex);
    }
}

