/*
 * Decompiled with CFR 0.152.
 */
package org.signal.framework.dao;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.signal.framework.dao.BaseDao;
import org.signal.framework.model.Page;

public class BaseDaoImpl<T>
implements BaseDao<T> {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<T> find(String hql, Map<String, Object> map) {
        Query query = this.createQuery(hql, map);
        return query.getResultList();
    }

    @Override
    public List findBySql(String sql, Map<String, Object> map) {
        Query query = this.createNativeQuery(sql, map);
        return query.getResultList();
    }

    @Override
    public int executeHql(String hql, Map<String, Object> map) {
        Query query = this.createQuery(hql, map);
        return query.executeUpdate();
    }

    @Override
    public int executeSql(String sql, Map<String, Object> map) {
        Query query = this.createNativeQuery(sql, map);
        return query.executeUpdate();
    }

    private Query createNativeQuery(String sql, Map<String, Object> map) {
        Query query = this.entityManager.createNativeQuery(sql);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    @Override
    public Page pagedSql(String sql, Page page, Map<String, Object> map) {
        BigInteger totalCount = this.getCount(sql, map);
        page.setCount(totalCount.longValue());
        List list = this.queryList(sql, page, map);
        page.setList(list);
        return page;
    }

    private BigInteger getCount(String sql, Map<String, Object> map) {
        sql = "SELECT COUNT(*) FROM (" + sql + ") as a";
        Query countQuery = this.createNativeQuery(sql, map);
        return (BigInteger)countQuery.getSingleResult();
    }

    private List queryList(String sql, Page page, Map<String, Object> map) {
        if (StringUtils.isNotBlank((CharSequence)page.getOrderBy())) {
            sql = sql + " order by " + page.getOrderBy();
        }
        Query query = this.createNativeQuery(sql, map);
        query.setFirstResult((page.getIndex() - 1) * page.getSize());
        query.setMaxResults(page.getSize());
        return query.getResultList();
    }

    @Override
    public void executeProcedure(String procedure, Map<String, Object> map) throws SQLException {
    }

    private Query createQuery(String hql, Map<String, Object> map) {
        Query query = this.entityManager.createQuery(hql);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    @Override
    public Page pagedQuery(String hql, Map<String, Object> map, Page page) {
        if (StringUtils.isNotBlank((CharSequence)page.getOrderBy())) {
            hql = hql + " order by " + page.getOrderBy();
        }
        Long count = this.getCount(map, hql);
        page.setCount(count);
        Query query = this.createQuery(hql, map);
        query.setFirstResult((page.getIndex() - 1) * page.getSize());
        query.setMaxResults(page.getSize());
        List list = query.getResultList();
        page.setList(list);
        return page;
    }

    private Long getCount(Map<String, Object> map, String hql) {
        String[] sections = hql.split("\\s");
        String first = sections[0].toUpperCase();
        hql = "SELECT COUNT(*) " + ("FROM".equals(first) ? hql : "FROM (" + hql + ")");
        Query query = this.createQuery(hql, map);
        return (Long)query.getSingleResult();
    }
}

