/*
 * Decompiled with CFR 0.152.
 */
package com.stardust.autojs.apkbuilder;

import com.stardust.autojs.apkbuilder.ApkPackager;
import com.stardust.autojs.apkbuilder.ManifestEditor;
import com.stardust.autojs.apkbuilder.util.DirsDelete;
import com.stardust.autojs.apkbuilder.util.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import zhao.arsceditor.ResDecoder.ARSCDecoder;

public class ApkBuilder {
    private File mOutApkFile;
    private ApkPackager mApkPackager;
    private ManifestEditor mManifestEditor;
    private String mWorkspacePath;
    private String mArscPackageName;
    private ProgressCallback mProgressCallback;

    public ApkBuilder setProgressCallback(ProgressCallback callback) {
        this.mProgressCallback = callback;
        return this;
    }

    public ApkBuilder(InputStream apkInputStream, File outApkFile, String workspacePath) {
        this.mOutApkFile = outApkFile;
        this.mWorkspacePath = workspacePath;
        this.mApkPackager = new ApkPackager(apkInputStream, this.mWorkspacePath);
    }

    public ApkBuilder(File inFile, File outFile, String workspacePath) throws FileNotFoundException {
        this(new FileInputStream(inFile), outFile, workspacePath);
    }

    public ApkBuilder prepare() throws IOException {
        File dirs = new File(this.mWorkspacePath);
        DirsDelete.deleteDir(dirs);
        dirs.mkdirs();
        this.mApkPackager.unzip();
        return this;
    }

    private File getManifestFile() {
        return new File(this.mWorkspacePath, "AndroidManifest.xml");
    }

    public ManifestEditor editManifest() throws FileNotFoundException {
        this.mManifestEditor = new ManifestEditor(new FileInputStream(this.getManifestFile()));
        return this.mManifestEditor;
    }

    public ApkBuilder setArscPackageName(String packageName) throws IOException {
        this.mArscPackageName = packageName;
        return this;
    }

    public ApkBuilder replaceFile(String relativePath, String newFilePath) throws IOException {
        StreamUtils.write(new FileInputStream(newFilePath), new FileOutputStream(new File(this.mWorkspacePath, relativePath)));
        return this;
    }

    public ApkBuilder build() throws IOException {
        if (this.mManifestEditor != null) {
            this.mManifestEditor.writeTo(new FileOutputStream(this.getManifestFile()));
        }
        if (this.mArscPackageName != null) {
            this.buildArsc();
        }
        return this;
    }

    private void buildArsc() throws IOException {
        File oldArsc = new File(this.mWorkspacePath, "resources.arsc");
        File newArsc = new File(this.mWorkspacePath, "resources.arsc.new");
        ARSCDecoder decoder = new ARSCDecoder(new BufferedInputStream(new FileInputStream(oldArsc)), null, false);
        FileOutputStream fos = new FileOutputStream(newArsc);
        decoder.CloneArsc(fos, this.mArscPackageName, true);
        oldArsc.delete();
        newArsc.renameTo(oldArsc);
    }

    public ApkBuilder sign() throws Exception {
        this.mApkPackager.repackage(this.mOutApkFile.getPath());
        this.mProgressCallback.onSign(this);
        return this;
    }

    public ApkBuilder cleanWorkspace() {
        this.delete(new File(this.mWorkspacePath));
        return this;
    }

    private void delete(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        for (File child : file.listFiles()) {
            this.delete(child);
        }
        file.delete();
    }

    public static interface ProgressCallback {
        public void onPrepare(ApkBuilder var1);

        public void onBuild(ApkBuilder var1);

        public void onSign(ApkBuilder var1);

        public void onClean(ApkBuilder var1);
    }
}

