/*
 * Decompiled with CFR 0.152.
 */
package com.stardust.autojs.apkbuilder;

import com.stardust.autojs.apkbuilder.util.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pxb.android.tinysign.TinySign;

public class ApkPackager {
    private InputStream mApkInputStream;
    private String mWorkspacePath;

    public ApkPackager(InputStream apkInputStream, String workspacePath) {
        this.mApkInputStream = apkInputStream;
        this.mWorkspacePath = workspacePath;
    }

    public ApkPackager(String apkPath, String workspacePath) throws FileNotFoundException {
        this.mApkInputStream = new FileInputStream(apkPath);
        this.mWorkspacePath = workspacePath;
    }

    public void unzip() throws IOException {
        ZipInputStream zis = new ZipInputStream(this.mApkInputStream);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            if (zipEntry.getName().endsWith("/") || zipEntry.getName().endsWith("\\")) {
                File file = new File(this.mWorkspacePath, name);
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                StreamUtils.write(zis, fos);
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.close();
    }

    public void repackage(String newApkPath) throws Exception {
        FileOutputStream fos = new FileOutputStream(newApkPath);
        TinySign.sign((File)new File(this.mWorkspacePath), (OutputStream)fos);
        fos.close();
    }

    public void cleanWorkspace() {
    }
}

