/*
 * Decompiled with CFR 0.152.
 */
package com.stardust.autojs.apkbuilder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import pxb.android.StringItem;
import pxb.android.axml.AxmlReader;
import pxb.android.axml.AxmlWriter;
import pxb.android.axml.NodeVisitor;

public class ManifestEditor {
    private static final String NS_ANDROID = "http://schemas.android.com/apk/res/android";
    private InputStream mManifestInputStream;
    private int mVersionCode = -1;
    private String mVersionName;
    private String mAppName;
    private String mPackageName;
    private byte[] mManifestData;

    public ManifestEditor(InputStream manifestInputStream) {
        this.mManifestInputStream = manifestInputStream;
    }

    public ManifestEditor setVersionCode(int versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    public ManifestEditor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    public ManifestEditor setAppName(String appName) {
        this.mAppName = appName;
        return this;
    }

    public ManifestEditor setPackageName(String packageName) {
        this.mPackageName = packageName;
        return this;
    }

    public ManifestEditor commit() throws IOException {
        MutableAxmlWriter writer = new MutableAxmlWriter();
        AxmlReader reader = new AxmlReader(IOUtils.readFully((InputStream)this.mManifestInputStream, (int)this.mManifestInputStream.available()));
        reader.accept(writer);
        this.mManifestData = writer.toByteArray();
        return this;
    }

    public void writeTo(OutputStream manifestOutputStream) throws IOException {
        manifestOutputStream.write(this.mManifestData);
        manifestOutputStream.close();
    }

    public void onAttr(AxmlWriter.Attr attr) {
        if ("package".equals(attr.name.data) && this.mPackageName != null && attr.value instanceof StringItem) {
            ((StringItem)attr.value).data = this.mPackageName;
            return;
        }
        if (attr.ns == null || !NS_ANDROID.equals(attr.ns.data)) {
            return;
        }
        if ("versionCode".equals(attr.name.data) && this.mVersionCode != -1) {
            attr.value = this.mVersionCode;
            return;
        }
        if ("versionName".equals(attr.name.data) && this.mVersionName != null && attr.value instanceof StringItem) {
            attr.value = new StringItem(this.mVersionName);
            ((StringItem)attr.value).data = this.mVersionName;
            return;
        }
        if ("label".equals(attr.name.data) && this.mAppName != null && attr.value instanceof StringItem) {
            ((StringItem)attr.value).data = this.mAppName;
            return;
        }
    }

    private class MutableAxmlWriter
    extends AxmlWriter {
        private MutableAxmlWriter() {
        }

        @Override
        public NodeVisitor child(String ns, String name) {
            MutableNodeImpl first = new MutableNodeImpl(ns, name);
            this.firsts.add(first);
            return first;
        }

        private class MutableNodeImpl
        extends AxmlWriter.NodeImpl {
            MutableNodeImpl(String ns, String name) {
                super(ns, name);
            }

            @Override
            protected void onAttr(AxmlWriter.Attr a) {
                ManifestEditor.this.onAttr(a);
                super.onAttr(a);
            }

            @Override
            public NodeVisitor child(String ns, String name) {
                MutableNodeImpl child = new MutableNodeImpl(ns, name);
                this.children.add(child);
                return child;
            }
        }
    }
}

