/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.openeuler.SM2KeyExchangeParameterSpec;
import org.openeuler.SM2KeyExchangeUtil;

public class SM2KeyAgreement
extends KeyAgreementSpi {
    private ECPublicKey localPublicKey;
    private ECPrivateKey localPrivateKey;
    private byte[] localId;
    private BigInteger localRandom;
    private ECPublicKey peerPublicKey;
    private byte[] peerRBytes;
    private byte[] peerId;
    private int secretLen;
    private boolean useClientMode;

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECPrivateKey expected");
        }
        this.localPrivateKey = (ECPrivateKey)key;
        SM2KeyExchangeParameterSpec parameterSpec = this.checkParams(params);
        this.localPublicKey = parameterSpec.getLocalPublicKey() == null ? SM2KeyExchangeUtil.generatePublicKey(this.localPrivateKey) : (ECPublicKey)parameterSpec.getLocalPublicKey();
        this.localId = parameterSpec.getLocalId();
        this.localRandom = parameterSpec.getLocalRandom();
        this.peerId = parameterSpec.getPeerId();
        this.peerRBytes = parameterSpec.getPeerRBytes();
        this.secretLen = parameterSpec.getSecretLen();
        this.useClientMode = parameterSpec.isUseClientMode();
    }

    private SM2KeyExchangeParameterSpec checkParams(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof SM2KeyExchangeParameterSpec)) {
            throw new InvalidAlgorithmParameterException("SM2KeyExchangeParameterSpec parameters expected");
        }
        SM2KeyExchangeParameterSpec parameterSpec = (SM2KeyExchangeParameterSpec)params;
        if (parameterSpec.getLocalPublicKey() != null & !(parameterSpec.getLocalPublicKey() instanceof ECPublicKey)) {
            throw new InvalidAlgorithmParameterException("The localPublicKey must be ECPublicKey");
        }
        if (parameterSpec.getLocalId() == null) {
            throw new InvalidAlgorithmParameterException("The localId cannot be null");
        }
        if (parameterSpec.getLocalRandom() == null) {
            throw new InvalidAlgorithmParameterException("The localRandom cannot be null");
        }
        if (parameterSpec.getPeerId() == null) {
            throw new InvalidAlgorithmParameterException("The peerId cannot be null");
        }
        if (parameterSpec.getPeerRBytes() == null) {
            throw new InvalidAlgorithmParameterException("The peerRBytes cannot be null");
        }
        if (parameterSpec.getSecretLen() < 0) {
            throw new InvalidAlgorithmParameterException("The keyLength cannot be less than 0");
        }
        return parameterSpec;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.localPrivateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        this.peerPublicKey = (ECPublicKey)key;
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] sharedSecretKey;
        if (this.localPrivateKey == null || this.peerPublicKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        try {
            sharedSecretKey = SM2KeyExchangeUtil.generateSharedSecret(this.localPublicKey, this.localPrivateKey, this.localRandom, this.localId, this.peerPublicKey, this.peerRBytes, this.peerId, this.secretLen, this.useClientMode);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return sharedSecretKey;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (offset + this.secretLen > sharedSecret.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), algorithm);
    }
}

