/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import com.gradle.scan.plugin.BuildScanExtension;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.SizeMetricType;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.stat.BuildFinishStatisticsData;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatisticsData;
import org.jetbrains.kotlin.gradle.plugin.stat.GradleBuildStartParameters;
import org.jetbrains.kotlin.gradle.plugin.stat.StatTag;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.gradle.report.BuildReportsService;
import org.jetbrains.kotlin.gradle.report.BuildScanExtensionHolder;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.FileReportSettings;
import org.jetbrains.kotlin.gradle.report.HttpReportSettings;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionInfo;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.TaskExecutionState;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002:;B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0007H\u0002J \u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0012\u0010$\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0018H\u0016J\u0012\u0010)\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010,\u001a\u00020\u0018H\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u000203H\u0002J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\u00070+2\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\tH\u0002J\u0014\u00107\u001a\u000208*\u0002082\u0006\u00109\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0011R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Parameters;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildUuid", "", "customValues", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "invalidUrl", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "log$1", "requestPreviousFailed", "startTime", "", "tags", "Ljava/util/LinkedHashSet;", "addBuildScanReport", "", "event", "Lorg/gradle/tooling/events/FinishEvent;", "buildScan", "Lorg/jetbrains/kotlin/gradle/report/BuildScanExtensionHolder;", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatisticsData;", "customValuesLimit", "addBuildScanTag", "tag", "addBuildScanValue", "customValue", "addHttpReport", "checkResponseAndLog", "connection", "Ljava/net/HttpURLConnection;", "close", "onFinish", "readableString", "", "reportBuildFinish", "reportBuildStatInFile", "fileReportSettings", "Lorg/jetbrains/kotlin/gradle/report/FileReportSettings;", "buildData", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "sendDataViaHttp", "", "splitStringIfNeed", "str", "lengthLimit", "includeVerboseEnvironment", "Lorg/jetbrains/kotlin/gradle/plugin/stat/GradleBuildStartParameters;", "verboseEnvironment", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class BuildReportsService
implements BuildService<Parameters>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion;
    private final Logger log$1 = Logging.getLogger(this.getClass());
    private final long startTime = System.nanoTime();
    @NotNull
    private final String buildUuid;
    @NotNull
    private ExecutorService executorService;
    @NotNull
    private final LinkedHashSet<String> tags;
    private int customValues;
    private boolean invalidUrl;
    private boolean requestPreviousFailed;
    private static final Logger log;
    public static final int lengthLimit = 100000;
    @Nullable
    private static final String hostName;

    public BuildReportsService() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.buildUuid = string;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executorService = executorService;
        this.tags = new LinkedHashSet();
        this.log$1.info("Build report service is registered. Unique build id: " + this.buildUuid);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() {
        v0 = ((Parameters)this.getParameters()).getStartParameters().get();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"parameters.startParameters.get()");
        v1 = (GradleBuildStartParameters)v0;
        v2 = (BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().getOrNull();
        if (v2 == null || (v2 = v2.getFailureMessages$kotlin_gradle_plugin_common()) == null || (v2 = CollectionsKt.toList((Iterable)((Iterable)v2))) == null) {
            v2 = CollectionsKt.emptyList();
        }
        if ((v3 = (BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().getOrNull()) == null || (v3 = v3.getBuildOperationRecords$kotlin_gradle_plugin_common()) == null) ** GOTO lbl-1000
        $this$sortedBy$iv = (Iterable)v3;
        $i$f$sortedBy = false;
        v3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BuildOperationRecord it = (BuildOperationRecord)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStartTimeMs());
                it = (BuildOperationRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTimeMs()));
            }
        });
        if (v3 != null) {
            v4 = (Collection)v3;
        } else lbl-1000:
        // 2 sources

        {
            v4 = CollectionsKt.emptyList();
        }
        buildData = new BuildExecutionData(v1, (List<String>)v2, v4);
        reportingSettings = (ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get();
        v5 = reportingSettings.getHttpReportSettings();
        if (v5 != null) {
            var3_5 = v5;
            it = var3_5;
            $i$a$-also-BuildReportsService$close$1 = false;
            this.executorService.submit(new Runnable(this){
                final /* synthetic */ BuildReportsService this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    BuildReportsService.access$reportBuildFinish(this.this$0);
                }
            });
        }
        v6 = reportingSettings.getFileReportSettings();
        if (v6 != null) {
            var3_5 = v6;
            it = var3_5;
            $i$a$-also-BuildReportsService$close$2 = false;
            this.reportBuildStatInFile((FileReportSettings)it, buildData);
        }
        v7 = reportingSettings.getSingleOutputFile();
        if (v7 != null) {
            singleOutputFile = var3_5 = v7;
            $i$a$-also-BuildReportsService$close$3 = false;
            v8 = singleOutputFile.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"singleOutputFile.absoluteFile");
            v9 = new MetricsWriter(v8);
            v10 = this.log$1;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"log");
            v9.process(buildData, v10);
        }
        this.executorService.shutdown();
    }

    public void onFinish(@Nullable FinishEvent event) {
        this.addHttpReport(event);
    }

    private final void reportBuildStatInFile(FileReportSettings fileReportSettings, BuildExecutionData buildData) {
        String ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
        File reportFile = FilesKt.resolve((File)fileReportSettings.getBuildReportDir(), (String)((String)((Parameters)this.getParameters()).getProjectName().get() + "-build-" + ts + ".txt"));
        PlainTextBuildReportWriter plainTextBuildReportWriter = new PlainTextBuildReportWriter(reportFile, fileReportSettings.getIncludeMetricsInReport());
        Logger logger = this.log$1;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        plainTextBuildReportWriter.process(buildData, logger);
    }

    private final void reportBuildFinish() {
        Object object = ((Parameters)this.getParameters()).getProjectName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectName.get()");
        String string = (String)object;
        Object object2 = ((Parameters)this.getParameters()).getStartParameters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.startParameters.get()");
        HttpReportSettings httpReportSettings = ((ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get()).getHttpReportSettings();
        BuildFinishStatisticsData buildFinishData = new BuildFinishStatisticsData(string, this.includeVerboseEnvironment((GradleBuildStartParameters)object2, httpReportSettings != null ? httpReportSettings.getVerboseEnvironment() : false), this.buildUuid, (String)((Parameters)this.getParameters()).getLabel().getOrNull(), (System.nanoTime() - this.startTime) / (long)1000000, null, System.currentTimeMillis(), null, hostName, 160, null);
        this.sendDataViaHttp(buildFinishData);
    }

    private final GradleBuildStartParameters includeVerboseEnvironment(GradleBuildStartParameters $this$includeVerboseEnvironment, boolean verboseEnvironment) {
        return verboseEnvironment ? $this$includeVerboseEnvironment : new GradleBuildStartParameters($this$includeVerboseEnvironment.getTasks(), $this$includeVerboseEnvironment.getExcludedTasks(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private final void addHttpReport(FinishEvent event) {
        block1: {
            CompileStatisticsData data;
            if (((ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get()).getHttpReportSettings() == null || !(event instanceof TaskFinishEvent)) break block1;
            TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
            Object object = ((Parameters)this.getParameters()).getProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectName.get()");
            String string = (String)object;
            String string2 = (String)((Parameters)this.getParameters()).getLabel().getOrNull();
            Object object2 = ((Parameters)this.getParameters()).getKotlinVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.kotlinVersion.get()");
            String string3 = (String)object2;
            Object object3 = ((Parameters)this.getParameters()).getAdditionalTags().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.additionalTags.get()");
            CompileStatisticsData compileStatisticsData = data = Companion.prepareData$kotlin_gradle_plugin_common(taskFinishEvent, string, this.buildUuid, string2, string3, (List)object3);
            if (compileStatisticsData != null) {
                CompileStatisticsData compileStatisticsData2;
                CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                boolean bl = false;
                this.executorService.submit(new Runnable(this, data){
                    final /* synthetic */ BuildReportsService this$0;
                    final /* synthetic */ CompileStatisticsData $data;
                    {
                        this.this$0 = $receiver;
                        this.$data = $data;
                    }

                    public final void run() {
                        BuildReportsService.access$sendDataViaHttp(this.this$0, this.$data);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendDataViaHttp(Object data) {
        HttpURLConnection httpURLConnection;
        HttpReportSettings httpReportSettings = ((ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get()).getHttpReportSettings();
        if (httpReportSettings == null) {
            return;
        }
        HttpReportSettings httpSettings = httpReportSettings;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.invalidUrl) {
            return;
        }
        try {
            URLConnection uRLConnection = new URL(httpSettings.getUrl()).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        catch (IOException e) {
            this.log$1.warn("Unable to open connection to " + httpSettings.getUrl() + ": " + e.getMessage());
            this.invalidUrl = true;
            return;
        }
        HttpURLConnection connection = httpURLConnection;
        try {
            Object auth;
            Charset charset;
            Object object;
            if (httpSettings.getUser() != null && httpSettings.getPassword() != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = (httpSettings.getUser() + ':' + httpSettings.getPassword()).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder()\n           \u2026password}\".toByteArray())");
                object = byArray2;
                charset = Charsets.UTF_8;
                auth = new String((byte[])object, charset);
                connection.addRequestProperty("Authorization", "Basic " + (String)auth);
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            object = null;
            try {
                OutputStream it = (OutputStream)auth;
                boolean bl2 = false;
                String string = new Gson().toJson(data);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(data)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                charset = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object);
            }
            connection.connect();
            this.checkResponseAndLog(connection);
        }
        catch (Exception e) {
            this.log$1.debug("Unexpected exception happened " + e.getMessage() + ": " + e.getStackTrace());
            this.checkResponseAndLog(connection);
        }
        finally {
            connection.disconnect();
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log$1.debug("Report statistic by http takes " + elapsedTime + " ms");
    }

    private final void checkResponseAndLog(HttpURLConnection connection) {
        boolean isResponseBad;
        int n = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n ? n < 300 : false);
        if (isResponseBad) {
            String message2 = "Failed to send statistic to " + connection.getURL() + " with " + connection.getResponseCode() + ": " + connection.getResponseMessage();
            if (!this.requestPreviousFailed) {
                this.log$1.warn(message2);
            } else {
                this.log$1.debug(message2);
            }
            this.requestPreviousFailed = true;
        }
    }

    private final void addBuildScanReport(FinishEvent event, BuildScanExtensionHolder buildScan) {
        block1: {
            BuildScanSettings buildScanSettings;
            ReportingSettings reportingSettings = (ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().getOrNull();
            BuildScanSettings buildScanSettings2 = buildScanSettings = reportingSettings != null ? reportingSettings.getBuildScanReportSettings() : null;
            if (buildScanSettings == null || buildScan.getBuildScan() == null || !(event instanceof TaskFinishEvent)) break block1;
            boolean $i$f$measureTimeMillisWithResult = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
            Object object = ((Parameters)this.getParameters()).getProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectName.get()");
            String string = (String)object;
            String string2 = (String)((Parameters)this.getParameters()).getLabel().getOrNull();
            Object object2 = ((Parameters)this.getParameters()).getKotlinVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.kotlinVersion.get()");
            CompileStatisticsData result$iv = org.jetbrains.kotlin.gradle.report.BuildReportsService$Companion.prepareData$kotlin_gradle_plugin_common$default(Companion, taskFinishEvent, string, this.buildUuid, string2, (String)object2, null, 32, null);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long collectDataDuration = ((Number)pair.component1()).longValue();
            CompileStatisticsData compileStatData = (CompileStatisticsData)pair.component2();
            this.log$1.debug("Collect data takes " + collectDataDuration + ": " + compileStatData);
            CompileStatisticsData compileStatisticsData = compileStatData;
            if (compileStatisticsData != null) {
                CompileStatisticsData compileStatisticsData2;
                CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                boolean bl2 = false;
                this.addBuildScanReport(it, buildScanSettings.getCustomValueLimit(), buildScan);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addBuildScanReport(CompileStatisticsData data, int customValuesLimit, BuildScanExtensionHolder buildScan) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        BuildScanExtension buildScanExtension = buildScan.getBuildScan();
        if (buildScanExtension != null) {
            Iterable $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterator iterator;
            Object object;
            BuildScanExtension buildScanExtension2;
            BuildScanExtension it = buildScanExtension2 = buildScanExtension;
            boolean bl2 = false;
            if (!this.tags.contains(this.buildUuid)) {
                this.addBuildScanTag(buildScan, this.buildUuid);
            }
            if ((object = data.getLabel()) != null) {
                iterator = object;
                String it2 = iterator;
                boolean bl3 = false;
                object = !this.tags.contains(it2) ? iterator : null;
                if (object != null) {
                    iterator = object;
                    it2 = iterator;
                    boolean bl4 = false;
                    this.addBuildScanTag(buildScan, it2);
                }
            }
            Iterable iterable = data.getTags();
            boolean $i$f$filter = false;
            iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl5 = false;
                if (!(!this.tags.contains(it3))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it4 = (String)element$iv;
                boolean bl6 = false;
                this.addBuildScanTag(buildScan, it4);
            }
            if (this.customValues < customValuesLimit) {
                $this$forEach$iv = this.readableString(data);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it5 = (String)element$iv;
                    boolean bl7 = false;
                    if (this.customValues < customValuesLimit) {
                        this.addBuildScanValue(buildScan, data, it5);
                        continue;
                    }
                    this.log$1.debug("Can't add any more custom values into build scan. Statistic data for " + data.getTaskName() + " was cut due to custom values limit.");
                }
            } else {
                this.log$1.debug("Can't add any more custom values into build scan.");
            }
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log$1.debug("Report statistic to build scan takes " + elapsedTime + " ms");
    }

    private final void addBuildScanValue(BuildScanExtensionHolder buildScan, CompileStatisticsData data, String customValue) {
        BuildScanExtension buildScanExtension = buildScan.getBuildScan();
        if (buildScanExtension != null) {
            buildScanExtension.value(data.getTaskName(), customValue);
        }
        int n = this.customValues;
        this.customValues = n + 1;
    }

    private final void addBuildScanTag(BuildScanExtensionHolder buildScan, String tag) {
        BuildScanExtension buildScanExtension = buildScan.getBuildScan();
        if (buildScanExtension != null) {
            buildScanExtension.tag(tag);
        }
        this.tags.add(tag);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readableString(CompileStatisticsData data) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        StringBuilder readableString2 = new StringBuilder();
        if (data.getNonIncrementalAttributes().isEmpty()) {
            readableString2.append("Incremental build; ");
            CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        } else {
            CollectionsKt.joinTo$default((Iterable)data.getNonIncrementalAttributes(), (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        }
        Map<BuildTime, Long> $this$map$iv = data.getBuildTimesMetrics();
        boolean $i$f$map = false;
        Map<BuildTime, Long> map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            BuildTime key = (BuildTime)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + value + "ms");
        }
        List timeData = (List)destination$iv$iv;
        Map<BuildPerformanceMetric, Long> $this$map$iv2 = data.getPerformanceMetrics();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            BuildPerformanceMetric key = (BuildPerformanceMetric)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            collection.add(WhenMappings.$EnumSwitchMapping$0[key.getType().ordinal()] == 1 ? key.getReadableString() + ": " + FormattingUtilsKt.formatSize(value) : key.getReadableString() + ": " + value + '}');
        }
        List perfData = (List)destination$iv$iv2;
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.union((Iterable)timeData, (Iterable)perfData), (Appendable)readableString2, (CharSequence)",", (CharSequence)"Performance: [", (CharSequence)"]", (int)0, null, null, (int)112, null);
        String string = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readableString.toString()");
        return this.splitStringIfNeed(string, 100000);
    }

    private final List<String> splitStringIfNeed(String str, int lengthLimit) {
        ArrayList<String> splattedString = new ArrayList<String>();
        String tempStr = str;
        while (tempStr.length() > lengthLimit) {
            String subSequence;
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(lengthLimit), (String)"this as java.lang.String).substring(startIndex)");
            int index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)';', (int)0, (boolean)false, (int)6, null);
            if (index == -1 && (index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)',', (int)0, (boolean)false, (int)6, null)) == -1) {
                index = lengthLimit;
            }
            String string = tempStr.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            splattedString.add(string);
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(index), (String)"this as java.lang.String).substring(startIndex)");
        }
        splattedString.add(tempStr);
        return splattedString;
    }

    public static final /* synthetic */ void access$addBuildScanReport(BuildReportsService $this, FinishEvent event, BuildScanExtensionHolder buildScan) {
        $this.addBuildScanReport(event, buildScan);
    }

    public static final /* synthetic */ void access$reportBuildFinish(BuildReportsService $this) {
        $this.reportBuildFinish();
    }

    public static final /* synthetic */ void access$sendDataViaHttp(BuildReportsService $this, Object data) {
        $this.sendDataViaHttp(data);
    }

    static {
        String string;
        Companion = new Companion(null);
        log = Logging.getLogger(Companion.getClass());
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string = null;
        }
        hostName = string;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "additionalTags", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/StatTag;", "getAdditionalTags", "()Lorg/gradle/api/provider/ListProperty;", "buildMetricsService", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "getBuildMetricsService", "()Lorg/gradle/api/provider/Provider;", "setBuildMetricsService", "(Lorg/gradle/api/provider/Provider;)V", "kotlinVersion", "Lorg/gradle/api/provider/Property;", "", "getKotlinVersion", "()Lorg/gradle/api/provider/Property;", "label", "getLabel", "projectName", "getProjectName", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "getReportingSettings", "startParameters", "Lorg/jetbrains/kotlin/gradle/plugin/stat/GradleBuildStartParameters;", "getStartParameters", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<GradleBuildStartParameters> getStartParameters();

        @NotNull
        public Property<ReportingSettings> getReportingSettings();

        @NotNull
        public Provider<BuildMetricsService> getBuildMetricsService();

        public void setBuildMetricsService(@NotNull Provider<BuildMetricsService> var1);

        @NotNull
        public Property<String> getLabel();

        @NotNull
        public Property<String> getProjectName();

        @NotNull
        public Property<String> getKotlinVersion();

        @NotNull
        public ListProperty<StatTag> getAdditionalTags();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002JI\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u00042\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u00a2\u0006\u0002\b!J$\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010)\u001a\u00020*H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion;", "", "()V", "hostName", "", "getHostName", "()Ljava/lang/String;", "lengthLimit", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "availableForStat", "", "taskPath", "getStartParameters", "Lorg/jetbrains/kotlin/gradle/plugin/stat/GradleBuildStartParameters;", "project", "Lorg/gradle/api/Project;", "parseTags", "", "Lorg/jetbrains/kotlin/gradle/plugin/stat/StatTag;", "taskExecutionResult", "Lorg/jetbrains/kotlin/gradle/report/TaskExecutionResult;", "additionalTags", "prepareData", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatisticsData;", "event", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "projectName", "uuid", "label", "kotlinVersion", "prepareData$kotlin_gradle_plugin_common", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "buildMetricsService", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "setupTags", "Ljava/util/ArrayList;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GradleBuildStartParameters getStartParameters(@NotNull Project project) {
            Collection<String> collection;
            String value;
            String key;
            Collection<String> collection2;
            Map.Entry entry;
            Map.Entry item$iv$iv;
            Map $this$mapTo$iv$iv;
            Map $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartParameter it = project.getGradle().getStartParameter();
            boolean bl = false;
            List list2 = it.getTaskRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.taskRequests");
            Object $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TaskExecutionRequest it2 = (TaskExecutionRequest)element$iv$iv;
                boolean bl2 = false;
                List list3 = it2.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it.args");
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            Set set2 = it.getExcludedTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.excludedTaskNames");
            String string = it.getCurrentDir().getPath();
            Map map = it.getProjectProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.projectProperties");
            $this$flatMap$iv = map;
            String string2 = string;
            Set set3 = set2;
            List list5 = list4;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = (Map.Entry)iterator.next();
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                collection2.add(key + ": " + value);
            }
            collection2 = (List)destination$iv$iv;
            Map map2 = it.getSystemPropertiesArgs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"it.systemPropertiesArgs");
            $this$map$iv = map2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = (Map.Entry)iterator.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                collection.add(key + ": " + value);
            }
            Collection<String> collection3 = collection = (List)destination$iv$iv;
            Collection<String> collection4 = collection2;
            String string3 = string2;
            Set set4 = set3;
            List list6 = list5;
            return new GradleBuildStartParameters(list6, set4, string3, (List<String>)collection4, (List<String>)collection3);
        }

        @Nullable
        public final Provider<BuildReportsService> registerIfAbsent(@NotNull Project project, @NotNull Provider<BuildMetricsService> buildMetricsService) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(buildMetricsService, (String)"buildMetricsService");
            Class<BuildReportsService> serviceClass = BuildReportsService.class;
            String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();
            Project project2 = project.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project2);
            if (reportingSettings.getBuildReportOutputs().isEmpty()) {
                return null;
            }
            String kotlinVersion = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
            Gradle gradle = project.getGradle();
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider = it.getService();
                Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.report.BuildReportsService>");
                return provider;
            }
            buildServiceRegistration = (Function1)new Function1<BuildServiceSpec<Parameters>, Unit>(reportingSettings, project, kotlinVersion, buildMetricsService, gradle){
                final /* synthetic */ ReportingSettings $reportingSettings;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $kotlinVersion;
                final /* synthetic */ Provider<BuildMetricsService> $buildMetricsService;
                final /* synthetic */ Gradle $gradle;
                {
                    this.$reportingSettings = $reportingSettings;
                    this.$project = $project;
                    this.$kotlinVersion = $kotlinVersion;
                    this.$buildMetricsService = $buildMetricsService;
                    this.$gradle = $gradle;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Parameters> it) {
                    ((Parameters)it.getParameters()).getLabel().set((Object)this.$reportingSettings.getBuildReportLabel());
                    ((Parameters)it.getParameters()).getProjectName().set((Object)this.$project.getRootProject().getName());
                    ((Parameters)it.getParameters()).getKotlinVersion().set((Object)this.$kotlinVersion);
                    ((Parameters)it.getParameters()).getStartParameters().set((Object)BuildReportsService.Companion.getStartParameters(this.$project));
                    ((Parameters)it.getParameters()).getReportingSettings().set((Object)this.$reportingSettings);
                    ((Parameters)it.getParameters()).setBuildMetricsService(this.$buildMetricsService);
                    ListProperty<StatTag> listProperty = ((Parameters)it.getParameters()).getAdditionalTags();
                    Gradle gradle = this.$gradle;
                    Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
                    listProperty.value((Iterable)org.jetbrains.kotlin.gradle.report.BuildReportsService$Companion.access$setupTags(BuildReportsService.Companion, gradle));
                }
            };
            BuildServiceRegistration it = buildServiceRegistration = gradle.getSharedServices().registerIfAbsent(serviceName, serviceClass, new Action((Function1)buildServiceRegistration){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            boolean bl = false;
            if (reportingSettings.getHttpReportSettings() != null) {
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion((Provider)it);
            }
            Object buildScanExtension = project.getRootProject().getExtensions().findByName("buildScan");
            if (reportingSettings.getBuildScanReportSettings() != null && buildScanExtension != null) {
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(project.provider(new Callable((Provider<BuildReportsService>)it, buildScanExtension){
                    final /* synthetic */ Provider<BuildReportsService> $it;
                    final /* synthetic */ Object $buildScanExtension;
                    {
                        this.$it = $it;
                        this.$buildScanExtension = $buildScanExtension;
                    }

                    public final OperationCompletionListener call() {
                        return new OperationCompletionListener(this.$it, this.$buildScanExtension){
                            final /* synthetic */ Provider<BuildReportsService> $it;
                            final /* synthetic */ Object $buildScanExtension;
                            {
                                this.$it = $it;
                                this.$buildScanExtension = $buildScanExtension;
                            }

                            public final void onFinish(FinishEvent event) {
                                Object object = this.$it.get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.get()");
                                BuildReportsService.access$addBuildScanReport((BuildReportsService)object, event, new BuildScanExtensionHolder(this.$buildScanExtension));
                            }
                        };
                    }
                }));
            }
            return buildServiceRegistration;
        }

        private final ArrayList<StatTag> setupTags(Gradle gradle) {
            ArrayList<StatTag> additionalTags = new ArrayList<StatTag>();
            if (ConfigurationCacheKt.isConfigurationCacheAvailable(gradle)) {
                additionalTags.add(StatTag.CONFIGURATION_CACHE);
            }
            if (gradle.getStartParameter().isBuildCacheEnabled()) {
                additionalTags.add(StatTag.BUILD_CACHE);
            }
            return additionalTags;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CompileStatisticsData prepareData$kotlin_gradle_plugin_common(@NotNull TaskFinishEvent event, @NotNull String projectName, @NotNull String uuid, @Nullable String label, @NotNull String kotlinVersion, @NotNull List<? extends StatTag> additionalTags) {
            Object object;
            List list2;
            String string;
            List changes;
            Map perfData;
            Map buildTimesMs;
            Object taskExecutionResult;
            long durationMs;
            String taskPath;
            block18: {
                block17: {
                    void $this$filterTo$iv$iv;
                    void $this$mapTo$iv$iv;
                    List list3;
                    Collection collection;
                    ChangedFiles changedFiles;
                    Map map;
                    Object object2;
                    Map map2;
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
                    Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                    Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
                    Intrinsics.checkNotNullParameter(additionalTags, (String)"additionalTags");
                    TaskOperationResult result2 = event.getResult();
                    taskPath = event.getDescriptor().getTaskPath();
                    durationMs = result2.getEndTime() - result2.getStartTime();
                    TaskOperationResult taskOperationResult = result2;
                    TaskExecutionState taskResult = taskOperationResult instanceof TaskSuccessResult ? (((TaskSuccessResult)result2).isFromCache() ? TaskExecutionState.FROM_CACHE : (((TaskSuccessResult)result2).isUpToDate() ? TaskExecutionState.UP_TO_DATE : TaskExecutionState.SUCCESS)) : (taskOperationResult instanceof TaskSkippedResult ? TaskExecutionState.SKIPPED : (taskOperationResult instanceof TaskFailureResult ? TaskExecutionState.FAILED : TaskExecutionState.UNKNOWN));
                    Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
                    if (!this.availableForStat(taskPath)) {
                        return null;
                    }
                    taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
                    Object object3 = taskExecutionResult;
                    if (object3 != null && (object3 = object3.getBuildMetrics()) != null && (object3 = object3.getBuildTimes()) != null && (object3 = object3.asMapMs()) != null) {
                        Object $this$filterValues$iv = object3;
                        boolean $i$f$filterValues = false;
                        LinkedHashMap result$iv = new LinkedHashMap();
                        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                            long l = ((Number)entry.getValue()).longValue();
                            bl = false;
                            if (!(l != 0L)) continue;
                            result$iv.put(entry.getKey(), entry.getValue());
                        }
                        map2 = result$iv;
                    } else {
                        map2 = buildTimesMs = MapsKt.emptyMap();
                    }
                    if ((object2 = taskExecutionResult) != null && (object2 = ((TaskExecutionResult)object2).getBuildMetrics()) != null && (object2 = object2.getBuildPerformanceMetrics()) != null && (object2 = object2.asMap()) != null) {
                        Object $this$filterValues$iv = object2;
                        boolean $i$f$filterValues = false;
                        LinkedHashMap result$iv = new LinkedHashMap();
                        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                            long value = ((Number)entry.getValue()).longValue();
                            boolean bl2 = false;
                            if (!(value != 0L)) continue;
                            result$iv.put(entry.getKey(), entry.getValue());
                        }
                        map = result$iv;
                    } else {
                        map = MapsKt.emptyMap();
                    }
                    perfData = map;
                    Object object4 = taskExecutionResult;
                    ChangedFiles changedFiles2 = object4 != null && (object4 = object4.getTaskInfo()) != null ? object4.getChangedFiles() : (changedFiles = null);
                    if (changedFiles instanceof ChangedFiles.Known) {
                        void $this$mapTo$iv$iv2;
                        Iterable $this$mapTo$iv$iv22;
                        Iterable $this$map$iv = ((ChangedFiles.Known)changedFiles).getModified();
                        boolean $i$f$map = false;
                        Iterable $this$filterValues$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object t : $this$mapTo$iv$iv22) {
                            void it;
                            File value = (File)t;
                            collection = destination$iv$iv;
                            bl = false;
                            collection.add(it.getAbsolutePath());
                        }
                        $this$map$iv = ((ChangedFiles.Known)changedFiles).getRemoved();
                        collection = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$mapTo$iv$iv22 = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object t : $this$mapTo$iv$iv2) {
                            File it = (File)t;
                            Collection collection2 = destination$iv$iv;
                            bl = false;
                            collection2.add(it.getAbsolutePath());
                        }
                        list3 = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                    } else {
                        list3 = CollectionsKt.emptyList();
                    }
                    changes = list3;
                    string = taskResult.name();
                    Iterable $this$map$iv = this.parseTags((TaskExecutionResult)taskExecutionResult, additionalTags);
                    boolean $i$f$map = false;
                    Iterable destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean bl3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StatTag bl4 = (StatTag)((Object)item$iv$iv);
                        collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(it.name());
                    }
                    list2 = (List)destination$iv$iv2;
                    object = taskExecutionResult;
                    if (object == null || (object = object.getBuildMetrics()) == null || (object = object.getBuildAttributes()) == null || (object = object.asMap()) == null) break block17;
                    Object object5 = object;
                    boolean $i$f$filter = false;
                    Object it = object5;
                    Map destination$iv$iv3 = new LinkedHashMap();
                    boolean $i$f$filterTo = false;
                    Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it2 = element$iv$iv = iterator.next();
                        boolean bl5 = false;
                        if (!(((Number)it2.getValue()).intValue() > 0)) continue;
                        destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    object = destination$iv$iv3.keySet();
                    if (object != null) break block18;
                }
                object = SetsKt.emptySet();
            }
            Object object5 = object;
            String string2 = this.getHostName();
            long l = System.currentTimeMillis();
            Object object6 = taskExecutionResult;
            if (object6 == null || (object6 = object6.getTaskInfo()) == null || (object6 = object6.getCompilerArguments()) == null || (object6 = ArraysKt.asList((Object[])object6)) == null) {
                object6 = CollectionsKt.emptyList();
            }
            Object[] objectArray = object6;
            return new CompileStatisticsData(0, projectName, label, taskPath, string, durationMs, list2, changes, uuid, kotlinVersion, string2, l, null, (List)objectArray, (Set)object5, buildTimesMs, perfData, null, 135169, null);
        }

        public static /* synthetic */ CompileStatisticsData prepareData$kotlin_gradle_plugin_common$default(Companion companion, TaskFinishEvent taskFinishEvent, String string, String string2, String string3, String string4, List list2, int n, Object object) {
            if ((n & 0x20) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            return companion.prepareData$kotlin_gradle_plugin_common(taskFinishEvent, string, string2, string3, string4, list2);
        }

        @Nullable
        public final String getHostName() {
            return hostName;
        }

        private final boolean availableForStat(String taskPath) {
            return StringsKt.contains$default((CharSequence)taskPath, (CharSequence)"Kotlin", (boolean)false, (int)2, null) && TaskExecutionResults.INSTANCE.get(taskPath) != null;
        }

        private final List<StatTag> parseTags(TaskExecutionResult taskExecutionResult, List<? extends StatTag> additionalTags) {
            Object v5;
            ArrayList<StatTag> tags;
            block9: {
                Object object;
                boolean $i$f$ifTrue;
                boolean $this$ifTrue$iv;
                Object nonIncrementalAttributes;
                tags = new ArrayList<StatTag>((Collection)additionalTags);
                Object object2 = taskExecutionResult;
                if (object2 == null || (object2 = ((TaskExecutionResult)object2).getBuildMetrics()) == null || (object2 = object2.getBuildAttributes()) == null || (object2 = object2.asMap()) == null) {
                    object2 = MapsKt.emptyMap();
                }
                if ((nonIncrementalAttributes = object2).isEmpty()) {
                    tags.add(StatTag.INCREMENTAL);
                } else {
                    tags.add(StatTag.NON_INCREMENTAL);
                }
                TaskExecutionResult taskExecutionResult2 = taskExecutionResult;
                TaskExecutionInfo taskInfo = taskExecutionResult2 != null ? taskExecutionResult2.getTaskInfo() : null;
                Object object3 = taskInfo;
                if (object3 != null && (object3 = ((TaskExecutionInfo)object3).getWithAbiSnapshot()) != null) {
                    $this$ifTrue$iv = (Boolean)object3;
                    $i$f$ifTrue = false;
                    if ($this$ifTrue$iv) {
                        boolean bl = false;
                        tags.add(StatTag.ABI_SNAPSHOT);
                    }
                }
                if ((object = taskInfo) != null && (object = ((TaskExecutionInfo)object).getWithArtifactTransform()) != null) {
                    $this$ifTrue$iv = (Boolean)object;
                    $i$f$ifTrue = false;
                    if ($this$ifTrue$iv) {
                        boolean bl = false;
                        tags.add(StatTag.ARTIFACT_TRANSFORM);
                    }
                }
                String debugConfiguration = "-agentlib:";
                List<String> list2 = ManagementFactory.getRuntimeMXBean().getInputArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getRuntimeMXBean().inputArguments");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!StringsKt.startsWith$default((String)it, (String)debugConfiguration, (boolean)false, (int)2, null)) continue;
                    v5 = element$iv;
                    break block9;
                }
                v5 = null;
            }
            if (v5 != null) {
                tags.add(StatTag.GRADLE_DEBUG);
            }
            return tags;
        }

        public static final /* synthetic */ ArrayList access$setupTags(Companion $this, Gradle gradle) {
            return $this.setupTags(gradle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SizeMetricType.values().length];
            try {
                nArray[SizeMetricType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

