/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinToolRunner;
import org.jetbrains.kotlin.konan.target.HostManager;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0016J\b\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&J\u0016\u00108\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J\u0016\u00109\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\tR\u0012\u0010\"\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u0012\u0010+\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0012\u0010-\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "classpath", "", "Ljava/io/File;", "getClasspath", "()Ljava/util/Set;", "daemonEntryPoint", "", "getDaemonEntryPoint", "()Ljava/lang/String;", "defaultMaxHeapSize", "getDefaultMaxHeapSize", "disableC2", "", "getDisableC2", "()Z", "displayName", "getDisplayName", "enableAssertions", "getEnableAssertions", "execEnvironment", "", "getExecEnvironment", "()Ljava/util/Map;", "execEnvironmentBlacklist", "getExecEnvironmentBlacklist", "execSystemProperties", "getExecSystemProperties", "execSystemPropertiesBlacklist", "getExecSystemPropertiesBlacklist", "isolatedClassLoaderCacheKey", "getIsolatedClassLoaderCacheKey", "()Ljava/lang/Object;", "jvmArgs", "", "getJvmArgs", "()Ljava/util/List;", "jvmArgs$delegate", "Lkotlin/Lazy;", "mainClass", "getMainClass", "mustRunViaExec", "getMustRunViaExec", "getProject", "()Lorg/gradle/api/Project;", "checkClasspath", "", "getCustomJvmArgs", "getIsolatedClassLoader", "Ljava/lang/ClassLoader;", "run", "args", "runInProcess", "runViaExec", "transformArgs", "Companion", "kotlin-gradle-plugin"})
public abstract class KotlinToolRunner {
    @NotNull
    private final Map<String, String> execEnvironment;
    @NotNull
    private final Set<String> execEnvironmentBlacklist;
    @NotNull
    private final Map<String, String> execSystemProperties;
    @NotNull
    private final Set<String> execSystemPropertiesBlacklist;
    private final Lazy jvmArgs$delegate;
    @NotNull
    private final Project project;
    private static final ConcurrentHashMap<Object, ClassLoader> isolatedClassLoadersMap;
    public static final Companion Companion;

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract String getMainClass();

    @NotNull
    public String getDaemonEntryPoint() {
        return "main";
    }

    @NotNull
    public Map<String, String> getExecEnvironment() {
        return this.execEnvironment;
    }

    @NotNull
    public Set<String> getExecEnvironmentBlacklist() {
        return this.execEnvironmentBlacklist;
    }

    @NotNull
    public Map<String, String> getExecSystemProperties() {
        return this.execSystemProperties;
    }

    @NotNull
    public Set<String> getExecSystemPropertiesBlacklist() {
        return this.execSystemPropertiesBlacklist;
    }

    @NotNull
    public abstract Set<File> getClasspath();

    public void checkClasspath() {
        Collection collection = this.getClasspath();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Classpath of the tool is empty: " + this.getDisplayName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public abstract Object getIsolatedClassLoaderCacheKey();

    private final ClassLoader getIsolatedClassLoader() {
        ClassLoader classLoader = isolatedClassLoadersMap.computeIfAbsent(this.getIsolatedClassLoaderCacheKey(), new Function<Object, ClassLoader>(this){
            final /* synthetic */ KotlinToolRunner this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final URLClassLoader apply(@NotNull Object it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable $this$map$iv = this.this$0.getClasspath();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    URL uRL = new File(it2.getAbsolutePath()).toURI().toURL();
                    collection.add(uRL);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] arrayOfURLs = uRLArray;
                return new URLClassLoader(arrayOfURLs, null);
            }
            {
                this.this$0 = kotlinToolRunner;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"isolatedClassLoadersMap.\u2026(arrayOfURLs, null)\n    }");
        return classLoader;
    }

    @NotNull
    public String getDefaultMaxHeapSize() {
        return "3G";
    }

    public boolean getEnableAssertions() {
        return true;
    }

    public boolean getDisableC2() {
        return true;
    }

    public abstract boolean getMustRunViaExec();

    @NotNull
    public List<String> transformArgs(@NotNull List<String> args) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return args;
    }

    @NotNull
    public List<String> getCustomJvmArgs() {
        return CollectionsKt.emptyList();
    }

    private final List<String> getJvmArgs() {
        Lazy lazy = this.jvmArgs$delegate;
        KotlinToolRunner kotlinToolRunner = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final void run(@NotNull List<String> args) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        this.project.getLogger().info("Run tool: \"" + this.getDisplayName() + "\" with args: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        this.checkClasspath();
        if (this.getMustRunViaExec()) {
            this.runViaExec(args);
        } else {
            this.runInProcess(args);
        }
    }

    private final void runViaExec(List<String> args) {
        this.project.javaexec((Action)new Action<JavaExecSpec>(this, args){
            final /* synthetic */ KotlinToolRunner this$0;
            final /* synthetic */ List $args;

            public final void execute(JavaExecSpec spec) {
                JavaExecSpec javaExecSpec = spec;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaExecSpec, (String)"spec");
                javaExecSpec.setMain(this.this$0.getMainClass());
                spec.setClasspath((FileCollection)this.this$0.getProject().files(new Object[]{this.this$0.getClasspath()}));
                spec.jvmArgs((Iterable)KotlinToolRunner.access$getJvmArgs$p(this.this$0));
                Properties properties = System.getProperties();
                Intrinsics.checkExpressionValueIsNotNull((Object)properties, (String)"System.getProperties()");
                spec.systemProperties(MapsKt.toMap((Sequence)org.jetbrains.kotlin.compilerRunner.KotlinToolRunner$Companion.access$escapeQuotesForWindows(KotlinToolRunner.Companion, SequencesKt.filter((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)properties), (Function1)runViaExec.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(this){
                    final /* synthetic */ runViaExec.1 this$0;

                    public final boolean invoke(@NotNull Pair<String, String> $dstr$k$_u24__u24) {
                        Intrinsics.checkParameterIsNotNull($dstr$k$_u24__u24, (String)"<name for destructuring parameter 0>");
                        String k = (String)$dstr$k$_u24__u24.component1();
                        return !this.this$0.this$0.getExecSystemPropertiesBlacklist().contains(k);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })))));
                spec.systemProperties(this.this$0.getExecSystemProperties());
                Iterable $this$forEach$iv = this.this$0.getExecEnvironmentBlacklist();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    spec.getEnvironment().remove(it);
                }
                spec.environment(this.this$0.getExecEnvironment());
                spec.args((Iterable)this.this$0.transformArgs(this.$args));
            }
            {
                this.this$0 = kotlinToolRunner;
                this.$args = list2;
            }
        });
    }

    private final void runInProcess(List<String> args) {
        try {
            Class<?> mainClass;
            Class<?> clazz = mainClass = this.getIsolatedClassLoader().loadClass(this.getMainClass());
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"mainClass");
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"mainClass.methods");
            Method[] $this$single$iv = methodArray;
            boolean $i$f$single = false;
            Method single$iv = null;
            boolean found$iv = false;
            Method[] methodArray2 = $this$single$iv;
            int n = methodArray2.length;
            for (int j = 0; j < n; ++j) {
                Method element$iv;
                Method it = element$iv = methodArray2[j];
                boolean bl = false;
                Method method = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"it");
                if (!Intrinsics.areEqual((Object)method.getName(), (Object)this.getDaemonEntryPoint())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Method entryPoint = single$iv;
            Object[] objectArray = new Object[1];
            Collection $this$toTypedArray$iv = this.transformArgs(args);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray[0] = stringArray;
            entryPoint.invoke(null, objectArray);
        }
        catch (InvocationTargetException t) {
            Throwable throwable = t.getTargetException();
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"t.targetException");
            throw throwable;
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinToolRunner(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.execEnvironment = MapsKt.emptyMap();
        this.execEnvironmentBlacklist = SetsKt.emptySet();
        this.execSystemProperties = MapsKt.emptyMap();
        this.execSystemPropertiesBlacklist = SetsKt.setOf((Object)"java.endorsed.dirs");
        this.jvmArgs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<String>>(this){
            final /* synthetic */ KotlinToolRunner this$0;

            @NotNull
            public final List<String> invoke() {
                boolean bl;
                List<String> customJvmArgs;
                List $receiver;
                List list2;
                block8: {
                    boolean bl2 = false;
                    list2 = new ArrayList<E>();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    $receiver = list2;
                    boolean bl5 = false;
                    if (this.this$0.getEnableAssertions()) {
                        $receiver.add("-ea");
                    }
                    customJvmArgs = this.this$0.getCustomJvmArgs();
                    Iterable $this$none$iv = customJvmArgs;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    $receiver.add("-Xmx" + this.this$0.getDefaultMaxHeapSize());
                }
                if (this.this$0.getDisableC2()) {
                    String string = System.getProperty("java.vm.name");
                    if (string != null) {
                        String string2 = string;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        String vmName = string2;
                        boolean bl9 = false;
                        if (StringsKt.contains((CharSequence)vmName, (CharSequence)"HotSpot", (boolean)true)) {
                            $receiver.add("-XX:TieredStopAtLevel=1");
                        }
                    }
                }
                $receiver.addAll((Collection)customJvmArgs);
                return list2;
            }
            {
                this.this$0 = kotlinToolRunner;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        isolatedClassLoadersMap = new ConcurrentHashMap();
    }

    public static final /* synthetic */ List access$getJvmArgs$p(KotlinToolRunner $this) {
        return $this.getJvmArgs();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002J0\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\t*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\tH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner$Companion;", "", "()V", "isolatedClassLoadersMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/ClassLoader;", "escapeQuotes", "", "escapeQuotesForWindows", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String escapeQuotes(String $receiver) {
            return StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        }

        private final Sequence<Pair<String, String>> escapeQuotesForWindows(Sequence<Pair<String, String>> $receiver) {
            return HostManager.Companion.getHostIsMingw() ? SequencesKt.map($receiver, (Function1)escapeQuotesForWindows.1.INSTANCE) : $receiver;
        }

        private Companion() {
        }

        public static final /* synthetic */ Sequence access$escapeQuotesForWindows(Companion $this, Sequence $receiver) {
            return $this.escapeQuotesForWindows((Sequence<Pair<String, String>>)$receiver);
        }

        public static final /* synthetic */ String access$escapeQuotes(Companion $this, String $receiver) {
            return $this.escapeQuotes($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

