/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverDescription;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0002\u001a\u000e\u0010\f\u001a\u00020\u000b*\u0004\u0018\u00010\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000b*\u00020\rH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\u0012\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"findClosestMatchingReceivers", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverDescription;", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "receiverGroups", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "isJavaApplicableCandidate", "", "isSuperCall", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isSuperReferenceExpression", "markCandidateForCompatibilityResolve", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "prepareReceivers", "argumentExtensionReceiverValue", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "resolve"})
public final class ResolutionStagesKt {
    private static final ReceiverDescription prepareReceivers(Candidate $this$prepareReceivers, ReceiverValue argumentExtensionReceiverValue, ConeKotlinType expectedType, ResolutionContext context) {
        ConeKotlinType it = ArgumentsKt.captureFromTypeParameterUpperBoundIfNeeded(argumentExtensionReceiverValue.getType(), expectedType, context.getSession());
        boolean bl = false;
        ConeKotlinType argumentType = ArgumentsKt.prepareCapturedType($this$prepareReceivers, it, context);
        return new ReceiverDescription(argumentExtensionReceiverValue.getReceiverExpression(), argumentType);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ReceiverDescription> findClosestMatchingReceivers(Candidate $this$findClosestMatchingReceivers, ConeKotlinType expectedType, List<? extends List<? extends ImplicitReceiverValue<?>>> receiverGroups, ResolutionContext context) {
        for (List<ImplicitReceiverValue<?>> list2 : receiverGroups) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ReceiverDescription it;
            boolean bl;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl = false;
                collection.add(ResolutionStagesKt.prepareReceivers($this$findClosestMatchingReceivers, (ReceiverValue)((Object)it), expectedType, context));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ReceiverDescription)element$iv$iv;
                bl = false;
                if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible($this$findClosestMatchingReceivers.getSystem(), it.getType(), expectedType, SimpleConstraintSystemConstraintPosition.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List currentResult = (List)destination$iv$iv;
            if (!(!((Collection)currentResult).isEmpty())) continue;
            return currentResult;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean isSuperCall(FirExpression $this$isSuperCall) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        return ((FirQualifiedAccessExpression)$this$isSuperCall).getCalleeReference() instanceof FirSuperReference;
    }

    private static final boolean isSuperReferenceExpression(FirExpression $this$isSuperReferenceExpression) {
        boolean bl;
        if ($this$isSuperReferenceExpression instanceof FirQualifiedAccessExpression) {
            FirReference calleeReference = ((FirQualifiedAccessExpression)$this$isSuperReferenceExpression).getCalleeReference();
            bl = calleeReference instanceof FirSuperReference;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isJavaApplicableCandidate(Candidate $this$isJavaApplicableCandidate) {
        FirBasedSymbol<?> firBasedSymbol = $this$isJavaApplicableCandidate.getSymbol();
        FirFunctionSymbol firFunctionSymbol = firBasedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null;
        if (firFunctionSymbol == null) {
            return false;
        }
        FirFunctionSymbol symbol2 = firFunctionSymbol;
        if (Intrinsics.areEqual((Object)symbol2.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
            return true;
        }
        if (!($this$isJavaApplicableCandidate.getOriginScope() instanceof FirTypeScope)) {
            return false;
        }
        if (!(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions((FirTypeScope)$this$isJavaApplicableCandidate.getOriginScope(), (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(result2){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
                    this.$result.element = true;
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        return result2.element;
    }

    private static final void markCandidateForCompatibilityResolve(CheckerSink $this$markCandidateForCompatibilityResolve, ResolutionContext context) {
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
            return;
        }
        $this$markCandidateForCompatibilityResolve.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
    }

    public static final /* synthetic */ boolean access$isSuperReferenceExpression(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperReferenceExpression($receiver);
    }

    public static final /* synthetic */ ReceiverDescription access$prepareReceivers(Candidate $receiver, ReceiverValue argumentExtensionReceiverValue, ConeKotlinType expectedType, ResolutionContext context) {
        return ResolutionStagesKt.prepareReceivers($receiver, argumentExtensionReceiverValue, expectedType, context);
    }

    public static final /* synthetic */ boolean access$isSuperCall(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperCall($receiver);
    }

    public static final /* synthetic */ List access$findClosestMatchingReceivers(Candidate $receiver, ConeKotlinType expectedType, List receiverGroups, ResolutionContext context) {
        return ResolutionStagesKt.findClosestMatchingReceivers($receiver, expectedType, receiverGroups, context);
    }

    public static final /* synthetic */ boolean access$isJavaApplicableCandidate(Candidate $receiver) {
        return ResolutionStagesKt.isJavaApplicableCandidate($receiver);
    }

    public static final /* synthetic */ void access$markCandidateForCompatibilityResolve(CheckerSink $receiver, ResolutionContext context) {
        ResolutionStagesKt.markCandidateForCompatibilityResolve($receiver, context);
    }
}

