/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.ConstructorDelegationComparator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0005*\u0006\u0012\u0002\b\u00030\t\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0086\u0010\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0010*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u0014\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u0017\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u0018\u001a\u00020\u0015*\u00020\u0010\u001a\u0016\u0010\u0019\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001b"}, d2={"delegatedThisConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getDelegatedThisConstructor", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "collectEnumEntries", "", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "constructors", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "constructorsSortedByDelegation", "fullyExpandedClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "useSiteSession", "getConstructedClass", "isAnnotationConstructor", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isEnumConstructor", "isInlineOrValueClass", "isPrimaryConstructorOfInlineClass", "primaryConstructorIfAny", "providers"})
public final class DeclarationUtilsKt {
    @NotNull
    public static final List<FirConstructorSymbol> constructors(@NotNull FirClass $this$constructors, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$constructors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        List result2 = new ArrayList();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(session2, $this$constructors).processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)new Function1<FirConstructorSymbol, Unit>((List<FirConstructorSymbol>)result2){
            final /* synthetic */ List<FirConstructorSymbol> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull FirConstructorSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Collection)this.$result).add(it);
            }
        }));
        return result2;
    }

    @NotNull
    public static final List<FirConstructorSymbol> constructorsSortedByDelegation(@NotNull FirClass $this$constructorsSortedByDelegation, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$constructorsSortedByDelegation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return CollectionsKt.sortedWith((Iterable)DeclarationUtilsKt.constructors($this$constructorsSortedByDelegation, session2), (Comparator)ConstructorDelegationComparator.INSTANCE);
    }

    @Nullable
    public static final FirConstructorSymbol primaryConstructorIfAny(@NotNull FirClass $this$primaryConstructorIfAny, @NotNull FirSession session2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$primaryConstructorIfAny, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Iterable iterable = DeclarationUtilsKt.constructors($this$primaryConstructorIfAny, session2);
            for (Object t : iterable) {
                FirConstructorSymbol p0 = (FirConstructorSymbol)t;
                boolean bl = false;
                if (!p0.isPrimary()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FirEnumEntry> collectEnumEntries(@NotNull FirClass $this$collectEnumEntries) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$collectEnumEntries, (String)"<this>");
        boolean bl2 = bl = $this$collectEnumEntries.getClassKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$filterIsInstance$iv = $this$collectEnumEntries.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FirEnumEntrySymbol> collectEnumEntries(@NotNull FirClassSymbol<?> $this$collectEnumEntries) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$collectEnumEntries, (String)"<this>");
        Iterable $this$map$iv = DeclarationUtilsKt.collectEnumEntries((FirClass)$this$collectEnumEntries.getFir());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirConstructorSymbol getDelegatedThisConstructor(@NotNull FirConstructorSymbol $this$delegatedThisConstructor) {
        FirConstructorSymbol firConstructorSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$delegatedThisConstructor, (String)"<this>");
        boolean condition$iv = $this$delegatedThisConstructor.getDelegatedConstructorCallIsThis();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            firConstructorSymbol = $this$delegatedThisConstructor.getResolvedDelegatedConstructor();
        } else {
            firConstructorSymbol = null;
        }
        return firConstructorSymbol;
    }

    @Nullable
    public static final FirRegularClassSymbol fullyExpandedClass(@NotNull FirClassLikeSymbol<?> $this$fullyExpandedClass, @NotNull FirSession useSiteSession) {
        FirRegularClassSymbol firRegularClassSymbol;
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter($this$fullyExpandedClass, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
                while (true) {
                    FirClassLikeSymbol<?> firClassLikeSymbol;
                    ConeClassLikeType coneClassLikeType;
                    FirClassLikeSymbol<?> firClassLikeSymbol2;
                    if ((firClassLikeSymbol2 = $this$fullyExpandedClass) instanceof FirRegularClassSymbol) {
                        firRegularClassSymbol = (FirRegularClassSymbol)$this$fullyExpandedClass;
                        break block4;
                    }
                    if (firClassLikeSymbol2 instanceof FirAnonymousObjectSymbol) {
                        firRegularClassSymbol = null;
                        break block4;
                    }
                    if (!(firClassLikeSymbol2 instanceof FirTypeAliasSymbol)) break block5;
                    FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)$this$fullyExpandedClass).getResolvedExpandedTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (firClassLikeSymbol = TypeUtilsKt.toSymbol(coneClassLikeType, useSiteSession)) == null) break;
                    FirSession firSession = useSiteSession;
                    $this$fullyExpandedClass = firClassLikeSymbol;
                    useSiteSession = firSession;
                }
                firRegularClassSymbol = null;
                break block4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return firRegularClassSymbol;
    }

    public static final boolean isAnnotationConstructor(@NotNull FirBasedSymbol<?> $this$isAnnotationConstructor, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isAnnotationConstructor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$isAnnotationConstructor instanceof FirConstructorSymbol)) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.getConstructedClass((FirConstructorSymbol)$this$isAnnotationConstructor, session2);
        return (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
    }

    public static final boolean isEnumConstructor(@NotNull FirBasedSymbol<?> $this$isEnumConstructor, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isEnumConstructor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$isEnumConstructor instanceof FirConstructorSymbol)) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.getConstructedClass((FirConstructorSymbol)$this$isEnumConstructor, session2);
        return (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ENUM_CLASS;
    }

    public static final boolean isPrimaryConstructorOfInlineClass(@NotNull FirBasedSymbol<?> $this$isPrimaryConstructorOfInlineClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isPrimaryConstructorOfInlineClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$isPrimaryConstructorOfInlineClass instanceof FirConstructorSymbol)) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.getConstructedClass((FirConstructorSymbol)$this$isPrimaryConstructorOfInlineClass, session2);
        return (firRegularClassSymbol != null ? DeclarationUtilsKt.isInlineOrValueClass(firRegularClassSymbol) : false) && ((FirConstructorSymbol)$this$isPrimaryConstructorOfInlineClass).isPrimary();
    }

    @Nullable
    public static final FirRegularClassSymbol getConstructedClass(@NotNull FirConstructorSymbol $this$getConstructedClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$getConstructedClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType($this$getConstructedClass.getResolvedReturnTypeRef()), session2), session2);
        return firClassifierSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassifierSymbol : null;
    }

    public static final boolean isInlineOrValueClass(@NotNull FirRegularClassSymbol $this$isInlineOrValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOrValueClass, (String)"<this>");
        if ($this$isInlineOrValueClass.getClassKind() != ClassKind.CLASS) {
            return false;
        }
        FirClassSymbol $this$isInline$iv = $this$isInlineOrValueClass;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getRawStatus().isInline();
    }
}

