/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.CommonVariableAsmNameManglingUtils;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put(Visibilities.Private.INSTANCE, 2).put((Visibilities.Private)((Object)Visibilities.PrivateToThis.INSTANCE), 2).put((Visibilities.Private)((Object)Visibilities.Protected.INSTANCE), 4).put((Visibilities.Private)((Object)JavaVisibilities.ProtectedStaticVisibility.INSTANCE), 4).put((Visibilities.Private)((Object)JavaVisibilities.ProtectedAndPackage.INSTANCE), 4).put((Visibilities.Private)((Object)Visibilities.Public.INSTANCE), 1).put((Visibilities.Private)((Object)Visibilities.Internal.INSTANCE), 1).put((Visibilities.Private)((Object)Visibilities.Local.INSTANCE), 0).put((Visibilities.Private)((Object)JavaVisibilities.PackageVisibility.INSTANCE), 0).build();
    public static final String CAPTURED_PREFIX = "$";
    public static final String THIS = "this";
    public static final String THIS_IN_DEFAULT_IMPLS = "$this";
    public static final String LABELED_THIS_FIELD = "this_";
    public static final String CAPTURED_LABELED_THIS_FIELD = "$this_";
    public static final String INLINE_DECLARATION_SITE_THIS = "this_";
    public static final String LABELED_THIS_PARAMETER = "$this$";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    public static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String LOCAL_FUNCTION_VARIABLE_PREFIX = "$fun$";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static String getCapturedFieldName(@NotNull String originalName) {
        if (originalName == null) {
            AsmUtil.$$$reportNull$$$0(0);
        }
        String string2 = CAPTURED_PREFIX + originalName;
        if (string2 == null) {
            AsmUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String getLabeledThisName(@NotNull String callableName, @NotNull String prefix, @NotNull String defaultName) {
        if (callableName == null) {
            AsmUtil.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(3);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(4);
        }
        if (!Name.isValidIdentifier(callableName)) {
            String string2 = defaultName;
            if (string2 == null) {
                AsmUtil.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = prefix + CommonVariableAsmNameManglingUtils.mangleNameIfNeeded(callableName);
        if (string3 == null) {
            AsmUtil.$$$reportNull$$$0(6);
        }
        return string3;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        Type boxedType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(7);
        }
        Type type3 = (boxedType = AsmUtil.boxPrimitiveType(type2)) != null ? boxedType : type2;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(8);
        }
        return type3;
    }

    @Nullable
    public static Type boxPrimitiveType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(9);
        }
        return (jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort())) != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : null;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType;
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(10);
        }
        if ((primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType)) == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type2 = primitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(11);
        }
        return type2;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(12);
        }
        return primitiveTypeByBoxedType.get(boxedType);
    }

    public static boolean isBoxedPrimitiveType(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(13);
        }
        return primitiveTypeByBoxedType.get(boxedType) != null;
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (boxedOrPrimitiveType == null) {
            AsmUtil.$$$reportNull$$$0(14);
        }
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            Type type2 = boxedOrPrimitiveType;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(15);
            }
            return type2;
        }
        return AsmUtil.unboxType(boxedOrPrimitiveType);
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(16);
        }
        if (unboxedType == null) {
            AsmUtil.$$$reportNull$$$0(17);
        }
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(18);
        }
        String internalName2 = type2.getInternalName();
        assert (internalName2.charAt(0) == '[');
        Type type3 = Type.getType(internalName2.substring(1));
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(19);
        }
        return type3;
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        if (componentType == null) {
            AsmUtil.$$$reportNull$$$0(20);
        }
        Type type2 = Type.getType("[" + componentType.getDescriptor());
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(21);
        }
        return type2;
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name, @NotNull Type returnType2, Type ... parameterTypes) {
        if (name == null) {
            AsmUtil.$$$reportNull$$$0(22);
        }
        if (returnType2 == null) {
            AsmUtil.$$$reportNull$$$0(23);
        }
        if (parameterTypes == null) {
            AsmUtil.$$$reportNull$$$0(24);
        }
        return new Method(name, Type.getMethodDescriptor(returnType2, parameterTypes));
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(25);
        }
        if (exception == null) {
            AsmUtil.$$$reportNull$$$0(26);
        }
        v.anew(Type.getObjectType(exception));
        v.dup();
        if (message != null) {
            v.aconst(message);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    public static void numConst(int value2, Type type2, InstructionAdapter v) {
        if (type2 == Type.FLOAT_TYPE) {
            v.fconst(value2);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.dconst(value2);
        } else if (type2 == Type.LONG_TYPE) {
            v.lconst(value2);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v.iconst(value2);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(27);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(28);
        }
        v.visitInsn(AsmUtil.defaultValueOpcode(type2));
    }

    public static int defaultValueOpcode(@NotNull Type type2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(29);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return 1;
        }
        if (type2.getSort() == 6) {
            return 11;
        }
        if (type2.getSort() == 8) {
            return 14;
        }
        if (type2.getSort() == 7) {
            return 9;
        }
        return 3;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (!AsmUtil.isPrimitive(left) || !AsmUtil.isPrimitive(right)) {
            throw new IllegalArgumentException("Cannot compute comparison operand type: " + left + ", " + right);
        }
        if (left == Type.BOOLEAN_TYPE || right == Type.BOOLEAN_TYPE) {
            if (left != Type.BOOLEAN_TYPE || right != Type.BOOLEAN_TYPE) {
                throw new IllegalArgumentException("Cannot compare boolean with non-boolean: " + left + ", " + right);
            }
            return Type.BOOLEAN_TYPE;
        }
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            AsmUtil.$$$reportNull$$$0(30);
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            Type type2 = Type.INT_TYPE;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(31);
            }
            return type2;
        }
        Type type3 = expectedType;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(32);
        }
        return type3;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(33);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(34);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(35);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(36);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(37);
        }
        if (topOfStack.getSize() == 1 && afterTop.getSize() == 1) {
            v.visitInsn(88);
        } else {
            AsmUtil.pop(v, topOfStack);
            AsmUtil.pop(v, afterTop);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(38);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(39);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
            v.visitInsn(88);
        } else {
            v.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(40);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(41);
        }
        AsmUtil.dup(v, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(42);
        }
        if (size == 2) {
            v.dup2();
        } else if (size == 1) {
            v.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(43);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(44);
        }
        AsmUtil.dupx(v, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(45);
        }
        if (size == 2) {
            v.dup2X2();
        } else if (size == 1) {
            v.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupSecond(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(46);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(47);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(48);
        }
        if (afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (topOfStack.getSize() == 1 && afterTop.getSize() == 1) {
            v.dup2();
            v.pop();
        } else {
            AsmUtil.swap(v, topOfStack, afterTop);
            if (topOfStack.getSize() == 1 && afterTop.getSize() == 2) {
                v.dup2X1();
            } else if (topOfStack.getSize() == 2 && afterTop.getSize() == 1) {
                v.dupX2();
            } else {
                v.dup2X2();
            }
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(49);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(50);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(51);
        }
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v, 2);
            } else {
                v.dup2X1();
                v.pop2();
                v.dupX2();
                v.dupX2();
                v.pop();
                v.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings2) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(52);
        }
        if (data == null) {
            AsmUtil.$$$reportNull$$$0(53);
        }
        if (strings2 == null) {
            AsmUtil.$$$reportNull$$$0(54);
        }
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string2 : data) {
            dataVisitor.visit(null, string2);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string3 : strings2) {
            stringsVisitor.visit(null, string3);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(55);
        }
        Type type2 = Type.getObjectType(AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(56);
        }
        return type2;
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            AsmUtil.$$$reportNull$$$0(57);
        }
        Type type2 = Type.getObjectType(classId.asString().replace('.', '$'));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(58);
        }
        return type2;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(59);
        }
        String string2 = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string2 == null) {
            AsmUtil.$$$reportNull$$$0(60);
        }
        return string2;
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(61);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(62);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor(AsmTypes.K_CLASS_ARRAY_TYPE, AsmTypes.getType(Class[].class)), false);
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility2) {
        return visibilityToAccessFlag.get(visibility2);
    }

    static {
        ImmutableMap.Builder<Integer, JvmPrimitiveType> typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Type, Type> typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType(primitiveType.getDesc());
            typeBySortBuilder.put(asmType.getSort(), primitiveType);
            typeByWrapperBuilder.put(AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 31: 
            case 32: 
            case 56: 
            case 58: 
            case 60: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 31: 
            case 32: 
            case 56: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 31: 
            case 32: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 7: 
            case 9: 
            case 18: 
            case 27: 
            case 29: 
            case 34: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedOrPrimitiveType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxedType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 49: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 36: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStack";
                break;
            }
            case 37: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterTop";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedFieldName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxUnlessPrimitive";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "correctElementType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "numberFunctionOperandType";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByClassId";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedFieldName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 31: 
            case 32: 
            case 56: 
            case 58: 
            case 60: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unboxType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unboxPrimitiveTypeOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedPrimitiveType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unboxUnlessPrimitive";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedTypeOf";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "correctElementType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "method";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "genThrow";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultValueOnStack";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "defaultValueOpcode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "numberFunctionOperandType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "pop";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "pop2";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "dupx";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "dupSecond";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByClassId";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassIntoKClass";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassesIntoKClasses";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 31: 
            case 32: 
            case 56: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

