/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 M2\u00020\u0001:\u0001MBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ@\u0010*\u001a\u0016\u0012\u0004\u0012\u00020,\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010-0+2\u0006\u0010/\u001a\u0002002\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u0003012\u0006\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J4\u0010:\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J:\u0010=\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010>0+2\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010?\u001a\u00020@2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010B\u001a\u00020@2\u0006\u0010C\u001a\u00020D2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u0002092\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020@2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001a\u0010K\u001a\b\u0012\u0004\u0012\u0002060L*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "checkSelectorTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "selectorTypeInfo", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getCallExpressionTypeInfo", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "callOperationNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "initialDataFlowInfoForArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getQualifiedExpressionTypeInfo", "expression", "getResolvedCallForFunction", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "getSafeOrUnsafeSelectorTypeInfo", "element", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "getSimpleNameExpressionTypeInfo", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getUnsafeSelectorTypeInfo", "selectorExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getVariableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "recordResultTypeInfo", "", "resultTypeInfo", "resolveDeferredReceiverInQualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "resolveSimpleName", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "traceAndCache", "Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryTraceAndCache;", "setExpressionTypingServices", "elementChain", "", "Companion", "frontend"})
public final class CallExpressionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)callResolver, (String)"callResolver");
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)qualifiedExpressionResolver, (String)"qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    @Inject
    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call2, ResolutionContext<?> context2, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context2, call2, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call2)));
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"callResolver.resolveFunc\u2026)\n            )\n        )");
        OverloadResolutionResults<FunctionDescriptor> results = overloadResolutionResults;
        return !results.isNothing() ? new Pair((Object)true, OverloadResolutionResultsUtil.getResultingCall(results, context2)) : new Pair((Object)false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context2) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as local variable or property", nameExpression);
        Call call2 = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makePropertyCall(receive\u2026tionNode, nameExpression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"create(\n            cont\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"callResolver.resolveSimp\u2026perty(contextForVariable)");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = overloadResolutionResults;
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                temporaryForVariable.commit();
                return new Pair((Object)true, resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null);
            }
        }
        temporaryForVariable.commit();
        return new Pair((Object)(!resolutionResult.isNothing() ? 1 : 0), resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null);
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)nameExpression, (String)"nameExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode, context2, dataFlowInfo);
    }

    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable", nameExpression);
        Object Context2 = context2.replaceTraceAndCache(temporaryForVariable);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceTraceAndCache(temporaryForVariable)");
        Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context2);
        boolean notNothing = (Boolean)pair.component1();
        KotlinType type2 = (KotlinType)pair.component2();
        if (notNothing) {
            temporaryForVariable.commit();
            return TypeInfoFactoryKt.createTypeInfo(type2, initialDataFlowInfoForArguments);
        }
        Call call2 = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(nameExpression,\u2026eExpression, emptyList())");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function", nameExpression);
        Object object = context2.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(object, (String)"context.replaceTraceAndCache(temporaryForFunction)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)object;
        object = this.getResolvedCallForFunction(call3, newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = (Boolean)object.component1();
        ResolvedCall resolvedCall2 = (ResolvedCall)object.component2();
        if (resolveResult) {
            FunctionDescriptor functionDescriptor;
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall3 == null ? null : (FunctionDescriptor)resolvedCall3.getResultingDescriptor();
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                temporaryForFunction.commit();
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), nameExpression, hasValueParameters));
                FunctionDescriptor functionDescriptor3 = functionDescriptor;
                return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 == null ? null : functionDescriptor3.getReturnType(), context2);
            }
        }
        TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context2, "trace to resolve as qualifier", nameExpression);
        Object object2 = context2.replaceTraceAndCache(temporaryForQualifier);
        Intrinsics.checkNotNullExpressionValue(object2, (String)"context.replaceTraceAndC\u2026he(temporaryForQualifier)");
        ExpressionTypingContext contextForQualifier = (ExpressionTypingContext)object2;
        object2 = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, contextForQualifier);
        if (object2 == null) {
            temporaryForVariable.commit();
        } else {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, contextForQualifier);
            temporaryForQualifier.commit();
        }
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, null, null, context2, dataFlowInfo);
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context2);
        }
        return typeInfo;
    }

    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        Call call2 = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(receiver, callO\u2026tionNode, callExpression)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function call", callExpression);
        Object Context2 = context2.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceTraceAndCache(temporaryForFunction)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call3, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = (Boolean)pair.component1();
        ResolvedCall resolvedCall2 = (ResolvedCall)pair.component2();
        if (resolveResult) {
            DataFlowInfo resultFlowInfo;
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor = resolvedCall3 == null ? null : (FunctionDescriptor)resolvedCall3.getResultingDescriptor();
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                Object object = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionDescriptor.constructedClass");
                ClassDescriptor constructedClass = object;
                if (DescriptorUtils.isAnnotationClass(constructedClass)) {
                    object = context2.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
                    if (!Companion.canInstantiateAnnotationClass(callExpression, (BindingTrace)object)) {
                        boolean supported;
                        boolean bl = supported = context2.languageVersionSettings.supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses) && constructedClass.getDeclaredTypeParameters().isEmpty();
                        if (!supported) {
                            context2.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                        }
                    }
                }
                if (DescriptorUtils.isEnumClass(constructedClass)) {
                    context2.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (DescriptorUtils.isSealedClass(constructedClass)) {
                    context2.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> list2 = callExpression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"callExpression.valueArguments");
            List<KtValueArgument> arguments2 = list2;
            DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"resolvedCall.dataFlowInfoForArguments.resultInfo");
            DataFlowInfo jumpFlowInfo = resultFlowInfo = dataFlowInfo;
            boolean jumpOutPossible = false;
            for (KtValueArgument argument2 : arguments2) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context2.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument2.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            return TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable with 'invoke' call", callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            Object resultFlowInfo = context2.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkNotNullExpressionValue(resultFlowInfo, (String)"context.replaceTraceAndCache(temporaryForVariable)");
            Pair<Boolean, KotlinType> pair2 = this.getVariableType(ktSimpleNameExpression, receiver, callOperationNode, (ExpressionTypingContext)resultFlowInfo);
            boolean notNothing = (Boolean)pair2.component1();
            KotlinType type3 = (KotlinType)pair2.component2();
            TemporaryBindingTrace temporaryBindingTrace = temporaryForVariable.trace;
            Object object = BindingContext.QUALIFIER;
            Intrinsics.checkNotNullExpressionValue(object, (String)"QUALIFIER");
            Qualifier qualifier = (Qualifier)temporaryBindingTrace.get((ReadOnlySlice)object, calleeExpression);
            if (notNothing && (qualifier == null || !(qualifier instanceof PackageQualifier))) {
                Object object2;
                ResolvedCallImpl resolvedCallImpl;
                Object it = object = CallUtilKt.getResolvedCall(callExpression, temporaryForVariable.trace.getBindingContext());
                boolean bl = false;
                ResolvedCallImpl resolvedCallImpl2 = resolvedCallImpl = it instanceof ResolvedCallImpl ? (ResolvedCallImpl)it : null;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context2.trace;
                PsiElement psiElement = calleeExpression;
                object = type3;
                if (object == null) {
                    SimpleType simpleType2 = ErrorUtils.createErrorType("");
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"createErrorType(\"\")");
                    object2 = simpleType2;
                } else {
                    object2 = object;
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, (KotlinType)object2));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context2, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call3)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    private final List<CallExpressionElement> elementChain(KtQualifiedExpression $this$elementChain, ExpressionTypingContext context2) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($this$elementChain, context2, (Function1<? super KtSimpleNameExpression, Boolean>)((Function1)new Function1<KtSimpleNameExpression, Boolean>(context2, this){
            final /* synthetic */ ExpressionTypingContext $context;
            final /* synthetic */ CallExpressionResolver this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtSimpleNameExpression nameExpression) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)nameExpression, (String)"nameExpression");
                TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create(this.$context, "trace to resolve as local variable or property", nameExpression);
                Intrinsics.checkNotNullExpressionValue((Object)temporaryTraceAndCache, (String)"temporaryTraceAndCache");
                OverloadResolutionResults resolutionResult = CallExpressionResolver.access$resolveSimpleName(this.this$0, this.$context, nameExpression, temporaryTraceAndCache);
                if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
                    bl = false;
                } else {
                    OverloadResolutionResults.Code code = resolutionResult.getResultCode();
                    int n = elementChain.WhenMappings.$EnumSwitchMapping$0[code.ordinal()];
                    switch (n) {
                        case 1: 
                        case 2: {
                            bl = false;
                            break;
                        }
                        default: {
                            boolean success;
                            boolean newInferenceEnabled = this.$context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
                            boolean bl2 = success = !newInferenceEnabled || resolutionResult.isSuccess();
                            if (newInferenceEnabled && success) {
                                temporaryTraceAndCache.commit();
                            }
                            bl = success;
                        }
                    }
                }
                return bl;
            }
        }));
    }

    private final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(ExpressionTypingContext context2, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        Call call2 = CallMaker.makePropertyCall(null, null, expression2);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makePropertyCall(null, null, expression)");
        Call call3 = call2;
        Object object = BasicCallResolutionContext.create(context2.replaceTraceAndCache(traceAndCache), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(\n            cont\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = object;
        object = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"callResolver.resolveSimp\u2026perty(contextForVariable)");
        return object;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver, ASTNode callOperationNode, KtExpression selectorExpression, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context2, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context2, initialDataFlowInfoForArguments);
        } else if (ktExpression != null) {
            ExpressionTypingServices expressionTypingServices;
            ExpressionTypingServices expressionTypingServices2 = this.expressionTypingServices;
            if (expressionTypingServices2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"expressionTypingServices");
                expressionTypingServices = null;
            } else {
                expressionTypingServices = expressionTypingServices2;
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context2);
            context2.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression)));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver, CallExpressionElement element, ExpressionTypingContext context2) {
        KotlinType selectorType;
        KotlinTypeInfo kotlinTypeInfo;
        KotlinTypeInfo kotlinTypeInfo2;
        DataFlowValue dataFlowValue2;
        ReceiverValue receiverValue;
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        DataFlowInfo initialDataFlowInfoForArguments = dataFlowInfo;
        ReceiverValue receiverValue2 = receiverValue = receiver instanceof ReceiverValue ? (ReceiverValue)receiver : null;
        if (receiverValue == null) {
            dataFlowValue2 = null;
        } else {
            ReceiverValue receiverValue3;
            ReceiverValue it = receiverValue3 = receiverValue;
            boolean bl = false;
            dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(it, context2);
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue2;
        boolean receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getStableNullability(receiverDataFlowValue).canBeNull();
        boolean shouldNullifySafeCallType = receiverCanBeNull || context2.languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable);
        ASTNode callOperationNode = AstLoadingFilter.forceAllowTreeLoading(element.getQualified().getContainingFile(), () -> CallExpressionResolver.getSafeOrUnsafeSelectorTypeInfo$lambda-3(element));
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (shouldNullifySafeCallType) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns), this.languageVersionSettings);
            }
            if (!receiverCanBeNull) {
                Object bl = context2.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"context.trace");
                BindingTrace bindingTrace = bl;
                bl = ((ReceiverValue)receiver).getType();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"receiver.type");
                Intrinsics.checkNotNullExpressionValue((Object)callOperationNode, (String)"callOperationNode");
                Companion.reportUnnecessarySafeCall(bindingTrace, (KotlinType)bl, callOperationNode, receiver);
            }
        }
        KtExpression selector = element.getSelector();
        KotlinTypeInfo $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4 = kotlinTypeInfo2 = this.getUnsafeSelectorTypeInfo(receiver, callOperationNode, selector, context2, initialDataFlowInfoForArguments);
        boolean bl = false;
        KotlinType kotlinType = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4.getType();
        if (kotlinType == null) {
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4;
        } else {
            KotlinType type2 = kotlinType;
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4.replaceType(this.kotlinTypeRefiner.refineType(type2));
        }
        KotlinTypeInfo selectorTypeInfo = kotlinTypeInfo;
        if (receiver instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver, selector, context2);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && shouldNullifySafeCallType) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context2.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context2) {
        Object object;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context2);
        KtExpression ktExpression = qualified;
        Object object2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace");
        CompileTimeConstant value2 = ConstantExpressionEvaluator.evaluateExpression$default(this.constantExpressionEvaluator, ktExpression, (BindingTrace)object2, context2.expectedType, false, 8, null);
        if (value2 != null && value2.isPure()) {
            object2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, qualified, context2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n            dataFlowAn\u2026ified, context)\n        }");
            object = object2;
        } else {
            if (context2.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context2);
            }
            object = selectorTypeInfo;
        }
        return object;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context2) {
        Object object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        BindingTrace trace = object;
        if (!Intrinsics.areEqual(trace.get(BindingContext.PROCESSED, qualified), (Object)true)) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            object = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.scope");
            BindingContextUtilsKt.recordScope(trace, (LexicalScope)object, qualified);
            object = context2.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.replaceDataFlowI\u2026ultTypeInfo.dataFlowInfo)");
            BindingContextUtilsKt.recordDataFlowInfo(object, qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression2, @NotNull ExpressionTypingContext context2) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object Context2 = ((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceExpectedT\u2026xtDependency(INDEPENDENT)");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)Context2;
        BindingTrace bindingTrace = currentContext.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"currentContext.trace");
        BindingTrace trace = bindingTrace;
        List<CallExpressionElement> elementChain2 = this.elementChain(expression2, currentContext);
        KtExpression firstReceiver = ((CallExpressionElement)CollectionsKt.first(elementChain2)).getReceiver();
        Qualifier qualifier = (Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver);
        if (qualifier == null) {
            ExpressionTypingServices expressionTypingServices;
            object = this.expressionTypingServices;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"expressionTypingServices");
                expressionTypingServices = null;
            } else {
                expressionTypingServices = object;
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            object = currentContext.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentContext.dataFlowInfo");
            KotlinTypeInfo kotlinTypeInfo2 = new KotlinTypeInfo(null, (DataFlowInfo)object, false, null, 12, null);
            kotlinTypeInfo = kotlinTypeInfo2;
        }
        KotlinTypeInfo kotlinTypeInfo3 = kotlinTypeInfo;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo3, (String)"when (trace.get(BindingC\u2026t.dataFlowInfo)\n        }");
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo3;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain2) {
            Receiver receiver;
            KotlinType kotlinType;
            Object object2;
            Object receiver2;
            KotlinType kotlinType2 = receiverTypeInfo.getType();
            if (kotlinType2 == null) {
                receiver2 = element.getReceiver();
                object2 = ErrorUtils.createErrorType(Intrinsics.stringPlus((String)"Type for ", (Object)(receiver2 instanceof KtNameReferenceExpression ? ((KtNameReferenceExpression)receiver2).getReferencedName() : receiver2.getText())));
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"createErrorType(\n       \u2026      }\n                )");
                kotlinType = (KotlinType)object2;
            } else {
                kotlinType = kotlinType2;
            }
            KotlinType receiverType = kotlinType;
            object2 = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver());
            if (object2 == null) {
                KtExpression ktExpression = element.getReceiver();
                receiver2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)receiver2, (String)"trace.bindingContext");
                receiver = ExpressionReceiver.Companion.create(ktExpression, receiverType, (BindingContext)receiver2);
            } else {
                receiver = (Receiver)object2;
            }
            Receiver receiver3 = receiver;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean lastStage = qualifiedExpression == expression2;
            Object Context3 = (lastStage ? context2 : currentContext).replaceDataFlowInfo(receiver3 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver3).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"if (lastStage) context e\u2026          }\n            )");
            ExpressionTypingContext contextForSelector = (ExpressionTypingContext)Context3;
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo(receiver3, element, contextForSelector);
            boolean bl = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, contextForSelector).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                this.recordResultTypeInfo(qualifiedExpression, resultTypeInfo, contextForSelector);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        return resultTypeInfo;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context2) {
        DeclarationDescriptor declarationDescriptor;
        KtReferenceExpression ktReferenceExpression;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(CallUtilKt.getCalleeExpressionIfAny(selectorExpression));
        KtReferenceExpression ktReferenceExpression2 = ktReferenceExpression = calleeExpression instanceof KtReferenceExpression ? (KtReferenceExpression)calleeExpression : null;
        if (ktReferenceExpression == null) {
            declarationDescriptor = null;
        } else {
            KtReferenceExpression ktReferenceExpression3;
            KtReferenceExpression it = ktReferenceExpression3 = ktReferenceExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)context2.trace.get(BindingContext.REFERENCE_TARGET, it);
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context2);
    }

    private static final ASTNode getSafeOrUnsafeSelectorTypeInfo$lambda-3(CallExpressionElement $element) {
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        return $element.getNode();
    }

    public static final /* synthetic */ OverloadResolutionResults access$resolveSimpleName(CallExpressionResolver $this, ExpressionTypingContext context2, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        return $this.resolveSimpleName(context2, expression2, traceAndCache);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "()V", "canInstantiateAnnotationClass", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkNestedClassAccess", "", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "isUnderAnnotationClassDeclaration", "parent", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "reportUnnecessarySafeCall", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callOperationNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canInstantiateAnnotationClass(@NotNull KtCallExpression expression2, @NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Object object = new Class[]{KtValueArgument.class, KtParameter.class};
            Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, object);
            if (parent2 instanceof KtValueArgument) {
                Object $this$getParentOfType$iv;
                object = parent2;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, strict$iv) != null) {
                    return true;
                }
                $this$getParentOfType$iv = parent2;
                strict$iv = true;
                $i$f$getParentOfType = false;
                parent2 = PsiTreeUtil.getParentOfType($this$getParentOfType$iv, KtParameter.class, strict$iv);
                if (parent2 != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void $this$getParentOfType$iv;
            PsiElement psiElement = parent2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, strict$iv);
            if (ktClass == null) {
                bl = false;
            } else {
                PsiElement it = psiElement = ktClass;
                boolean bl2 = false;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull ASTNode callOperationNode, @Nullable Receiver explicitReceiver) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)callOperationNode, (String)"callOperationNode");
            if (explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression) {
                trace.report(Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode.getPsi()));
            } else if (!KotlinTypeKt.isError(type2)) {
                trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type2));
            }
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression2, ExpressionTypingContext context2) {
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context2.trace.get(BindingContext.QUALIFIER, expression2);
            Qualifier receiverQualifier = (Qualifier)context2.trace.get(BindingContext.QUALIFIER, expression2.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassifierQualifier;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = Intrinsics.stringPlus((String)"Only class can (package cannot) be accessed by instance reference: ", (Object)expressionQualifier);
                    throw new AssertionError((Object)string2);
                }
                ClassifierDescriptorWithTypeParameters descriptor2 = ((ClassifierQualifier)expressionQualifier).getDescriptor();
                context2.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), descriptor2));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

