/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.jtype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private Utils() {
        throw new AssertionError();
    }

    public static <T> T checkNotNull(T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " cannot be null");
        }
        return object;
    }

    public static void checkTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkTrue(boolean condition, String message, Object value) {
        if (!condition) {
            throw new IllegalArgumentException(message + value);
        }
    }

    public static void checkFalse(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkFalse(boolean condition, String message, Object value) {
        if (condition) {
            throw new IllegalArgumentException(message + value);
        }
    }

    public static int nullHashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static boolean nullEquals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }
}

