/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.xbean.osgi.bundle.util.DelegatingBundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingBundle
implements Bundle {
    private CopyOnWriteArrayList<Bundle> bundles;
    private Bundle bundle;
    private BundleContext bundleContext;

    public DelegatingBundle(Collection<Bundle> bundles) {
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("At least one bundle is required");
        }
        this.bundles = new CopyOnWriteArrayList<Bundle>(bundles);
        this.bundle = bundles.iterator().next();
        this.bundleContext = new DelegatingBundleContext(this, this.bundle.getBundleContext());
    }

    public DelegatingBundle(Bundle bundle) {
        this(Collections.singletonList(bundle));
    }

    public Bundle getMainBundle() {
        return this.bundle;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.bundle.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            int index = name.lastIndexOf(46);
            if (index > 0 && this.bundles.size() > 1) {
                String packageName = name.substring(0, index);
                Set<Bundle> packageBundles = this.getPackageBundles(packageName);
                if (packageBundles == null) {
                    Iterator<Bundle> iterator = this.bundles.iterator();
                    iterator.next();
                    while (iterator.hasNext()) {
                        Bundle delegate = iterator.next();
                        try {
                            return delegate.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                    throw ex;
                }
                Bundle delegate = this.findFirstBundle(packageBundles);
                if (delegate == null || delegate == this.bundle) {
                    throw ex;
                }
                return delegate.loadClass(name);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Bundle> getPackageBundles(String packageName) {
        BundleContext context = this.bundle.getBundleContext();
        ServiceReference reference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(reference);
        HashSet<Bundle> bundles = null;
        try {
            ExportedPackage[] exportedPackages = packageAdmin.getExportedPackages(packageName);
            if (exportedPackages != null && exportedPackages.length > 0) {
                bundles = new HashSet<Bundle>();
                for (ExportedPackage exportedPackage : exportedPackages) {
                    bundles.add(exportedPackage.getExportingBundle());
                    Bundle[] importingBundles = exportedPackage.getImportingBundles();
                    if (importingBundles == null) continue;
                    for (Bundle importingBundle : importingBundles) {
                        bundles.add(importingBundle);
                    }
                }
            }
            HashSet<Bundle> hashSet = bundles;
            return hashSet;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private Bundle findFirstBundle(Set<Bundle> packageBundles) {
        Collection<Bundle> c1 = this.bundles;
        Collection<Bundle> c2 = packageBundles;
        if (this.bundles instanceof Set && this.bundles.size() > packageBundles.size()) {
            c1 = packageBundles;
            c2 = this.bundles;
        }
        for (Bundle bundle : c1) {
            if (!c2.contains(bundle)) continue;
            return bundle;
        }
        return null;
    }

    public void addBundle(Bundle b) {
        this.bundles.add(b);
    }

    public void removeBundle(Bundle b) {
        this.bundles.remove(b);
    }

    public URL getResource(String name) {
        URL resource = null;
        for (Bundle bundle : this.bundles) {
            resource = bundle.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> allResources = new ArrayList<URL>();
        for (Bundle bundle : this.bundles) {
            Enumeration e = bundle.getResources(name);
            DelegatingBundle.addToList(allResources, e);
        }
        return Collections.enumeration(allResources);
    }

    private static void addToList(List<URL> list, Enumeration<URL> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Enumeration findEntries(String arg0, String arg1, boolean arg2) {
        return this.bundle.findEntries(arg0, arg1, arg2);
    }

    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    public URL getEntry(String arg0) {
        return this.bundle.getEntry(arg0);
    }

    public Enumeration getEntryPaths(String arg0) {
        return this.bundle.getEntryPaths(arg0);
    }

    public Dictionary getHeaders() {
        return this.bundle.getHeaders();
    }

    public Dictionary getHeaders(String arg0) {
        return this.bundle.getHeaders(arg0);
    }

    public long getLastModified() {
        return this.bundle.getLastModified();
    }

    public String getLocation() {
        return this.bundle.getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return this.bundle.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        return this.bundle.getServicesInUse();
    }

    public Map getSignerCertificates(int arg0) {
        return this.bundle.getSignerCertificates(arg0);
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    public Version getVersion() {
        return this.bundle.getVersion();
    }

    public boolean hasPermission(Object arg0) {
        return this.bundle.hasPermission(arg0);
    }

    public void start() throws BundleException {
        this.bundle.start();
    }

    public void start(int arg0) throws BundleException {
        this.bundle.start(arg0);
    }

    public void stop() throws BundleException {
        this.bundle.stop();
    }

    public void stop(int arg0) throws BundleException {
        this.bundle.stop(arg0);
    }

    public void uninstall() throws BundleException {
        this.bundle.uninstall();
    }

    public void update() throws BundleException {
        this.bundle.update();
    }

    public void update(InputStream arg0) throws BundleException {
        this.bundle.update(arg0);
    }

    public int compareTo(Bundle other) {
        return this.bundle.compareTo((Object)other);
    }

    public <A> A adapt(Class<A> type) {
        return (A)this.bundle.adapt(type);
    }

    public File getDataFile(String filename) {
        return this.bundle.getDataFile(filename);
    }

    public String toString() {
        return "[DelegatingBundle: " + this.bundles + "]";
    }
}

