/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.ArchiveResource$;
import org.apache.spark.sql.catalyst.catalog.FileResource$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceLoader;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceType;
import org.apache.spark.sql.catalyst.catalog.JarResource$;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@InterfaceStability.Unstable
@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\t)2+Z:tS>t'+Z:pkJ\u001cW\rT8bI\u0016\u0014(BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u000f\r\fG/\u00197pO*\u0011\u0011\u0004B\u0001\tG\u0006$\u0018\r\\=ti&\u00111D\u0006\u0002\u0017\rVt7\r^5p]J+7o\\;sG\u0016du.\u00193fe\"AQ\u0004\u0001B\u0001B\u0003%a$A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005}\u0001S\"\u0001\u0003\n\u0005\u0005\"!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\b\u0006\u0002&OA\u0011a\u0005A\u0007\u0002\u0005!)QD\ta\u0001=!)\u0011\u0006\u0001C!U\u0005aAn\\1e%\u0016\u001cx.\u001e:dKR\u00111F\f\t\u0003\u001f1J!!\f\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006_!\u0002\r\u0001M\u0001\te\u0016\u001cx.\u001e:dKB\u0011Q#M\u0005\u0003eY\u0011\u0001CR;oGRLwN\u001c*fg>,(oY3\t\u000bQ\u0002A\u0011A\u001b\u0002\r\u0005$GMS1s)\tYc\u0007C\u00038g\u0001\u0007\u0001(\u0001\u0003qCRD\u0007CA\u001dA\u001d\tQd\b\u0005\u0002<!5\tAH\u0003\u0002>\u0019\u00051AH]8pizJ!a\u0010\t\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fAA#\u0001\u0001#\u0011\u0005\u0015[eB\u0001$J\u001b\u00059%B\u0001%\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0015\u001e\u000b!#\u00138uKJ4\u0017mY3Ti\u0006\u0014\u0017\u000e\\5us&\u0011A*\u0014\u0002\t+:\u001cH/\u00192mK*\u0011!j\u0012")
public class SessionResourceLoader
implements FunctionResourceLoader {
    private final SparkSession session;

    public void loadResource(FunctionResource resource) {
        FunctionResourceType functionResourceType = resource.resourceType();
        if (JarResource$.MODULE$.equals(functionResourceType)) {
            this.addJar(resource.uri());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FileResource$.MODULE$.equals(functionResourceType)) {
            this.session.sparkContext().addFile(resource.uri());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (ArchiveResource$.MODULE$.equals(functionResourceType)) {
                throw new AnalysisException("Archive is not allowed to be loaded. If YARN mode is used, please use --archives options while calling spark-submit.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new MatchError((Object)functionResourceType);
        }
    }

    public void addJar(String path) {
        this.session.sparkContext().addJar(path);
        URI uri = new Path(path).toUri();
        URL jarURL = uri.getScheme() == null ? new File(path).toURI().toURL() : uri.toURL();
        this.session.sharedState().jarClassLoader().addURL(jarURL);
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.session.sharedState().jarClassLoader()));
    }

    public SessionResourceLoader(SparkSession session) {
        this.session = session;
    }
}

