/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.ArrayOps;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%b!B\u0001\u0003\u0003\u0003y!\u0001G\"p[B\f7\r^5cY\u00164\u0015\u000e\\3TiJ,\u0017-\u001c'pO*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u0001QC\u0001\t\u001e'\t\u0001\u0011\u0003E\u0002\u0013'Ui\u0011AA\u0005\u0003)\t\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\t\u0004-eYR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005qiB\u0002\u0001\u0003\u0006=\u0001\u0011\ra\b\u0002\u0002)F\u0011\u0001e\t\t\u0003-\u0005J!AI\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003J\u0005\u0003K]\u0011a!\u00118z%\u00164\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002%5,G/\u00193bi\u0006dun\u001a,feNLwN\u001c\t\u0003-%J!AK\f\u0003\u0007%sG\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tqs&D\u0001\u0007\u0013\t\u0001dA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005QZdBA\u001b:!\t1t#D\u00018\u0015\tAd\"\u0001\u0004=e>|GOP\u0005\u0003u]\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!h\u0006\u0005\t\u007f\u0001\u0011\u0019\u0011)A\u0006\u0001\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007\u0005#5$D\u0001C\u0015\t\u0019u#A\u0004sK\u001adWm\u0019;\n\u0005\u0015\u0013%\u0001C\"mCN\u001cH+Y4\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0011IE*\u0014(\u0015\u0005)[\u0005c\u0001\n\u00017!)qH\u0012a\u0002\u0001\")qE\u0012a\u0001Q!)AF\u0012a\u0001[!)!G\u0012a\u0001g!9\u0001\u000b\u0001b\u0001\n\u0017\t\u0016a\u00024pe6\fGo]\u000b\u0002%J\u00191k\t.\u0007\tQ\u0003\u0001A\u0015\u0002\ryI,g-\u001b8f[\u0016tGOP\u0005\u0003!ZK!a\u0016-\u0003\u001bM+'/[1mSj\fG/[8o\u0015\tIF\"\u0001\u0004kg>tGg\u001d\t\u00037rk\u0011\u0001W\u0005\u0003;b\u0013qAR8s[\u0006$8\u000fC\u0004`'\n\u0007I\u0011\u00011\u0002\u0015\u0011\fG/\u001a$pe6\fG/F\u0001b!\tY&-\u0003\u0002d1\nQA)\u0019;f\r>\u0014X.\u0019;\t\u000f\u0015\u001c&\u0019!C!M\u0006IA/\u001f9f\u0011&tGo]\u000b\u0002OB\u00111\f[\u0005\u0003Sb\u0013\u0011\u0002V=qK\"Kg\u000e^:\t\r-\u0004\u0001\u0015!\u0003S\u0003!1wN]7biN\u0004\u0003bB7\u0001\u0005\u0004%YA\\\u0001\t[\u0006t\u0017NZ3tiV\tq\u000eE\u0002BanI!!\u001d\"\u0003\u00115\u000bg.\u001b4fgRDaa\u001d\u0001!\u0002\u0013y\u0017!C7b]&4Wm\u001d;!\u0011\u001d)\bA1A\u0005\u0012Y\f!#\\5o\u0005\u0006$8\r[3t)>\u0014V\r^1j]V\t\u0001\u0006\u0003\u0004y\u0001\u0001\u0006I\u0001K\u0001\u0014[&t')\u0019;dQ\u0016\u001cHk\u001c*fi\u0006Lg\u000e\t\u0005\u0006u\u00021\tb_\u0001\u0013M&dWm\u00117fC:,\b\u000fR3mCfl5/F\u0001}!\t1R0\u0003\u0002\u007f/\t!Aj\u001c8h\u0011\u001d\t\t\u0001\u0001D\t\u0003\u0007\tA#[:EK2,G/\u001b8h\u000bb\u0004\u0018N]3e\u0019><WCAA\u0003!\r1\u0012qA\u0005\u0004\u0003\u00139\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u001b\u0001a\u0011\u0003<\u0002-\u0011,g-Y;mi\u000e{W\u000e]1di&sG/\u001a:wC2D\u0011\"!\u0005\u0001\u0011\u000b\u0007IQ\u0003<\u0002\u001f\r|W\u000e]1di&sG/\u001a:wC2Dq!!\u0006\u0001\r\u0003\t9\"A\u0006d_6\u0004\u0018m\u0019;M_\u001e\u001cH\u0003BA\r\u0003W\u0001R!a\u0007\u0002&mqA!!\b\u0002\"9\u0019a'a\b\n\u0003aI1!a\t\u0018\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\n\u0002*\t\u00191+Z9\u000b\u0007\u0005\rr\u0003\u0003\u0005\u0002.\u0005M\u0001\u0019AA\r\u0003\u0011awnZ:\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u0005i!-\u0019;dQ&#Gk\u001c)bi\"$B!!\u000e\u0002FA!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012A\u00014t\u0015\r\tyDC\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005\r\u0013\u0011\b\u0002\u0005!\u0006$\b\u000eC\u0004\u0002H\u0005=\u0002\u0019\u0001?\u0002\u000f\t\fGo\u00195JI\"9\u00111\n\u0001\u0005B\u00055\u0013!\u00049bi\"$vNQ1uG\"LE\rF\u0002}\u0003\u001fBqAMA%\u0001\u0004\t)\u0004C\u0004\u0002T\u0001!\t%!\u0016\u0002\u0017%\u001c()\u0019;dQ\u001aKG.\u001a\u000b\u0005\u0003\u000b\t9\u0006C\u00043\u0003#\u0002\r!!\u000e\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005I1/\u001a:jC2L'0\u001a\u000b\u0007\u0003?\n)'!\u001b\u0011\u0007Y\t\t'C\u0002\u0002d]\u0011A!\u00168ji\"9\u0011qMA-\u0001\u0004)\u0012a\u00027pO\u0012\u000bG/\u0019\u0005\t\u0003W\nI\u00061\u0001\u0002n\u0005\u0019q.\u001e;\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005\u0011\u0011n\u001c\u0006\u0003\u0003o\nAA[1wC&!\u00111PA9\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\ty\b\u0001C!\u0003\u0003\u000b1\u0002Z3tKJL\u0017\r\\5{KR\u0019Q#a!\t\u0011\u0005\u0015\u0015Q\u0010a\u0001\u0003\u000f\u000b!!\u001b8\u0011\t\u0005=\u0014\u0011R\u0005\u0005\u0003\u0017\u000b\tHA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBAH\u0001\u0011\u0005\u0013\u0011S\u0001\u0004C\u0012$GCBA\u0003\u0003'\u000b)\nC\u0004\u0002H\u00055\u0005\u0019\u0001?\t\u000f\u00055\u0012Q\u0012a\u0001+!9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0015aB2p[B\f7\r\u001e\u000b\u0007\u0003\u000b\ti*a(\t\u000f\u0005\u001d\u0013q\u0013a\u0001y\"9\u0011QFAL\u0001\u0004)\u0002bBAR\u0001\u0011\u0005\u0011QU\u0001\tC2dg)\u001b7fgR\tQ\u0003C\u0004\u0002*\u0002!I!a+\u0002!\u0011,G.\u001a;f\u000bb\u0004\u0018N]3e\u0019><G\u0003BA0\u0003[Cq!a,\u0002(\u0002\u0007A0\u0001\bdkJ\u0014XM\u001c;CCR\u001c\u0007.\u00133\t\u001d\u0005M\u0006\u0001%A\u0002\u0002\u0003%I!!.\u0002@\u0006I1/\u001e9fe\u0012:W\r\u001e\u000b\u0005\u0003o\u000bi\f\u0005\u0003\u0017\u0003s+\u0012bAA^/\t1q\n\u001d;j_:Dq!a\u0012\u00022\u0002\u0007A0C\u0002\u0002BN\t1aZ3u\u000f\u001d\t)M\u0001E\u0001\u0003\u000f\f\u0001dQ8na\u0006\u001cG/\u001b2mK\u001aKG.Z*ue\u0016\fW\u000eT8h!\r\u0011\u0012\u0011\u001a\u0004\u0007\u0003\tA\t!a3\u0014\u0007\u0005%7\u0005C\u0004H\u0003\u0013$\t!a4\u0015\u0005\u0005\u001d\u0007BCAj\u0003\u0013\u0014\r\u0011\"\u0001\u0002V\u0006\u00192iT'Q\u0003\u000e#vLR%M\u000b~\u001bVK\u0012$J1V\u0011\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*!\u0011Q\\A;\u0003\u0011a\u0017M\\4\n\u0007q\nY\u000eC\u0005\u0002d\u0006%\u0007\u0015!\u0003\u0002X\u0006!2iT'Q\u0003\u000e#vLR%M\u000b~\u001bVK\u0012$J1\u0002B\u0001\"a:\u0002J\u0012\u0005\u0011\u0011^\u0001\u0017O\u0016$()\u0019;dQ&#gI]8n\r&dWMT1nKR\u0019A0a;\t\u000f\u00055\u0018Q\u001da\u0001g\u0005Aa-\u001b7f\u001d\u0006lW\r\u0003\u0005\u0002r\u0006%G\u0011AAz\u0003EI7oQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0003\u000b\t)0a>\t\u000f\u0005\u001d\u0013q\u001ea\u0001y\"9\u0011\u0011CAx\u0001\u0004A\u0003\u0002CA~\u0003\u0013$\t!!@\u0002I\u001d,GOV1mS\u0012\u0014\u0015\r^2iKN\u0014UMZ8sK\u000e{W\u000e]1di&|gNQ1uG\"$b!a@\u0003\u0002\t\u0015\u0001#BA\u000e\u0003Ka\bb\u0002B\u0002\u0003s\u0004\r\u0001`\u0001\u0012G>l\u0007/Y2uS>t')\u0019;dQ&#\u0007bBA\t\u0003s\u0004\r\u0001\u000b\u0005\t\u0005\u0013\tI\r\"\u0001\u0003\f\u0005\u0011r-\u001a;BY24\u0016\r\\5e\u0005\u0006$8\r[3t)\u0019\tyP!\u0004\u0003\u0010!9\u0011q\tB\u0004\u0001\u0004a\bbBA\t\u0005\u000f\u0001\r\u0001 \u0005\t\u0005'\tI\r\"\u0001\u0003\u0016\u0005)b.\u001a=u\u0007>l\u0007/Y2uS>t')\u0019;dQ&#G#\u0002?\u0003\u0018\te\u0001bBA$\u0005#\u0001\r\u0001 \u0005\b\u0003#\u0011\t\u00021\u0001}\u0011!\u0011i\"!3\u0005\u0002\t}\u0011!\u00063fe&4XmQ8na\u0006\u001cG/\u00138uKJ4\u0018\r\u001c\u000b\u0006Q\t\u0005\"Q\u0005\u0005\b\u0005G\u0011Y\u00021\u0001)\u0003=!WMZ1vYRLe\u000e^3sm\u0006d\u0007b\u0002B\u0014\u00057\u0001\r\u0001K\u0001\u0015Y\u0006$Xm\u001d;D_6\u0004\u0018m\u0019;CCR\u001c\u0007.\u00133")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int n, int n2) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(n, n2);
    }

    public static long nextCompactionBatchId(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(l, l2);
    }

    public static Seq<Object> getAllValidBatches(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(l, l2);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(l, n);
    }

    public static boolean isCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(l, n);
    }

    public static long getBatchIdFromFileName(String string) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(string);
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private /* synthetic */ Option super$get(long batchId) {
        return super.get(batchId);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$))).reverse();
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("intervalValue = ").append(interval$1.elem).append(" not positive value.").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Set the compact interval to ").append(interval$1.elem).append(" ").append(new StringBuilder(26).append("[defaultCompactInterval: ").append(this.defaultCompactInterval()).append("]").toString()).toString());
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        return !this.bitmap$0 ? this.compactInterval$lzycompute() : this.compactInterval;
    }

    public abstract Seq<T> compactLogs(Seq<T> var1);

    @Override
    public Path batchIdToPath(long batchId) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? new Path(this.metadataPath(), new StringBuilder(0).append(batchId).append(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX()).toString()) : new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(new StringBuilder(1).append("v").append(this.metadataLogVersion).toString().getBytes(StandardCharsets.UTF_8));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logData)).foreach((Function1 & Serializable & scala.Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        int version = this.parseVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable & scala.Serializable)json -> Serialization$.MODULE$.read(json, this.formats(), this.manifest())).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    private boolean compact(long batchId, T[] logs) {
        Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId, this.compactInterval());
        Seq allLogs = (Seq)((TraversableLike)((GenericTraversableTemplate)validBatches.map((Function1 & Serializable & scala.Serializable)id -> CompactibleFileStreamLog.$anonfun$compact$1(this, batchId, BoxesRunTime.unboxToLong((Object)id)), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(xs)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logs)), Seq$.MODULE$.canBuildFrom());
        return super.add(batchId, this.compactLogs(allLogs).toArray(this.manifest()));
    }

    public T[] allFiles() {
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)((GenericTraversableTemplate)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).map((Function1 & Serializable & scala.Serializable)id -> CompactibleFileStreamLog.$anonfun$allFiles$3(this, latestId, BoxesRunTime.unboxToLong((Object)id)), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(xs)));
                return (Object[])this.compactLogs(logs).toArray(this.manifest());
            }
            catch (IOException e) {
                latestId.elem = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                super.get(latestId.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw e;
                });
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        block0: {
            if ((long)this.compactInterval() > currentBatchId + 1L - (long)this.minBatchesToRetain()) break block0;
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(minCompactionBatchId).append(" is not a compaction batch").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Current compact batch id = ").append(currentBatchId).append(" ").append(new StringBuilder(36).append("min compaction batch id to delete = ").append(minCompactionBatchId).toString()).toString());
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), new PathFilter(null, minCompactionBatchId){
                private final long minCompactionBatchId$1;

                public boolean accept(Path path) {
                    boolean bl;
                    block3: {
                        try {
                            long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                            if (batchId < this.minCompactionBatchId$1) {
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    }
                    return bl;
                }
                {
                    this.minCompactionBatchId$1 = minCompactionBatchId$1;
                }
            }))).foreach((Function1 & Serializable & scala.Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$3(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        out$1.write(Serialization$.MODULE$.write(data, $this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ Object[] $anonfun$compact$1(CompactibleFileStreamLog $this, long batchId$1, long id) {
        return (Object[])$this.super$get(id).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(38).append($this.batchIdToPath(id)).append(" doesn't exist when compacting batch ").append(batchId$1).append(" ").append(new StringBuilder(19).append("(compactInterval: ").append($this.compactInterval()).append(")").toString()).toString());
        });
    }

    public static final /* synthetic */ Object[] $anonfun$allFiles$3(CompactibleFileStreamLog $this, LongRef latestId$1, long id) {
        return (Object[])$this.super$get(id).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(15).append($this.batchIdToPath(id)).append(" doesn't exist ").append(new StringBuilder(31).append("(latestId: ").append(latestId$1.elem).append(", compactInterval: ").append($this.compactInterval()).append(")").toString()).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$3(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        block0: {
            if (f.getModificationTime() > expiredTime$1) break block0;
            $this.fileManager().delete(f.getPath());
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

