/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.HadoopFileWholeTextReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001E\u0011a\u0002V3yi\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!A/\u001a=u\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\n\t\u0003K9r!A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u0002\u0012A\u0002\u001fs_>$hHC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+\u0011\u0015\u0011\u0004\u0001\"\u0011$\u0003!!xn\u0015;sS:<\u0007\"\u0002\u001b\u0001\t\u0013)\u0014\u0001\u0004<fe&4\u0017pU2iK6\fGC\u0001\u001c;!\t9\u0004(D\u0001+\u0013\tI$F\u0001\u0003V]&$\b\"B\u001e4\u0001\u0004a\u0014AB:dQ\u0016l\u0017\r\u0005\u0002>\u00016\taH\u0003\u0002@\u0011\u0005)A/\u001f9fg&\u0011\u0011I\u0010\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B\"\u0001\t\u0003\"\u0015aC5t'Bd\u0017\u000e^1cY\u0016$B!\u0012%O'B\u0011qGR\u0005\u0003\u000f*\u0012qAQ8pY\u0016\fg\u000eC\u0003J\u0005\u0002\u0007!*\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002L\u00196\t\u0001\"\u0003\u0002N\u0011\ta1\u000b]1sWN+7o]5p]\")qJ\u0011a\u0001!\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0013RI\u0011J!A\u0015\u0019\u0003\u00075\u000b\u0007\u000fC\u0003U\u0005\u0002\u0007Q+\u0001\u0003qCRD\u0007C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\t17O\u0003\u0002[\u0019\u00051\u0001.\u00193p_BL!\u0001X,\u0003\tA\u000bG\u000f\u001b\u0005\u0006=\u0002!\teX\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003aG\u0012,\u0007cA\u001cby%\u0011!M\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b%k\u0006\u0019\u0001&\t\u000b=k\u0006\u0019\u0001)\t\u000b\u0019l\u0006\u0019A4\u0002\u000b\u0019LG.Z:\u0011\u0007!l\u0007O\u0004\u0002jW:\u0011qE[\u0005\u0002W%\u0011ANK\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0002TKFT!\u0001\u001c\u0016\u0011\u0005Y\u000b\u0018B\u0001:X\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006i\u0002!\t%^\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\bmfT\u0018QAA\u0004!\t\u0019r/\u0003\u0002y\t\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")\u0011j\u001da\u0001\u0015\")1p\u001da\u0001y\u0006\u0019!n\u001c2\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018,A\u0005nCB\u0014X\rZ;dK&\u0019\u00111\u0001@\u0003\u0007){'\rC\u0003Pg\u0002\u0007\u0001\u000b\u0003\u0004\u0002\nM\u0004\r\u0001P\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007bBA\u0007\u0001\u0011\u0005\u0013qB\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002\u0012\u0005=\u0012\u0011GA\u001a\u0003o\tY$a\u0012\u0002JA9q'a\u0005\u0002\u0018\u0005u\u0011bAA\u000bU\tIa)\u001e8di&|g.\r\t\u0004'\u0005e\u0011bAA\u000e\t\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003i\u0003?\t\u0019#C\u0002\u0002\"=\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0005\u0002\u0011\r\fG/\u00197zgRLA!!\f\u0002(\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019I\u00151\u0002a\u0001\u0015\"9\u0011\u0011BA\u0006\u0001\u0004a\u0004bBA\u001b\u0003\u0017\u0001\r\u0001P\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u0011\u0011HA\u0006\u0001\u0004a\u0014A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\t\u0003{\tY\u00011\u0001\u0002@\u00059a-\u001b7uKJ\u001c\b\u0003\u00025n\u0003\u0003\u00022aFA\"\u0013\r\t)\u0005\u0007\u0002\u0007\r&dG/\u001a:\t\r=\u000bY\u00011\u0001Q\u0011!\tY%a\u0003A\u0002\u00055\u0013A\u00035bI>|\u0007oQ8oMB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002Te\u000bAaY8oM&!\u0011qKA)\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u00111\f\u0001\u0005\n\u0005u\u0013a\u0004:fC\u0012$v.\u00168tC\u001a,W*Z7\u0015\u0011\u0005}\u0013qNAE\u0003\u0017\u0003raNA\n\u0003/\t\t\u0007E\u0003i\u0003?\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\u0011\tI'a\n\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003[\n9GA\u0005V]N\fg-\u001a*po\"A\u00111KA-\u0001\u0004\t\t\b\u0005\u0004\u0002t\u0005e\u0014QP\u0007\u0003\u0003kR1!a\u001e\u000b\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0003\u0002|\u0005U$!\u0003\"s_\u0006$7-Y:u!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB\u0015\u0005!Q\u000f^5m\u0013\u0011\t9)!!\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003s\tI\u00061\u0001=\u0011!\ti)!\u0017A\u0002\u0005=\u0015a\u0003;fqR|\u0005\u000f^5p]N\u00042\u0001IAI\u0013\r\t\u0019J\u0001\u0002\f)\u0016DHo\u00149uS>t7\u000fC\u0004\u0002\u0018\u0002!\t%!'\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$R!RAN\u0003KC\u0001\"!(\u0002\u0016\u0002\u0007\u0011qT\u0001\tI\u0006$\u0018\rV=qKB\u0019Q(!)\n\u0007\u0005\rfH\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\t9+!&A\u0002\u0015\u000b!\"[:SK\u0006$\u0007+\u0019;i\u0001")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "text";
    }

    public String toString() {
        return "Text";
    }

    private void verifySchema(StructType schema) {
        if (schema.size() != 1) {
            throw new AnalysisException(new StringBuilder(70).append("Text data source supports only a single column, and you have ").append(schema.size()).append(" columns.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        TextOptions textOptions = new TextOptions(options);
        return super.isSplitable(sparkSession, options, path) && !textOptions.wholeText();
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(4).append(".txt").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "Text data source only produces a single data column named \"value\".");
        TextOptions textOptions = new TextOptions(options);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return this.readToUnsafeMem((Broadcast<SerializableConfiguration>)broadcastedHadoopConf, requiredSchema, textOptions);
    }

    private Function1<PartitionedFile, Iterator<UnsafeRow>> readToUnsafeMem(Broadcast<SerializableConfiguration> conf, StructType requiredSchema, TextOptions textOptions) {
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            Configuration confValue = ((SerializableConfiguration)conf.value()).value();
            Closeable reader = !textOptions.wholeText() ? new HadoopFileLinesReader((PartitionedFile)file, textOptions.lineSeparatorInRead(), confValue) : new HadoopFileWholeTextReader((PartitionedFile)file, confValue);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach(arg_0 -> TextFileFormat.$anonfun$readToUnsafeMem$2((Iterator)reader, arg_0));
            if (requiredSchema.isEmpty()) {
                UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                iterator = reader.map((Function1 & Serializable & scala.Serializable)x$3 -> emptyUnsafeRow);
            } else {
                UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(1);
                iterator = reader.map((Function1 & Serializable & scala.Serializable)line -> {
                    unsafeRowWriter.reset();
                    unsafeRowWriter.write(0, line.getBytes(), 0, line.getLength());
                    return unsafeRowWriter.getRow();
                });
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        DataType dataType2 = dataType;
        StringType$ stringType$ = StringType$.MODULE$;
        return !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null);
    }

    public static final /* synthetic */ void $anonfun$readToUnsafeMem$3(Iterator reader$1, TaskContext x$2) {
        ((Closeable)reader$1).close();
    }

    public static final /* synthetic */ TaskContext $anonfun$readToUnsafeMem$2(Iterator reader$1, TaskContext x$1) {
        return x$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
            TextFileFormat.$anonfun$readToUnsafeMem$3(reader$1, x$2);
            return BoxedUnit.UNIT;
        });
    }
}

