/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0002\u0001\u00131q\u0011\u0003\u0006\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011!BR5mK\u001a{'/\\1u!\ti\u0002%D\u0001\u001f\u0015\ty\u0002\"A\u0004t_V\u00148-Z:\n\u0005\u0005r\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0006\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oOB\u00111#K\u0005\u0003UQ\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000fE\u0002!\u0019!C\u0005e\u0005!\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J,\u0012a\r\t\u0003_QJ!!\u000e\u0002\u0003)A\u000b'/];fi2{wMU3eSJ,7\r^8s\u0011\u00199\u0004\u0001)A\u0005g\u0005)\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J\u0004\u0003\"B\u001d\u0001\t\u0003R\u0014!C:i_J$h*Y7f)\u0005Y\u0004C\u0001\u001fD\u001d\ti\u0014\t\u0005\u0002?)5\tqH\u0003\u0002A!\u00051AH]8pizJ!A\u0011\u000b\u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005RAQa\u0012\u0001\u0005Bi\n\u0001\u0002^8TiJLgn\u001a\u0005\u0006\u0013\u0002!\tES\u0001\tQ\u0006\u001c\bnQ8eKR\t1\n\u0005\u0002\u0014\u0019&\u0011Q\n\u0006\u0002\u0004\u0013:$\b\"B(\u0001\t\u0003\u0002\u0016AB3rk\u0006d7\u000f\u0006\u0002R)B\u00111CU\u0005\u0003'R\u0011qAQ8pY\u0016\fg\u000eC\u0003V\u001d\u0002\u0007a+A\u0003pi\",'\u000f\u0005\u0002\u0014/&\u0011\u0001\f\u0006\u0002\u0004\u0003:L\b\"\u0002.\u0001\t\u0003Z\u0016\u0001\u00049sKB\f'/Z,sSR,G#\u0002/`K>$\bCA\r^\u0013\tqFAA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003a3\u0002\u0007\u0011-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002cG6\t\u0001\"\u0003\u0002e\u0011\ta1\u000b]1sWN+7o]5p]\")a-\u0017a\u0001O\u0006\u0019!n\u001c2\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017!C7baJ,G-^2f\u0015\taG\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003]&\u00141AS8c\u0011\u0015\u0001\u0018\f1\u0001r\u0003\u001dy\u0007\u000f^5p]N\u0004B\u0001\u0010:<w%\u00111/\u0012\u0002\u0004\u001b\u0006\u0004\b\"B;Z\u0001\u00041\u0018A\u00033bi\u0006\u001c6\r[3nCB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010C\u0001\u0006if\u0004Xm]\u0005\u0003wb\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015i\b\u0001\"\u0011\u007f\u0003-IgNZ3s'\u000eDW-\\1\u0015\u000f}\f)!a\u0002\u0002\fA!1#!\u0001w\u0013\r\t\u0019\u0001\u0006\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\u0001d\b\u0019A1\t\r\u0005%A\u00101\u0001r\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\b\u0003\u001ba\b\u0019AA\b\u0003\u00151\u0017\u000e\\3t!\u0019\t\t\"a\u0007\u0002\"9!\u00111CA\f\u001d\rq\u0014QC\u0005\u0002+%\u0019\u0011\u0011\u0004\u000b\u0002\u000fA\f7m[1hK&!\u0011QDA\u0010\u0005\r\u0019V-\u001d\u0006\u0004\u00033!\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001d2.\u0001\u0002gg&!\u00111FA\u0013\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0004\u0007\u0003_\u0001\u0001)!\r\u0003\u0013\u0019KG.\u001a+za\u0016\u001c8CBA\u0017%\u0005M\u0002\u0006E\u0002\u0014\u0003kI1!a\u000e\u0015\u0005\u001d\u0001&o\u001c3vGRD1\"a\u000f\u0002.\tU\r\u0011\"\u0001\u0002>\u0005!A-\u0019;b+\t\ty\u0001C\u0006\u0002B\u00055\"\u0011#Q\u0001\n\u0005=\u0011!\u00023bi\u0006\u0004\u0003bCA#\u0003[\u0011)\u001a!C\u0001\u0003{\t\u0001\"\\3uC\u0012\fG/\u0019\u0005\f\u0003\u0013\niC!E!\u0002\u0013\ty!A\u0005nKR\fG-\u0019;bA!Y\u0011QJA\u0017\u0005+\u0007I\u0011AA\u001f\u00039\u0019w.\\7p]6+G/\u00193bi\u0006D1\"!\u0015\u0002.\tE\t\u0015!\u0003\u0002\u0010\u0005y1m\\7n_:lU\r^1eCR\f\u0007\u0005C\u0004-\u0003[!\t!!\u0016\u0015\u0011\u0005]\u00131LA/\u0003?\u0002B!!\u0017\u0002.5\t\u0001\u0001\u0003\u0005\u0002<\u0005M\u0003\u0019AA\b\u0011!\t)%a\u0015A\u0002\u0005=\u0001\u0002CA'\u0003'\u0002\r!a\u0004\t\u0015\u0005\r\u0014QFA\u0001\n\u0003\t)'\u0001\u0003d_BLH\u0003CA,\u0003O\nI'a\u001b\t\u0015\u0005m\u0012\u0011\rI\u0001\u0002\u0004\ty\u0001\u0003\u0006\u0002F\u0005\u0005\u0004\u0013!a\u0001\u0003\u001fA!\"!\u0014\u0002bA\u0005\t\u0019AA\b\u0011)\ty'!\f\u0012\u0002\u0013\u0005\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019H\u000b\u0003\u0002\u0010\u0005U4FAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005E#\u0001\u0006b]:|G/\u0019;j_:LA!!\"\u0002|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005%\u0015QFI\u0001\n\u0003\t\t(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u00055\u0015QFI\u0001\n\u0003\t\t(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005E\u0015QFA\u0001\n\u0003\n\u0019*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0003B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0003mC:<'BAAP\u0003\u0011Q\u0017M^1\n\u0007\u0011\u000bI\n\u0003\u0006\u0002&\u00065\u0012\u0011!C\u0001\u0003O\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u0013\u0005\u000b\u0003W\u000bi#!A\u0005\u0002\u00055\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004-\u0006=\u0006\"CAY\u0003S\u000b\t\u00111\u0001L\u0003\rAH%\r\u0005\u000b\u0003k\u000bi#!A\u0005B\u0005]\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0006#BA^\u0003\u00034VBAA_\u0015\r\ty\fF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAb\u0003{\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0003\u000f\fi#!A\u0005\u0002\u0005%\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007E\u000bY\rC\u0005\u00022\u0006\u0015\u0017\u0011!a\u0001-\"A\u0011*!\f\u0002\u0002\u0013\u0005#\nC\u0005H\u0003[\t\t\u0011\"\u0011\u0002RR\u0011\u0011Q\u0013\u0005\n\u001f\u00065\u0012\u0011!C!\u0003+$2!UAl\u0011%\t\t,a5\u0002\u0002\u0003\u0007akB\u0005\u0002\\\u0002\t\t\u0011#\u0001\u0002^\u0006Ia)\u001b7f)f\u0004Xm\u001d\t\u0005\u00033\nyNB\u0005\u00020\u0001\t\t\u0011#\u0001\u0002bN)\u0011q\\ArQAa\u0011Q]Av\u0003\u001f\ty!a\u0004\u0002X5\u0011\u0011q\u001d\u0006\u0004\u0003S$\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003[\f9OA\tBEN$(/Y2u\rVt7\r^5p]NBq\u0001LAp\t\u0003\t\t\u0010\u0006\u0002\u0002^\"Iq)a8\u0002\u0002\u0013\u0015\u0013\u0011\u001b\u0005\u000b\u0003o\fy.!A\u0005\u0002\u0006e\u0018!B1qa2LH\u0003CA,\u0003w\fi0a@\t\u0011\u0005m\u0012Q\u001fa\u0001\u0003\u001fA\u0001\"!\u0012\u0002v\u0002\u0007\u0011q\u0002\u0005\t\u0003\u001b\n)\u00101\u0001\u0002\u0010!Q!1AAp\u0003\u0003%\tI!\u0002\u0002\u000fUt\u0017\r\u001d9msR!!q\u0001B\b!\u0015\u0019\u0012\u0011\u0001B\u0005!%\u0019\"1BA\b\u0003\u001f\ty!C\u0002\u0003\u000eQ\u0011a\u0001V;qY\u0016\u001c\u0004B\u0003B\t\u0005\u0003\t\t\u00111\u0001\u0002X\u0005\u0019\u0001\u0010\n\u0019\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\u0005Q1\u000f\u001d7ji\u001aKG.Z:\u0015\t\u0005]#\u0011\u0004\u0005\t\u00057\u0011\u0019\u00021\u0001\u0002\u0010\u0005A\u0011\r\u001c7GS2,7\u000fC\u0004\u0003 \u0001!IA!\t\u0002\u001b%\u001c8+^7nCJLh)\u001b7f)\r\t&1\u0005\u0005\t\u0005K\u0011i\u00021\u0001\u0003(\u0005!a-\u001b7f!\u0011\t\u0019C!\u000b\n\t\t-\u0012Q\u0005\u0002\u0005!\u0006$\b\u000eC\u0004\u00030\u0001!\tE!\r\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000bE\u0013\u0019D!\u000e\t\r\u0001\u0014i\u00031\u0001b\u0011\u001d\u00119D!\fA\u0002Y\faa]2iK6\f\u0007b\u0002B\u001e\u0001\u0011\u0005#QH\u0001\fm\u0016\u001cGo\u001c:UsB,7\u000f\u0006\u0005\u0003@\t\r#q\tB&!\u0015\u0019\u0012\u0011\u0001B!!\u0015\t\t\"a\u0007<\u0011\u001d\u0011)E!\u000fA\u0002Y\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0003J\te\u0002\u0019\u0001<\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006D\u0001B!\u0014\u0003:\u0001\u0007!qJ\u0001\bgFd7i\u001c8g!\u0011\u0011\tF!\u0016\u000e\u0005\tM#BA\u0013\t\u0013\u0011\u00119Fa\u0015\u0003\u000fM\u000bFjQ8oM\"9!1\f\u0001\u0005B\tu\u0013aC5t'Bd\u0017\u000e^1cY\u0016$r!\u0015B0\u0005C\u0012\u0019\u0007\u0003\u0004a\u00053\u0002\r!\u0019\u0005\u0007a\ne\u0003\u0019A9\t\u0011\t\u0015$\u0011\fa\u0001\u0005O\tA\u0001]1uQ\"9!\u0011\u000e\u0001\u0005B\t-\u0014A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\u0011iG!#\u0003\f\n5%q\u0012BI\u0005;\u0013y\nE\u0004\u0014\u0005_\u0012\u0019H!\u001f\n\u0007\tEDCA\u0005Gk:\u001cG/[8ocA\u0019\u0011D!\u001e\n\u0007\t]DAA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0019\t\tBa\u001f\u0003~%!\u00111YA\u0010!\u0011\u0011yH!\"\u000e\u0005\t\u0005%b\u0001BB\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0003\b\n\u0005%aC%oi\u0016\u0014h.\u00197S_^Da\u0001\u0019B4\u0001\u0004\t\u0007BB;\u0003h\u0001\u0007a\u000fC\u0004\u0003J\t\u001d\u0004\u0019\u0001<\t\u000f\t\u0015#q\ra\u0001m\"A!1\u0013B4\u0001\u0004\u0011)*A\u0004gS2$XM]:\u0011\r\u0005E\u00111\u0004BL!\ri\"\u0011T\u0005\u0004\u00057s\"A\u0002$jYR,'\u000f\u0003\u0004q\u0005O\u0002\r!\u001d\u0005\t\u0005C\u00139\u00071\u0001\u0003$\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\t\u0015&1V\u0007\u0003\u0005OS1A!+l\u0003\u0011\u0019wN\u001c4\n\t\t5&q\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\tE\u0006\u0001\"\u0011\u00034\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0003R\u0005k\u0013y\f\u0003\u0005\u00038\n=\u0006\u0019\u0001B]\u0003!!\u0017\r^1UsB,\u0007cA<\u0003<&\u0019!Q\u0018=\u0003\u0011\u0011\u000bG/\u0019+za\u0016DqA!1\u00030\u0002\u0007\u0011+\u0001\u0006jgJ+\u0017\r\u001a)bi\"<qA!2\u0003\u0011\u0003\u00119-A\tQCJ\fX/\u001a;GS2,gi\u001c:nCR\u00042a\fBe\r\u0019\t!\u0001#\u0001\u0003LN)!\u0011\u001a\n#Q!9AF!3\u0005\u0002\t=GC\u0001Bd\u0011%\u0011\u0019N!3\u0005\u0002\t\u0011).\u0001\u0006sK\u0006$7k\u00195f[\u0006$Ra Bl\u0005SD\u0001B!7\u0003R\u0002\u0007!1\\\u0001\bM>|G/\u001a:t!\u0019\t\t\"a\u0007\u0003^B!!q\u001cBs\u001b\t\u0011\tOC\u0002m\u0005GT!a\u0001\u0007\n\t\t\u001d(\u0011\u001d\u0002\u0007\r>|G/\u001a:\t\r\u0001\u0014\t\u000e1\u0001b\u0011%\u0011iO!3\u0005\u0002\t\u0011y/\u0001\u000fsK\u0006$\u0007+\u0019:rk\u0016$hi\\8uKJ\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\u0011\tm'\u0011\u001fBz\u0005oD\u0001B!+\u0003l\u0002\u0007!1\u0015\u0005\t\u0005k\u0014Y\u000f1\u0001\u0002\u0010\u0005I\u0001/\u0019:u\r&dWm\u001d\u0005\b\u0005s\u0014Y\u000f1\u0001R\u0003IIwM\\8sK\u000e{'O];qi\u001aKG.Z:\t\u0011\tu(\u0011\u001aC\u0001\u0005\u007f\fa#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\u0006\u007f\u000e\u00051Q\u0001\u0005\t\u0007\u0007\u0011Y\u00101\u0001\u0002\u0010\u0005aa-\u001b7fgR{Gk\\;dQ\"1\u0001Ma?A\u0002\u0005D\u0001b!\u0003\u0003J\u0012\u000511B\u0001\u0015e\u0016\fGmU2iK6\fgI]8n\r>|G/\u001a:\u0015\u000bY\u001cia!\u0005\t\u0011\r=1q\u0001a\u0001\u0005;\faAZ8pi\u0016\u0014\b\u0002CB\n\u0007\u000f\u0001\ra!\u0006\u0002\u0013\r|gN^3si\u0016\u0014\bcA\u0018\u0004\u0018%\u00191\u0011\u0004\u0002\u0003;A\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJD\u0001b!\b\u0003J\u0012%1qD\u0001\u0018I\u0016\u001cXM]5bY&TXmU2iK6\f7\u000b\u001e:j]\u001e$2a`B\u0011\u0011\u001d\u0019\u0019ca\u0007A\u0002m\nAb]2iK6\f7\u000b\u001e:j]\u001eD!ba\n\u0003J\u0006\u0005I\u0011BB\u0015\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r-\u0002\u0003BAL\u0007[IAaa\f\u0002\u001a\n1qJ\u00196fGR\u0004")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
scala.Serializable {
    private volatile ParquetFileFormat$FileTypes$ FileTypes$module;
    private final ParquetLogRedirector parquetLogRedirector;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(seq, sparkSession);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    public ParquetFileFormat$FileTypes$ FileTypes() {
        if (this.FileTypes$module == null) {
            this.FileTypes$lzycompute$1();
        }
        return this.FileTypes$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if (!(jobSummaryLevel != null ? !jobSummaryLevel.equals(jobSummaryLevel2) : jobSummaryLevel2 != null) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append(new StringBuilder(58).append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString()).toString());
        }
        return new OutputWriterFactory(null){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.empty() : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.metadata().headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.data().headOption())).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles) {
        FileStatus[] leaves = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isSummaryFile(f.getPath())))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$splitFiles$3(x$2)))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$splitFiles$4(x$3)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$supportBatch$1(x$4)));
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply((Object)Seq$.MODULE$.fill(requiredSchema.fields().length + partitionSchema.fields().length, (Function0 & Serializable & scala.Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName()));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$5)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable & scala.Serializable)file -> {
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Path filePath = fileSplit.getPath();
            ParquetInputSplit split = new ParquetInputSplit(filePath, fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = ParquetFileFormat.footerFileMetaData$1(filePath, sharedConf, footerFileMetaData$lzy).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(parquetSchema, (Filter)x$6)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(filePath, sharedConf, footerFileMetaData$lzy) ? new Some((Object)DateTimeUtils$.MODULE$.getTimeZone(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((TimeZone)convertTz.orNull(Predef$.MODULE$.$conforms()), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$8 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                if (returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            } else {
                ParquetRecordReader parquetRecordReader;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport((Option<TimeZone>)convertTz), parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport((Option<TimeZone>)convertTz));
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator(reader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$10 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                JoinedRow joinedRow = new JoinedRow();
                UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                recordReaderIterator = partitionSchema.length() == 0 ? iter : iter.map((Function1 & Serializable & scala.Serializable)d -> appendPartitionColumns.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType(), isReadPath)));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void FileTypes$lzycompute$1() {
        ParquetFileFormat parquetFileFormat = this;
        synchronized (parquetFileFormat) {
            if (this.FileTypes$module == null) {
                this.FileTypes$module = new ParquetFileFormat$FileTypes$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$3(FileStatus x$2) {
        String string = x$2.getPath().getName();
        String string2 = "_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$4(FileStatus x$3) {
        String string = x$3.getPath().getName();
        String string2 = "_common_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$4) {
        return x$4.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$5) {
        return x$5.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(Path filePath$1, Configuration sharedConf$1, LazyRef footerFileMetaData$lzy$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFileReader.readFooter((Configuration)sharedConf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(Path filePath$1, Configuration sharedConf$1, LazyRef footerFileMetaData$lzy$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetFileFormat.footerFileMetaData$lzycompute$1(filePath$1, sharedConf$1, footerFileMetaData$lzy$1);
    }

    private static final boolean isCreatedByParquetMr$1(Path filePath$1, Configuration sharedConf$1, LazyRef footerFileMetaData$lzy$1) {
        return ParquetFileFormat.footerFileMetaData$1(filePath$1, sharedConf$1, footerFileMetaData$lzy$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }

    public class FileTypes
    implements Product,
    scala.Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ ParquetFileFormat $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.data();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ParquetFileFormat org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(ParquetFileFormat $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

