/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r]h\u0001B\u0001\u0003\u0001=\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u0015\t\u0019A!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u001b!\u0006\u0014H/\u001b;j_:LgnZ!xCJ,g)\u001b7f\u0013:$W\r\u001f\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005a1\u000f]1sWN+7o]5p]B\u0011q\u0003G\u0007\u0002\r%\u0011\u0011D\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005\u0011\"o\\8u!\u0006$\bn]*qK\u000eLg-[3e!\rirE\u000b\b\u0003=\u0011r!a\b\u0012\u000e\u0003\u0001R!!\t\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013'\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aI\u0005\u0003Q%\u00121aU3r\u0015\t)c\u0005\u0005\u0002,a5\tAF\u0003\u0002.]\u0005\u0011am\u001d\u0006\u0003_)\ta\u0001[1e_>\u0004\u0018BA\u0019-\u0005\u0011\u0001\u0016\r\u001e5\t\u0011M\u0002!\u0011!Q\u0001\nQ\n!\u0002]1sC6,G/\u001a:t!\u0011)\u0014\b\u0010\u001f\u000f\u0005Y:\u0004CA\u0010'\u0013\tAd%\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u00121!T1q\u0015\tAd\u0005\u0005\u00026{%\u0011ah\u000f\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005\u000b1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u00042AQ\"F\u001b\u00051\u0013B\u0001#'\u0005\u0019y\u0005\u000f^5p]B\u0011a)S\u0007\u0002\u000f*\u0011\u0001JB\u0001\u0006if\u0004Xm]\u0005\u0003\u0015\u001e\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011!a\u0005A!A!\u0002\u0013i\u0015a\u00044jY\u0016\u001cF/\u0019;vg\u000e\u000b7\r[3\u0011\u0005Eq\u0015BA(\u0003\u0005=1\u0015\u000e\\3Ti\u0006$Xo]\"bG\",\u0007\"B)\u0001\t\u0003\u0011\u0016A\u0002\u001fj]&$h\b\u0006\u0004T)V3v\u000b\u0017\t\u0003#\u0001AQ!\u0006)A\u0002YAQa\u0007)A\u0002qAQa\r)A\u0002QBQ\u0001\u0011)A\u0002\u0005Cq\u0001\u0014)\u0011\u0002\u0003\u0007Q\nC\u0004[\u0001\t\u0007I\u0011I.\u0002\u0013I|w\u000e\u001e)bi\"\u001cX#\u0001/\u0011\u0007u\u0003'&D\u0001_\u0015\tyf%\u0001\u0006d_2dWm\u0019;j_:L!\u0001\u000b0\t\r\t\u0004\u0001\u0015!\u0003]\u0003)\u0011xn\u001c;QCRD7\u000f\t\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015\fqbY1dQ\u0016$G*Z1g\r&dWm]\u000b\u0002MB!qM\u001b\u0016m\u001b\u0005A'BA5_\u0003\u001diW\u000f^1cY\u0016L!a\u001b5\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\tYS.\u0003\u0002oY\tQa)\u001b7f'R\fG/^:\t\u0013A\u0004\u0001\u0019!a\u0001\n\u0013\t\u0018aE2bG\",G\rT3bM\u001aKG.Z:`I\u0015\fHC\u0001:v!\t\u00115/\u0003\u0002uM\t!QK\\5u\u0011\u001d1x.!AA\u0002\u0019\f1\u0001\u001f\u00132\u0011%A\b\u00011A\u0001B\u0003&a-\u0001\tdC\u000eDW\r\u001a'fC\u001a4\u0015\u000e\\3tA!\u0012qO\u001f\t\u0003\u0005nL!\u0001 \u0014\u0003\u0011Y|G.\u0019;jY\u0016D\u0011B \u0001A\u0002\u0003\u0007I\u0011B@\u00029\r\f7\r[3e\u0019\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fgV\u0011\u0011\u0011\u0001\t\u0006keR\u00131\u0001\t\u0005\u0005\u0006\u0015A.C\u0002\u0002\b\u0019\u0012Q!\u0011:sCfD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e\u0005\u00013-Y2iK\u0012dU-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001cx\fJ3r)\r\u0011\u0018q\u0002\u0005\nm\u0006%\u0011\u0011!a\u0001\u0003\u0003A1\"a\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0002\u0005i2-Y2iK\u0012dU-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001c\b\u0005K\u0002\u0002\u0012iD1\"!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001c\u0005\u00192-Y2iK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fGV\u0011\u0011Q\u0004\t\u0004#\u0005}\u0011bAA\u0011\u0005\ti\u0001+\u0019:uSRLwN\\*qK\u000eD1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(\u000592-Y2iK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fG~#S-\u001d\u000b\u0004e\u0006%\u0002\"\u0003<\u0002$\u0005\u0005\t\u0019AA\u000f\u0011-\ti\u0003\u0001a\u0001\u0002\u0003\u0006K!!\b\u0002)\r\f7\r[3e!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2!Q\r\tYC\u001f\u0005\b\u0003g\u0001A\u0011IA\u001b\u00035\u0001\u0018M\u001d;ji&|gn\u00159fGR\u0011\u0011Q\u0004\u0005\u0007\u0003s\u0001A\u0011K3\u0002\u00131,\u0017M\u001a$jY\u0016\u001c\bBBA\u001f\u0001\u0011Es0\u0001\fmK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3t\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007\nqA]3ge\u0016\u001c\b\u000eF\u0001s\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0007\n\u0001B]3ge\u0016\u001c\b\u000e\r\u0005\b\u0003\u0017\u0002A\u0011IA'\u0003\u0019)\u0017/^1mgR!\u0011qJA+!\r\u0011\u0015\u0011K\u0005\u0004\u0003'2#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003/\nI\u00051\u0001\u0002Z\u0005)q\u000e\u001e5feB\u0019!)a\u0017\n\u0007\u0005ucEA\u0002B]fDq!!\u0019\u0001\t\u0003\n\u0019'\u0001\u0005iCND7i\u001c3f)\t\t)\u0007E\u0002C\u0003OJ1!!\u001b'\u0005\rIe\u000e\u001e\u0005\b\u0003[\u0002A\u0011AA8\u00035a\u0017n\u001d;MK\u00064g)\u001b7fgR!\u0011\u0011OA<!\u00119\u00171\u000f7\n\u0007\u0005U\u0004NA\u0007MS:\\W\r\u001a%bg\"\u001cV\r\u001e\u0005\b\u0003s\nY\u00071\u0001\u001d\u0003\u0015\u0001\u0018\r\u001e5t\u000f\u001d\tiH\u0001E\u0001\u0003\u007f\n\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y!\r\t\u0012\u0011\u0011\u0004\u0007\u0003\tA\t!a!\u0014\r\u0005\u0005\u0015QQAF!\r\u0011\u0015qQ\u0005\u0004\u0003\u00133#AB!osJ+g\r\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t\nC\u0001\tS:$XM\u001d8bY&!\u0011QSAH\u0005\u001daunZ4j]\u001eDq!UAA\t\u0003\tI\n\u0006\u0002\u0002\u0000\u00199\u0011QTAA\t\u0006}%!G*fe&\fG.\u001b>bE2,'\t\\8dW2{7-\u0019;j_:\u001c\u0002\"a'\u0002\u0006\u0006\u0005\u0016q\u0015\t\u0004\u0005\u0006\r\u0016bAASM\t9\u0001K]8ek\u000e$\bc\u0001\"\u0002*&\u0019\u00111\u0016\u0014\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0017\u0005=\u00161\u0014BK\u0002\u0013\u0005\u0011\u0011W\u0001\u0006]\u0006lWm]\u000b\u0003\u0003g\u0003BAQA\u0003y!Y\u0011qWAN\u0005#\u0005\u000b\u0011BAZ\u0003\u0019q\u0017-\\3tA!Y\u00111XAN\u0005+\u0007I\u0011AAY\u0003\u0015Awn\u001d;t\u0011-\ty,a'\u0003\u0012\u0003\u0006I!a-\u0002\r!|7\u000f^:!\u0011-\t\u0019-a'\u0003\u0016\u0004%\t!!2\u0002\r=4gm]3u+\t\t9\rE\u0002C\u0003\u0013L1!a3'\u0005\u0011auN\\4\t\u0017\u0005=\u00171\u0014B\tB\u0003%\u0011qY\u0001\b_\u001a47/\u001a;!\u0011-\t\u0019.a'\u0003\u0016\u0004%\t!!2\u0002\r1,gn\u001a;i\u0011-\t9.a'\u0003\u0012\u0003\u0006I!a2\u0002\u000f1,gn\u001a;iA!9\u0011+a'\u0005\u0002\u0005mGCCAo\u0003C\f\u0019/!:\u0002hB!\u0011q\\AN\u001b\t\t\t\t\u0003\u0005\u00020\u0006e\u0007\u0019AAZ\u0011!\tY,!7A\u0002\u0005M\u0006\u0002CAb\u00033\u0004\r!a2\t\u0011\u0005M\u0017\u0011\u001ca\u0001\u0003\u000fD!\"a;\u0002\u001c\u0006\u0005I\u0011AAw\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005u\u0017q^Ay\u0003g\f)\u0010\u0003\u0006\u00020\u0006%\b\u0013!a\u0001\u0003gC!\"a/\u0002jB\u0005\t\u0019AAZ\u0011)\t\u0019-!;\u0011\u0002\u0003\u0007\u0011q\u0019\u0005\u000b\u0003'\fI\u000f%AA\u0002\u0005\u001d\u0007BCA}\u00037\u000b\n\u0011\"\u0001\u0002|\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u007fU\u0011\t\u0019,a@,\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u001bi!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0003'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0011)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba\u0005\u0002\u001cF\u0005I\u0011AA~\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB!Ba\u0006\u0002\u001cF\u0005I\u0011\u0001B\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u0007+\t\u0005\u001d\u0017q \u0005\u000b\u0005?\tY*%A\u0005\u0002\te\u0011AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005G\tY*!A\u0005B\t\u0015\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003(A!!\u0011\u0006B\u001a\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012\u0001\u00027b]\u001eT!A!\r\u0002\t)\fg/Y\u0005\u0004}\t-\u0002B\u0003B\u001c\u00037\u000b\t\u0011\"\u0001\u0003:\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\r\u0005\u000b\u0005{\tY*!A\u0005\u0002\t}\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00033\u0012\t\u0005C\u0005w\u0005w\t\t\u00111\u0001\u0002f!Q!QIAN\u0003\u0003%\tEa\u0012\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0013\u0011\u000bu\u0013Y%!\u0017\n\u0007\t5cL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011\t&a'\u0002\u0002\u0013\u0005!1K\u0001\tG\u0006tW)];bYR!\u0011q\nB+\u0011%1(qJA\u0001\u0002\u0004\tI\u0006\u0003\u0006\u0002b\u0005m\u0015\u0011!C!\u0003GB!Ba\u0017\u0002\u001c\u0006\u0005I\u0011\tB/\u0003!!xn\u0015;sS:<GC\u0001B\u0014\u0011)\tY%a'\u0002\u0002\u0013\u0005#\u0011\r\u000b\u0005\u0003\u001f\u0012\u0019\u0007C\u0005w\u0005?\n\t\u00111\u0001\u0002Z\u001dQ!qMAA\u0003\u0003EIA!\u001b\u00023M+'/[1mSj\f'\r\\3CY>\u001c7\u000eT8dCRLwN\u001c\t\u0005\u0003?\u0014YG\u0002\u0006\u0002\u001e\u0006\u0005\u0015\u0011!E\u0005\u0005[\u001abAa\u001b\u0003p\u0005\u001d\u0006C\u0004B9\u0005o\n\u0019,a-\u0002H\u0006\u001d\u0017Q\\\u0007\u0003\u0005gR1A!\u001e'\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u001f\u0003t\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000fE\u0013Y\u0007\"\u0001\u0003~Q\u0011!\u0011\u000e\u0005\u000b\u00057\u0012Y'!A\u0005F\tu\u0003B\u0003BB\u0005W\n\t\u0011\"!\u0003\u0006\u0006)\u0011\r\u001d9msRQ\u0011Q\u001cBD\u0005\u0013\u0013YI!$\t\u0011\u0005=&\u0011\u0011a\u0001\u0003gC\u0001\"a/\u0003\u0002\u0002\u0007\u00111\u0017\u0005\t\u0003\u0007\u0014\t\t1\u0001\u0002H\"A\u00111\u001bBA\u0001\u0004\t9\r\u0003\u0006\u0003\u0012\n-\u0014\u0011!CA\u0005'\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0016\nu\u0005\u0003\u0002\"D\u0005/\u00032B\u0011BM\u0003g\u000b\u0019,a2\u0002H&\u0019!1\u0014\u0014\u0003\rQ+\b\u000f\\35\u0011)\u0011yJa$\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0004q\u0012\u0002\u0004B\u0003BR\u0005W\n\t\u0011\"\u0003\u0003&\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u000b\u0005\u0003\u0003*\t%\u0016\u0002\u0002BV\u0005W\u0011aa\u00142kK\u000e$ha\u0002BX\u0003\u0003#%\u0011\u0017\u0002\u0017'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a$jY\u0016\u001cF/\u0019;vgNA!QVAC\u0003C\u000b9\u000bC\u0006\u00036\n5&Q3A\u0005\u0002\t]\u0016\u0001\u00029bi\",\u0012\u0001\u0010\u0005\u000b\u0005w\u0013iK!E!\u0002\u0013a\u0014!\u00029bi\"\u0004\u0003bCAj\u0005[\u0013)\u001a!C\u0001\u0003\u000bD1\"a6\u0003.\nE\t\u0015!\u0003\u0002H\"Y!1\u0019BW\u0005+\u0007I\u0011\u0001Bc\u0003\u0015I7\u000fR5s+\t\ty\u0005C\u0006\u0003J\n5&\u0011#Q\u0001\n\u0005=\u0013AB5t\t&\u0014\b\u0005C\u0006\u0003N\n5&Q3A\u0005\u0002\t=\u0017\u0001\u00052m_\u000e\\'+\u001a9mS\u000e\fG/[8o+\t\u0011\t\u000eE\u0002C\u0005'L1A!6'\u0005\u0015\u0019\u0006n\u001c:u\u0011-\u0011IN!,\u0003\u0012\u0003\u0006IA!5\u0002#\tdwnY6SKBd\u0017nY1uS>t\u0007\u0005C\u0006\u0003^\n5&Q3A\u0005\u0002\u0005\u0015\u0017!\u00032m_\u000e\\7+\u001b>f\u0011-\u0011\tO!,\u0003\u0012\u0003\u0006I!a2\u0002\u0015\tdwnY6TSj,\u0007\u0005C\u0006\u0003f\n5&Q3A\u0005\u0002\u0005\u0015\u0017\u0001E7pI&4\u0017nY1uS>tG+[7f\u0011-\u0011IO!,\u0003\u0012\u0003\u0006I!a2\u0002#5|G-\u001b4jG\u0006$\u0018n\u001c8US6,\u0007\u0005C\u0006\u0003n\n5&Q3A\u0005\u0002\u0005\u0015\u0017AC1dG\u0016\u001c8\u000fV5nK\"Y!\u0011\u001fBW\u0005#\u0005\u000b\u0011BAd\u0003-\t7mY3tgRKW.\u001a\u0011\t\u0017\tU(Q\u0016BK\u0002\u0013\u0005!q_\u0001\u000fE2|7m\u001b'pG\u0006$\u0018n\u001c8t+\t\u0011I\u0010E\u0003C\u0003\u000b\ti\u000eC\u0006\u0003~\n5&\u0011#Q\u0001\n\te\u0018a\u00042m_\u000e\\Gj\\2bi&|gn\u001d\u0011\t\u000fE\u0013i\u000b\"\u0001\u0004\u0002Q\u001121AB\u0003\u0007\u000f\u0019Iaa\u0003\u0004\u000e\r=1\u0011CB\n!\u0011\tyN!,\t\u000f\tU&q a\u0001y!A\u00111\u001bB\u0000\u0001\u0004\t9\r\u0003\u0005\u0003D\n}\b\u0019AA(\u0011!\u0011iMa@A\u0002\tE\u0007\u0002\u0003Bo\u0005\u007f\u0004\r!a2\t\u0011\t\u0015(q a\u0001\u0003\u000fD\u0001B!<\u0003\u0000\u0002\u0007\u0011q\u0019\u0005\t\u0005k\u0014y\u00101\u0001\u0003z\"Q\u00111\u001eBW\u0003\u0003%\taa\u0006\u0015%\r\r1\u0011DB\u000e\u0007;\u0019yb!\t\u0004$\r\u00152q\u0005\u0005\n\u0005k\u001b)\u0002%AA\u0002qB!\"a5\u0004\u0016A\u0005\t\u0019AAd\u0011)\u0011\u0019m!\u0006\u0011\u0002\u0003\u0007\u0011q\n\u0005\u000b\u0005\u001b\u001c)\u0002%AA\u0002\tE\u0007B\u0003Bo\u0007+\u0001\n\u00111\u0001\u0002H\"Q!Q]B\u000b!\u0003\u0005\r!a2\t\u0015\t58Q\u0003I\u0001\u0002\u0004\t9\r\u0003\u0006\u0003v\u000eU\u0001\u0013!a\u0001\u0005sD!\"!?\u0003.F\u0005I\u0011AB\u0016+\t\u0019iCK\u0002=\u0003\u007fD!Ba\u0005\u0003.F\u0005I\u0011\u0001B\r\u0011)\u00119B!,\u0012\u0002\u0013\u000511G\u000b\u0003\u0007kQC!a\u0014\u0002\u0000\"Q!q\u0004BW#\u0003%\ta!\u000f\u0016\u0005\rm\"\u0006\u0002Bi\u0003\u007fD!ba\u0010\u0003.F\u0005I\u0011\u0001B\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIUB!ba\u0011\u0003.F\u0005I\u0011\u0001B\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIYB!ba\u0012\u0003.F\u0005I\u0011\u0001B\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]B!ba\u0013\u0003.F\u0005I\u0011AB'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"aa\u0014+\t\te\u0018q \u0005\u000b\u0005G\u0011i+!A\u0005B\t\u0015\u0002B\u0003B\u001c\u0005[\u000b\t\u0011\"\u0001\u0003:!Q!Q\bBW\u0003\u0003%\taa\u0016\u0015\t\u0005e3\u0011\f\u0005\nm\u000eU\u0013\u0011!a\u0001\u0003KB!B!\u0012\u0003.\u0006\u0005I\u0011\tB$\u0011)\u0011\tF!,\u0002\u0002\u0013\u00051q\f\u000b\u0005\u0003\u001f\u001a\t\u0007C\u0005w\u0007;\n\t\u00111\u0001\u0002Z!Q\u0011\u0011\rBW\u0003\u0003%\t%a\u0019\t\u0015\tm#QVA\u0001\n\u0003\u0012i\u0006\u0003\u0006\u0002L\t5\u0016\u0011!C!\u0007S\"B!a\u0014\u0004l!Iaoa\u001a\u0002\u0002\u0003\u0007\u0011\u0011L\u0004\u000b\u0007_\n\t)!A\t\n\rE\u0014AF*fe&\fG.\u001b>bE2,g)\u001b7f'R\fG/^:\u0011\t\u0005}71\u000f\u0004\u000b\u0005_\u000b\t)!A\t\n\rU4CBB:\u0007o\n9\u000bE\u000b\u0003r\reD(a2\u0002P\tE\u0017qYAd\u0003\u000f\u0014Ipa\u0001\n\t\rm$1\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:D\u0004bB)\u0004t\u0011\u00051q\u0010\u000b\u0003\u0007cB!Ba\u0017\u0004t\u0005\u0005IQ\tB/\u0011)\u0011\u0019ia\u001d\u0002\u0002\u0013\u00055Q\u0011\u000b\u0013\u0007\u0007\u00199i!#\u0004\f\u000e55qRBI\u0007'\u001b)\nC\u0004\u00036\u000e\r\u0005\u0019\u0001\u001f\t\u0011\u0005M71\u0011a\u0001\u0003\u000fD\u0001Ba1\u0004\u0004\u0002\u0007\u0011q\n\u0005\t\u0005\u001b\u001c\u0019\t1\u0001\u0003R\"A!Q\\BB\u0001\u0004\t9\r\u0003\u0005\u0003f\u000e\r\u0005\u0019AAd\u0011!\u0011ioa!A\u0002\u0005\u001d\u0007\u0002\u0003B{\u0007\u0007\u0003\rA!?\t\u0015\tE51OA\u0001\n\u0003\u001bI\n\u0006\u0003\u0004\u001c\u000e\r\u0006\u0003\u0002\"D\u0007;\u0003\"CQBPy\u0005\u001d\u0017q\nBi\u0003\u000f\f9-a2\u0003z&\u00191\u0011\u0015\u0014\u0003\rQ+\b\u000f\\39\u0011)\u0011yja&\u0002\u0002\u0003\u000711\u0001\u0005\u000b\u0005G\u001b\u0019(!A\u0005\n\t\u0015\u0006\"CBU\u0003\u0003#\tABBV\u0003E\u0011W\u000f\\6MSN$H*Z1g\r&dWm\u001d\u000b\u000b\u0007[\u001b9l!/\u0004J\u000eM\u0007\u0003B\u000f(\u0007_\u0003bAQBYU\rU\u0016bABZM\t1A+\u001e9mKJ\u00022!H\u0014m\u0011\u001d\tIha*A\u0002qA\u0001ba/\u0004(\u0002\u00071QX\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BB`\u0007\u000bl!a!1\u000b\u0007\r\rg&\u0001\u0003d_:4\u0017\u0002BBd\u0007\u0003\u0014QbQ8oM&<WO]1uS>t\u0007\u0002CBf\u0007O\u0003\ra!4\u0002\r\u0019LG\u000e^3s!\rY3qZ\u0005\u0004\u0007#d#A\u0003)bi\"4\u0015\u000e\u001c;fe\"1Qca*A\u0002YA\u0001\"!\u001c\u0002\u0002\u0012%1q\u001b\u000b\u000b\u0007k\u001bIna7\u0004^\u000e}\u0007b\u0002B[\u0007+\u0004\rA\u000b\u0005\t\u0007w\u001b)\u000e1\u0001\u0004>\"A11ZBk\u0001\u0004\u0019i\r\u0003\u0005\u0004b\u000eU\u0007\u0019ABr\u0003)\u0019Xm]:j_:|\u0005\u000f\u001e\t\u0004\u0005\u000e3\u0002\u0002CBt\u0003\u0003#\ta!;\u0002\u001fMDw.\u001e7e\r&dG/\u001a:PkR$B!a\u0014\u0004l\"91Q^Bs\u0001\u0004a\u0014\u0001\u00039bi\"t\u0015-\\3\t\u0015\rE\u0018\u0011QI\u0001\n\u0003\u0019\u00190A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007kT3!TA\u0000\u0001")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean shouldFilterOut(String string) {
        return InMemoryFileIndex$.MODULE$.shouldFilterOut(string);
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            this.cachedPartitionSpec_$eq(this.inferPartitioning());
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f), LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        void var2_2;
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            ArrayBuffer arrayBuffer;
            Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles((Path)path);
            if (option instanceof Some) {
                Some some = (Some)option;
                FileStatus[] files = (FileStatus[])some.value();
                HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
                arrayBuffer = (AbstractIterable)output.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
            } else if (None$.MODULE$.equals(option)) {
                arrayBuffer = pathsToFetch.$plus$eq(path);
            } else {
                throw new MatchError(option);
            }
            return Unit$.MODULE$;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch, this.hadoopConf(), filter, this.sparkSession);
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            return linkedHashSet;
        });
        return var2_2;
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }

    public static class SerializableBlockLocation
    implements Product,
    scala.Serializable {
        private final String[] names;
        private final String[] hosts;
        private final long offset;
        private final long length;

        public String[] names() {
            return this.names;
        }

        public String[] hosts() {
            return this.hosts;
        }

        public long offset() {
            return this.offset;
        }

        public long length() {
            return this.length;
        }

        public SerializableBlockLocation copy(String[] names, String[] hosts, long offset, long length) {
            return new SerializableBlockLocation(names, hosts, offset, length);
        }

        public String[] copy$default$1() {
            return this.names();
        }

        public String[] copy$default$2() {
            return this.hosts();
        }

        public long copy$default$3() {
            return this.offset();
        }

        public long copy$default$4() {
            return this.length();
        }

        public String productPrefix() {
            return "SerializableBlockLocation";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.names();
                    break;
                }
                case 1: {
                    object = this.hosts();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.offset());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableBlockLocation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.names()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hosts()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableBlockLocation)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableBlockLocation serializableBlockLocation = (SerializableBlockLocation)x$1;
            if (this.names() != serializableBlockLocation.names()) return false;
            if (this.hosts() != serializableBlockLocation.hosts()) return false;
            if (this.offset() != serializableBlockLocation.offset()) return false;
            if (this.length() != serializableBlockLocation.length()) return false;
            if (!serializableBlockLocation.canEqual(this)) return false;
            return true;
        }

        public SerializableBlockLocation(String[] names, String[] hosts, long offset, long length) {
            this.names = names;
            this.hosts = hosts;
            this.offset = offset;
            this.length = length;
            Product.$init$((Product)this);
        }
    }

    public static class SerializableFileStatus
    implements Product,
    scala.Serializable {
        private final String path;
        private final long length;
        private final boolean isDir;
        private final short blockReplication;
        private final long blockSize;
        private final long modificationTime;
        private final long accessTime;
        private final SerializableBlockLocation[] blockLocations;

        public String path() {
            return this.path;
        }

        public long length() {
            return this.length;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public short blockReplication() {
            return this.blockReplication;
        }

        public long blockSize() {
            return this.blockSize;
        }

        public long modificationTime() {
            return this.modificationTime;
        }

        public long accessTime() {
            return this.accessTime;
        }

        public SerializableBlockLocation[] blockLocations() {
            return this.blockLocations;
        }

        public SerializableFileStatus copy(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            return new SerializableFileStatus(path, length, isDir, blockReplication, blockSize, modificationTime, accessTime, blockLocations);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.length();
        }

        public boolean copy$default$3() {
            return this.isDir();
        }

        public short copy$default$4() {
            return this.blockReplication();
        }

        public long copy$default$5() {
            return this.blockSize();
        }

        public long copy$default$6() {
            return this.modificationTime();
        }

        public long copy$default$7() {
            return this.accessTime();
        }

        public SerializableBlockLocation[] copy$default$8() {
            return this.blockLocations();
        }

        public String productPrefix() {
            return "SerializableFileStatus";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isDir());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToShort((short)this.blockReplication());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToLong((long)this.blockSize());
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToLong((long)this.modificationTime());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToLong((long)this.accessTime());
                    break;
                }
                case 7: {
                    object = this.blockLocations();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableFileStatus;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            n = Statics.mix((int)n, (int)(this.isDir() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.blockReplication());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.blockSize()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.modificationTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.accessTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.blockLocations()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableFileStatus)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableFileStatus serializableFileStatus = (SerializableFileStatus)x$1;
            String string = this.path();
            String string2 = serializableFileStatus.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.length() != serializableFileStatus.length()) return false;
            if (this.isDir() != serializableFileStatus.isDir()) return false;
            if (this.blockReplication() != serializableFileStatus.blockReplication()) return false;
            if (this.blockSize() != serializableFileStatus.blockSize()) return false;
            if (this.modificationTime() != serializableFileStatus.modificationTime()) return false;
            if (this.accessTime() != serializableFileStatus.accessTime()) return false;
            if (this.blockLocations() != serializableFileStatus.blockLocations()) return false;
            if (!serializableFileStatus.canEqual(this)) return false;
            return true;
        }

        public SerializableFileStatus(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            this.path = path;
            this.length = length;
            this.isDir = isDir;
            this.blockReplication = blockReplication;
            this.blockSize = blockSize;
            this.modificationTime = modificationTime;
            this.accessTime = accessTime;
            this.blockLocations = blockLocations;
            Product.$init$((Product)this);
        }
    }
}

