/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u0001>\u0011q\u0002T8bI\u0012\u000bG/Y\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\tqaY8n[\u0006tGM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001AQb\u0004\n\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0016-\u0005)\u0001\u000f\\1og*\u0011qCB\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011D\u0005\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0002;bE2,W#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\na\u0001^1cY\u0016\u0004\u0003\u0002C\u0019\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002\tA\fG\u000f[\u000b\u0002gA\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\u0011\u000e\u0003]R!\u0001\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0004%\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e!\u0011!y\u0004A!E!\u0002\u0013\u0019\u0014!\u00029bi\"\u0004\u0003\u0002C!\u0001\u0005+\u0007I\u0011\u0001\"\u0002\u000f%\u001cHj\\2bYV\t1\t\u0005\u0002 \t&\u0011Q\t\t\u0002\b\u0005>|G.Z1o\u0011!9\u0005A!E!\u0002\u0013\u0019\u0015\u0001C5t\u0019>\u001c\u0017\r\u001c\u0011\t\u0011%\u0003!Q3A\u0005\u0002\t\u000b1\"[:Pm\u0016\u0014xO]5uK\"A1\n\u0001B\tB\u0003%1)\u0001\u0007jg>3XM]<sSR,\u0007\u0005\u0003\u0005N\u0001\tU\r\u0011\"\u0001O\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001P!\ry\u0002KU\u0005\u0003#\u0002\u0012aa\u00149uS>t\u0007CA*e\u001d\t!\u0016M\u0004\u0002V?:\u0011aK\u0018\b\u0003/vs!\u0001\u0017/\u000f\u0005e[fB\u0001\u001c[\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003AZ\tqaY1uC2|w-\u0003\u0002cG\u0006a1)\u0019;bY><G+\u001f9fg*\u0011\u0001MF\u0005\u0003K\u001a\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011!m\u0019\u0005\tQ\u0002\u0011\t\u0012)A\u0005\u001f\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000b)\u0004A\u0011A6\u0002\rqJg.\u001b;?)\u0019aWN\\8qcB\u00111\u0004\u0001\u0005\u0006Q%\u0004\rA\u000b\u0005\u0006c%\u0004\ra\r\u0005\u0006\u0003&\u0004\ra\u0011\u0005\u0006\u0013&\u0004\ra\u0011\u0005\u0006\u001b&\u0004\ra\u0014\u0005\u0006g\u0002!\t\u0005^\u0001\u0004eVtGcA;\u0002\u0006A\u0019ao\u001f@\u000f\u0005]LhB\u0001\u001cy\u0013\u0005\t\u0013B\u0001>!\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001`?\u0003\u0007M+\u0017O\u0003\u0002{AA\u0019q0!\u0001\u000e\u0003\u0019I1!a\u0001\u0007\u0005\r\u0011vn\u001e\u0005\b\u0003\u000f\u0011\b\u0019AA\u0005\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\ry\u00181B\u0005\u0004\u0003\u001b1!\u0001D*qCJ\\7+Z:tS>t\u0007\"CA\t\u0001\u0005\u0005I\u0011AA\n\u0003\u0011\u0019w\u000e]=\u0015\u00171\f)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u0005\tQ\u0005=\u0001\u0013!a\u0001U!A\u0011'a\u0004\u0011\u0002\u0003\u00071\u0007\u0003\u0005B\u0003\u001f\u0001\n\u00111\u0001D\u0011!I\u0015q\u0002I\u0001\u0002\u0004\u0019\u0005\u0002C'\u0002\u0010A\u0005\t\u0019A(\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KQ3AKA\u0014W\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001aA\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u001e\u0001E\u0005I\u0011AA\u001f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0010+\u0007M\n9\u0003C\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002F\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA$U\r\u0019\u0015q\u0005\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003\u000b\nabY8qs\u0012\"WMZ1vYR$C\u0007C\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002R\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA*U\ry\u0015q\u0005\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\nA\u0001\\1oO*\u0011\u0011QM\u0001\u0005U\u00064\u0018-C\u0002=\u0003?B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0004cA\u0010\u0002r%\u0019\u00111\u000f\u0011\u0003\u0007%sG\u000fC\u0005\u0002x\u0001\t\t\u0011\"\u0001\u0002z\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA>\u0003\u0003\u00032aHA?\u0013\r\ty\b\t\u0002\u0004\u0003:L\bBCAB\u0003k\n\t\u00111\u0001\u0002p\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005\u001d\u0005!!A\u0005B\u0005%\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0005CBAG\u0003'\u000bY(\u0004\u0002\u0002\u0010*\u0019\u0011\u0011\u0013\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0016\u0006=%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005e\u0005!!A\u0005\u0002\u0005m\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\r\u000bi\n\u0003\u0006\u0002\u0004\u0006]\u0015\u0011!a\u0001\u0003wB\u0011\"!)\u0001\u0003\u0003%\t%a)\u0002\r\u0015\fX/\u00197t)\r\u0019\u0015Q\u0015\u0005\u000b\u0003\u0007\u000by*!AA\u0002\u0005mtaBAU\u0005!\u0005\u00111V\u0001\u0010\u0019>\fG\rR1uC\u000e{W.\\1oIB\u00191$!,\u0007\r\u0005\u0011\u0001\u0012AAX'\u0015\ti+!-%!\ry\u00121W\u0005\u0004\u0003k\u0003#AB!osJ+g\rC\u0004k\u0003[#\t!!/\u0015\u0005\u0005-\u0006\"CA_\u0003[#\tABA`\u00035i\u0017m[3Rk\u0006d\u0017NZ5fIRA\u0011\u0011YAi\u0003C\f)\u000f\u0005\u0003\u0002D\u00065WBAAc\u0015\u0011\t9-!3\u0002\u0005\u0019\u001c(bAAf\u0015\u00051\u0001.\u00193p_BLA!a4\u0002F\n!\u0001+\u0019;i\u0011!\t\u0019.a/A\u0002\u0005U\u0017A\u00033fM\u0006,H\u000e^+sSB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006\r\u0014a\u00018fi&!\u0011q\\Am\u0005\r)&+\u0013\u0005\t\u0003G\fY\f1\u0001\u0002B\u0006Qqo\u001c:lS:<G)\u001b:\t\u000fE\nY\f1\u0001\u0002B\"Q\u0011\u0011^AW\u0003\u0003%\t)a;\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00171\fi/a<\u0002r\u0006M\u0018Q\u001f\u0005\u0007Q\u0005\u001d\b\u0019\u0001\u0016\t\rE\n9\u000f1\u00014\u0011\u0019\t\u0015q\u001da\u0001\u0007\"1\u0011*a:A\u0002\rCa!TAt\u0001\u0004y\u0005BCA}\u0003[\u000b\t\u0011\"!\u0002|\u00069QO\\1qa2LH\u0003BA\u007f\u0005\u000b\u0001Ba\b)\u0002\u0000BAqD!\u0001+g\r\u001bu*C\u0002\u0003\u0004\u0001\u0012a\u0001V;qY\u0016,\u0004\"\u0003B\u0004\u0003o\f\t\u00111\u0001m\u0003\rAH\u0005\r\u0005\u000b\u0005\u0017\ti+!A\u0005\n\t5\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0004\u0011\t\u0005u#\u0011C\u0005\u0005\u0005'\tyF\u0001\u0004PE*,7\r\u001e")
public class LoadDataCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final String path;
    private final boolean isLocal;
    private final boolean isOverwrite;
    private final Option<Map<String, String>> partition;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>> unapply(LoadDataCommand loadDataCommand) {
        return LoadDataCommand$.MODULE$.unapply(loadDataCommand);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        LoadDataCommand loadDataCommand = this;
        synchronized (loadDataCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String path() {
        return this.path;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isOverwrite() {
        return this.isOverwrite;
    }

    public Option<Map<String, String>> partition() {
        return this.partition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Path path;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable targetTable = catalog.getTableMetadata(this.table());
        String tableIdentwithDB = targetTable.identifier().quotedString();
        CatalogTableType catalogTableType = targetTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringBuilder(44).append("Target table in LOAD DATA cannot be a view: ").append(tableIdentwithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(targetTable)) {
            throw new AnalysisException(new StringBuilder(50).append("LOAD DATA is not supported for datasource tables: ").append(tableIdentwithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (targetTable.partitionColumnNames().nonEmpty()) {
            if (this.partition().isEmpty()) {
                throw new AnalysisException(new StringBuilder(73).append("LOAD DATA target table ").append(tableIdentwithDB).append(" is partitioned, ").append("but no partition spec is provided").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (targetTable.partitionColumnNames().size() != ((TraversableOnce)this.partition().get()).size()) {
                throw new AnalysisException(new StringBuilder(92).append("LOAD DATA target table ").append(tableIdentwithDB).append(" is partitioned, ").append(new StringBuilder(52).append("but number of columns in provided partition spec (").append(((TraversableOnce)this.partition().get()).size()).append(") ").toString()).append("do not match number of partitioned columns in table ").append(new StringBuilder(2).append("(").append(targetTable.partitionColumnNames().size()).append(")").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            ((MapLike)this.partition().get()).keys().foreach((Function1 & Serializable & scala.Serializable)colName -> {
                LoadDataCommand.$anonfun$run$6(targetTable, tableIdentwithDB, colName);
                return BoxedUnit.UNIT;
            });
        } else if (this.partition().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(78).append("LOAD DATA target table ").append(tableIdentwithDB).append(" is not ").append("partitioned, but a partition spec was provided.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isLocal()) {
            FileContext localFS = FileContext.getLocalFSFileContext();
            path = LoadDataCommand$.MODULE$.makeQualified(FsConstants.LOCAL_FS_URI, localFS.getWorkingDirectory(), new Path(this.path()));
        } else {
            Path loadPath = new Path(this.path());
            String defaultFSConf = sparkSession.sessionState().newHadoopConf().get("fs.defaultFS");
            URI defaultFS = defaultFSConf == null ? new URI("") : new URI(defaultFSConf);
            Path uriPath = new Path(new StringBuilder(7).append("/user/").append(System.getProperty("user.name")).append("/").toString());
            path = LoadDataCommand$.MODULE$.makeQualified(defaultFS, uriPath, loadPath);
        }
        Path loadPath = path;
        FileSystem fs = loadPath.getFileSystem(sparkSession.sessionState().newHadoopConf());
        try {
            FileStatus[] fileStatus = fs.globStatus(loadPath);
            if (fileStatus == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).isEmpty()) {
                throw new AnalysisException(new StringBuilder(37).append("LOAD DATA input path does not exist: ").append(this.path()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        catch (IllegalArgumentException e) {
            this.log().warn(new StringBuilder(42).append("Exception while validating the load path ").append(this.path()).append(" ").toString(), (Throwable)e);
            throw new AnalysisException(new StringBuilder(37).append("LOAD DATA input path does not exist: ").append(this.path()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partition().nonEmpty()) {
            catalog.loadPartition(targetTable.identifier(), loadPath.toString(), (Map)this.partition().get(), this.isOverwrite(), true, this.isLocal());
        } else {
            catalog.loadTable(targetTable.identifier(), loadPath.toString(), this.isOverwrite(), this.isLocal());
        }
        catalog.refreshTable(targetTable.identifier());
        CommandUtils$.MODULE$.updateTableStats(sparkSession, targetTable);
        return (Seq)Seq$.MODULE$.empty();
    }

    public LoadDataCommand copy(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        return new LoadDataCommand(table, path, isLocal, isOverwrite, partition);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.isLocal();
    }

    public boolean copy$default$4() {
        return this.isOverwrite();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partition();
    }

    public String productPrefix() {
        return "LoadDataCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isLocal());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isOverwrite());
                break;
            }
            case 4: {
                object = this.partition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LoadDataCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LoadDataCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        LoadDataCommand loadDataCommand = (LoadDataCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = loadDataCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.path();
        String string2 = loadDataCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isLocal() != loadDataCommand.isLocal()) return false;
        if (this.isOverwrite() != loadDataCommand.isOverwrite()) return false;
        Option<Map<String, String>> option = this.partition();
        Option<Map<String, String>> option2 = loadDataCommand.partition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!loadDataCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$6(CatalogTable targetTable$1, String tableIdentwithDB$1, String colName) {
        if (!targetTable$1.partitionColumnNames().contains((Object)colName)) {
            throw new AnalysisException(new StringBuilder(117).append("LOAD DATA target table ").append(tableIdentwithDB$1).append(" is partitioned, ").append("but the specified partition spec refers to a column that is not partitioned: ").append(new StringBuilder(2).append("'").append(colName).append("'").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public LoadDataCommand(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        this.table = table;
        this.path = path;
        this.isLocal = isLocal;
        this.isOverwrite = isOverwrite;
        this.partition = partition;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

