/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u0001>\u0011Q$\u00117uKJ$\u0016M\u00197f\u0007\"\fgnZ3D_2,XN\\\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\tqaY8n[\u0006tGM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001AQb\u0004\n\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0016-\u0005)\u0001\u000f\\1og*\u0011qCB\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011D\u0005\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0003;bE2,g*Y7f+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003)\u0019w\u000e\\;n]:\u000bW.Z\u000b\u0002gA\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\u0011\u000e\u0003]R!\u0001\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0004%\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e!\u0011!y\u0004A!E!\u0002\u0013\u0019\u0014aC2pYVlgNT1nK\u0002B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tAQ\u0001\n]\u0016<8i\u001c7v[:,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u001a\tQ\u0001^=qKNL!\u0001S#\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u0007\u0006Qa.Z<D_2,XN\u001c\u0011\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\u0011qu\nU)\u0011\u0005m\u0001\u0001\"\u0002\u0015L\u0001\u0004Q\u0003\"B\u0019L\u0001\u0004\u0019\u0004\"B!L\u0001\u0004\u0019\u0005\"B*\u0001\t\u0003\"\u0016a\u0001:v]R\u0011QK\u0019\t\u0004-nsfBA,Z\u001d\t1\u0004,C\u0001\"\u0013\tQ\u0006%A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&aA*fc*\u0011!\f\t\t\u0003?\u0002l\u0011AB\u0005\u0003C\u001a\u00111AU8x\u0011\u0015\u0019'\u000b1\u0001e\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tyV-\u0003\u0002g\r\ta1\u000b]1sWN+7o]5p]\")\u0001\u000e\u0001C\u0005S\u0006\u0001b-\u001b8e\u0007>dW/\u001c8Cs:\u000bW.\u001a\u000b\u0005\u0007*|\u0017\u000fC\u0003lO\u0002\u0007A.\u0001\u0004tG\",W.\u0019\t\u0003\t6L!A\\#\u0003\u0015M#(/^2u)f\u0004X\rC\u0003qO\u0002\u00071'\u0001\u0003oC6,\u0007\"\u0002:h\u0001\u0004\u0019\u0018\u0001\u0003:fg>dg/\u001a:\u0011\u0007Q\fIAD\u0002v\u0003\u000bq1A^A\u0001\u001d\t9xP\u0004\u0002y}:\u0011\u00110 \b\u0003urt!AN>\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t9b!C\u0002\u0002\u0004Y\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u00045\u0006\u001d!bAA\u0002-%!\u00111BA\u0007\u0005!\u0011Vm]8mm\u0016\u0014(b\u0001.\u0002\b!9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0011AC1eI\u000e{W.\\3oiR)1)!\u0006\u0002\u001a!9\u0011qCA\b\u0001\u0004\u0019\u0015AB2pYVlg\u000e\u0003\u0005\u0002\u001c\u0005=\u0001\u0019AA\u000f\u0003\u001d\u0019w.\\7f]R\u0004BaHA\u0010g%\u0019\u0011\u0011\u0005\u0011\u0003\r=\u0003H/[8o\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\t1bY8mk6tW)];bYRA\u0011\u0011FA\u0018\u0003g\t9\u0004E\u0002 \u0003WI1!!\f!\u0005\u001d\u0011un\u001c7fC:Dq!!\r\u0002$\u0001\u00071)A\u0003gS\u0016dG\rC\u0004\u00026\u0005\r\u0002\u0019A\"\u0002\u000b=$\b.\u001a:\t\rI\f\u0019\u00031\u0001t\u0011%\tY\u0004AA\u0001\n\u0003\ti$\u0001\u0003d_BLHc\u0002(\u0002@\u0005\u0005\u00131\t\u0005\tQ\u0005e\u0002\u0013!a\u0001U!A\u0011'!\u000f\u0011\u0002\u0003\u00071\u0007\u0003\u0005B\u0003s\u0001\n\u00111\u0001D\u0011%\t9\u0005AI\u0001\n\u0003\tI%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-#f\u0001\u0016\u0002N-\u0012\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003%)hn\u00195fG.,GMC\u0002\u0002Z\u0001\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti&a\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002d\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA3U\r\u0019\u0014Q\n\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003W\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002n)\u001a1)!\u0014\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014\u0001\u00027b]\u001eT!!a \u0002\t)\fg/Y\u0005\u0004y\u0005e\u0004\"CAC\u0001\u0005\u0005I\u0011AAD\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\tE\u0002 \u0003\u0017K1!!$!\u0005\rIe\u000e\u001e\u0005\n\u0003#\u0003\u0011\u0011!C\u0001\u0003'\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0016\u0006m\u0005cA\u0010\u0002\u0018&\u0019\u0011\u0011\u0014\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002\u001e\u0006=\u0015\u0011!a\u0001\u0003\u0013\u000b1\u0001\u001f\u00132\u0011%\t\t\u000bAA\u0001\n\u0003\n\u0019+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u000b\u0005\u0004\u0002(\u00065\u0016QS\u0007\u0003\u0003SS1!a+!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000bIK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\fAA\u0001\n\u0003\t),\u0001\u0005dC:,\u0015/^1m)\u0011\tI#a.\t\u0015\u0005u\u0015\u0011WA\u0001\u0002\u0004\t)\nC\u0005\u0002<\u0002\t\t\u0011\"\u0011\u0002>\u00061Q-];bYN$B!!\u000b\u0002@\"Q\u0011QTA]\u0003\u0003\u0005\r!!&\b\u0013\u0005\r'!!A\t\u0002\u0005\u0015\u0017!H!mi\u0016\u0014H+\u00192mK\u000eC\u0017M\\4f\u0007>dW/\u001c8D_6l\u0017M\u001c3\u0011\u0007m\t9M\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAe'\u0015\t9-a3%!!\ti-a5+g\rsUBAAh\u0015\r\t\t\u000eI\u0001\beVtG/[7f\u0013\u0011\t).a4\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004M\u0003\u000f$\t!!7\u0015\u0005\u0005\u0015\u0007BCAo\u0003\u000f\f\t\u0011\"\u0012\u0002`\u0006AAo\\*ue&tw\r\u0006\u0002\u0002v!Q\u00111]Ad\u0003\u0003%\t)!:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f9\u000b9/!;\u0002l\"1\u0001&!9A\u0002)Ba!MAq\u0001\u0004\u0019\u0004BB!\u0002b\u0002\u00071\t\u0003\u0006\u0002p\u0006\u001d\u0017\u0011!CA\u0003c\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002t\u0006m\b#B\u0010\u0002 \u0005U\bCB\u0010\u0002x*\u001a4)C\u0002\u0002z\u0002\u0012a\u0001V;qY\u0016\u001c\u0004\"CA\u007f\u0003[\f\t\u00111\u0001O\u0003\rAH\u0005\r\u0005\u000b\u0005\u0003\t9-!A\u0005\n\t\r\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0002\u0011\t\u0005]$qA\u0005\u0005\u0005\u0013\tIH\u0001\u0004PE*,7\r\u001e")
public class AlterTableChangeColumnCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterTableChangeColumnCommand alterTableChangeColumnCommand) {
        return AlterTableChangeColumnCommand$.MODULE$.unapply(alterTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterTableChangeColumnCommand> tupled() {
        return AlterTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterTableChangeColumnCommand>>> curried() {
        return AlterTableChangeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = this;
        synchronized (alterTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        StructField originColumn = this.findColumnByName(table.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver);
        if (!this.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw new AnalysisException(new StringBuilder(63).append("ALTER TABLE CHANGE COLUMN is not supported for changing column ").append(new StringBuilder(19).append("'").append(originColumn.name()).append("' with type '").append(originColumn.dataType()).append("' to ").toString()).append(new StringBuilder(15).append("'").append(this.newColumn().name()).append("' with type '").append(this.newColumn().dataType()).append("'").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        StructField[] newDataSchema = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.dataSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.addComment((StructField)field, (Option<String>)this.newColumn().getComment()) : field;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        catalog.alterTableDataSchema(this.tableName(), new StructType(newDataSchema));
        return (Seq)Seq$.MODULE$.empty();
    }

    private StructField findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver) {
        return (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).collectFirst((PartialFunction)new scala.Serializable(null, name, resolver){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Function2 resolver$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1)) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
                return bl;
            }
            {
                this.name$1 = name$1;
                this.resolver$1 = resolver$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException(new StringBuilder(46).append("Can't find column `").append(name).append("` given table data columns ").append(String.valueOf(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).mkString("[`", "`, `", "`]"))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
    }

    private StructField addComment(StructField column, Option<String> comment) {
        return (StructField)comment.map((Function1 & Serializable & scala.Serializable)x$7 -> column.withComment(x$7)).getOrElse((Function0 & Serializable & scala.Serializable)() -> column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public AlterTableChangeColumnCommand copy(TableIdentifier tableName, String columnName, StructField newColumn) {
        return new AlterTableChangeColumnCommand(tableName, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableChangeColumnCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableChangeColumnCommand(TableIdentifier tableName, String columnName, StructField newColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

