/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.execution.aggregate.HashMapGenerator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\tA\"k\\<CCN,G\rS1tQ6\u000b\u0007oR3oKJ\fGo\u001c:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001\u0003S1tQ6\u000b\u0007oR3oKJ\fGo\u001c:\t\u0011U\u0001!\u0011!Q\u0001\nY\t1a\u0019;y!\t9b$D\u0001\u0019\u0015\tI\"$A\u0004d_\u0012,w-\u001a8\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0004\u0002\u0011\r\fG/\u00197zgRL!a\b\r\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u000bbO\u001e\u0014XmZ1uK\u0016C\bO]3tg&|gn\u001d\t\u0004G5\u0002dB\u0001\u0013+\u001d\t)\u0003&D\u0001'\u0015\t9c\"\u0001\u0004=e>|GOP\u0005\u0002S\u0005)1oY1mC&\u00111\u0006L\u0001\ba\u0006\u001c7.Y4f\u0015\u0005I\u0013B\u0001\u00180\u0005\r\u0019V-\u001d\u0006\u0003W1\u0002\"!M\u001a\u000e\u0003IR!a\u0001\u000e\n\u0005Q\u0012$aE!hOJ,w-\u0019;f\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002%\u001d,g.\u001a:bi\u0016$7\t\\1tg:\u000bW.\u001a\t\u0003qqr!!\u000f\u001e\u0011\u0005\u0015b\u0013BA\u001e-\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mb\u0003\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002#\u001d\u0014x.\u001e9j]\u001e\\U-_*dQ\u0016l\u0017\r\u0005\u0002C\u000b6\t1I\u0003\u0002E\r\u0005)A/\u001f9fg&\u0011ai\u0011\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u0019\t,hMZ3s'\u000eDW-\\1\t\u0011)\u0003!\u0011!Q\u0001\n-\u000baBY5u\u001b\u0006D8)\u00199bG&$\u0018\u0010\u0005\u0002M\u001b6\tA&\u0003\u0002OY\t\u0019\u0011J\u001c;\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\u001d\u00116\u000bV+W/b\u0003\"!\u0005\u0001\t\u000bUy\u0005\u0019\u0001\f\t\u000b\u0005z\u0005\u0019\u0001\u0012\t\u000bYz\u0005\u0019A\u001c\t\u000b\u0001{\u0005\u0019A!\t\u000b!{\u0005\u0019A!\t\u000b){\u0005\u0019A&\t\u000bi\u0003A\u0011K.\u00025%t\u0017\u000e^5bY&TX-Q4he\u0016<\u0017\r^3ICNDW*\u00199\u0015\u0003]BQ!\u0018\u0001\u0005\u0012m\u000babZ3oKJ\fG/Z#rk\u0006d7\u000fC\u0003`\u0001\u0011E1,\u0001\u000bhK:,'/\u0019;f\r&tGm\u0014:J]N,'\u000f\u001e\u0005\u0006C\u0002!\tbW\u0001\u0014O\u0016tWM]1uKJ{w/\u0013;fe\u0006$xN\u001d")
public class RowBasedHashMapGenerator
extends HashMapGenerator {
    private final CodegenContext ctx;
    private final String generatedClassName;
    private final StructType groupingKeySchema;
    private final StructType bufferSchema;
    private final int bitMaxCapacity;

    @Override
    public String initializeAggregateHashMap() {
        String keySchema = this.ctx.addReferenceObj("keySchemaTerm", (Object)this.groupingKeySchema, this.ctx.addReferenceObj$default$3());
        String valueSchema = this.ctx.addReferenceObj("valueSchemaTerm", (Object)this.bufferSchema, this.ctx.addReferenceObj$default$3());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1242).append("\n       |  private org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch batch;\n       |  private int[] buckets;\n       |  private int capacity = 1 << ").append(this.bitMaxCapacity).append(";\n       |  private double loadFactor = 0.5;\n       |  private int numBuckets = (int) (capacity / loadFactor);\n       |  private int maxSteps = 2;\n       |  private int numRows = 0;\n       |  private Object emptyVBase;\n       |  private long emptyVOff;\n       |  private int emptyVLen;\n       |  private boolean isBatchFull = false;\n       |\n       |\n       |  public ").append(this.generatedClassName).append("(\n       |    org.apache.spark.memory.TaskMemoryManager taskMemoryManager,\n       |    InternalRow emptyAggregationBuffer) {\n       |    batch = org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch\n       |      .allocate(").append(keySchema).append(", ").append(valueSchema).append(", taskMemoryManager, capacity);\n       |\n       |    final UnsafeProjection valueProjection = UnsafeProjection.create(").append(valueSchema).append(");\n       |    final byte[] emptyBuffer = valueProjection.apply(emptyAggregationBuffer).getBytes();\n       |\n       |    emptyVBase = emptyBuffer;\n       |    emptyVOff = Platform.BYTE_ARRAY_OFFSET;\n       |    emptyVLen = emptyBuffer.length;\n       |\n       |    buckets = new int[numBuckets];\n       |    java.util.Arrays.fill(buckets, -1);\n       |  }\n     ").toString())).stripMargin();
    }

    @Override
    public String generateEquals() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n       |private boolean equals(int idx, ").append(this.groupingKeySignature()).append(") {\n       |  UnsafeRow row = batch.getKeyRow(buckets[idx]);\n       |  return ").append(this.genEqualsForKeys$1(this.groupingKeys())).append(";\n       |}\n     ").toString())).stripMargin();
    }

    @Override
    public String generateFindOrInsert() {
        int numVarLenFields = ((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)RowBasedHashMapGenerator.$anonfun$generateFindOrInsert$2(x0$2)));
        String createUnsafeRowForKey = ((TraversableOnce)((TraversableLike)this.groupingKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            String string;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            HashMapGenerator.Buffer key = (HashMapGenerator.Buffer)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            if (key == null) throw new MatchError((Object)tuple2);
            HashMapGenerator.Buffer buffer = key;
            int n = ordinal;
            DataType dataType = buffer.dataType();
            if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                string = new StringBuilder(27).append("agg_rowWriter.write(").append(n).append(", ").append(buffer.name()).append(", ").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString();
                return string;
            } else {
                if (dataType == null) throw new MatchError((Object)dataType);
                DataType dataType2 = dataType;
                if (!(dataType2 instanceof StringType) && !CodeGenerator$.MODULE$.isPrimitiveType(dataType2)) {
                    throw new IllegalArgumentException(new StringBuilder(43).append("cannot generate code for unsupported type: ").append(dataType2).toString());
                }
                string = new StringBuilder(23).append("agg_rowWriter.write(").append(n).append(", ").append(buffer.name()).append(")").toString();
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(";\n");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1811).append("\n       |public org.apache.spark.sql.catalyst.expressions.UnsafeRow findOrInsert(").append(this.groupingKeySignature()).append(") {\n       |  long h = hash(").append(((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n       |  int step = 0;\n       |  int idx = (int) h & (numBuckets - 1);\n       |  while (step < maxSteps) {\n       |    // Return bucket index if it's either an empty slot or already contains the key\n       |    if (buckets[idx] == -1) {\n       |      if (numRows < capacity && !isBatchFull) {\n       |        // creating the unsafe for new entry\n       |        org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter agg_rowWriter\n       |          = new org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter(\n       |              ").append(this.groupingKeySchema.length()).append(", ").append(numVarLenFields * 32).append(");\n       |        agg_rowWriter.reset(); //TODO: investigate if reset or zeroout are actually needed\n       |        agg_rowWriter.zeroOutNullBytes();\n       |        ").append(createUnsafeRowForKey).append(";\n       |        org.apache.spark.sql.catalyst.expressions.UnsafeRow agg_result\n       |          = agg_rowWriter.getRow();\n       |        Object kbase = agg_result.getBaseObject();\n       |        long koff = agg_result.getBaseOffset();\n       |        int klen = agg_result.getSizeInBytes();\n       |\n       |        UnsafeRow vRow\n       |            = batch.appendRow(kbase, koff, klen, emptyVBase, emptyVOff, emptyVLen);\n       |        if (vRow == null) {\n       |          isBatchFull = true;\n       |        } else {\n       |          buckets[idx] = numRows++;\n       |        }\n       |        return vRow;\n       |      } else {\n       |        // No more space\n       |        return null;\n       |      }\n       |    } else if (equals(idx, ").append(((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")) {\n       |      return batch.getValueRow(buckets[idx]);\n       |    }\n       |    idx = (idx + 1) & (numBuckets - 1);\n       |    step++;\n       |  }\n       |  // Didn't find it\n       |  return null;\n       |}\n     ").toString())).stripMargin();
    }

    @Override
    public String generateRowIterator() {
        return new StringOps(Predef$.MODULE$.augmentString("\n       |public org.apache.spark.unsafe.KVIterator<UnsafeRow, UnsafeRow> rowIterator() {\n       |  return batch.rowIterator();\n       |}\n     ")).stripMargin();
    }

    private final String genEqualsForKeys$1(Seq groupingKeys) {
        return ((TraversableOnce)((TraversableLike)groupingKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int ordinal;
            HashMapGenerator.Buffer key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    key = (HashMapGenerator.Buffer)tuple2._1();
                    ordinal = tuple2._2$mcI$sp();
                    if (key != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            HashMapGenerator.Buffer buffer = key;
            int n = ordinal;
            String string = new StringBuilder(2).append("(").append($this.ctx.genEqual(buffer.dataType(), CodeGenerator$.MODULE$.getValue("row", buffer.dataType(), ((Object)BoxesRunTime.boxToInteger((int)n)).toString()), buffer.name())).append(")").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(" && ");
    }

    public static final /* synthetic */ boolean $anonfun$generateFindOrInsert$2(DataType x0$2) {
        DataType dataType = x0$2;
        boolean bl = !UnsafeRow.isFixedLength((DataType)dataType);
        return bl;
    }

    public RowBasedHashMapGenerator(CodegenContext ctx, Seq<AggregateExpression> aggregateExpressions, String generatedClassName, StructType groupingKeySchema, StructType bufferSchema, int bitMaxCapacity) {
        this.ctx = ctx;
        this.generatedClassName = generatedClassName;
        this.groupingKeySchema = groupingKeySchema;
        this.bufferSchema = bufferSchema;
        this.bitMaxCapacity = bitMaxCapacity;
        super(ctx, aggregateExpressions, generatedClassName, groupingKeySchema, bufferSchema);
    }
}

