/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.MalformedInputException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001=\u0011QBS1dWN|g\u000eU1sg\u0016\u0014(BA\u0002\u0005\u0003\u0011Q7o\u001c8\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00037a\u0011q\u0001T8hO&tw\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0019\u00198\r[3nCB\u0011qDI\u0007\u0002A)\u0011\u0011EB\u0001\u0006if\u0004Xm]\u0005\u0003G\u0001\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\tK\u0001\u0011)\u0019!C\u0001M\u00059q\u000e\u001d;j_:\u001cX#A\u0014\u0011\u0005!JS\"\u0001\u0002\n\u0005)\u0012!a\u0003&T\u001f:{\u0005\u000f^5p]ND\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006IaJ\u0001\t_B$\u0018n\u001c8tA!)a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"2\u0001M\u00193!\tA\u0003\u0001C\u0003\u001e[\u0001\u0007a\u0004C\u0003&[\u0001\u0007q%\u0002\u00035\u0001\u0011)$A\u0004,bYV,7i\u001c8wKJ$XM\u001d\t\u0005#YB\u0004#\u0003\u00028%\tIa)\u001e8di&|g.\r\t\u0003s\tk\u0011A\u000f\u0006\u0003wq\nAaY8sK*\u0011QHP\u0001\bU\u0006\u001c7n]8o\u0015\ty\u0004)A\u0005gCN$XM\u001d=nY*\t\u0011)A\u0002d_6L!a\u0011\u001e\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u001bI|w\u000e^\"p]Z,'\u000f^3s+\u00059\u0005\u0003B\t7q!\u00032!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003!J\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A\u0013\u0002CA+W\u001b\u0005!\u0011BA,\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\re\u0003\u0001\u0015!\u0003H\u00039\u0011xn\u001c;D_:4XM\u001d;fe\u0002Bqa\u0017\u0001C\u0002\u0013%A,A\u0004gC\u000e$xN]=\u0016\u0003u\u0003\"!\u000f0\n\u0005}S$a\u0003&t_:4\u0015m\u0019;pefDa!\u0019\u0001!\u0002\u0013i\u0016\u0001\u00034bGR|'/\u001f\u0011\t\u000b\r\u0004A\u0011\u00023\u0002#5\f7.\u001a*p_R\u001cuN\u001c<feR,'\u000f\u0006\u0002HK\")aM\u0019a\u0001=\u0005\u0011A\r\u001e\u0005\u0006Q\u0002!I![\u0001\u0018[\u0006\\Wm\u0015;sk\u000e$(k\\8u\u0007>tg/\u001a:uKJ$\"a\u00126\t\u000b-<\u0007\u0019\u00017\u0002\u0005M$\bCA\u0010n\u0013\tq\u0007E\u0001\u0006TiJ,8\r\u001e+za\u0016DQ\u0001\u001d\u0001\u0005\nE\fA#\\1lK6\u000b\u0007OU8pi\u000e{gN^3si\u0016\u0014HCA$s\u0011\u0015\u0019x\u000e1\u0001u\u0003\tiG\u000f\u0005\u0002 k&\u0011a\u000f\t\u0002\b\u001b\u0006\u0004H+\u001f9f\u0011\u0015A\b\u0001\"\u0003z\u0003Yi\u0017m[3BeJ\f\u0017PU8pi\u000e{gN^3si\u0016\u0014HCA${\u0011\u0015Yx\u000f1\u0001}\u0003\t\tG\u000f\u0005\u0002 {&\u0011a\u0010\t\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016Dq!!\u0001\u0001\t\u0003\t\u0019!A\u0007nC.,7i\u001c8wKJ$XM\u001d\u000b\u0005\u0003\u000b\tI\u0001E\u0002\u0002\bMj\u0011\u0001\u0001\u0005\u0007\u0003\u0017y\b\u0019\u0001\u0010\u0002\u0011\u0011\fG/\u0019+za\u0016Dq!a\u0004\u0001\t\u0013\t\t\"\u0001\bqCJ\u001cXMS:p]R{7.\u001a8\u0016\t\u0005M\u00111\u0004\u000b\u0007\u0003+\ti$!\u0011\u0015\t\u0005]\u0011Q\u0006\t\u0005\u00033\tY\u0002\u0004\u0001\u0005\u0011\u0005u\u0011Q\u0002b\u0001\u0003?\u0011\u0011AU\t\u0005\u0003C\t9\u0003E\u0002\u0012\u0003GI1!!\n\u0013\u0005\u0011qU\u000f\u001c7\u0011\u0007E\tI#C\u0002\u0002,I\u00111!\u00118z\u0011!\ty#!\u0004A\u0002\u0005E\u0012!\u00014\u0011\u000fE\t\u0019$a\u000e\u0002\u0018%\u0019\u0011Q\u0007\n\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042!OA\u001d\u0013\r\tYD\u000f\u0002\n\u0015N|g\u000eV8lK:Dq!a\u0010\u0002\u000e\u0001\u0007\u0001(\u0001\u0004qCJ\u001cXM\u001d\u0005\b\u0003\u0017\ti\u00011\u0001\u001f\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\n\u0001CZ1jY\u0016$7i\u001c8wKJ\u001c\u0018n\u001c8\u0016\t\u0005%\u0013q\n\u000b\u0007\u0003\u0017\n\t&a\u0015\u0011\u000fE\t\u0019$a\u000e\u0002NA!\u0011\u0011DA(\t!\ti\"a\u0011C\u0002\u0005}\u0001bBA \u0003\u0007\u0002\r\u0001\u000f\u0005\b\u0003\u0017\t\u0019\u00051\u0001\u001f\u0011\u001d\t9\u0006\u0001C\u0005\u00033\nQbY8om\u0016\u0014Ho\u00142kK\u000e$Hc\u0002+\u0002\\\u0005u\u0013q\f\u0005\b\u0003\u007f\t)\u00061\u00019\u0011\u0019i\u0012Q\u000ba\u0001Y\"A\u0011\u0011MA+\u0001\u0004\t\u0019'A\bgS\u0016dGmQ8om\u0016\u0014H/\u001a:t!\u0015\t\u0012QMA\u0003\u0013\r\t9G\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003W\u0002A\u0011BA7\u0003)\u0019wN\u001c<feRl\u0015\r\u001d\u000b\u0007\u0003_\nY(! \u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001e\u0005\u0003\u0011)H/\u001b7\n\t\u0005e\u00141\u000f\u0002\b\u001b\u0006\u0004H)\u0019;b\u0011\u001d\ty$!\u001bA\u0002aB\u0001\"a \u0002j\u0001\u0007\u0011QA\u0001\u000fM&,G\u000eZ\"p]Z,'\u000f^3s\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000b\u000bAbY8om\u0016\u0014H/\u0011:sCf$b!a\"\u0002\u000e\u0006=\u0005\u0003BA9\u0003\u0013KA!a#\u0002t\tI\u0011I\u001d:bs\u0012\u000bG/\u0019\u0005\b\u0003\u007f\t\t\t1\u00019\u0011!\ty(!!A\u0002\u0005\u0015\u0001bBAJ\u0001\u0011\u0005\u0011QS\u0001\u0006a\u0006\u00148/Z\u000b\u0005\u0003/\u000by\nF\u0004I\u00033\u000bY+!.\t\u0011\u0005m\u0015\u0011\u0013a\u0001\u0003;\u000baA]3d_J$\u0007\u0003BA\r\u0003?#\u0001\"!)\u0002\u0012\n\u0007\u00111\u0015\u0002\u0002)F!\u0011QUA\u0014!\r\t\u0012qU\u0005\u0004\u0003S\u0013\"a\u0002(pi\"Lgn\u001a\u0005\t\u0003[\u000b\t\n1\u0001\u00020\u0006a1M]3bi\u0016\u0004\u0016M]:feB9\u0011#!-^\u0003;C\u0014bAAZ%\tIa)\u001e8di&|gN\r\u0005\t\u0003o\u000b\t\n1\u0001\u0002:\u0006i!/Z2pe\u0012d\u0015\u000e^3sC2\u0004b!\u0005\u001c\u0002\u001e\u0006m\u0006\u0003BA_\u0003\u000bl!!a0\u000b\u0007\u0005\n\tMC\u0002\u0002D\"\ta!\u001e8tC\u001a,\u0017\u0002BAd\u0003\u007f\u0013!\"\u0016+GqM#(/\u001b8h\u0001")
public class JacksonParser
implements Logging {
    public final DataType org$apache$spark$sql$catalyst$json$JacksonParser$$schema;
    private final JSONOptions options;
    private final Function1<JsonParser, Seq<InternalRow>> rootConverter;
    private final JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public JSONOptions options() {
        return this.options;
    }

    private Function1<JsonParser, Seq<InternalRow>> rootConverter() {
        return this.rootConverter;
    }

    public JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    }

    private Function1<JsonParser, Seq<InternalRow>> makeRootConverter(DataType dt) {
        Function1<JsonParser, Seq<InternalRow>> function1;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            function1 = this.makeStructRootConverter(structType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            function1 = this.makeMapRootConverter(mapType);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            function1 = this.makeArrayRootConverter(arrayType);
        } else {
            throw new MatchError((Object)dataType);
        }
        return function1;
    }

    private Function1<JsonParser, Seq<InternalRow>> makeStructRootConverter(StructType st) {
        Function1<JsonParser, Object> elementConverter = this.makeConverter(st);
        Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        return (Function1 & Serializable & scala.Serializable)parser -> (Seq)this.parseJsonToken((JsonParser)parser, st, (PartialFunction)new scala.Serializable(this, st, (Function1)elementConverter, fieldConverters, (JsonParser)parser){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final StructType st$1;
            private final Function1 elementConverter$1;
            private final Function1[] fieldConverters$1;
            private final JsonParser parser$2;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (JsonToken.START_OBJECT.equals(A1)) {
                    InternalRow internalRow = this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$2, this.st$1, this.fieldConverters$1);
                    object = Nil$.MODULE$.$colon$colon((Object)internalRow);
                } else {
                    ArrayData array;
                    object = JsonToken.START_ARRAY.equals(A1) ? ((array = this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$2, (Function1<JsonParser, Object>)this.elementConverter$1)).numElements() == 0 ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array.toArray(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$schema, ClassTag$.MODULE$.apply(InternalRow.class)))).toSeq()) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_OBJECT.equals(jsonToken) ? true : JsonToken.START_ARRAY.equals(jsonToken);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.st$1 = st$1;
                this.elementConverter$1 = elementConverter$1;
                this.fieldConverters$1 = fieldConverters$1;
                this.parser$2 = parser$2;
            }
        });
    }

    private Function1<JsonParser, Seq<InternalRow>> makeMapRootConverter(MapType mt) {
        Function1<JsonParser, Object> fieldConverter = this.makeConverter(mt.valueType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Seq)this.parseJsonToken((JsonParser)parser, mt, (PartialFunction)new scala.Serializable(this, (Function1)fieldConverter, (JsonParser)parser){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final Function1 fieldConverter$1;
            private final JsonParser parser$3;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = JsonToken.START_OBJECT.equals(A1) ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$3, (Function1<JsonParser, Object>)this.fieldConverter$1)}))})) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x2) {
                JsonToken jsonToken = x2;
                boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fieldConverter$1 = fieldConverter$1;
                this.parser$3 = parser$3;
            }
        });
    }

    private Function1<JsonParser, Seq<InternalRow>> makeArrayRootConverter(ArrayType at) {
        Function1<JsonParser, Object> elemConverter = this.makeConverter(at.elementType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Seq)this.parseJsonToken((JsonParser)parser, at, (PartialFunction)new scala.Serializable(this, at, (Function1)elemConverter, (JsonParser)parser){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final ArrayType at$1;
            private final Function1 elemConverter$1;
            private final JsonParser parser$4;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (JsonToken.START_ARRAY.equals(A1)) {
                    object = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$4, (Function1<JsonParser, Object>)this.elemConverter$1)}))}));
                } else if (JsonToken.START_OBJECT.equals(A1) && this.at$1.elementType() instanceof StructType) {
                    StructType st = (StructType)this.at$1.elementType();
                    Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> $this.$outer.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
                    object = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$4, st, fieldConverters)}))))}))}));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x3) {
                JsonToken jsonToken = x3;
                boolean bl = JsonToken.START_ARRAY.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken) && this.at$1.elementType() instanceof StructType;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.at$1 = at$1;
                this.elemConverter$1 = elemConverter$1;
                this.parser$4 = parser$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.types.StructField ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeArrayRootConverter$1$1 org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        });
    }

    public Function1<JsonParser, Object> makeConverter(DataType dataType2) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType3 = dataType2;
        if (BooleanType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Boolean)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    Object object = JsonToken.VALUE_TRUE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(true) : (JsonToken.VALUE_FALSE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(false) : function1.apply(x4));
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x4) {
                    JsonToken jsonToken = x4;
                    boolean bl = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
                    return bl;
                }
            });
        } else if (ByteType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Byte)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$5;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    A1 A1 = x5;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.byte2Byte(this.parser$5.getByteValue()) : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x5) {
                    JsonToken jsonToken = x5;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$5 = parser$5;
                }
            });
        } else if (ShortType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Short)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$6;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    A1 A1 = x6;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.short2Short(this.parser$6.getShortValue()) : function1.apply(x6);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x6) {
                    JsonToken jsonToken = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$6 = parser$6;
                }
            });
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$7;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    A1 A1 = x7;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.int2Integer(this.parser$7.getIntValue()) : function1.apply(x7);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x7) {
                    JsonToken jsonToken = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$7 = parser$7;
                }
            });
        } else if (LongType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$8;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    A1 A1 = x8;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$8.getLongValue()) : function1.apply(x8);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x8) {
                    JsonToken jsonToken = x8;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$8 = parser$8;
                }
            });
        } else if (FloatType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Float)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$9;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x9;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.float2Float(this.parser$9.getFloatValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1)) {
                        Float f;
                        String string = this.parser$9.getText();
                        if ("NaN".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NaN);
                        } else if ("Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(FloatType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = f;
                    } else {
                        object = function1.apply(x9);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x9) {
                    JsonToken jsonToken = x9;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl2;
                }
                {
                    this.parser$9 = parser$9;
                }
            });
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Double)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$10;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x10;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.double2Double(this.parser$10.getDoubleValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1)) {
                        Double d;
                        String string = this.parser$10.getText();
                        if ("NaN".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NaN);
                        } else if ("Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(DoubleType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = d;
                    } else {
                        object = function1.apply(x10);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x10) {
                    JsonToken jsonToken = x10;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl2;
                }
                {
                    this.parser$10 = parser$10;
                }
            });
        } else if (StringType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (UTF8String)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$11;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    UTF8String uTF8String;
                    A1 A1 = x11;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        uTF8String = UTF8String.fromString((String)this.parser$11.getText());
                    } else {
                        ByteArrayOutputStream writer = new ByteArrayOutputStream();
                        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$factory().createGenerator((OutputStream)writer, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                            $anonfun$$nestedInanonfun$makeConverter$8$1.$anonfun$applyOrElse$4(this, generator);
                            return BoxedUnit.UNIT;
                        });
                        uTF8String = UTF8String.fromBytes((byte[])writer.toByteArray());
                    }
                    return (B1)uTF8String;
                }

                public final boolean isDefinedAt(JsonToken x11) {
                    JsonToken jsonToken = x11;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) ? true : true;
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4($anonfun$$nestedInanonfun$makeConverter$8$1 $this, JsonGenerator generator) {
                    generator.copyCurrentStructure($this.parser$11);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$11 = parser$11;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 java.io.ByteArrayOutputStream ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 com.fasterxml.jackson.core.JsonGenerator )}, serializedLambda);
                }
            });
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$12;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x12;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String stringValue = this.parser$12.getText();
                        object = BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.$outer.options().timestampFormat().parse(stringValue).getTime() * 1000L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.stringToTime(stringValue).getTime() * 1000L)));
                    } else {
                        object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$12.getLongValue() * 1000000L) : function1.apply(x12);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x12) {
                    JsonToken jsonToken = x12;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$12 = parser$12;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$9$1 java.lang.String ), $anonfun$applyOrElse$6(java.lang.String )}, serializedLambda);
                }
            });
        } else if (DateType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$13;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x13;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String stringValue = this.parser$13.getText();
                        object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.millisToDays($this.$outer.options().dateFormat().parse(stringValue).getTime())).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime(stringValue).getTime()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(stringValue)).toInt())));
                    } else {
                        object = function1.apply(x13);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x13) {
                    JsonToken jsonToken = x13;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$13 = parser$13;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.String ), $anonfun$applyOrElse$8(java.lang.String ), $anonfun$applyOrElse$10(java.lang.String ), $anonfun$applyOrElse$9(java.lang.String )}, serializedLambda);
                }
            });
        } else if (BinaryType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (byte[])this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$14;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    A1 A1 = x14;
                    Object object = JsonToken.VALUE_STRING.equals(A1) ? this.parser$14.getBinaryValue() : (Object)function1.apply(x14);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x14) {
                    JsonToken jsonToken = x14;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$14 = parser$14;
                }
            });
        } else if (dataType3 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType3;
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Decimal)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, decimalType, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final DecimalType x13$1;
                private final JsonParser parser$15;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                    A1 A1 = x15;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    Object object = bl ? Decimal$.MODULE$.apply(this.parser$15.getDecimalValue(), this.x13$1.precision(), this.x13$1.scale()) : function1.apply(x15);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x15) {
                    JsonToken jsonToken = x15;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    this.x13$1 = x13$1;
                    this.parser$15 = parser$15;
                }
            });
        } else if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (InternalRow)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, fieldConverters, structType, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final Function1[] fieldConverters$2;
                private final StructType x14$1;
                private final JsonParser parser$16;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                    A1 A1 = x16;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$16, this.x14$1, this.fieldConverters$2) : function1.apply(x16);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x16) {
                    JsonToken jsonToken = x16;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fieldConverters$2 = fieldConverters$2;
                    this.x14$1 = x14$1;
                    this.parser$16 = parser$16;
                }
            });
        } else if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            Function1<JsonParser, Object> elementConverter = this.makeConverter(arrayType.elementType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (ArrayData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (Function1)elementConverter, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final Function1 elementConverter$2;
                private final JsonParser parser$17;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                    A1 A1 = x17;
                    Object object = JsonToken.START_ARRAY.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$17, (Function1<JsonParser, Object>)this.elementConverter$2) : function1.apply(x17);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x17) {
                    JsonToken jsonToken = x17;
                    boolean bl = JsonToken.START_ARRAY.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.elementConverter$2 = elementConverter$2;
                    this.parser$17 = parser$17;
                }
            });
        } else if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            Function1<JsonParser, Object> valueConverter = this.makeConverter(mapType.valueType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (MapData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (Function1)valueConverter, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final Function1 valueConverter$1;
                private final JsonParser parser$18;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                    A1 A1 = x18;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$18, (Function1<JsonParser, Object>)this.valueConverter$1) : function1.apply(x18);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x18) {
                    JsonToken jsonToken = x18;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.valueConverter$1 = valueConverter$1;
                    this.parser$18 = parser$18;
                }
            });
        } else if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            intersect = this.makeConverter(userDefinedType.sqlType());
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)PartialFunction$.MODULE$.empty());
        }
        return intersect;
    }

    private <R> R parseJsonToken(JsonParser parser, DataType dataType, PartialFunction<JsonToken, R> f) {
        JsonToken jsonToken;
        while (JsonToken.FIELD_NAME.equals(jsonToken = parser.getCurrentToken())) {
            parser.nextToken();
        }
        boolean bl = jsonToken == null ? true : JsonToken.VALUE_NULL.equals(jsonToken);
        Object object = bl ? null : f.applyOrElse((Object)jsonToken, this.failedConversion(parser, dataType));
        return (R)object;
    }

    private <R> PartialFunction<JsonToken, R> failedConversion(JsonParser parser, DataType dataType) {
        return new scala.Serializable(null, parser, dataType){
            public static final long serialVersionUID = 0L;
            private final JsonParser parser$1;
            private final DataType dataType$2;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x19, Function1<A1, B1> function1) {
                A1 A1 = x19;
                if (!JsonToken.VALUE_STRING.equals(A1) || this.parser$1.getTextLength() >= 1) {
                    throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
                }
                B1 B1 = null;
                return B1;
            }

            public final boolean isDefinedAt(JsonToken x19) {
                JsonToken jsonToken = x19;
                boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$1.getTextLength() < 1 ? true : true;
                return bl;
            }
            {
                this.parser$1 = parser$1;
                this.dataType$2 = dataType$2;
            }
        };
    }

    public InternalRow org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(JsonParser parser, StructType schema, Function1<JsonParser, Object>[] fieldConverters) {
        GenericInternalRow row = new GenericInternalRow(schema.length());
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            JsonParser jsonParser;
            Option<Object> option = schema.getFieldIndex(parser.getCurrentName());
            if (option instanceof Some) {
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt((Object)some.value());
                row.update(index, fieldConverters[index].apply((Object)parser));
                jsonParser = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                jsonParser = parser.skipChildren();
                continue;
            }
            throw new MatchError(option);
        }
        return row;
    }

    public MapData org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            keys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return ArrayBasedMapData$.MODULE$.apply(keys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)), values.toArray(ClassTag$.MODULE$.Any()));
    }

    public ArrayData org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return new GenericArrayData((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T> Seq<InternalRow> parse(T record, Function2<JsonFactory, T, JsonParser> createParser, Function1<T, UTF8String> recordLiteral) {
        Seq seq;
        try {
            seq = (Seq)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory(), record), (Function1 & Serializable & scala.Serializable)parser -> {
                Nil$ nil$;
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == null) {
                    nil$ = Nil$.MODULE$;
                } else {
                    Seq seq = (Seq)this.rootConverter().apply(parser);
                    if (seq == null) {
                        throw new RuntimeException("Root converter returned null");
                    }
                    Seq seq2 = seq;
                    nil$ = seq2;
                }
                return nil$;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException);
            if (bl) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, throwable2);
            }
            if (throwable2 instanceof CharConversionException) {
                CharConversionException charConversionException = (CharConversionException)throwable2;
                if (this.options().encoding().isEmpty()) {
                    String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n            |Specifying encoding as an input option explicitly might help to resolve the issue.\n            |")).stripMargin()).append(charConversionException.getMessage()).toString();
                    CharConversionException wrappedCharException = new CharConversionException(msg);
                    wrappedCharException.initCause(charConversionException);
                    throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, wrappedCharException);
                }
            }
            throw throwable;
        }
        return seq;
    }

    public JacksonParser(DataType schema, JSONOptions options) {
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$schema = schema;
        this.options = options;
        Logging.$init$((Logging)this);
        this.rootConverter = this.makeRootConverter(schema);
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory = new JsonFactory();
        options.setJacksonOptions(this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory());
    }
}

