/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathString$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns the text contents of the first xml node that matches the XPath expression.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>b</b><c>cc</c></a>','a/c');\n       cc\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001F\u00111\u0002\u0017)bi\"\u001cFO]5oO*\u00111\u0001B\u0001\u0004q6d'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011A\u0002\u0017)bi\",\u0005\u0010\u001e:bGR\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0007\u0001\u0011)\u001a!C\u0001AU\t\u0011\u0005\u0005\u0002#G5\tA!\u0003\u0002%\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0019\u0002!\u0011#Q\u0001\n\u0005\nA\u0001_7mA!A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0001%\u0001\u0003qCRD\u0007\u0002\u0003\u0016\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\u000bA\fG\u000f\u001b\u0011\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\rqs\u0006\r\t\u0003'\u0001AQaA\u0016A\u0002\u0005BQ\u0001K\u0016A\u0002\u0005BQA\r\u0001\u0005BM\n!\u0002\u001d:fiRLh*Y7f+\u0005!\u0004CA\u001b=\u001d\t1$\b\u0005\u0002815\t\u0001H\u0003\u0002:!\u00051AH]8pizJ!a\u000f\r\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003waAQ\u0001\u0011\u0001\u0005B\u0005\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tC\u0001\u0006if\u0004Xm]\u0005\u0003\u000f\u0012\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u0013\u0002!\tES\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u0017:{\u0005CA\fM\u0013\ti\u0005DA\u0002B]fDQa\u0001%A\u0002-CQ\u0001\u000b%A\u0002-Cq!\u0015\u0001\u0002\u0002\u0013\u0005!+\u0001\u0003d_BLHc\u0001\u0018T)\"91\u0001\u0015I\u0001\u0002\u0004\t\u0003b\u0002\u0015Q!\u0003\u0005\r!\t\u0005\b-\u0002\t\n\u0011\"\u0001X\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u0017\u0016\u0003Ce[\u0013A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005}C\u0012AC1o]>$\u0018\r^5p]&\u0011\u0011\r\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB2\u0001#\u0003%\taV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d)\u0007!!A\u0005B\u0019\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001\u00027b]\u001eT\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002>S\"9q\u000eAA\u0001\n\u0003\u0001\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#A9\u0011\u0005]\u0011\u0018BA:\u0019\u0005\rIe\u000e\u001e\u0005\bk\u0002\t\t\u0011\"\u0001w\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"aS<\t\u000fa$\u0018\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\t\u000fi\u0004\u0011\u0011!C!w\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001}!\u0011i\u0018\u0011A&\u000e\u0003yT!a \r\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\u0004y\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u000f\u0001\u0011\u0011!C\u0001\u0003\u0013\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\t\t\u0002E\u0002\u0018\u0003\u001bI1!a\u0004\u0019\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002_A\u0003\u0003\u0003\u0005\ra\u0013\u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/\ta!Z9vC2\u001cH\u0003BA\u0006\u00033A\u0001\u0002_A\n\u0003\u0003\u0005\ra\u0013\u0015\f\u0001\u0005u\u00111EA\u0013\u0003S\tY\u0003E\u0002#\u0003?I1!!\t\u0005\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\n\u0002O~3UKT\"`QalG\u000e\f\u0011ya\u0006$\b.\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011uKb$\beY8oi\u0016tGo\u001d\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t=nY\u0002rw\u000eZ3!i\"\fG\u000fI7bi\u000eDWm\u001d\u0011uQ\u0016\u0004\u0003\fU1uQ\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\f\u0002)*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt$\rP\u0018c}q\u001aghY2=_\rtDhL1?O1:\u0013mL2(SmR\u0001\u0005\t\u0011!A\u0001\u00023m\u0019\u0006!A\u001dI\u0011\u0011\u0007\u0002\u0002\u0002#\u0005\u00111G\u0001\f1B\u000bG\u000f[*ue&tw\rE\u0002\u0014\u0003k1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qG\n\u0006\u0003k\tI\u0004\b\t\b\u0003w\t\t%I\u0011/\u001b\t\tiDC\u0002\u0002@a\tqA];oi&lW-\u0003\u0003\u0002D\u0005u\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9A&!\u000e\u0005\u0002\u0005\u001dCCAA\u001a\u0011)\tY%!\u000e\u0002\u0002\u0013\u0015\u0013QJ\u0001\ti>\u001cFO]5oOR\tq\r\u0003\u0006\u0002R\u0005U\u0012\u0011!CA\u0003'\nQ!\u00199qYf$RALA+\u0003/BaaAA(\u0001\u0004\t\u0003B\u0002\u0015\u0002P\u0001\u0007\u0011\u0005\u0003\u0006\u0002\\\u0005U\u0012\u0011!CA\u0003;\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002`\u0005-\u0004#B\f\u0002b\u0005\u0015\u0014bAA21\t1q\n\u001d;j_:\u0004RaFA4C\u0005J1!!\u001b\u0019\u0005\u0019!V\u000f\u001d7fe!I\u0011QNA-\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\u0002\u0004BCA9\u0003k\t\t\u0011\"\u0003\u0002t\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\bE\u0002i\u0003oJ1!!\u001fj\u0005\u0019y%M[3di\u0002")
public class XPathString
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathString xPathString) {
        return XPathString$.MODULE$.unapply(xPathString);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathString> tupled() {
        return XPathString$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathString>> curried() {
        return XPathString$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_string";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        String ret = this.xpathUtil().evalString(((UTF8String)xml).toString(), this.pathString());
        return UTF8String.fromString((String)ret);
    }

    public XPathString copy(Expression xml, Expression path) {
        return new XPathString(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathString";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathString)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathString xPathString = (XPathString)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathString.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathString.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathString.canEqual(this)) return false;
        return true;
    }

    public XPathString(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

