/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="The function is non-deterministic.")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001>\u0011A!V;jI*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001!Q9\"\u0004\t\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011a\u0002T3bM\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\t'R\fG/\u001a4vYB\u0011\u0011\u0003G\u0005\u00033\t\u0011\u0001$\u0012=qe\u0016\u001c8/[8o/&$\bNU1oI>l7+Z3e!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001d\u0001&o\u001c3vGR\u0004\"aG\u0011\n\u0005\tb\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0013\u0001\u0005+\u0007I\u0011A\u0013\u0002\u0015I\fg\u000eZ8n'\u0016,G-F\u0001'!\rYr%K\u0005\u0003Qq\u0011aa\u00149uS>t\u0007CA\u000e+\u0013\tYCD\u0001\u0003M_:<\u0007\u0002C\u0017\u0001\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\u0017I\fg\u000eZ8n'\u0016,G\r\t\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u0012\u0004CA\t\u0001\u0011\u001d!c\u0006%AA\u0002\u0019BQa\f\u0001\u0005\u0002Q\"\u0012!\r\u0005\u0006m\u0001!\teN\u0001\fo&$\bNT3x'\u0016,G\r\u0006\u00022q!)\u0011(\u000ea\u0001S\u0005!1/Z3e\u0011!Y\u0004\u0001#b\u0001\n\u0003b\u0014\u0001\u0003:fg>dg/\u001a3\u0016\u0003u\u0002\"a\u0007 \n\u0005}b\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0003\u0002!\t\u0005P\u0001\t]VdG.\u00192mK\")1\t\u0001C!\t\u0006AA-\u0019;b)f\u0004X-F\u0001F!\t1\u0015*D\u0001H\u0015\tAe!A\u0003usB,7/\u0003\u0002K\u000f\nAA)\u0019;b)f\u0004X\rC\u0005M\u0001\u0001\u0007\t\u0011)Q\u0005\u001b\u0006y!/\u00198e_6<UM\\3sCR|'\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\t\u0005!Q\u000f^5m\u0013\t\u0011vJA\nSC:$w.\\+V\u0013\u0012;UM\\3sCR|'\u000f\u000b\u0002L)B\u00111$V\u0005\u0003-r\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000ba\u0003A\u0011K-\u0002%%t\u0017\u000e^5bY&TX-\u00138uKJt\u0017\r\u001c\u000b\u00035v\u0003\"aG.\n\u0005qc\"\u0001B+oSRDQAX,A\u0002}\u000ba\u0002]1si&$\u0018n\u001c8J]\u0012,\u0007\u0010\u0005\u0002\u001cA&\u0011\u0011\r\b\u0002\u0004\u0013:$\b\"B2\u0001\t#\"\u0017\u0001D3wC2Le\u000e^3s]\u0006dGCA3i!\tYb-\u0003\u0002h9\t\u0019\u0011I\\=\t\u000b%\u0014\u0007\u0019\u00016\u0002\u000b%t\u0007/\u001e;\u0011\u0005-dW\"\u0001\u0003\n\u00055$!aC%oi\u0016\u0014h.\u00197S_^DQa\u001c\u0001\u0005BA\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007E<H\u0010\u0005\u0002sk6\t1O\u0003\u0002u\u0005\u000591m\u001c3fO\u0016t\u0017B\u0001<t\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002=o\u0001\u0004I\u0018aA2uqB\u0011!O_\u0005\u0003wN\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003~]\u0002\u0007\u0011/\u0001\u0002fm\")q\u0010\u0001C!i\u0005IaM]3tQ\u000e{\u0007/\u001f\u0005\n\u0003\u0007\u0001\u0011\u0011!C\u0001\u0003\u000b\tAaY8qsR\u0019\u0011'a\u0002\t\u0011\u0011\n\t\u0001%AA\u0002\u0019B\u0011\"a\u0003\u0001#\u0003%\t!!\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0002\u0016\u0004M\u0005E1FAA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uA$\u0001\u0006b]:|G/\u0019;j_:LA!!\t\u0002\u0018\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0015\u0002!!A\u0005B\u0005\u001d\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001\u00027b]\u001eT!!a\r\u0002\t)\fg/Y\u0005\u0005\u0003o\tiC\u0001\u0004TiJLgn\u001a\u0005\n\u0003w\u0001\u0011\u0011!C\u0001\u0003{\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u0018\u0005\n\u0003\u0003\u0002\u0011\u0011!C\u0001\u0003\u0007\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002f\u0003\u000bB\u0011\"a\u0012\u0002@\u0005\u0005\t\u0019A0\u0002\u0007a$\u0013\u0007C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002PA)\u0011\u0011KA,K6\u0011\u00111\u000b\u0006\u0004\u0003+b\u0012AC2pY2,7\r^5p]&!\u0011\u0011LA*\u0005!IE/\u001a:bi>\u0014\b\"CA/\u0001\u0005\u0005I\u0011AA0\u0003!\u0019\u0017M\\#rk\u0006dGcA\u001f\u0002b!I\u0011qIA.\u0003\u0003\u0005\r!\u001a\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003O\na!Z9vC2\u001cHcA\u001f\u0002j!I\u0011qIA2\u0003\u0003\u0005\r!\u001a\u0015\u0010\u0001\u00055\u00141OA;\u0003s\nY(a \u0002\u0002B\u0019\u0011#a\u001c\n\u0007\u0005E$AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0014!a\u0001`\rVs5i\u0018\u0015*A5\u0002#+\u001a;ve:\u001c\b%\u00198!k:Lg/\u001a:tC2d\u0017\u0010I;oSF,X\rI5eK:$\u0018NZ5fe\u0002BS+V%ES\u0001\u001aHO]5oO:\u0002C\u000b[3!m\u0006dW/\u001a\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%Y:!C\u0002\u001a\u0017M\\8oS\u000e\fG\u000eI+V\u0013\u0012\u00033GN\u0017dQ\u0006\u0014\u0018m\u0019;fe\u0002\u001aHO]5oO:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003{\naK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\"dg\u000e\u00198If\u0012T\u0006\r\u001agi5\"\u0004(M\u001c.qE\nd'L15GN\u0012'gM37eY2$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003\u0007\u000b!\u0005\u00165fA\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011o_:lC-\u001a;fe6Lg.[:uS\u000ets!CAD\u0005\u0005\u0005\t\u0012AAE\u0003\u0011)V/\u001b3\u0011\u0007E\tYI\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAG'\u0015\tY)a$!!\u0019\t\t*a&'c5\u0011\u00111\u0013\u0006\u0004\u0003+c\u0012a\u0002:v]RLW.Z\u0005\u0005\u00033\u000b\u0019JA\tBEN$(/Y2u\rVt7\r^5p]FBqaLAF\t\u0003\ti\n\u0006\u0002\u0002\n\"Q\u0011\u0011UAF\u0003\u0003%)%a)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000b\t\u0015\u0005\u001d\u00161RA\u0001\n\u0003\u000bI+A\u0003baBd\u0017\u0010F\u00022\u0003WC\u0001\u0002JAS!\u0003\u0005\rA\n\u0005\u000b\u0003_\u000bY)!A\u0005\u0002\u0006E\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003g\u000b)\fE\u0002\u001cO\u0019B\u0011\"a.\u0002.\u0006\u0005\t\u0019A\u0019\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002<\u0006-\u0015\u0013!C\u0001\u0003\u001b\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004BCA`\u0003\u0017\u000b\n\u0011\"\u0001\u0002\u000e\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013\u0007\u0003\u0006\u0002D\u0006-\u0015\u0011!C\u0005\u0003\u000b\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0019\t\u0005\u0003W\tI-\u0003\u0003\u0002L\u00065\"AB(cU\u0016\u001cG\u000f")
public class Uuid
extends LeafExpression
implements Stateful,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid uuid) {
        return Uuid$.MODULE$.unapply(uuid);
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> function1) {
        return Uuid$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Uuid> compose(Function1<A, Option<Object>> function1) {
        return Uuid$.MODULE$.compose(function1);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState(x$1, x$2, x$5, x$3, x$4);
        ctx.addPartitionInitializationStatement(new StringBuilder(62).append(randomGen).append(" = ").append("new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(").append(new StringBuilder(20).append(this.randomSeed().get()).append("L + partitionIndex);").toString()).toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Uuid freshCopy() {
        return new Uuid(this.randomSeed());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.randomSeed();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }
}

