/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(fmt, ts) - Returns timestamp `ts` truncated to the unit specified by the format model `fmt`.\n    `fmt` should be one of [\"YEAR\", \"YYYY\", \"YY\", \"MON\", \"MONTH\", \"MM\", \"DAY\", \"DD\", \"HOUR\", \"MINUTE\", \"SECOND\", \"WEEK\", \"QUARTER\"]\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', '2015-03-05T09:32:05.359');\n       2015-01-01 00:00:00\n      > SELECT _FUNC_('MM', '2015-03-05T09:32:05.359');\n       2015-03-01 00:00:00\n      > SELECT _FUNC_('DD', '2015-03-05T09:32:05.359');\n       2015-03-05 00:00:00\n      > SELECT _FUNC_('HOUR', '2015-03-05T09:32:05.359');\n       2015-03-05 09:00:00\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0001\u0003\u0001>\u0011a\u0002\u0016:v]\u000e$\u0016.\\3ti\u0006l\u0007O\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003F\f\u001bAA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!\u0001\u0004+sk:\u001c\u0017J\\:uC:$\bCA\t\u0019\u0013\tI\"AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9\u0001K]8ek\u000e$\bCA\u000e\"\u0013\t\u0011CD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005%\u0001\tU\r\u0011\"\u0001&\u0003\u00191wN]7biV\ta\u0005\u0005\u0002\u0012O%\u0011\u0001F\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0016\u0001\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\u000f\u0019|'/\\1uA!AA\u0006\u0001BK\u0002\u0013\u0005Q%A\u0005uS6,7\u000f^1na\"Aa\u0006\u0001B\tB\u0003%a%\u0001\u0006uS6,7\u000f^1na\u0002B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t!M\u0001\u000bi&lWMW8oK&#W#\u0001\u001a\u0011\u0007m\u0019T'\u0003\u000259\t1q\n\u001d;j_:\u0004\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d\u001d\u001b\u0005I$B\u0001\u001e\u000f\u0003\u0019a$o\\8u}%\u0011A\bH\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=9!A\u0011\t\u0001B\tB\u0003%!'A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0003\"B\"\u0001\t\u0003!\u0015A\u0002\u001fj]&$h\b\u0006\u0003F\r\u001eC\u0005CA\t\u0001\u0011\u0015!#\t1\u0001'\u0011\u0015a#\t1\u0001'\u0011\u001d\u0001$\t%AA\u0002IBQA\u0013\u0001\u0005B\u0015\nA\u0001\\3gi\")A\n\u0001C!K\u0005)!/[4ii\")a\n\u0001C!\u001f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003A\u00032!\u0015,Z\u001d\t\u0011FK\u0004\u00029'&\tQ$\u0003\u0002V9\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005\r\u0019V-\u001d\u0006\u0003+r\u0001\"AW/\u000e\u0003mS!\u0001\u0018\u0004\u0002\u000bQL\b/Z:\n\u0005y[&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0003!!\u0017\r^1UsB,W#\u00012\u0011\u0005i\u001b\u0017B\u00013\\\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\")a\r\u0001C!O\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003UBq!\u001b\u0001C\u0002\u0013\u0005S%A\u0004j]N$\u0018M\u001c;\t\r-\u0004\u0001\u0015!\u0003'\u0003!Ign\u001d;b]R\u0004\u0003\"B7\u0001\t\u0003r\u0017\u0001D<ji\"$\u0016.\\3[_:,GCA\fp\u0011\u0015\u0001D\u000e1\u00016\u0011\u0015\u0019\u0005\u0001\"\u0001r)\r)%o\u001d\u0005\u0006IA\u0004\rA\n\u0005\u0006YA\u0004\rA\n\u0005\u0006k\u0002!\tE^\u0001\u0005KZ\fG\u000e\u0006\u0002xuB\u00111\u0004_\u0005\u0003sr\u00111!\u00118z\u0011\u001dYH\u000f%AA\u0002q\fQ!\u001b8qkR\u0004\"! @\u000e\u0003\u0011I!a \u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\b\u0005M\u0011Q\u0004\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0002\u0002\u000f\r|G-Z4f]&!\u0011\u0011CA\u0006\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\u0002CA\u000b\u0003\u0003\u0001\r!a\u0006\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\n\u0005e\u0011\u0002BA\u000e\u0003\u0017\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0005\u0002 \u0005\u0005\u0001\u0019AA\u0004\u0003\t)g\u000fC\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&\u0005!1m\u001c9z)\u001d)\u0015qEA\u0015\u0003WA\u0001\u0002JA\u0011!\u0003\u0005\rA\n\u0005\tY\u0005\u0005\u0002\u0013!a\u0001M!A\u0001'!\t\u0011\u0002\u0003\u0007!\u0007C\u0005\u00020\u0001\t\n\u0011\"\u0001\u00022\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001aU\r1\u0013QG\u0016\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\t\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0005m\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\n\u0001\u0012\u0002\u0013\u0005\u0011\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ti\u0005AI\u0001\n\u0003\ty%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E#f\u0001\u001a\u00026!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0013qK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0002d\u0005!!.\u0019<b\u0013\rq\u0014Q\f\u0005\n\u0003S\u0002\u0011\u0011!C\u0001\u0003W\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001c\u0011\u0007m\ty'C\u0002\u0002rq\u00111!\u00138u\u0011%\t)\bAA\u0001\n\u0003\t9(\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007]\fI\b\u0003\u0006\u0002|\u0005M\u0014\u0011!a\u0001\u0003[\n1\u0001\u001f\u00132\u0011%\ty\bAA\u0001\n\u0003\n\t)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\tE\u0003\u0002\u0006\u0006-u/\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u000e\u0006\u001d%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005E\u0005!!A\u0005\u0002\u0005M\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U\u00151\u0014\t\u00047\u0005]\u0015bAAM9\t9!i\\8mK\u0006t\u0007\"CA>\u0003\u001f\u000b\t\u00111\u0001x\u0011%\ty\nAA\u0001\n\u0003\n\t+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\u000b\u0019\u000bC\u0005\u0002|\u0005u\u0015\u0011!a\u0001o\"z\u0001!a*\u0002.\u0006=\u00161WA[\u0003s\u000bY\fE\u0002\u0012\u0003SK1!a+\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!-\u0002\u0003?T\u0001\u0005\t\u0011!?\u001a+fjQ0)M6$H\u0006\t;tS\u0001j\u0003EU3ukJt7\u000f\t;j[\u0016\u001cH/Y7qA\u0001$8\u000f\u0019\u0011ueVt7-\u0019;fI\u0002\"x\u000e\t;iK\u0002*h.\u001b;!gB,7-\u001b4jK\u0012\u0004#-\u001f\u0011uQ\u0016\u0004cm\u001c:nCR\u0004Sn\u001c3fY\u0002\u0002g-\u001c;a])\u0001\u0003\u0005\t\u0011aM6$\b\rI:i_VdG\r\t2fA=tW\rI8gAm\u0013\u0013,R!SE1\u0002#%W-Z3\nb\u0003EI-ZE1\u0002#%T(OE1\u0002#%T(O)\"\u0013C\u0006\t\u0012N\u001b\nb\u0003E\t#B3\nb\u0003E\t#EE1\u0002#\u0005S(V%\nb\u0003EI'J\u001dV#VI\t\u0017!EM+5i\u0014(EE1\u0002#eV#F\u0017\nb\u0003EI)V\u0003J#VI\u0015\u0012^\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0016Aa1\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dJV)\u0011*(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":S*T\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"Ei\n\u0017!OI\u0002\u0014'N\u00171g5\u0002T\u0007\u0016\u0019:uM\u0012$\bM\u001b/gUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nT'\f\u00194[A*\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!{UKU\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002T\u0007\t\u0019:uA\u0002$\b\r\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!0\u0002\u000bIr3G\f\u0019\b\u0013\u0005\u0005'!!A\t\u0002\u0005\r\u0017A\u0004+sk:\u001cG+[7fgR\fW\u000e\u001d\t\u0004#\u0005\u0015g\u0001C\u0001\u0003\u0003\u0003E\t!a2\u0014\u000b\u0005\u0015\u0017\u0011\u001a\u0011\u0011\u0011\u0005-\u0017\u0011\u001b\u0014'e\u0015k!!!4\u000b\u0007\u0005=G$A\u0004sk:$\u0018.\\3\n\t\u0005M\u0017Q\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004bB\"\u0002F\u0012\u0005\u0011q\u001b\u000b\u0003\u0003\u0007D!\"a7\u0002F\u0006\u0005IQIAo\u0003!!xn\u0015;sS:<GCAA-\u0011)\t\t/!2\u0002\u0002\u0013\u0005\u00151]\u0001\u0006CB\u0004H.\u001f\u000b\b\u000b\u0006\u0015\u0018q]Au\u0011\u0019!\u0013q\u001ca\u0001M!1A&a8A\u0002\u0019B\u0001\u0002MAp!\u0003\u0005\rA\r\u0005\u000b\u0003[\f)-!A\u0005\u0002\u0006=\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003c\fI\u0010\u0005\u0003\u001cg\u0005M\bCB\u000e\u0002v\u001a2#'C\u0002\u0002xr\u0011a\u0001V;qY\u0016\u001c\u0004\"CA~\u0003W\f\t\u00111\u0001F\u0003\rAH\u0005\r\u0005\u000b\u0003\u007f\f)-%A\u0005\u0002\u0005=\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003\u0004\u0005\u0015\u0017\u0013!C\u0001\u0003\u001f\nq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\u000b\u0005\u000f\t)-!A\u0005\n\t%\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0003\u0011\t\u0005m#QB\u0005\u0005\u0005\u001f\tiF\u0001\u0004PE*,7\r\u001e")
public class TruncTimestamp
extends BinaryExpression
implements TruncInstant,
TimeZoneAwareExpression,
scala.Serializable {
    private final Expression format;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private final Expression instant;
    private boolean resolved;
    private transient TimeZone timeZone;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return TruncTimestamp$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return TruncTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(TruncTimestamp truncTimestamp) {
        return TruncTimestamp$.MODULE$.unapply(truncTimestamp);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, TruncTimestamp> tupled() {
        return TruncTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, TruncTimestamp>>> curried() {
        return TruncTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int maxLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, maxLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int maxLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, maxLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.format();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, TimestampType$.MODULE$}));
    }

    @Override
    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "date_trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$35 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$36 = this.copy$default$1();
        Expression x$37 = this.copy$default$2();
        return this.copy(x$36, x$37, (Option<String>)x$35);
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(t, level) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncTimestamp(BoxesRunTime.unboxToLong((Object)t), BoxesRunTime.unboxToInt((Object)level), this.timeZone())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), true, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(21).append("truncTimestamp(").append((String)date).append(", ").append((String)fmt).append(", ").append(tz).append(");").toString());
    }

    public TruncTimestamp copy(Expression format, Expression timestamp, Option<String> timeZoneId) {
        return new TruncTimestamp(format, timestamp, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.format();
    }

    public Expression copy$default$2() {
        return this.timestamp();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TruncTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.format();
                break;
            }
            case 1: {
                option = this.timestamp();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncTimestamp truncTimestamp = (TruncTimestamp)x$1;
        Expression expression = this.format();
        Expression expression2 = truncTimestamp.format();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = truncTimestamp.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = truncTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncTimestamp.canEqual(this)) return false;
        return true;
    }

    public TruncTimestamp(Expression format, Expression timestamp, Option<String> timeZoneId) {
        this.format = format;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        this.instant = timestamp;
    }

    public TruncTimestamp(Expression format, Expression timestamp) {
        this(format, timestamp, (Option<String>)None$.MODULE$);
    }
}

