/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TruncDate$;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date, fmt) - Returns `date` with the time portion of the day truncated to the unit specified by the format model `fmt`.\n    `fmt` should be one of [\"year\", \"yyyy\", \"yy\", \"mon\", \"month\", \"mm\"]\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-02-12', 'MM');\n       2009-02-01\n      > SELECT _FUNC_('2015-10-27', 'YEAR');\n       2015-01-01\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001>\u0011\u0011\u0002\u0016:v]\u000e$\u0015\r^3\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\u0007UeVt7-\u00138ti\u0006tG\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00023bi\u0016,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015!\u0017\r^3!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013A\u00024pe6\fG\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u001d1wN]7bi\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00181cA\u0011\u0011\u0003\u0001\u0005\u0006C1\u0002\ra\t\u0005\u0006S1\u0002\ra\t\u0005\u0006g\u0001!\tEI\u0001\u0005Y\u00164G\u000fC\u00036\u0001\u0011\u0005#%A\u0003sS\u001eDG\u000fC\u00038\u0001\u0011\u0005\u0003(\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u000f\t\u0004u\t+eBA\u001eA\u001d\tat(D\u0001>\u0015\tqd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011\u0011)G\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EIA\u0002TKFT!!Q\r\u0011\u0005\u0019KU\"A$\u000b\u0005!3\u0011!\u0002;za\u0016\u001c\u0018B\u0001&H\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003M\u0001\u0011\u0005S*\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0005C\u0001$P\u0013\t\u0001vI\u0001\u0005ECR\fG+\u001f9f\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002)B\u0011Q+\u0017\b\u0003-^\u0003\"\u0001P\r\n\u0005aK\u0012A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W\r\t\u000fu\u0003!\u0019!C!E\u00059\u0011N\\:uC:$\bBB0\u0001A\u0003%1%\u0001\u0005j]N$\u0018M\u001c;!\u0011\u0015\t\u0007\u0001\"\u0011c\u0003\u0011)g/\u00197\u0015\u0005\r4\u0007C\u0001\re\u0013\t)\u0017DA\u0002B]fDqa\u001a1\u0011\u0002\u0003\u0007\u0001.A\u0003j]B,H\u000f\u0005\u0002jU6\tA!\u0003\u0002l\t\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015i\u0007\u0001\"\u0011o\u0003%!wnR3o\u0007>$W\rF\u0002pkj\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0002\u0002\u000f\r|G-Z4f]&\u0011A/\u001d\u0002\t\u000bb\u0004(oQ8eK\")a\u000f\u001ca\u0001o\u0006\u00191\r\u001e=\u0011\u0005AD\u0018BA=r\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa\u001f7A\u0002=\f!!\u001a<\t\u000fu\u0004\u0011\u0011!C\u0001}\u0006!1m\u001c9z)\u0011ys0!\u0001\t\u000f\u0005b\b\u0013!a\u0001G!9\u0011\u0006 I\u0001\u0002\u0004\u0019\u0003\"CA\u0003\u0001E\u0005I\u0011AA\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0003+\u0007\r\nYa\u000b\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011!C;oG\",7m[3e\u0015\r\t9\"G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000e\u0003#\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\u0002AI\u0001\n\u0003\t9!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\r\u0002!!A\u0005B\u0005\u0015\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027b]\u001eT!!!\r\u0002\t)\fg/Y\u0005\u00045\u0006-\u0002\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0004E\u0002\u0019\u0003{I1!a\u0010\u001a\u0005\rIe\u000e\u001e\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000b\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002d\u0003\u000fB!\"!\u0013\u0002B\u0005\u0005\t\u0019AA\u001e\u0003\rAH%\r\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001f\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0002R!a\u0015\u0002Z\rl!!!\u0016\u000b\u0007\u0005]\u0013$\u0001\u0006d_2dWm\u0019;j_:LA!a\u0017\u0002V\tA\u0011\n^3sCR|'\u000fC\u0005\u0002`\u0001\t\t\u0011\"\u0001\u0002b\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002d\u0005%\u0004c\u0001\r\u0002f%\u0019\u0011qM\r\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011JA/\u0003\u0003\u0005\ra\u0019\u0005\n\u0003[\u0002\u0011\u0011!C!\u0003_\na!Z9vC2\u001cH\u0003BA2\u0003cB\u0011\"!\u0013\u0002l\u0005\u0005\t\u0019A2)\u001f\u0001\t)(a\u001f\u0002~\u0005\u0005\u00151QAD\u0003\u0013\u00032!EA<\u0013\r\tIH\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty(AAO\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b3bi\u0016d\u0003EZ7uS\u0001j\u0003EU3ukJt7\u000f\t1eCR,\u0007\rI<ji\"\u0004C\u000f[3!i&lW\r\t9peRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011eCf\u0004CO];oG\u0006$X\r\u001a\u0011u_\u0002\"\b.\u001a\u0011v]&$\be\u001d9fG&4\u0017.\u001a3!Ef\u0004C\u000f[3!M>\u0014X.\u0019;![>$W\r\u001c\u0011aM6$\bM\f\u0006!A\u0001\u0002\u0003MZ7uA\u0002\u001a\bn\\;mI\u0002\u0012W\rI8oK\u0002zg\rI.#s\u0016\f'O\t\u0017!EeL\u00180\u001f\u0012-A\tJ\u0018P\t\u0017!E5|gN\t\u0017!E5|g\u000e\u001e5#Y\u0001\u0012S.\u001c\u0012^\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0015!a\u0007\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004\u0007M\u001d.aIj\u0013GM\u0014-A\u001djUjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0004'O\u00171e5\u0002\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nT'L\u00191[I:t\u0005\f\u0011(3\u0016\u000b%kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171c5\u0002\u0014G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY)A\u00032]Ur\u0003gB\u0005\u0002\u0010\n\t\t\u0011#\u0001\u0002\u0012\u0006IAK];oG\u0012\u000bG/\u001a\t\u0004#\u0005Me\u0001C\u0001\u0003\u0003\u0003E\t!!&\u0014\u000b\u0005M\u0015qS\u000f\u0011\u000f\u0005e\u0015qT\u0012$_5\u0011\u00111\u0014\u0006\u0004\u0003;K\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003C\u000bYJA\tBEN$(/Y2u\rVt7\r^5p]JBq!LAJ\t\u0003\t)\u000b\u0006\u0002\u0002\u0012\"Q\u0011\u0011VAJ\u0003\u0003%)%a+\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\n\t\u0015\u0005=\u00161SA\u0001\n\u0003\u000b\t,A\u0003baBd\u0017\u0010F\u00030\u0003g\u000b)\f\u0003\u0004\"\u0003[\u0003\ra\t\u0005\u0007S\u00055\u0006\u0019A\u0012\t\u0015\u0005e\u00161SA\u0001\n\u0003\u000bY,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0016\u0011\u001a\t\u00061\u0005}\u00161Y\u0005\u0004\u0003\u0003L\"AB(qi&|g\u000eE\u0003\u0019\u0003\u000b\u001c3%C\u0002\u0002Hf\u0011a\u0001V;qY\u0016\u0014\u0004\"CAf\u0003o\u000b\t\u00111\u00010\u0003\rAH\u0005\r\u0005\u000b\u0003\u001f\f\u0019*!A\u0005\n\u0005E\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a5\u0011\t\u0005%\u0012Q[\u0005\u0005\u0003/\fYC\u0001\u0004PE*,7\r\u001e")
public class TruncDate
extends BinaryExpression
implements TruncInstant,
scala.Serializable {
    private final Expression date;
    private final Expression format;
    private final Expression instant;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TruncDate truncDate) {
        return TruncDate$.MODULE$.unapply(truncDate);
    }

    public static Function1<Tuple2<Expression, Expression>, TruncDate> tupled() {
        return TruncDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TruncDate>> curried() {
        return TruncDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int maxLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, maxLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int maxLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, maxLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncDate truncDate = this;
        synchronized (truncDate) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    public Expression date() {
        return this.date;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.date();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(d, level) -> BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.truncDate(BoxesRunTime.unboxToInt((Object)d), BoxesRunTime.unboxToInt((Object)level))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), this.codeGenHelper$default$4(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(14).append("truncDate(").append((String)date).append(", ").append((String)fmt).append(");").toString());
    }

    public TruncDate copy(Expression date, Expression format) {
        return new TruncDate(date, format);
    }

    public Expression copy$default$1() {
        return this.date();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "TruncDate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.date();
                break;
            }
            case 1: {
                expression = this.format();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncDate truncDate = (TruncDate)x$1;
        Expression expression = this.date();
        Expression expression2 = truncDate.date();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = truncDate.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!truncDate.canEqual(this)) return false;
        return true;
    }

    public TruncDate(Expression date, Expression format) {
        this.date = date;
        this.format = format;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        this.instant = date;
    }
}

