/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the leading string contains the characters from the trim string\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('Sp', 'SSparkSQLS');\n       arkSQLS\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0001\u0003\u0011\u0003y\u0011AD*ue&tw\r\u0016:j[2+g\r\u001e\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\tq1\u000b\u001e:j]\u001e$&/[7MK\u001a$8cA\t\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"!F\u000e\n\u0005q1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0010\u0012\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u0015\t\u0013\u0003\"\u0001#\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u00131SAL!\t\u0001BE\u0002\u0003\u0013\u0005\u0001+3#\u0002\u0013'S1R\u0002C\u0001\t(\u0013\tA#A\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001\u0005\u0016\n\u0005-\u0012!!F*ue&twM\r+sS6,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003+5J!A\f\f\u0003\u000fA\u0013x\u000eZ;di\"A\u0001\u0007\nBK\u0002\u0013\u0005\u0011'\u0001\u0004te\u000e\u001cFO]\u000b\u0002M!A1\u0007\nB\tB\u0003%a%A\u0004te\u000e\u001cFO\u001d\u0011\t\u0011U\"#Q3A\u0005\u0002Y\nq\u0001\u001e:j[N#(/F\u00018!\r)\u0002HJ\u0005\u0003sY\u0011aa\u00149uS>t\u0007\u0002C\u001e%\u0005#\u0005\u000b\u0011B\u001c\u0002\u0011Q\u0014\u0018.\\*ue\u0002BQA\b\u0013\u0005\u0002u\"2a\t @\u0011\u0015\u0001D\b1\u0001'\u0011\u001d)D\b%AA\u0002]BQA\b\u0013\u0005\u0002\u0005#2a\t\"D\u0011\u0015)\u0004\t1\u0001'\u0011\u0015\u0001\u0004\t1\u0001'\u0011\u0015qB\u0005\"\u0001F)\t\u0019c\tC\u00031\t\u0002\u0007a\u0005C\u0003II\u0011\u0005\u0013*\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0013\t\u0003\u0017Js!\u0001\u0014)\u0011\u000553R\"\u0001(\u000b\u0005=s\u0011A\u0002\u001fs_>$h(\u0003\u0002R-\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\tf\u0003C\u0003WI\u0011\u0005s+\u0001\u0005dQ&dGM]3o+\u0005A\u0006cA-_M9\u0011!\f\u0018\b\u0003\u001bnK\u0011aF\u0005\u0003;Z\tq\u0001]1dW\u0006<W-\u0003\u0002`A\n\u00191+Z9\u000b\u0005u3\u0002\"\u00022%\t\u0003\u001a\u0017\u0001B3wC2$\"\u0001Z4\u0011\u0005U)\u0017B\u00014\u0017\u0005\r\te.\u001f\u0005\bQ\u0006\u0004\n\u00111\u0001j\u0003\u0015Ig\u000e];u!\tQ7.D\u0001\u0005\u0013\taGAA\u0006J]R,'O\\1m%><\b\"\u00028%\t#z\u0017!\u00033p\u000f\u0016t7i\u001c3f)\r\u0001ho\u001f\t\u0003cRl\u0011A\u001d\u0006\u0003g\n\tqaY8eK\u001e,g.\u0003\u0002ve\nAQ\t\u001f9s\u0007>$W\rC\u0003x[\u0002\u0007\u00010A\u0002dib\u0004\"!]=\n\u0005i\u0014(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006y6\u0004\r\u0001]\u0001\u0003KZDqA \u0013\u0002\u0002\u0013\u0005q0\u0001\u0003d_BLH#B\u0012\u0002\u0002\u0005\r\u0001b\u0002\u0019~!\u0003\u0005\rA\n\u0005\bku\u0004\n\u00111\u00018\u0011%\t9\u0001JI\u0001\n\u0003\tI!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-!f\u0001\u0014\u0002\u000e-\u0012\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001aY\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti\"a\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\"\u0011\n\n\u0011\"\u0001\u0002$\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0013U\r9\u0014Q\u0002\u0005\n\u0003S!\u0013\u0011!C!\u0003W\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0017!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\tA\u0001\\1oO*\u0011\u0011qG\u0001\u0005U\u00064\u0018-C\u0002T\u0003cA\u0011\"!\u0010%\u0003\u0003%\t!a\u0010\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0003cA\u000b\u0002D%\u0019\u0011Q\t\f\u0003\u0007%sG\u000fC\u0005\u0002J\u0011\n\t\u0011\"\u0001\u0002L\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00013\u0002N!Q\u0011qJA$\u0003\u0003\u0005\r!!\u0011\u0002\u0007a$\u0013\u0007C\u0005\u0002T\u0011\n\t\u0011\"\u0011\u0002V\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002XA)\u0011\u0011LA0I6\u0011\u00111\f\u0006\u0004\u0003;2\u0012AC2pY2,7\r^5p]&!\u0011\u0011MA.\u0005!IE/\u001a:bi>\u0014\b\"CA3I\u0005\u0005I\u0011AA4\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA5\u0003_\u00022!FA6\u0013\r\tiG\u0006\u0002\b\u0005>|G.Z1o\u0011%\ty%a\u0019\u0002\u0002\u0003\u0007A\rC\u0005\u0002t\u0011\n\t\u0011\"\u0011\u0002v\u00051Q-];bYN$B!!\u001b\u0002x!I\u0011qJA9\u0003\u0003\u0005\r\u0001\u001a\u0015\u0010I\u0005m\u0014\u0011QAB\u0003\u000f\u000bI)!$\u0002\u0010B\u0019\u0001#! \n\u0007\u0005}$AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0015!!\u0016\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\"(/[7TiJd\u0003e\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u00043\u000f\u001e:j]\u001e\u00043m\u001c8uC&t7\u000f\t;iK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005\u001e5fAQ\u0014\u0018.\u001c\u0011tiJLgn\u001a\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u0017\u000b\u0011Q\u0004\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!iJLWn\u0015;sA5\u0002C\u000f[3!iJLW\u000eI:ue&tw\rI2iCJ\f7\r^3sg\u0002\"x\u000e\t;sS6d\u0003\u0005\u001e5fA\u0011,g-Y;mi\u00022\u0018\r\\;fA%\u001c\b%\u0019\u0011tS:<G.\u001a\u0011ta\u0006\u001cWM\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAI\u0003\u0005-!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003x\u0005\f\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!CJ\\7+\u0015'T\u0015\u0001\u0002\u0003BBAKA\u0001\u0007a%A\u0002tiJDQ!\u000e\u0011A\u0002\u0019Ba!I\t\u0005\u0002\u0005mEcA\u0012\u0002\u001e\"9\u0011QSAM\u0001\u00041\u0003\u0002C\u0011\u0012\u0003\u0003%\t)!)\u0015\u000b\r\n\u0019+!*\t\rA\ny\n1\u0001'\u0011!)\u0014q\u0014I\u0001\u0002\u00049\u0004\"CAU#\u0005\u0005I\u0011QAV\u0003\u001d)h.\u00199qYf$B!!,\u00026B!Q\u0003OAX!\u0015)\u0012\u0011\u0017\u00148\u0013\r\t\u0019L\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005]\u0016qUA\u0001\u0002\u0004\u0019\u0013a\u0001=%a!I\u00111X\t\u0012\u0002\u0013\u0005\u00111E\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005}\u0016#%A\u0005\u0002\u0005\r\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\r\u0017#!A\u0005\n\u0005\u0015\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a2\u0011\t\u0005=\u0012\u0011Z\u0005\u0005\u0003\u0017\f\tD\u0001\u0004PE*,7\r\u001e")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimLeft((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimLeft());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimLeftFunction = new StringBuilder(88).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimLeft(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimLeftFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

