/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       map(\"a\":\"1\",\"b\":\"2\",\"c\":\"3\")\n      > SELECT _FUNC_('a');\n       map(\"a\":null)\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001>\u00111b\u0015;sS:<Gk\\'ba*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001!QQRd\t\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t)\u0002$D\u0001\u0017\u0015\t9\"!A\u0004d_\u0012,w-\u001a8\n\u0005e1\"aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005EY\u0012B\u0001\u000f\u0003\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b!J|G-^2u!\tqB%\u0003\u0002&?\ta1+\u001a:jC2L'0\u00192mK\"Aq\u0005\u0001BK\u0002\u0013\u0005\u0001&\u0001\u0003uKb$X#A\u0015\u0011\u0005EQ\u0013BA\u0016\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t[\u0001\u0011\t\u0012)A\u0005S\u0005)A/\u001a=uA!Aq\u0006\u0001BK\u0002\u0013\u0005\u0001&A\u0005qC&\u0014H)\u001a7j[\"A\u0011\u0007\u0001B\tB\u0003%\u0011&\u0001\u0006qC&\u0014H)\u001a7j[\u0002B\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u000eW\u0016Lh+\u00197vK\u0012+G.[7\t\u0011U\u0002!\u0011#Q\u0001\n%\nab[3z-\u0006dW/\u001a#fY&l\u0007\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0005siZD\b\u0005\u0002\u0012\u0001!)qE\u000ea\u0001S!)qF\u000ea\u0001S!)1G\u000ea\u0001S!)q\u0007\u0001C\u0001}Q\u0019\u0011hP!\t\u000b\u0001k\u0004\u0019A\u0015\u0002\u000b\rD\u0017\u000e\u001c3\t\u000b=j\u0004\u0019A\u0015\t\u000b]\u0002A\u0011A\"\u0015\u0005e\"\u0005\"\u0002!C\u0001\u0004I\u0003\"\u0002$\u0001\t\u0003:\u0015\u0001C2iS2$'/\u001a8\u0016\u0003!\u00032!S)*\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizJ\u0011\u0001I\u0005\u0003!~\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A{\u0002\"B+\u0001\t\u00032\u0016AC5oaV$H+\u001f9fgV\tq\u000bE\u0002J#b\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u0004\u0002\u000bQL\b/Z:\n\u0005uS&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015y\u0006\u0001\"\u0011a\u0003!!\u0017\r^1UsB,W#A1\u0011\u0005e\u0013\u0017BA2[\u0005!!\u0015\r^1UsB,\u0007\"B3\u0001\t\u00032\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A4\u0011\u0005!\\W\"A5\u000b\u0005)$\u0011\u0001C1oC2L8/[:\n\u00051L'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000b9\u0004A\u0011I8\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\tA\u001cXo\u001e\t\u0003=EL!A]\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003u[\u0002\u0007\u0001/A\u0006j]B,Ho\u0015;sS:<\u0007\"\u0002<n\u0001\u0004\u0001\u0018aD:ue&tw\rR3mS6LG/\u001a:\t\u000bal\u0007\u0019\u00019\u0002#-,\u0017PV1mk\u0016$U\r\\5nSR,'\u000fC\u0003{\u0001\u0011\u000530\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001 \t\u0004{\u0006\raB\u0001@\u0000!\tYu$C\u0002\u0002\u0002}\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001?!I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011QB\u0001\u0005G>\u0004\u0018\u0010F\u0004:\u0003\u001f\t\t\"a\u0005\t\u0011\u001d\nI\u0001%AA\u0002%B\u0001bLA\u0005!\u0003\u0005\r!\u000b\u0005\tg\u0005%\u0001\u0013!a\u0001S!I\u0011q\u0003\u0001\u0012\u0002\u0013\u0005\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYBK\u0002*\u0003;Y#!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Sy\u0012AC1o]>$\u0018\r^5p]&!\u0011QFA\u0012\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u00026\u0001\t\n\u0011\"\u0001\u0002\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0013\u0001\u00026bm\u0006LA!!\u0002\u0002B!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011qJ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003#\u00022AHA*\u0013\r\t)f\b\u0002\u0004\u0013:$\b\"CA-\u0001\u0005\u0005I\u0011AA.\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001]A/\u0011)\ty&a\u0016\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0004q\u0012\n\u0004\"CA2\u0001\u0005\u0005I\u0011IA3\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA4!\u0015\tI'a\u001cq\u001b\t\tYGC\u0002\u0002n}\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t(a\u001b\u0003\u0011%#XM]1u_JD\u0011\"!\u001e\u0001\u0003\u0003%\t!a\u001e\u0002\u0011\r\fg.R9vC2$B!!\u001f\u0002\u0000A\u0019a$a\u001f\n\u0007\u0005utDA\u0004C_>dW-\u00198\t\u0013\u0005}\u00131OA\u0001\u0002\u0004\u0001\b\"CAB\u0001\u0005\u0005I\u0011IAC\u0003\u0019)\u0017/^1mgR!\u0011\u0011PAD\u0011%\ty&!!\u0002\u0002\u0003\u0007\u0001\u000fK\u0006\u0001\u0003\u0017\u000b\t*a%\u0002\u0018\u0006e\u0005cA\t\u0002\u000e&\u0019\u0011q\u0012\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QS\u0001\u0002\u0006~3UKT\"`QQ,\u0007\u0010^.-AA\f\u0017N\u001d#fY&l7\f\f\u0011lKf4\u0016\r\\;f\t\u0016d\u0017.\\/^S\u0001j\u0003e\u0011:fCR,7\u000fI1![\u0006\u0004\b%\u00194uKJ\u00043\u000f\u001d7jiRLgn\u001a\u0011uQ\u0016\u0004C/\u001a=uA%tGo\u001c\u0011lKf|c/\u00197vK\u0002\u0002\u0018-\u001b:tAU\u001c\u0018N\\4!I\u0016d\u0017.\\5uKJ\u001ch\u0006\t#fM\u0006,H\u000e\u001e\u0011eK2LW.\u001b;feN\u0004\u0013M]3!O1:\u0003EZ8sA\u0001\u0004\u0018-\u001b:EK2LW\u000e\u0019\u0011b]\u0012\u0004sEO\u0014!M>\u0014\b\u0005Y6fsZ\u000bG.^3EK2LW\u000e\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a'\u0002\u0003[Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1;c1\u0012'H\r\u0017duM:C\u0006I\u0014-O1\u0002sEO\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0017\r\u001d\u0015#C\nR$%\r\u0012-E\t\u0014#H\t\u001a#Y\t\u001a'E\u000f\u00124E%R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1(SmR\u0001\u0005\t\u0011!A\u0001\u0002S.\u00199)E\u0005\u0014#H\\;mY&R\u0001\u0005I\u0004\n\u0003?\u0013\u0011\u0011!E\u0001\u0003C\u000b1b\u0015;sS:<Gk\\'baB\u0019\u0011#a)\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003K\u001bR!a)\u0002(\u000e\u0002\u0002\"!+\u00020&J\u0013&O\u0007\u0003\u0003WS1!!, \u0003\u001d\u0011XO\u001c;j[\u0016LA!!-\u0002,\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f]\n\u0019\u000b\"\u0001\u00026R\u0011\u0011\u0011\u0015\u0005\u000b\u0003s\u000b\u0019+!A\u0005F\u0005m\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0002BCA`\u0003G\u000b\t\u0011\"!\u0002B\u0006)\u0011\r\u001d9msR9\u0011(a1\u0002F\u0006\u001d\u0007BB\u0014\u0002>\u0002\u0007\u0011\u0006\u0003\u00040\u0003{\u0003\r!\u000b\u0005\u0007g\u0005u\u0006\u0019A\u0015\t\u0015\u0005-\u00171UA\u0001\n\u0003\u000bi-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005=\u00171\u001c\t\u0006=\u0005E\u0017Q[\u0005\u0004\u0003'|\"AB(qi&|g\u000e\u0005\u0004\u001f\u0003/L\u0013&K\u0005\u0004\u00033|\"A\u0002+va2,7\u0007C\u0005\u0002^\u0006%\u0017\u0011!a\u0001s\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\u0005\u00181UA\u0001\n\u0013\t\u0019/A\u0006sK\u0006$'+Z:pYZ,GCAAs!\u0011\ty$a:\n\t\u0005%\u0018\u0011\t\u0002\u0007\u001f\nTWm\u0019;")
public class StringToMap
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$29))) ? new TypeCheckResult.TypeCheckFailure(new java.lang.StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        Iterator<Tuple2<UTF8String, UTF8String>> iterator = new Iterator<Tuple2<UTF8String, UTF8String>>(null, keyValueDelimiter, keyValues){
            private int index;
            private final UTF8String keyValueDelimiterUTF8String;
            private final UTF8String[] keyValues$1;

            public Iterator<Tuple2<UTF8String, UTF8String>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<UTF8String, UTF8String>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<UTF8String, UTF8String>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> filter(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<UTF8String, UTF8String>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> withFilter(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> filterNot(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<UTF8String, UTF8String>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> takeWhile(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> partition(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> span(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> dropWhile(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<UTF8String, UTF8String>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<UTF8String, UTF8String>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<UTF8String, UTF8String>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<UTF8String, UTF8String>> find(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<UTF8String, UTF8String>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<UTF8String, UTF8String>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<UTF8String, UTF8String>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<UTF8String, UTF8String>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public List<Tuple2<UTF8String, UTF8String>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<UTF8String, UTF8String>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<UTF8String, UTF8String>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<UTF8String, UTF8String>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<UTF8String, UTF8String>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<UTF8String, UTF8String>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<UTF8String, UTF8String>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<UTF8String, UTF8String>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<UTF8String, UTF8String>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Tuple2<UTF8String, UTF8String>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public int index() {
                return this.index;
            }

            public void index_$eq(int x$1) {
                this.index = x$1;
            }

            public UTF8String keyValueDelimiterUTF8String() {
                return this.keyValueDelimiterUTF8String;
            }

            public boolean hasNext() {
                return this.keyValues$1.length > this.index();
            }

            public Tuple2<UTF8String, UTF8String> next() {
                UTF8String[] keyValueArray = this.keyValues$1[this.index()].split(this.keyValueDelimiterUTF8String(), 2);
                this.index_$eq(this.index() + 1);
                return new Tuple2((Object)keyValueArray[0], keyValueArray.length < 2 ? null : keyValueArray[1]);
            }
            {
                this.keyValues$1 = keyValues$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.index = 0;
                this.keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter$1;
            }
        };
        return ArrayBasedMapData$.MODULE$.apply(iterator, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues)).size(), (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.text();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$29) {
        return !x$29.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

