/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len, pad) - Returns `str`, right-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       hi???\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001>\u0011!b\u0015;sS:<'\u000bU1e\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u0011)]i\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005\u00191\u000f\u001e:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0003tiJ\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u00071,g\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0011aWM\u001c\u0011\t\u00115\u0002!Q3A\u0005\u0002\t\n1\u0001]1e\u0011!y\u0003A!E!\u0002\u0013\u0019\u0013\u0001\u00029bI\u0002BQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD\u0003B\u001a5kY\u0002\"!\u0005\u0001\t\u000b\u0005\u0002\u0004\u0019A\u0012\t\u000b%\u0002\u0004\u0019A\u0012\t\u000b5\u0002\u0004\u0019A\u0012\t\u000ba\u0002A\u0011I\u001d\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u000f\t\u0004w\r\u001bcB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\tyd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011!)G\u0001\ba\u0006\u001c7.Y4f\u0013\t!UIA\u0002TKFT!AQ\r\t\u000b\u001d\u0003A\u0011\t%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u001a\tQ\u0001^=qKNL!AT&\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u0015\u0001\u0005BE\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\u0006cA\u001eD\u0013\")A\u000b\u0001C!+\u0006aa.\u001e7m'\u00064W-\u0012<bYR!a+\u0017.\\!\tAr+\u0003\u0002Y3\t\u0019\u0011I\\=\t\u000b\u0005\u001a\u0006\u0019\u0001,\t\u000b%\u001a\u0006\u0019\u0001,\t\u000b5\u001a\u0006\u0019\u0001,\t\u000bu\u0003A\u0011\u000b0\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA0fUB\u0011\u0001mY\u0007\u0002C*\u0011!MA\u0001\bG>$WmZ3o\u0013\t!\u0017M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151G\f1\u0001h\u0003\r\u0019G\u000f\u001f\t\u0003A\"L!![1\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u000e\u0018a\u0001?\u0006\u0011QM\u001e\u0005\u0006[\u0002!\tE\\\u0001\u000baJ,G\u000f^=OC6,W#A8\u0011\u0005A$hBA9s!\ti\u0014$\u0003\u0002t3\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019\u0018\u0004C\u0004y\u0001\u0005\u0005I\u0011A=\u0002\t\r|\u0007/\u001f\u000b\u0005gi\\H\u0010C\u0004\"oB\u0005\t\u0019A\u0012\t\u000f%:\b\u0013!a\u0001G!9Qf\u001eI\u0001\u0002\u0004\u0019\u0003b\u0002@\u0001#\u0003%\ta`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tAK\u0002$\u0003\u0007Y#!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001fI\u0012AC1o]>$\u0018\r^5p]&!\u00111CA\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\t\u0003/\u0001\u0011\u0013!C\u0001\u007f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\u0002CA\u000e\u0001E\u0005I\u0011A@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0013\u0011E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0005Y\u0006twM\u0003\u0002\u0002.\u0005!!.\u0019<b\u0013\r)\u0018q\u0005\u0005\n\u0003g\u0001\u0011\u0011!C\u0001\u0003k\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000e\u0011\u0007a\tI$C\u0002\u0002<e\u00111!\u00138u\u0011%\ty\u0004AA\u0001\n\u0003\t\t%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Y\u000b\u0019\u0005\u0003\u0006\u0002F\u0005u\u0012\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0011%\tI\u0005AA\u0001\n\u0003\nY%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0005E\u0003\u0002P\u0005Uc+\u0004\u0002\u0002R)\u0019\u00111K\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u0005E#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0013Q\r\t\u00041\u0005\u0005\u0014bAA23\t9!i\\8mK\u0006t\u0007\"CA#\u00033\n\t\u00111\u0001W\u0011%\tI\u0007AA\u0001\n\u0003\nY'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\ni\u0007C\u0005\u0002F\u0005\u001d\u0014\u0011!a\u0001-\"Z\u0001!!\u001d\u0002x\u0005e\u0014QPA@!\r\t\u00121O\u0005\u0004\u0003k\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003w\n\u0011\u0011\u000e\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-A1,g\u000e\f\u0011qC\u0012L\u0003%\f\u0011SKR,(O\\:!AN$(\u000f\u0019\u0017!e&<\u0007\u000e^\u0017qC\u0012$W\r\u001a\u0011xSRD\u0007\u0005\u00199bI\u0002\u0004Co\u001c\u0011bA1,gn\u001a;iA=4\u0007\u0005\u00197f]\u0002t#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011agR\u0014\b\rI5tA1|gnZ3sAQD\u0017M\u001c\u0011aY\u0016t\u0007\r\f\u0011uQ\u0016\u0004#/\u001a;ve:\u0004c/\u00197vK\u0002J7\u000fI:i_J$XM\\3eAQ|\u0007\u0005\u00197f]\u0002\u00043\r[1sC\u000e$XM]:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0015a\u001d\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00116Y\u0001:shP\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001B\u0017nP @\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003.[\u0014-AEb\u0003eJ @O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001b\u0006!A\u001dI\u0011Q\u0011\u0002\u0002\u0002#\u0005\u0011qQ\u0001\u000b'R\u0014\u0018N\\4S!\u0006$\u0007cA\t\u0002\n\u001aA\u0011AAA\u0001\u0012\u0003\tYiE\u0003\u0002\n\u00065U\u0004\u0005\u0005\u0002\u0010\u0006U5eI\u00124\u001b\t\t\tJC\u0002\u0002\u0014f\tqA];oi&lW-\u0003\u0003\u0002\u0018\u0006E%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9\u0011'!#\u0005\u0002\u0005mECAAD\u0011)\ty*!#\u0002\u0002\u0013\u0015\u0013\u0011U\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0005\u0005\u000b\u0003K\u000bI)!A\u0005\u0002\u0006\u001d\u0016!B1qa2LHcB\u001a\u0002*\u0006-\u0016Q\u0016\u0005\u0007C\u0005\r\u0006\u0019A\u0012\t\r%\n\u0019\u000b1\u0001$\u0011\u0019i\u00131\u0015a\u0001G!Q\u0011\u0011WAE\u0003\u0003%\t)a-\u0002\u000fUt\u0017\r\u001d9msR!\u0011QWAa!\u0015A\u0012qWA^\u0013\r\tI,\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ra\tilI\u0012$\u0013\r\ty,\u0007\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005\r\u0017qVA\u0001\u0002\u0004\u0019\u0014a\u0001=%a!Q\u0011qYAE\u0003\u0003%I!!3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u0004B!!\n\u0002N&!\u0011qZA\u0014\u0005\u0019y%M[3di\u0002")
public class StringRPad
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringRPad stringRPad) {
        return StringRPad$.MODULE$.unapply(stringRPad);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringRPad> tupled() {
        return StringRPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringRPad>>> curried() {
        return StringRPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).rpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".rpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "rpad";
    }

    public StringRPad copy(Expression str, Expression len, Expression pad) {
        return new StringRPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringRPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRPad stringRPad = (StringRPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringRPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringRPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringRPad.canEqual(this)) return false;
        return true;
    }

    public StringRPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }
}

