/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    The function returns -1 if its input is null and spark.sql.legacy.sizeOfNull is set to true.\n    If spark.sql.legacy.sizeOfNull is set to false, the function returns null for null input.\n    By default, the spark.sql.legacy.sizeOfNull parameter is set to true.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n      > SELECT _FUNC_(NULL);\n       -1\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001>\u0011AaU5{K*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\nQa\u00195jY\u0012,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0019\u0007.\u001b7eA!)\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005E\u0001\u0001\"B\u0011)\u0001\u0004\u0019\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0011Y\u0016<\u0017mY=TSj,wJ\u001a(vY2,\u0012\u0001\r\t\u00031EJ!AM\r\u0003\u000f\t{w\u000e\\3b]\"1A\u0007\u0001Q\u0001\nA\n\u0011\u0003\\3hC\u000eL8+\u001b>f\u001f\u001atU\u000f\u001c7!\u0011\u00151\u0004\u0001\"\u00118\u0003!!\u0017\r^1UsB,W#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0011!\u0002;za\u0016\u001c\u0018BA\u001f;\u0005!!\u0015\r^1UsB,\u0007\"B \u0001\t\u0003\u0002\u0015AC5oaV$H+\u001f9fgV\t\u0011\tE\u0002C\u00156s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019s\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tI\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%aA*fc*\u0011\u0011*\u0007\t\u0003s9K!a\u0014\u001e\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B)\u0001\t\u0003z\u0013\u0001\u00038vY2\f'\r\\3\t\u000bM\u0003A\u0011\t+\u0002\t\u00154\u0018\r\u001c\u000b\u0003+b\u0003\"\u0001\u0007,\n\u0005]K\"aA!os\"9\u0011L\u0015I\u0001\u0002\u0004Q\u0016!B5oaV$\bCA.]\u001b\u0005!\u0011BA/\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b}\u0003A\u0011\t1\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA1hYB\u0011!-Z\u0007\u0002G*\u0011AMA\u0001\bG>$WmZ3o\u0013\t17M\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015Ag\f1\u0001j\u0003\r\u0019G\u000f\u001f\t\u0003E*L!a[2\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")QN\u0018a\u0001C\u0006\u0011QM\u001e\u0005\b_\u0002\t\t\u0011\"\u0001q\u0003\u0011\u0019w\u000e]=\u0015\u0005-\n\bbB\u0011o!\u0003\u0005\ra\t\u0005\bg\u0002\t\n\u0011\"\u0001u\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001e\u0016\u0003GY\\\u0013a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005qL\u0012AC1o]>$\u0018\r^5p]&\u0011a0\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0001\u0001\u0005\u0005I\u0011IA\u0002\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0011\u0001\u00026bm\u0006LA!a\u0005\u0002\n\t11\u000b\u001e:j]\u001eD\u0011\"a\u0006\u0001\u0003\u0003%\t!!\u0007\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0001c\u0001\r\u0002\u001e%\u0019\u0011qD\r\u0003\u0007%sG\u000fC\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&\u0005q\u0001O]8ek\u000e$X\t\\3nK:$HcA+\u0002(!Q\u0011\u0011FA\u0011\u0003\u0003\u0005\r!a\u0007\u0002\u0007a$\u0013\u0007C\u0005\u0002.\u0001\t\t\u0011\"\u0011\u00020\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00022A)\u00111GA\u001d+6\u0011\u0011Q\u0007\u0006\u0004\u0003oI\u0012AC2pY2,7\r^5p]&!\u00111HA\u001b\u0005!IE/\u001a:bi>\u0014\b\"CA \u0001\u0005\u0005I\u0011AA!\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001\u0019\u0002D!I\u0011\u0011FA\u001f\u0003\u0003\u0005\r!\u0016\u0005\n\u0003\u000f\u0002\u0011\u0011!C!\u0003\u0013\na!Z9vC2\u001cHc\u0001\u0019\u0002L!I\u0011\u0011FA#\u0003\u0003\u0005\r!\u0016\u0015\f\u0001\u0005=\u0013QKA,\u00037\ni\u0006E\u0002\u0012\u0003#J1!a\u0015\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0017\u0002\u0005\u001bS\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tSj,\u0007e\u001c4!C:\u0004\u0013M\u001d:bs\u0002z'\u000fI1![\u0006\u0004hF\u0003\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002j\u0013\u0007I5gA%$8\u000fI5oaV$\b%[:!]VdG\u000eI1oI\u0002\u001a\b/\u0019:l]M\fHN\f7fO\u0006\u001c\u0017PL:ju\u0016|eMT;mY\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016t#\u0002\t\u0011!A%3\u0007e\u001d9be.t3/\u001d7/Y\u0016<\u0017mY=/g&TXm\u00144Ok2d\u0007%[:!g\u0016$\b\u0005^8!M\u0006d7/\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0011sKR,(O\\:!]VdG\u000e\t4pe\u0002rW\u000f\u001c7!S:\u0004X\u000f\u001e\u0018\u000bA\u0001\u0002\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001\"\b.\u001a\u0011ta\u0006\u00148NL:rY:bWmZ1ds:\u001a\u0018N_3PM:+H\u000e\u001c\u0011qCJ\fW.\u001a;fe\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u0018\u0002\u0003#R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDsEY\u0014-A\u001d\"w\u0005\f\u0011(G\u001eb\u0003eJ1(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[\u0006\u0004\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006FT+M\u0019&Z$\u0002\t\u0011!A\u0001\u0002\u0003%L\u0019\u000bA\u0001:\u0011\"a\u0019\u0003\u0003\u0003E\t!!\u001a\u0002\tMK'0\u001a\t\u0004#\u0005\u001dd\u0001C\u0001\u0003\u0003\u0003E\t!!\u001b\u0014\u000b\u0005\u001d\u00141N\u000f\u0011\r\u00055\u00141O\u0012,\u001b\t\tyGC\u0002\u0002re\tqA];oi&lW-\u0003\u0003\u0002v\u0005=$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9\u0011&a\u001a\u0005\u0002\u0005eDCAA3\u0011)\ti(a\u001a\u0002\u0002\u0013\u0015\u0013qP\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0001\u0005\u000b\u0003\u0007\u000b9'!A\u0005\u0002\u0006\u0015\u0015!B1qa2LHcA\u0016\u0002\b\"1\u0011%!!A\u0002\rB!\"a#\u0002h\u0005\u0005I\u0011QAG\u0003\u001d)h.\u00199qYf$B!a$\u0002\u0016B!\u0001$!%$\u0013\r\t\u0019*\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005]\u0015\u0011RA\u0001\u0002\u0004Y\u0013a\u0001=%a!Q\u00111TA4\u0003\u0003%I!!(\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0003B!a\u0002\u0002\"&!\u00111UA\u0005\u0005\u0019y%M[3di\u0002")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Expression> unapply(Size size) {
        return Size$.MODULE$.unapply(size);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Size, A> function1) {
        return Size$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Size> compose(Function1<A, Expression> function1) {
        return Size$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$}))}));
    }

    @Override
    public boolean nullable() {
        return this.legacySizeOfNull() ? false : super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Integer n;
        Object value = this.child().eval(input);
        if (value == null) {
            n = this.legacySizeOfNull() ? BoxesRunTime.boxToInteger((int)-1) : null;
        } else {
            Integer n2;
            DataType dataType = this.child().dataType();
            if (dataType instanceof ArrayType) {
                n2 = BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
            } else if (dataType instanceof MapType) {
                n2 = BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(51).append("The size function doesn't support the operand type ").append(dataType.getClass().getCanonicalName()).toString());
            }
            n = n2;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append("(").append((String)c).append(").numElements()").toString());
        }
        return exprCode;
    }

    public Size copy(Expression child) {
        return new Size(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        this.legacySizeOfNull = SQLConf$.MODULE$.get().legacySizeOfNull();
    }
}

