/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp[, idx]) - Extracts a group that matches `regexp`.", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ")
@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B\u0001\u0003\u0001>\u0011QBU3h\u000bb\u0004X\t\u001f;sC\u000e$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004tk\nTWm\u0019;\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005tk\nTWm\u0019;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013A\u0002:fO\u0016D\b\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u001d\u0011XmZ3ya\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\u0004S\u0012D\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\t%$\u0007\u0010\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u0003#\u0001AQ!\t\u0019A\u0002\rBQ!\u000b\u0019A\u0002\rBQ!\f\u0019A\u0002\rBQ!\r\u0001\u0005\u0002a\"2aM\u001d<\u0011\u0015Qt\u00071\u0001$\u0003\u0005\u0019\b\"\u0002\u001f8\u0001\u0004\u0019\u0013!\u0001:\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0013y\u0014!\u00037bgR\u0014VmZ3y+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0015!\u0018\u0010]3t\u0015\t)\u0005\"\u0001\u0004v]N\fg-Z\u0005\u0003\u000f\n\u0013!\"\u0016+GqM#(/\u001b8h\u0011%I\u0005\u00011AA\u0002\u0013%!*A\u0007mCN$(+Z4fq~#S-\u001d\u000b\u0003\u0017:\u0003\"\u0001\u0007'\n\u00055K\"\u0001B+oSRDqa\u0014%\u0002\u0002\u0003\u0007\u0001)A\u0002yIEB\u0011\"\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002!\u0002\u00151\f7\u000f\u001e*fO\u0016D\b\u0005\u000b\u0002Q'B\u0011\u0001\u0004V\u0005\u0003+f\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0013A\u0016a\u00029biR,'O\\\u000b\u00023B\u0011!,Y\u0007\u00027*\u0011A,X\u0001\u0006e\u0016<W\r\u001f\u0006\u0003=~\u000bA!\u001e;jY*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012\\\u0005\u001d\u0001\u0016\r\u001e;fe:D\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\u0002\u0017A\fG\u000f^3s]~#S-\u001d\u000b\u0003\u0017\u001aDqaT2\u0002\u0002\u0003\u0007\u0011\fC\u0005i\u0001\u0001\u0007\t\u0011)Q\u00053\u0006A\u0001/\u0019;uKJt\u0007\u0005\u000b\u0002h'\")1\u000e\u0001C!Y\u0006aa.\u001e7m'\u00064W-\u0012<bYR!Q\u000e]9t!\tAb.\u0003\u0002p3\t\u0019\u0011I\\=\t\u000biR\u0007\u0019A7\t\u000bIT\u0007\u0019A7\u0002\u0003ADQ\u0001\u00106A\u00025DQ!\u001e\u0001\u0005BY\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002oB\u0011\u0001P_\u0007\u0002s*\u00111IB\u0005\u0003wf\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\u0006{\u0002!\tE`\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A@\u0011\r\u0005\u0005\u0011\u0011CA\f\u001d\u0011\t\u0019!!\u0004\u000f\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u000f\u0003\u0019a$o\\8u}%\t!$C\u0002\u0002\u0010e\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0005U!aA*fc*\u0019\u0011qB\r\u0011\u0007a\fI\"C\u0002\u0002\u001ce\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005A1\r[5mIJ,g.\u0006\u0002\u0002$A)\u0011\u0011AA\tG!9\u0011q\u0005\u0001\u0005B\u0005%\u0012A\u00039sKR$\u0018PT1nKV\u0011\u00111\u0006\t\u0005\u0003[\t)D\u0004\u0003\u00020\u0005E\u0002cAA\u00033%\u0019\u00111G\r\u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019$\u0007\u0005\b\u0003{\u0001A\u0011KA \u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002B\u00055\u0013q\u000b\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0002\u0002\u000f\r|G-Z4f]&!\u00111JA#\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\u0002CA(\u0003w\u0001\r!!\u0015\u0002\u0007\r$\b\u0010\u0005\u0003\u0002D\u0005M\u0013\u0002BA+\u0003\u000b\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0005\u0002Z\u0005m\u0002\u0019AA!\u0003\t)g\u000fC\u0005\u0002^\u0001\t\t\u0011\"\u0001\u0002`\u0005!1m\u001c9z)\u001d\u0019\u0014\u0011MA2\u0003KB\u0001\"IA.!\u0003\u0005\ra\t\u0005\tS\u0005m\u0003\u0013!a\u0001G!AQ&a\u0017\u0011\u0002\u0003\u00071\u0005C\u0005\u0002j\u0001\t\n\u0011\"\u0001\u0002l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA7U\r\u0019\u0013qN\u0016\u0003\u0003c\u0002B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0005v]\u000eDWmY6fI*\u0019\u00111P\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0000\u0005U$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u0011\u0001\u0012\u0002\u0013\u0005\u00111N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t9\tAI\u0001\n\u0003\tY'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005-\u0005!!A\u0005B\u00055\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016~\u000bA\u0001\\1oO&!\u0011qGAJ\u0011%\tY\nAA\u0001\n\u0003\ti*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002 B\u0019\u0001$!)\n\u0007\u0005\r\u0016DA\u0002J]RD\u0011\"a*\u0001\u0003\u0003%\t!!+\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q.a+\t\u0013=\u000b)+!AA\u0002\u0005}\u0005\"CAX\u0001\u0005\u0005I\u0011IAY\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAZ!\u0015\t),a/n\u001b\t\t9LC\u0002\u0002:f\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti,a.\u0003\u0011%#XM]1u_JD\u0011\"!1\u0001\u0003\u0003%\t!a1\u0002\u0011\r\fg.R9vC2$B!!2\u0002LB\u0019\u0001$a2\n\u0007\u0005%\u0017DA\u0004C_>dW-\u00198\t\u0011=\u000by,!AA\u00025D\u0011\"a4\u0001\u0003\u0003%\t%!5\u0002\r\u0015\fX/\u00197t)\u0011\t)-a5\t\u0011=\u000bi-!AA\u00025D3\u0002AAl\u0003;\fy.a9\u0002fB\u0019\u0011#!7\n\u0007\u0005m'AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0005\u0018\u0001R0G+:\u001bu\fK:ue2\u0002#/Z4fqB\\F\u0006I5eqvK\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004sM]8va\u0002\"\b.\u0019;![\u0006$8\r[3tA\u0001\u0014XmZ3ya\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0018A\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OE\u0002\u0004'\f\u001a1a\u001db\u0003e\n\u0015]9\u0012\\\u0013&\f\u0015]9\u0012\\\u0013f\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00191\u0015\u0001\u0002s!CAv\u0005\u0005\u0005\t\u0012AAw\u00035\u0011VmZ#ya\u0016CHO]1diB\u0019\u0011#a<\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003c\u001cR!a<\u0002tv\u0001\u0002\"!>\u0002|\u000e\u001a3eM\u0007\u0003\u0003oT1!!?\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!!@\u0002x\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fE\ny\u000f\"\u0001\u0003\u0002Q\u0011\u0011Q\u001e\u0005\u000b\u0005\u000b\ty/!A\u0005F\t\u001d\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\u0005B\u0003B\u0006\u0003_\f\t\u0011\"!\u0003\u000e\u0005)\u0011\r\u001d9msR91Ga\u0004\u0003\u0012\tM\u0001BB\u0011\u0003\n\u0001\u00071\u0005\u0003\u0004*\u0005\u0013\u0001\ra\t\u0005\u0007[\t%\u0001\u0019A\u0012\t\u0015\t]\u0011q^A\u0001\n\u0003\u0013I\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm!q\u0005\t\u00061\tu!\u0011E\u0005\u0004\u0005?I\"AB(qi&|g\u000e\u0005\u0004\u0019\u0005G\u00193eI\u0005\u0004\u0005KI\"A\u0002+va2,7\u0007C\u0005\u0003*\tU\u0011\u0011!a\u0001g\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t5\u0012q^A\u0001\n\u0013\u0011y#A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0019!\u0011\t\tJa\r\n\t\tU\u00121\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpExtract
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract regExpExtract) {
        return RegExpExtract$.MODULE$.unapply(regExpExtract);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtract> tupled() {
        return RegExpExtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtract>>> curried() {
        return RegExpExtract$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression idx() {
        return this.idx;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        MatchResult mr;
        String group;
        Matcher m;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        return (m = this.pattern().matcher(s.toString())).find() ? ((group = (mr = m.toMatchResult()).group(BoxesRunTime.unboxToInt((Object)r))) == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group)) : UTF8String.EMPTY_UTF8;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.idx();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(476).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      java.util.regex.Matcher ").append(matcher).append(" =\n        ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n      if (").append(matcher).append(".find()) {\n        java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n        if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n          ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        } else {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append("));\n        }\n        ").append(setEvNotNull).append("\n      } else {\n        ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        ").append(setEvNotNull).append("\n      }").toString());
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
        ExpectsInputTypes.$init$(this);
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

