/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ regexp - Returns true if `str` matches `regexp`, or false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * regexp - a string expression. The pattern string should be a Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      When spark.sql.parser.escapedStringLiterals is disabled (default).\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\\\Users.*'\n      true\n\n      When spark.sql.parser.escapedStringLiterals is enabled.\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\Users.*'\n      true\n  ", note="\n    Use LIKE to match with simple string pattern.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001>\u0011QA\u0015'jW\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t)2\u000b\u001e:j]\u001e\u0014VmZ3y\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\tA\u0001\\3giV\t\u0001\u0005\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\u0011\u0002\u000b1,g\r\u001e\u0011\t\u0011\u0019\u0002!Q3A\u0005\u0002}\tQA]5hQRD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0007e&<\u0007\u000e\u001e\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003#\u0001AQAH\u0015A\u0002\u0001BQAJ\u0015A\u0002\u0001BQ\u0001\r\u0001\u0005BE\na!Z:dCB,GC\u0001\u001a>!\t\u0019$H\u0004\u00025qA\u0011QGF\u0007\u0002m)\u0011qGD\u0001\u0007yI|w\u000e\u001e \n\u0005e2\u0012A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\f\t\u000byz\u0003\u0019\u0001\u001a\u0002\u0003YDQ\u0001\u0011\u0001\u0005B\u0005\u000bq!\\1uG\",7\u000fF\u0002C\u000bB\u0003\"!F\"\n\u0005\u00113\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\r~\u0002\raR\u0001\u0006e\u0016<W\r\u001f\t\u0003\u0011:k\u0011!\u0013\u0006\u0003\r*S!a\u0013'\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty\u0015JA\u0004QCR$XM\u001d8\t\u000bE{\u0004\u0019\u0001\u001a\u0002\u0007M$(\u000fC\u0003T\u0001\u0011\u0005C+\u0001\u0005u_N#(/\u001b8h)\u0005\u0011\u0004\"\u0002,\u0001\t#:\u0016!\u00033p\u000f\u0016t7i\u001c3f)\rAfl\u0019\t\u00033rk\u0011A\u0017\u0006\u00037\n\tqaY8eK\u001e,g.\u0003\u0002^5\nAQ\t\u001f9s\u0007>$W\rC\u0003`+\u0002\u0007\u0001-A\u0002dib\u0004\"!W1\n\u0005\tT&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006IV\u0003\r\u0001W\u0001\u0003KZDqA\u001a\u0001\u0002\u0002\u0013\u0005q-\u0001\u0003d_BLHc\u0001\u0017iS\"9a$\u001aI\u0001\u0002\u0004\u0001\u0003b\u0002\u0014f!\u0003\u0005\r\u0001\t\u0005\bW\u0002\t\n\u0011\"\u0001m\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001c\u0016\u0003A9\\\u0013a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Q4\u0012AC1o]>$\u0018\r^5p]&\u0011a/\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002=\u0001#\u0003%\t\u0001\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001dQ\b!!A\u0005Bm\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyH*\u0001\u0003mC:<\u0017BA\u001e\u007f\u0011%\t)\u0001AA\u0001\n\u0003\t9!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\nA\u0019Q#a\u0003\n\u0007\u00055aCA\u0002J]RD\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QCA\u000e!\r)\u0012qC\u0005\u0004\u000331\"aA!os\"Q\u0011QDA\b\u0003\u0003\u0005\r!!\u0003\u0002\u0007a$\u0013\u0007C\u0005\u0002\"\u0001\t\t\u0011\"\u0011\u0002$\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002&A1\u0011qEA\u0017\u0003+i!!!\u000b\u000b\u0007\u0005-b#\u0001\u0006d_2dWm\u0019;j_:LA!a\f\u0002*\tA\u0011\n^3sCR|'\u000fC\u0005\u00024\u0001\t\t\u0011\"\u0001\u00026\u0005A1-\u00198FcV\fG\u000eF\u0002C\u0003oA!\"!\b\u00022\u0005\u0005\t\u0019AA\u000b\u0011%\tY\u0004AA\u0001\n\u0003\ni$\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0005\u0006}\u0002BCA\u000f\u0003s\t\t\u00111\u0001\u0002\u0016!\u001a\u0002!a\u0011\u0002J\u0005-\u0013qJA)\u0003+\n9&a\u0017\u0002^A\u0019\u0011#!\u0012\n\u0007\u0005\u001d#AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u00055\u0013aT:ue\u0002zf)\u0016(D?\u0002\u0012XmZ3ya\u0002j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011agR\u0014\b\rI7bi\u000eDWm\u001d\u0011ae\u0016<W\r\u001f9aY\u0001z'\u000f\t4bYN,\u0007e\u001c;iKJ<\u0018n]3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002T\u0005!iN\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sK\u001e,\u0007\u0010\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t9biR,'O\u001c\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n\u0007ES1wC\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I*j]\u000e,\u0007e\u00159be.\u0004#G\f\u0019-AM$(/\u001b8hA1LG/\u001a:bYN\u0004\u0003&\u001b8dYV$\u0017N\\4!e\u0016<W\r\u001f\u0011qCR$XM\u001d8tS\u0001\n'/\u001a\u0011v]\u0016\u001c8-\u00199fI\u0002Jg\u000eI8ve\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]:fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006I1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|g\u000e\t4pe\u0002\u0002'/Z4fqB\u0004\u0007eY1oA\t,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!EycF,\u00192dI\tr#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQCWM]3!SN\u0004\u0013\rI*R\u0019\u0002\u001awN\u001c4jO\u0002:3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:(AQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011vg\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c-\u00197mE\u0006\u001c7\u000e\t;pAQDW\rI*qCJ\\\u0007%\r\u00187A\t,\u0007.\u0019<j_J\u0004#/Z4be\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011mSR,'/\u00197!a\u0006\u00148/\u001b8h]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001b4!i\",\u0007eY8oM&<\u0007%[:!K:\f'\r\\3eY\u0001\"\b.\u001a\u0011ae\u0016<W\r\u001f9aAQD\u0017\r\u001e\u0011dC:\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE\u0001J7\u000f\t\u0012_9\u0006\u00147\r\n\u0012/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0013A!\"\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007e\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197tA%\u001c\b\u0005Z5tC\ndW\r\u001a\u0011)I\u00164\u0017-\u001e7uS9R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eJ\u0013TsN$X-\u001c#sSZ,W\u0005X+tKJ\u001cHLS8i]\u001e\u0002sLR+O\u0007~\u0003s%J*zgR,W\u000e\u0012:jm\u0016,C\fX+tKJ\u001chFK\u0014\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'B\u0003\u0011!A\u0001\u0002\u0003e\u00165f]\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn\u001d\u0011jg\u0002*g.\u00192mK\u0012t#\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/Vg\u0016\u00148\u000f\u0018&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006eJ\u0013TsN$X-\u001c#sSZ,W\u0005X+tKJ\u001chFK\u0014\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003?\nQG\u0003\u0011!A\u0001*6/\u001a\u0011M\u0013.+\u0005\u0005^8![\u0006$8\r\u001b\u0011xSRD\u0007e]5na2,\u0007e\u001d;sS:<\u0007\u0005]1ui\u0016\u0014hN\f\u0006!A\u001dI\u00111\r\u0002\u0002\u0002#\u0005\u0011QM\u0001\u0006%2K7.\u001a\t\u0004#\u0005\u001dd\u0001C\u0001\u0003\u0003\u0003E\t!!\u001b\u0014\u000b\u0005\u001d\u00141\u000e\u000e\u0011\u000f\u00055\u00141\u000f\u0011!Y5\u0011\u0011q\u000e\u0006\u0004\u0003c2\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003k\nyGA\tBEN$(/Y2u\rVt7\r^5p]JBqAKA4\t\u0003\tI\b\u0006\u0002\u0002f!I1+a\u001a\u0002\u0002\u0013\u0015\u0013Q\u0010\u000b\u0002y\"Q\u0011\u0011QA4\u0003\u0003%\t)a!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b1\n))a\"\t\ry\ty\b1\u0001!\u0011\u00191\u0013q\u0010a\u0001A!Q\u00111RA4\u0003\u0003%\t)!$\u0002\u000fUt\u0017\r\u001d9msR!\u0011qRAN!\u0015)\u0012\u0011SAK\u0013\r\t\u0019J\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\t9\n\t\u0011\n\u0007\u0005eeC\u0001\u0004UkBdWM\r\u0005\n\u0003;\u000bI)!AA\u00021\n1\u0001\u001f\u00131\u0011)\t\t+a\u001a\u0002\u0002\u0013%\u00111U\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002&B\u0019Q0a*\n\u0007\u0005%fP\u0001\u0004PE*,7\r\u001e")
public class RLike
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(RLike rLike) {
        return RLike$.MODULE$.unapply(rLike);
    }

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringBuilder(7).append(this.left()).append(" RLIKE ").append(this.right()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                String pattern = ctx.addMutableState(patternClass, "patternRLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            String pattern = ctx.freshName("pattern");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(112).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(").append(rightStr).append(");\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).find(0);\n        ").toString());
        }
        return exprCode;
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

