/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001>\u0011qAT3yi\u0012\u000b\u0017P\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0005ti\u0006\u0014H\u000fR1uKV\t1\u0005\u0005\u0002\u0012I%\u0011QE\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002C\u0014\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u0015M$\u0018M\u001d;ECR,\u0007\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003%!\u0017-_(g/\u0016,7\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003)!\u0017-_(g/\u0016,7\u000e\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!E\u0005!A.\u001a4u\u0011\u0015)\u0004\u0001\"\u0011#\u0003\u0015\u0011\u0018n\u001a5u\u0011\u00159\u0004\u0001\"\u00119\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002B3\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003f\u0001\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\u000bQL\b/Z:\n\u0005);%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015a\u0005\u0001\"\u0011N\u0003!!\u0017\r^1UsB,W#\u0001(\u0011\u0005\u0019{\u0015B\u0001)H\u0005!!\u0015\r^1UsB,\u0007\"\u0002*\u0001\t\u0003\u001a\u0016\u0001\u00038vY2\f'\r\\3\u0016\u0003Q\u0003\"\u0001G+\n\u0005YK\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061\u0002!\t%W\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00045v{\u0006C\u0001\r\\\u0013\ta\u0016DA\u0002B]fDQAX,A\u0002i\u000bQa\u001d;beRDQ\u0001Y,A\u0002i\u000ba\u0001Z1z\u001f\u001a<\u0006\"\u00022\u0001\t#\u001a\u0017!\u00033p\u000f\u0016t7i\u001c3f)\r!'n\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003O\n\tqaY8eK\u001e,g.\u0003\u0002jM\nAQ\t\u001f9s\u0007>$W\rC\u0003lC\u0002\u0007A.A\u0002dib\u0004\"!Z7\n\u000594'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006a\u0006\u0004\r\u0001Z\u0001\u0003KZDQA\u001d\u0001\u0005BM\f!\u0002\u001d:fiRLh*Y7f+\u0005!\bCA;z\u001d\t1x\u000f\u0005\u0002=3%\u0011\u00010G\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y3!9Q\u0010AA\u0001\n\u0003q\u0018\u0001B2paf$BaL@\u0002\u0002!9\u0011\u0005 I\u0001\u0002\u0004\u0019\u0003bB\u0015}!\u0003\u0005\ra\t\u0005\n\u0003\u000b\u0001\u0011\u0013!C\u0001\u0003\u000f\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\n)\u001a1%a\u0003,\u0005\u00055\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0006\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\t\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\b\u0001#\u0003%\t!a\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\u0005\u0001\u0002\u0002\u0013\u0005\u0013QE\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005Y\u0006twM\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\rQ\u00181\u0006\u0005\n\u0003o\u0001\u0011\u0011!C\u0001\u0003s\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000f\u0011\u0007a\ti$C\u0002\u0002@e\u00111!\u00138u\u0011%\t\u0019\u0005AA\u0001\n\u0003\t)%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007i\u000b9\u0005\u0003\u0006\u0002J\u0005\u0005\u0013\u0011!a\u0001\u0003w\t1\u0001\u001f\u00132\u0011%\ti\u0005AA\u0001\n\u0003\ny%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0006E\u0003\u0002T\u0005e#,\u0004\u0002\u0002V)\u0019\u0011qK\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\\\u0005U#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Q\u000b\u0019\u0007C\u0005\u0002J\u0005u\u0013\u0011!a\u00015\"I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011N\u0001\u0007KF,\u0018\r\\:\u0015\u0007Q\u000bY\u0007C\u0005\u0002J\u0005\u0015\u0014\u0011!a\u00015\"z\u0001!a\u001c\u0002v\u0005]\u00141PA?\u0003\u0003\u000b\u0019\tE\u0002\u0012\u0003cJ1!a\u001d\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001f\u0002c~3UKT\"`QM$\u0018M\u001d;`I\u0006$X\r\f\u0011eCf|vNZ0xK\u0016\\\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t4jeN$\b\u0005Z1uK\u0002:\b.[2iA%\u001c\b\u0005\\1uKJ\u0004C\u000f[1oA\u0001\u001cH/\u0019:u?\u0012\fG/\u001a1!C:$\u0007E\\1nK\u0012\u0004\u0013m\u001d\u0011j]\u0012L7-\u0019;fI:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\naJ\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nT'\f\u00192[E\"t\u0005\f\u0011()V;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE*T\u0006M\u0019.eAR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000b\u000bQ!\r\u00186]A:\u0011\"!#\u0003\u0003\u0003E\t!a#\u0002\u000f9+\u0007\u0010\u001e#bsB\u0019\u0011#!$\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u001f\u001bR!!$\u0002\u0012v\u0001r!a%\u0002\u001a\u000e\u001as&\u0004\u0002\u0002\u0016*\u0019\u0011qS\r\u0002\u000fI,h\u000e^5nK&!\u00111TAK\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\u00055E\u0011AAP)\t\tY\t\u0003\u0006\u0002$\u00065\u0015\u0011!C#\u0003K\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003OA!\"!+\u0002\u000e\u0006\u0005I\u0011QAV\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0013QVAX\u0011\u0019\t\u0013q\u0015a\u0001G!1\u0011&a*A\u0002\rB!\"a-\u0002\u000e\u0006\u0005I\u0011QA[\u0003\u001d)h.\u00199qYf$B!a.\u0002DB)\u0001$!/\u0002>&\u0019\u00111X\r\u0003\r=\u0003H/[8o!\u0015A\u0012qX\u0012$\u0013\r\t\t-\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005\u0015\u0017\u0011WA\u0001\u0002\u0004y\u0013a\u0001=%a!Q\u0011\u0011ZAG\u0003\u0003%I!a3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u001b\u0004B!!\u000b\u0002P&!\u0011\u0011[A\u0016\u0005\u0019y%M[3di\u0002")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;

    public static Option<Tuple2<Expression, Expression>> unapply(NextDay nextDay) {
        return NextDay$.MODULE$.unapply(nextDay);
    }

    public static Function1<Tuple2<Expression, Expression>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NextDay>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
        if (dow == -1) {
            n = null;
        } else {
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, dowS) -> {
            String string;
            String dateTimeUtilClass = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            String dayOfWeekTerm = ctx.freshName("dayOfWeek");
            if (this.dayOfWeek().foldable()) {
                UTF8String input = (UTF8String)this.dayOfWeek().eval(this.dayOfWeek().eval$default$1());
                if (input == null || DateTimeUtils$.MODULE$.getDayOfWeekFromString(input) == -1) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(35).append("\n             |").append(ev.isNull()).append(" = true;\n           ").toString())).stripMargin();
                } else {
                    int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n             |").append(ev.value()).append(" = ").append(dateTimeUtilClass).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekValue).append(");\n           ").toString())).stripMargin();
                }
            } else {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(187).append("\n           |int ").append(dayOfWeekTerm).append(" = ").append(dateTimeUtilClass).append(".getDayOfWeekFromString(").append((String)dowS).append(");\n           |if (").append(dayOfWeekTerm).append(" == -1) {\n           |  ").append(ev.isNull()).append(" = true;\n           |} else {\n           |  ").append(ev.value()).append(" = ").append(dateTimeUtilClass).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekTerm).append(");\n           |}\n         ").toString())).stripMargin();
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek) {
        return new NextDay(startDate, dayOfWeek);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.dayOfWeek();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        ExpectsInputTypes.$init$(this);
    }
}

