/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u0001>\u0011Q\"T8oi\"\u001c()\u001a;xK\u0016t'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001Bc\u0006\u000e!!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t\t\u0002$\u0003\u0002\u001a\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0004Qe>$Wo\u0019;\u0011\u0005m\t\u0013B\u0001\u0012\u001d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!!\u0003A!f\u0001\n\u0003)\u0013!\u00023bi\u0016\fT#\u0001\u0014\u0011\u0005E9\u0013B\u0001\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tU\u0001\u0011\t\u0012)A\u0005M\u00051A-\u0019;fc\u0001B\u0001\u0002\f\u0001\u0003\u0016\u0004%\t!J\u0001\u0006I\u0006$XM\r\u0005\t]\u0001\u0011\t\u0012)A\u0005M\u00051A-\u0019;fe\u0001B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t!J\u0001\te>,h\u000eZ(gM\"A!\u0007\u0001B\tB\u0003%a%A\u0005s_VtGm\u00144gA!AA\u0007\u0001BK\u0002\u0013\u0005Q'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\u000e\t\u00047]J\u0014B\u0001\u001d\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011!(\u0011\b\u0003w}\u0002\"\u0001\u0010\u000f\u000e\u0003uR!A\u0010\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001E$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!\u001d\u0011!)\u0005A!E!\u0002\u00131\u0014a\u0003;j[\u0016TvN\\3JI\u0002BQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtD#B%K\u00172k\u0005CA\t\u0001\u0011\u0015!c\t1\u0001'\u0011\u0015ac\t1\u0001'\u0011\u0015\u0001d\t1\u0001'\u0011\u001d!d\t%AA\u0002YBQa\u0012\u0001\u0005\u0002=#2!\u0013)R\u0011\u0015!c\n1\u0001'\u0011\u0015ac\n1\u0001'\u0011\u00159\u0005\u0001\"\u0001T)\u0011IE+\u0016,\t\u000b\u0011\u0012\u0006\u0019\u0001\u0014\t\u000b1\u0012\u0006\u0019\u0001\u0014\t\u000bA\u0012\u0006\u0019\u0001\u0014\t\u000ba\u0003A\u0011I-\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u0017\t\u00047\u00024cB\u0001/_\u001d\taT,C\u0001\u001e\u0013\tyF$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'aA*fc*\u0011q\f\b\u0005\u0006I\u0002!\t%Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00014\u0011\u0007m\u0003w\r\u0005\u0002iW6\t\u0011N\u0003\u0002k\r\u0005)A/\u001f9fg&\u0011A.\u001b\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQA\u001c\u0001\u0005B=\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002aB\u0011\u0001.]\u0005\u0003e&\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\u0006i\u0002!\t%^\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0003)YDQ\u0001N:A\u0002eBQ\u0001\u001f\u0001\u0005Be\fAB\\;mYN\u000bg-Z#wC2$RA_?\u0000\u0003\u0007\u0001\"aG>\n\u0005qd\"aA!os\")ap\u001ea\u0001u\u0006\u0011A/\r\u0005\u0007\u0003\u00039\b\u0019\u0001>\u0002\u0005Q\u0014\u0004\"\u0002\u0019x\u0001\u0004Q\bbBA\u0004\u0001\u0011\u0005\u0013\u0011B\u0001\nI><UM\\\"pI\u0016$b!a\u0003\u0002\u0018\u0005\u0005\u0002\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E!!A\u0004d_\u0012,w-\u001a8\n\t\u0005U\u0011q\u0002\u0002\t\u000bb\u0004(oQ8eK\"A\u0011\u0011DA\u0003\u0001\u0004\tY\"A\u0002dib\u0004B!!\u0004\u0002\u001e%!\u0011qDA\b\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRD\u0001\"a\t\u0002\u0006\u0001\u0007\u00111B\u0001\u0003KZDq!a\n\u0001\t\u0003\nI#\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u000f\u0005\n\u0003[\u0001\u0011\u0011!C\u0001\u0003_\tAaY8qsRI\u0011*!\r\u00024\u0005U\u0012q\u0007\u0005\tI\u0005-\u0002\u0013!a\u0001M!AA&a\u000b\u0011\u0002\u0003\u0007a\u0005\u0003\u00051\u0003W\u0001\n\u00111\u0001'\u0011!!\u00141\u0006I\u0001\u0002\u00041\u0004\"CA\u001e\u0001E\u0005I\u0011AA\u001f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0010+\u0007\u0019\n\te\u000b\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013!C;oG\",7m[3e\u0015\r\ti\u0005H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA)\u0003\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t)\u0006AI\u0001\n\u0003\ti$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005e\u0003!%A\u0005\u0002\u0005u\u0012AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003;\u0002\u0011\u0013!C\u0001\u0003?\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002b)\u001aa'!\u0011\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001d\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0004\u0005\u00065\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\bE\u0002\u001c\u0003\u007fJ1!!!\u001d\u0005\rIe\u000e\u001e\u0005\n\u0003\u000b\u0003\u0011\u0011!C\u0001\u0003\u000f\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002{\u0003\u0013C!\"a#\u0002\u0004\u0006\u0005\t\u0019AA?\u0003\rAH%\r\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0003R!!&\u0002\u001cjl!!a&\u000b\u0007\u0005eE$\u0001\u0006d_2dWm\u0019;j_:LA!!(\u0002\u0018\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\"\u0002\t\t\u0011\"\u0001\u0002$\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002&\u0006-\u0006cA\u000e\u0002(&\u0019\u0011\u0011\u0016\u000f\u0003\u000f\t{w\u000e\\3b]\"I\u00111RAP\u0003\u0003\u0005\rA\u001f\u0005\n\u0003_\u0003\u0011\u0011!C!\u0003c\u000ba!Z9vC2\u001cH\u0003BAS\u0003gC\u0011\"a#\u0002.\u0006\u0005\t\u0019\u0001>)\u001f\u0001\t9,!0\u0002@\u0006\r\u0017QYAe\u0003\u0017\u00042!EA]\u0013\r\tYL\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t-AB\u0002\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qc1\u0002C/[7fgR\fW\u000e\u001d\u001a\\Y\u0001\u0012x.\u001e8e\u001f\u001a4W,\u000b\u0011.A%3\u0007\u0005\u0019;j[\u0016\u001cH/Y7qc\u0001\u0004\u0013n\u001d\u0011mCR,'\u000f\t;iC:\u0004\u0003\r^5nKN$\u0018-\u001c93A2\u0002C\u000f[3oAQDW\r\t:fgVdGO\u0003\u0011!A\u0001\u0002\u0003%[:!a>\u001c\u0018\u000e^5wK:\u0002\u0013J\u001a\u0011ai&lWm\u001d;b[B\f\u0004\rI1oI\u0002\u0002G/[7fgR\fW\u000e\u001d\u001aaA\u0005\u0014X\rI8oAQDW\rI:b[\u0016\u0004C-Y=!_\u001a\u0004Sn\u001c8uQ2\u0002sN\u001d\u0011c_RD'\u0002\t\u0011!A\u0001\u0002\u0013M]3!i\",\u0007\u0005\\1ti\u0002\"\u0017-\u001f\u0011pM\u0002jwN\u001c;iY\u0001\"\u0018.\\3!_\u001a\u0004C-Y=!o&dG\u000e\t2fA%<gn\u001c:fI:\u0002s\n\u001e5fe^L7/\u001a\u0017!i\",\u0007\u0005Z5gM\u0016\u0014XM\\2fA%\u001c(\u0002\t\u0011!A\u0001\u00023-\u00197dk2\fG/\u001a3!E\u0006\u001cX\r\u001a\u0011p]\u0002\u001a\u0014\u0007\t3bsN\u0004\u0003/\u001a:![>tG\u000f\u001b\u0017!C:$\u0007E]8v]\u0012,G\r\t;pAa\u0002C-[4jiN\u0004SO\u001c7fgN\u0004#o\\;oI>3g-\u00104bYN,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAd\u0003\u0005e$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142se:T\u0006\r\u001a.ea\u0002\u0013\u0007\r\u001e4ai\u0002\u0004g\n\u0017!OEJ\u0014HN\u00172a5\u001a\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0013\bN\u001d6sY:tG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(ceJt'\f\u00193[IB\u0004%\r\u0019;gAR\u0004\u0007M\u0014-A\u001d\n\u0014(\u000f\u001c.cAj3\u0007M\u0014-A\u0019\fGn]3*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001ad&\u000f\u001b:ke2tg\u000e\u001b2sM*D\u0007O\u001b\u000bA\u0001\nQa]5oG\u0016\f#!!4\u0002\u000bErSG\f\u0019\b\u0013\u0005E'!!A\t\u0002\u0005M\u0017!D'p]RD7OQ3uo\u0016,g\u000eE\u0002\u0012\u0003+4\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011q[\n\u0006\u0003+\fI\u000e\t\t\n\u00037\f\tO\n\u0014'm%k!!!8\u000b\u0007\u0005}G$A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0018Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004bB$\u0002V\u0012\u0005\u0011q\u001d\u000b\u0003\u0003'D!\"a;\u0002V\u0006\u0005IQIAw\u0003!!xn\u0015;sS:<GCAA5\u0011)\t\t0!6\u0002\u0002\u0013\u0005\u00151_\u0001\u0006CB\u0004H.\u001f\u000b\n\u0013\u0006U\u0018q_A}\u0003wDa\u0001JAx\u0001\u00041\u0003B\u0002\u0017\u0002p\u0002\u0007a\u0005\u0003\u00041\u0003_\u0004\rA\n\u0005\ti\u0005=\b\u0013!a\u0001m!Q\u0011q`Ak\u0003\u0003%\tI!\u0001\u0002\u000fUt\u0017\r\u001d9msR!!1\u0001B\u0006!\u0011YrG!\u0002\u0011\u000fm\u00119A\n\u0014'm%\u0019!\u0011\u0002\u000f\u0003\rQ+\b\u000f\\35\u0011%\u0011i!!@\u0002\u0002\u0003\u0007\u0011*A\u0002yIAB!B!\u0005\u0002VF\u0005I\u0011AA0\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!Q!QCAk#\u0003%\t!a\u0018\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQB!B!\u0007\u0002V\u0006\u0005I\u0011\u0002B\u000e\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tu\u0001\u0003BA6\u0005?IAA!\t\u0002n\t1qJ\u00196fGR\u0004")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.date1(), this.date2(), this.roundOff()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, TimestampType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$31 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$32 = this.copy$default$1();
        Expression x$33 = this.copy$default$2();
        Expression x$34 = this.copy$default$3();
        return this.copy(x$32, x$33, x$34, (Option<String>)x$31);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(d1, d2, roundOff) -> new StringBuilder(22).append(dtu).append(".monthsBetween(").append((String)d1).append(", ").append((String)d2).append(", ").append((String)roundOff).append(", ").append(tz).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.date1();
                break;
            }
            case 1: {
                option = this.date2();
                break;
            }
            case 2: {
                option = this.roundOff();
                break;
            }
            case 3: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

