/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001>\u0011\u0011$T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4J\t*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tqA*Z1g\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\u0005Ti\u0006$XMZ;m!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0001$!\t\t\u0002\u0001C\u0005&\u0001\u0001\u0007\t\u0011)Q\u0005M\u0005)1m\\;oiB\u0011\u0001dJ\u0005\u0003Qe\u0011A\u0001T8oO\"\u0012AE\u000b\t\u00031-J!\u0001L\r\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"\u0003\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003'\u00035\u0001\u0018M\u001d;ji&|g.T1tW\"\u0012QF\u000b\u0005\u0006c\u0001!\tFM\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u00024mA\u0011\u0001\u0004N\u0005\u0003ke\u0011A!\u00168ji\")q\u0007\ra\u0001q\u0005q\u0001/\u0019:uSRLwN\\%oI\u0016D\bC\u0001\r:\u0013\tQ\u0014DA\u0002J]RDQ\u0001\u0010\u0001\u0005Bu\n\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002}A\u0011\u0001dP\u0005\u0003\u0001f\u0011qAQ8pY\u0016\fg\u000eC\u0003C\u0001\u0011\u00053)\u0001\u0005eCR\fG+\u001f9f+\u0005!\u0005CA#I\u001b\u00051%BA$\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tIeI\u0001\u0005ECR\fG+\u001f9f\u0011\u0015Y\u0005\u0001\"\u0015M\u00031)g/\u00197J]R,'O\\1m)\t1S\nC\u0003O\u0015\u0002\u0007q*A\u0003j]B,H\u000f\u0005\u0002Q#6\tA!\u0003\u0002S\t\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015!\u0006\u0001\"\u0011V\u0003%!wnR3o\u0007>$W\rF\u0002W9\u0006\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u0002\u0002\u000f\r|G-Z4f]&\u00111\f\u0017\u0002\t\u000bb\u0004(oQ8eK\")Ql\u0015a\u0001=\u0006\u00191\r\u001e=\u0011\u0005]{\u0016B\u00011Y\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQAY*A\u0002Y\u000b!!\u001a<\t\u000b\u0011\u0004A\u0011I3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001g!\t9gN\u0004\u0002iYB\u0011\u0011.G\u0007\u0002U*\u00111ND\u0001\u0007yI|w\u000e\u001e \n\u00055L\u0012A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\r\t\u000b\u001d\u0001A\u0011I3\t\u000bM\u0004A\u0011\t\u0012\u0002\u0013\u0019\u0014Xm\u001d5D_BL\bbB;\u0001\u0003\u0003%\tAI\u0001\u0005G>\u0004\u0018\u0010C\u0004x\u0001\u0005\u0005I\u0011\t=\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0011a\u0017M\\4\u000b\u0003y\fAA[1wC&\u0011qn\u001f\u0005\n\u0003\u0007\u0001\u0011\u0011!C\u0001\u0003\u000b\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001\u000f\u0005\n\u0003\u0013\u0001\u0011\u0011!C\u0001\u0003\u0017\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005M\u0001c\u0001\r\u0002\u0010%\u0019\u0011\u0011C\r\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0016\u0005\u001d\u0011\u0011!a\u0001q\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005e\u0001!!A\u0005B\u0005m\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0001CBA\u0010\u0003K\ti!\u0004\u0002\u0002\")\u0019\u00111E\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0005\u0005\"\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007y\ny\u0003\u0003\u0006\u0002\u0016\u0005%\u0012\u0011!a\u0001\u0003\u001bA\u0011\"a\r\u0001\u0003\u0003%\t%!\u000e\u0002\r\u0015\fX/\u00197t)\rq\u0014q\u0007\u0005\u000b\u0003+\t\t$!AA\u0002\u00055\u0001f\u0002\u0001\u0002<\u0005\u0005\u00131\t\t\u0004#\u0005u\u0012bAA \u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA#\u0003\u0011u\"\u0002\t\u0011!A}3UKT\"`Q%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011n_:|Go\u001c8jG\u0006dG.\u001f\u0011j]\u000e\u0014X-Y:j]\u001e\u0004c\u0007N\u0017cSR\u0004\u0013N\u001c;fO\u0016\u00148O\f\u0011UQ\u0016\u0004s-\u001a8fe\u0006$X\r\u001a\u0011J\t\u0002J7\u000fI4vCJ\fg\u000e^3fI*\u0001\u0003\u0005\t\u0011!AQ|\u0007EY3![>tw\u000e^8oS\u000e\fG\u000e\\=!S:\u001c'/Z1tS:<\u0007%\u00198eAUt\u0017.];fY\u0001\u0012W\u000f\u001e\u0011o_R\u00043m\u001c8tK\u000e,H/\u001b<f]\u0001\"\u0006.\u001a\u0011dkJ\u0014XM\u001c;!S6\u0004H.Z7f]R\fG/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!aV$8\u000f\t;iK\u0002\u0002\u0018M\u001d;ji&|g\u000eI%EA%t\u0007\u0005\u001e5fAU\u0004\b/\u001a:!gE\u0002#-\u001b;tY\u0001\ng\u000e\u001a\u0011uQ\u0016\u0004Cn\\<fe\u0002\u001a4\u0007\t2jiN\u0004#/\u001a9sKN,g\u000e\u001e\u0011uQ\u0016\u0004#/Z2pe\u0012\u0004c.^7cKJT\u0001\u0005\t\u0011!A\u0001:\u0018\u000e\u001e5j]\u0002*\u0017m\u00195!a\u0006\u0014H/\u001b;j_:t\u0003\u0005\u00165fA\u0005\u001c8/^7qi&|g\u000eI5tAQD\u0017\r\u001e\u0011uQ\u0016\u0004C-\u0019;bA\u0019\u0014\u0018-\\3!Q\u0006\u001c\b\u0005\\3tg\u0002\"\b.\u00198!c\u0001\u0012\u0017\u000e\u001c7j_:T\u0001\u0005\t\u0011!A\u0001\u0002\u0018M\u001d;ji&|gn\u001d\u0017!C:$\u0007%Z1dQ\u0002\u0002\u0018M\u001d;ji&|g\u000e\t5bg\u0002bWm]:!i\"\fg\u000e\t\u001d!E&dG.[8oAI,7m\u001c:eg:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oA%\u001c\bE\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA\t,7-Y;tK\u0002JGo\u001d\u0011sKN,H\u000e\u001e\u0011eKB,g\u000eZ:!_:\u0004\u0003/\u0019:uSRLwN\u001c\u0011J\tNt#\u0002\t\u0011\b\u0013\u0005%#!!A\t\u0002\u0005-\u0013!G'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h\u0013\u0012\u00032!EA'\r!\t!!!A\t\u0002\u0005=3#BA'\u0003#j\u0002#BA*\u00033\u001aSBAA+\u0015\r\t9&G\u0001\beVtG/[7f\u0013\u0011\tY&!\u0016\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007C\u0004\"\u0003\u001b\"\t!a\u0018\u0015\u0005\u0005-\u0003BCA2\u0003\u001b\n\t\u0011\"\u0012\u0002f\u0005AAo\\*ue&tw\rF\u0001z\u0011%\tI'!\u0014\u0002\u0002\u0013\u0005%%A\u0003baBd\u0017\u0010\u0003\u0006\u0002n\u00055\u0013\u0011!CA\u0003_\nq!\u001e8baBd\u0017\u0010F\u0002?\u0003cB\u0011\"a\u001d\u0002l\u0005\u0005\t\u0019A\u0012\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002x\u00055\u0013\u0011!C\u0005\u0003s\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0010\t\u0004u\u0006u\u0014bAA@w\n1qJ\u00196fGR\u0004")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Stateful,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID monotonicallyIncreasingID) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(monotonicallyIncreasingID);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return !this.bitmap$0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringBuilder(6).append(countTerm).append(" = 0L;").toString());
        ctx.addPartitionInitializationStatement(new StringBuilder(33).append(partitionMaskTerm).append(" = ((long) partitionIndex) << 33;").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.prettyName()).append("()").toString();
    }

    @Override
    public MonotonicallyIncreasingID freshCopy() {
        return new MonotonicallyIncreasingID();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof MonotonicallyIncreasingID;
        return bl && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }
}

